/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.framework.model;

import com.sun.jbi.jsf.framework.common.XmlUtils;
import com.sun.jbi.jsf.framework.model.JBIIdentification;
import org.w3c.dom.Element;

public class JBIServiceUnit {
    private JBIIdentification identification;
    private String targetName;

    public JBIServiceUnit() {
    }

    public JBIServiceUnit(JBIIdentification identification, String targetName) {
        this.identification = identification;
        this.targetName = targetName;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public String getName() {
        return this.identification == null ? null : this.identification.getName();
    }

    public String getDescription() {
        return this.identification == null ? null : this.identification.getDescription();
    }

    public String toString() {
        return " Name:" + this.getName() + " Description:" + this.getDescription() + " TargetName:" + this.getTargetName();
    }

    public static JBIServiceUnit create(JBIIdentification identification, String targetName) {
        return new JBIServiceUnit(identification, targetName);
    }

    public static JBIServiceUnit create(Element suElement) {
        Element targetNameElement;
        JBIIdentification identification = null;
        String targetName = null;
        Element idElement = XmlUtils.getElement(suElement, "identification");
        if (idElement != null) {
            identification = JBIIdentification.create(idElement);
        }
        if ((targetNameElement = XmlUtils.getElement(suElement, "component-name")) != null) {
            targetName = XmlUtils.getTextData(targetNameElement);
        }
        return JBIServiceUnit.create(identification, targetName);
    }
}

