/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.util;

import com.sun.appserv.management.config.ClusterConfig;
import com.sun.appserv.management.config.ClusteredServerConfig;
import com.sun.enterprise.tools.admingui.util.AMXUtil;
import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.jbi.jsf.bean.SelectableJBIComponentInfo;
import com.sun.jbi.jsf.bean.SelectableJBIServiceAssemblyInfo;
import com.sun.jbi.jsf.util.BeanUtilities;
import com.sun.jbi.jsf.util.I18nUtilities;
import com.sun.jbi.jsf.util.JBILogger;
import com.sun.jbi.jsf.util.SharedConstants;
import com.sun.jbi.ui.common.JBIAdminCommands;
import com.sun.jbi.ui.common.JBIComponentInfo;
import com.sun.jbi.ui.common.JBIRemoteException;
import com.sun.jbi.ui.common.ServiceAssemblyInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;

public final class ClusterUtilities {
    private static Logger sLog = JBILogger.getInstance();
    private static JBIAdminCommands sJac = BeanUtilities.getClient();

    public static List findBindingComponentsForTarget(String aTarget) {
        ArrayList<SelectableJBIComponentInfo> result = new ArrayList<SelectableJBIComponentInfo>();
        List compInfoList = null;
        if (null != sJac) {
            try {
                String queryResult = sJac.listBindingComponents(aTarget);
                compInfoList = JBIComponentInfo.readFromXmlText((String)queryResult);
            }
            catch (JBIRemoteException jbiRemoteEx) {
                sLog.fine("ClusterUtilities.findBindingComponentsForTarget(" + aTarget + "), caught jbiRemoteEx=" + (Object)((Object)jbiRemoteEx));
                jbiRemoteEx.printStackTrace(System.err);
            }
        }
        if (null != compInfoList) {
            for (JBIComponentInfo component : compInfoList) {
                SelectableJBIComponentInfo selectableComponent = new SelectableJBIComponentInfo(component);
                result.add(selectableComponent);
            }
        }
        sLog.fine("ClusterUtilities.findBindingComponentsForTarget(" + aTarget + "), result=" + result);
        return result;
    }

    public static List findServiceAssembliesForTarget(String aTarget) {
        ArrayList<SelectableJBIServiceAssemblyInfo> result = new ArrayList<SelectableJBIServiceAssemblyInfo>();
        List saInfoList = null;
        if (null != sJac) {
            try {
                String queryResult = sJac.listServiceAssemblies(aTarget);
                sLog.fine("ClusterUtilities.findServiceAssembliesForTarget(" + aTarget + "), queryResult=" + queryResult);
                saInfoList = ServiceAssemblyInfo.readFromXmlTextWithProlog((String)queryResult);
                sLog.fine("ClusterUtilities.findServiceAssembliesForTarget(" + aTarget + "), saInfoList=" + saInfoList);
            }
            catch (JBIRemoteException jbiRemoteEx) {
                sLog.fine("ClusterUtilities.findServiceAssembliesForTarget(" + aTarget + "), caught jbiRemoteEx=" + (Object)((Object)jbiRemoteEx));
                jbiRemoteEx.printStackTrace(System.err);
            }
        }
        if (null != saInfoList) {
            for (ServiceAssemblyInfo deployment : saInfoList) {
                SelectableJBIServiceAssemblyInfo selectableDeployment = new SelectableJBIServiceAssemblyInfo(deployment);
                result.add(selectableDeployment);
            }
        }
        sLog.fine("ClusterUtilities.findServiceAssembliesForTarget(" + aTarget + "), result=" + result);
        return result;
    }

    public static List findServiceEnginesForTarget(String aTarget) {
        ArrayList<SelectableJBIComponentInfo> result = new ArrayList<SelectableJBIComponentInfo>();
        List compInfoList = null;
        if (null != sJac) {
            try {
                String queryResult = sJac.listServiceEngines(aTarget);
                compInfoList = JBIComponentInfo.readFromXmlText((String)queryResult);
            }
            catch (JBIRemoteException jbiRemoteEx) {
                sLog.fine("ClusterUtilities.findServiceEnginesForTarget(" + aTarget + "), caught jbiRemoteEx=" + (Object)((Object)jbiRemoteEx));
                jbiRemoteEx.printStackTrace(System.err);
            }
        }
        if (null != compInfoList) {
            for (JBIComponentInfo component : compInfoList) {
                SelectableJBIComponentInfo selectableComponent = new SelectableJBIComponentInfo(component);
                result.add(selectableComponent);
            }
        }
        sLog.fine("ClusterUtilities.findServiceEnginesForTarget(" + aTarget + "), result=" + result);
        return result;
    }

    public static List findSharedLibrariesForTarget(String aTarget) {
        ArrayList<SelectableJBIComponentInfo> result = new ArrayList<SelectableJBIComponentInfo>();
        List compInfoList = null;
        if (null != sJac) {
            try {
                String queryResult = sJac.listSharedLibraries(aTarget);
                compInfoList = JBIComponentInfo.readFromXmlText((String)queryResult);
            }
            catch (JBIRemoteException jbiRemoteEx) {
                sLog.fine("ClusterUtilities.findSharedLibrariesForTarget(" + aTarget + "), caught jbiRemoteEx=" + (Object)((Object)jbiRemoteEx));
                jbiRemoteEx.printStackTrace(System.err);
            }
        }
        if (null != compInfoList) {
            for (JBIComponentInfo component : compInfoList) {
                SelectableJBIComponentInfo selectableComponent = new SelectableJBIComponentInfo(component);
                result.add(selectableComponent);
            }
        }
        sLog.fine("ClusterUtilities.findSharedLibrariesForTarget(" + aTarget + ") result=" + result);
        return result;
    }

    public static List findAllNonDomainTargets() {
        ArrayList result = null;
        Set clusterSet = AMXUtil.getDomainConfig().getClusterConfigMap().keySet();
        Set serverSet = AMXUtil.getDomainConfig().getStandaloneServerConfigMap().keySet();
        TreeSet targetsSet = new TreeSet(clusterSet);
        targetsSet.addAll(serverSet);
        result = new ArrayList(targetsSet);
        sLog.fine("ClusterUtilities.findAllNonDomainTargets(), result=" + result);
        return result;
    }

    public static List findTargetsForNameByType(String aName, String aType) {
        ArrayList<Properties> result = new ArrayList<Properties>();
        sLog.fine("ClusterUtilities.findTargetsForNameByType(" + aName + ", " + aType + ")");
        List sortedTargetsList = ClusterUtilities.findAllNonDomainTargets();
        for (String nextTarget : sortedTargetsList) {
            if (null == sJac) continue;
            try {
                List list;
                String queryResult = "";
                boolean isServiceAssembly = false;
                if ("binding-component".equals(aType)) {
                    queryResult = sJac.showBindingComponent(aName, SharedConstants.NO_STATE_CHECK, SharedConstants.NO_LIBRARY_CHECK, SharedConstants.NO_DEPLOYMENT_CHECK, nextTarget);
                } else if ("service-engine".equals(aType)) {
                    queryResult = sJac.showServiceEngine(aName, SharedConstants.NO_STATE_CHECK, SharedConstants.NO_LIBRARY_CHECK, SharedConstants.NO_DEPLOYMENT_CHECK, nextTarget);
                } else if ("service-assembly".equals(aType)) {
                    isServiceAssembly = true;
                    queryResult = sJac.showServiceAssembly(aName, SharedConstants.NO_STATE_CHECK, SharedConstants.NO_COMPONENT_CHECK, nextTarget);
                } else if ("shared-library".equals(aType)) {
                    queryResult = sJac.showSharedLibrary(aName, SharedConstants.NO_COMPONENT_CHECK, nextTarget);
                }
                if (1 != (list = isServiceAssembly ? ServiceAssemblyInfo.readFromXmlTextWithProlog((String)queryResult) : JBIComponentInfo.readFromXmlText((String)queryResult)).size()) continue;
                Properties targetProperties = new Properties();
                targetProperties.setProperty("name", nextTarget);
                result.add(targetProperties);
                sLog.fine("ClusterUtilities.findTargetsForNameByType(" + aName + ", " + aType + "), nextTarget=" + nextTarget + ", queryResult=" + queryResult);
            }
            catch (JBIRemoteException jbiRemoteEx) {
                sLog.fine("ClusterUtilities.findTargetsForNameByType(" + aName + ", " + aType + "), caught jbiRemoteEx=" + (Object)((Object)jbiRemoteEx));
                jbiRemoteEx.printStackTrace(System.err);
            }
        }
        sLog.fine("ClusterUtilities.findTargetsForNameByType(...). result=" + result);
        return result;
    }

    public static String getInstanceDomainCluster(String aInstanceName) {
        String clusterName = aInstanceName;
        List allNonDomainTargets = ClusterUtilities.findAllNonDomainTargets();
        ArrayList allTargets = new ArrayList(allNonDomainTargets);
        for (String target : allTargets) {
            if (!ClusterUtilities.isCluster(target)) continue;
            Map serverMap = ((ClusterConfig)AMXUtil.getDomainConfig().getClusterConfigMap().get(target)).getClusteredServerConfigMap();
            ArrayList instancesForOneCluster = new ArrayList();
            if (null == serverMap) continue;
            for (String key : serverMap.keySet()) {
                String name = ((ClusteredServerConfig)serverMap.get(key)).getName();
                if (!name.equalsIgnoreCase(aInstanceName)) continue;
                clusterName = target;
                return clusterName;
            }
        }
        return clusterName;
    }

    public static boolean isClusterProfile() {
        boolean result = AMXUtil.supportCluster();
        sLog.fine("ClusterUtilities.isClusterProfile(). result=" + result);
        return result;
    }

    public static boolean isCluster(String aClusterOrServerName) {
        Set clusterSet = AMXUtil.getDomainConfig().getClusterConfigMap().keySet();
        boolean result = clusterSet.contains(aClusterOrServerName);
        sLog.fine("ClusterUtilities.isCluster(" + aClusterOrServerName + "). result=" + result);
        return result;
    }

    public static boolean isServer(String aClusterOrServerName) {
        Set serverSet = AMXUtil.getDomainConfig().getStandaloneServerConfigMap().keySet();
        boolean result = serverSet.contains(aClusterOrServerName);
        sLog.fine("ClusterUtilities.isServer(" + aClusterOrServerName + "). result=" + result);
        return result;
    }

    public static SelectableJBIComponentInfo[] getCompStatus(String aType) {
        sLog.fine("ClusterUtilities.getCompStatus(" + aType + ")1");
        SelectableJBIComponentInfo[] resultDomainComponentsArray = new SelectableJBIComponentInfo[]{};
        Map queryMapResult = ClusterUtilities.getAllTargetCompInfosByType(aType);
        if (null != queryMapResult) {
            resultDomainComponentsArray = ClusterUtilities.findDomainComponents(queryMapResult);
            for (int i = 0; i < resultDomainComponentsArray.length; ++i) {
                String name = resultDomainComponentsArray[i].getName();
                int disabledCount = 0;
                int enabledCount = 0;
                Set targetNames = queryMapResult.keySet();
                for (String nextTarget : targetNames) {
                    String info;
                    List list;
                    if ("domain".equals(nextTarget) || 0 >= (list = JBIComponentInfo.readFromXmlText((String)(info = (String)queryMapResult.get(nextTarget)))).size()) continue;
                    for (JBIComponentInfo targetCompInfo : list) {
                        if (!name.equals(targetCompInfo.getName())) continue;
                        if ("Started".equalsIgnoreCase(targetCompInfo.getState())) {
                            ++enabledCount;
                            continue;
                        }
                        ++disabledCount;
                    }
                }
                ClusterUtilities.summarizeStateForComponent(resultDomainComponentsArray[i], enabledCount, disabledCount);
            }
        }
        return resultDomainComponentsArray;
    }

    public static SelectableJBIServiceAssemblyInfo[] getSaStatus() {
        sLog.fine("ClusterUtilities.getSaStatus()1");
        SelectableJBIServiceAssemblyInfo[] resultDomainServiceAssembliesArray = new SelectableJBIServiceAssemblyInfo[]{};
        Map queryMapResult = ClusterUtilities.getAllTargetSaInfos();
        if (null != queryMapResult) {
            resultDomainServiceAssembliesArray = ClusterUtilities.findDomainDeployments(queryMapResult);
            for (int i = 0; i < resultDomainServiceAssembliesArray.length; ++i) {
                String name = resultDomainServiceAssembliesArray[i].getName();
                int disabledCount = 0;
                int enabledCount = 0;
                Set targetNames = queryMapResult.keySet();
                for (String nextTarget : targetNames) {
                    String info;
                    List list;
                    if ("domain".equals(nextTarget) || 0 >= (list = ServiceAssemblyInfo.readFromXmlTextWithProlog((String)(info = (String)queryMapResult.get(nextTarget)))).size()) continue;
                    for (ServiceAssemblyInfo targetSaInfo : list) {
                        if (!name.equals(targetSaInfo.getName())) continue;
                        if ("Started".equalsIgnoreCase(targetSaInfo.getState())) {
                            ++enabledCount;
                            continue;
                        }
                        ++disabledCount;
                    }
                }
                ClusterUtilities.summarizeStateForDeployment(resultDomainServiceAssembliesArray[i], enabledCount, disabledCount);
            }
        }
        return resultDomainServiceAssembliesArray;
    }

    private static Map getAllTargetCompInfosByType(String aType) {
        Map queryMapResult = null;
        sLog.fine("ClusterUtilities.getAllTargetCompInfosByType(" + aType + ")");
        List allTargets = ClusterUtilities.findAllNonDomainTargets();
        allTargets.add("domain");
        String[] allTargetsArray = allTargets.toArray(new String[0]);
        sLog.fine("ClusterUtilities..getAllTargetCompInfosByType(" + aType + ")2, allTargetsArray=" + allTargetsArray + ", .length=" + allTargetsArray.length);
        if (null != sJac) {
            try {
                queryMapResult = "binding-component".equals(aType) ? sJac.listBindingComponents(allTargetsArray) : sJac.listServiceEngines(allTargetsArray);
            }
            catch (JBIRemoteException jbiRemoteEx) {
                sLog.fine("ClusterUtilities.getAllTargetCompInfosByType(" + aType + "): caught jbiRemoteEx=" + (Object)((Object)jbiRemoteEx));
            }
        }
        sLog.fine("ClusterUtilities.getAllTargetCompInfosByType(" + aType + "), queryMapResult=" + queryMapResult);
        return queryMapResult;
    }

    private static Map getAllTargetSaInfos() {
        Map queryMapResult = null;
        sLog.fine("ClusterUtilities.getAllTargetSaInfos()");
        List allTargets = ClusterUtilities.findAllNonDomainTargets();
        allTargets.add("domain");
        String[] allTargetsArray = allTargets.toArray(new String[0]);
        sLog.fine("ClusterUtilities..getAllTargetSaInfosByType()2, allTargetsArray=" + allTargetsArray + ", .length=" + allTargetsArray.length);
        if (null != sJac) {
            try {
                queryMapResult = sJac.listServiceAssemblies(allTargetsArray);
            }
            catch (JBIRemoteException jbiRemoteEx) {
                sLog.fine("ClusterUtilities.getAllTargetSaInfos(): caught jbiRemoteEx=" + (Object)((Object)jbiRemoteEx));
            }
        }
        sLog.fine("ClusterUtilities.getAllTargetSaInfos(), queryMapResult=" + queryMapResult);
        return queryMapResult;
    }

    private static SelectableJBIComponentInfo[] findDomainComponents(Map aQueryMap) {
        SelectableJBIComponentInfo[] result = new SelectableJBIComponentInfo[]{};
        sLog.fine("ClusterUtilities.findDomainComponents(" + aQueryMap + ")");
        Set targetNames = aQueryMap.keySet();
        for (String nextTarget : targetNames) {
            if (!"domain".equals(nextTarget)) continue;
            String info = (String)aQueryMap.get(nextTarget);
            List list = JBIComponentInfo.readFromXmlText((String)info);
            result = new SelectableJBIComponentInfo[list.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = new SelectableJBIComponentInfo((JBIComponentInfo)list.get(i));
            }
        }
        sLog.fine("ClusterUtilities.findDomainComponents(" + aQueryMap + "), result=" + result + ", .length=" + result.length);
        return result;
    }

    private static SelectableJBIServiceAssemblyInfo[] findDomainDeployments(Map aQueryMap) {
        SelectableJBIServiceAssemblyInfo[] result = new SelectableJBIServiceAssemblyInfo[]{};
        sLog.fine("ClusterUtilities.findDomainDeployments(" + aQueryMap + ")");
        Set targetNames = aQueryMap.keySet();
        for (String nextTarget : targetNames) {
            if (!"domain".equals(nextTarget)) continue;
            String info = (String)aQueryMap.get(nextTarget);
            List list = ServiceAssemblyInfo.readFromXmlTextWithProlog((String)info);
            result = new SelectableJBIServiceAssemblyInfo[list.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = new SelectableJBIServiceAssemblyInfo((ServiceAssemblyInfo)list.get(i));
            }
        }
        sLog.fine("ClusterUtilities.findDomainDeployments(" + aQueryMap + "), result=" + result + ", .length=" + result.length);
        return result;
    }

    private static void summarizeStateForComponent(SelectableJBIComponentInfo aComp, int anEnabledCount, int aDisabledCount) {
        sLog.fine("ClusterUtilities.summarizeStateForComponent(" + (Object)((Object)aComp) + ", " + anEnabledCount + ", " + aDisabledCount + ")");
        if (0 < anEnabledCount) {
            if (0 == aDisabledCount) {
                aComp.setSummaryStatus(I18nUtilities.getResourceString("jbi.operations.enabled.on.all.targets"));
            } else if (1 == anEnabledCount) {
                aComp.setSummaryStatus(I18nUtilities.getResourceString("jbi.operations.enabled.on.one.target"));
            } else if (1 < anEnabledCount) {
                Object[] args = new Object[]{anEnabledCount};
                String enabledOnNTargets = GuiUtil.getMessage((String)I18nUtilities.getResourceString("jbi.operations.enabled.on.n.targets"), (Object[])args);
                aComp.setSummaryStatus(enabledOnNTargets);
            }
        } else if (0 == aDisabledCount) {
            aComp.setSummaryStatus(I18nUtilities.getResourceString("jbi.operations.no.targets"));
        } else {
            aComp.setSummaryStatus(I18nUtilities.getResourceString("jbi.operations.disabled.on.all.targets"));
        }
        sLog.fine("ClusterUtilities.summarizeStateForComponent(), summary=" + aComp.getSummaryStatus());
    }

    private static void summarizeStateForDeployment(SelectableJBIServiceAssemblyInfo anSa, int anEnabledCount, int aDisabledCount) {
        sLog.fine("ClusterUtilities.summarizeStateForDeployment(" + (Object)((Object)anSa) + ", " + anEnabledCount + ", " + aDisabledCount + ")");
        if (0 < anEnabledCount) {
            if (0 == aDisabledCount) {
                anSa.setSummaryStatus(I18nUtilities.getResourceString("jbi.operations.enabled.on.all.targets"));
            } else if (1 == anEnabledCount) {
                anSa.setSummaryStatus(I18nUtilities.getResourceString("jbi.operations.enabled.on.one.target"));
            } else if (1 < anEnabledCount) {
                Object[] args = new Object[]{anEnabledCount};
                String enabledOnNTargets = GuiUtil.getMessage((String)I18nUtilities.getResourceString("jbi.operations.enabled.on.n.targets"), (Object[])args);
                anSa.setSummaryStatus(enabledOnNTargets);
            }
        } else if (0 == aDisabledCount) {
            anSa.setSummaryStatus(I18nUtilities.getResourceString("jbi.operations.no.targets"));
        } else {
            anSa.setSummaryStatus(I18nUtilities.getResourceString("jbi.operations.disabled.on.all.targets"));
        }
        sLog.fine("ClusterUtilities.summarizeStateForDeployment(), summary=" + anSa.getSummaryStatus());
    }
}

