<%--
 Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 Use is subject to license terms.
--%>

<%@ taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt" %>
<fmt:setBundle basename="LocalStrings"/>

<html>
  <head>
    <title><fmt:message key="basic-comparisons.jsp.title"/></title>
  </head>
  <body>
    <h1><fmt:message key="basic-comparisons.jsp.title"/></h1>
    <hr>
    <fmt:message key="basic-comparisons.jsp.overview"/>
    <ul>
      <li><fmt:message key="basic-comparisons.jsp.lessthan"/> (&lt; or lt)</li>
      <li><fmt:message key="basic-comparisons.jsp.greaterthan"/> (&gt; or gt)</li>
      <li><fmt:message key="basic-comparisons.jsp.lessthanorequal"/> (&lt;= or le)</li>
      <li><fmt:message key="basic-comparisons.jsp.greaterthanorequal"/> (&gt;= or ge)</li>
      <li><fmt:message key="basic-comparisons.jsp.equal"/> (== or eq)</li>
      <li><fmt:message key="basic-comparisons.jsp.notequal"/> (!= or ne)</li>
    </ul>
    <blockquote>
      <u><b><fmt:message key="basic-comparisons.jsp.numeric"/></b></u>
      <code>
        <table border="1">
          <thead>
	    <td><b><fmt:message key="basic-comparisons.jsp.elexpression"/></b></td>
	    <td><b><fmt:message key="basic-comparisons.jsp.result"/></b></td>
	  </thead>
	  <tr>
	    <td>\${1 &lt; 2}</td>
	    <td>${1 < 2}</td>
	  </tr>
	  <tr>
	    <td>\${1 lt 2}</td>
	    <td>${1 lt 2}</td>
	  </tr>
	  <tr>
	    <td>\${1 &gt; (4/2)}</td>
	    <td>${1 > (4/2)}</td>
	  </tr>
	  <tr>
	    <td>\${1 &gt; (4/2)}</td>
	    <td>${1 > (4/2)}</td>
	  </tr>
	  <tr>
	    <td>\${4.0 &gt;= 3}</td>
	    <td>${4.0 >= 3}</td>
	  </tr>
	  <tr>
	    <td>\${4.0 ge 3}</td>
	    <td>${4.0 ge 3}</td>
	  </tr>
	  <tr>
	    <td>\${4 &lt;= 3}</td>
	    <td>${4 <= 3}</td>
	  </tr>
	  <tr>
	    <td>\${4 le 3}</td>
	    <td>${4 le 3}</td>
	  </tr>
	  <tr>
	    <td>\${100.0 == 100}</td>
	    <td>${100.0 == 100}</td>
	  </tr>
	  <tr>
	    <td>\${100.0 eq 100}</td>
	    <td>${100.0 eq 100}</td>
	  </tr>
	  <tr>
	    <td>\${(10*10) != 100}</td>
	    <td>${(10*10) != 100}</td>
	  </tr>
	  <tr>
	    <td>\${(10*10) ne 100}</td>
	    <td>${(10*10) ne 100}</td>
	  </tr>
	</table>
      </code>
      <br>
      <u><b><fmt:message key="basic-comparisons.jsp.alphabetic"/></b></u>
      <code>
        <table border="1">
          <thead>
	    <td><b><fmt:message key="basic-comparisons.jsp.elexpression"/></b></td>
	    <td><b><fmt:message key="basic-comparisons.jsp.result"/></b></td>
	  </thead>
	  <tr>
	    <td>\${'a' &lt; 'b'}</td>
	    <td>${'a' < 'b'}</td>
	  </tr>
	  <tr>
	    <td>\${'hip' &gt; 'hit'}</td>
	    <td>${'hip' > 'hit'}</td>
	  </tr>
	  <tr>
	    <td>\${'4' &gt; 3}</td>
	    <td>${'4' > 3}</td>
	  </tr>
	</table>
      </code>
    </blockquote>
  </body>
</html>
