// ==============================================================
//	This file is part of Glest Shared Library (www.glest.org)
//
//	Copyright (C) 2001-2008 Martio Figueroa
//
//	You can redistribute this code and/or modify it under 
//	the terms of the GNU General Public License as published 
//	by the Free Software Foundation; either version 2 of the 
//	License, or (at your option) any later version
// ==============================================================

#ifndef _SHARED_UTIL_PROPERTIES_H_
#define _SHARED_UTIL_PROPERTIES_H_

#include <string>
#include <map>

using std::map;
using std::string;
using std::pair;

namespace Shared{ namespace Util{

// =====================================================
//	class Properties
//
///	ini-like file loader
// =====================================================

class Properties{
private:
	static const int maxLine= 256;

private:	
	typedef pair<string, string> PropertiesPair;
	typedef map<string, string> PropertiesMap;

private:
	PropertiesMap properties;
	string path;

public:
	void load(const string &path);
	void save(const string &path);

	bool getBool(const string &key) const;
	int getInt(const string &key) const;
	int getInt(const string &key, int min, int max) const;
	float getFloat(const string &key) const;
	float getFloat(const string &key, float min, float max) const;
	const string &getString(const string &key) const;

	void setInt(const string &key, int value);
	void setBool(const string &key, bool value);
	void setFloat(const string &key, float value);
	void setString(const string &key, const string &value);

	string toString();
};

}}//end namespace

#endif
