// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "Osmo4.h"

#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_WM_SETFOCUS()
	ON_WM_SIZE()
	ON_WM_MOVE()
	ON_MESSAGE(WM_SETSIZE,OnSetSize)
	ON_MESSAGE(WM_NAVIGATE,OnNavigate)
	ON_MESSAGE(WM_OPENURL, Open)
	ON_MESSAGE(WM_STOPURL, Stop)
	ON_MESSAGE(WM_SETTIMING, SetTiming)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONDBLCLK()
	ON_WM_LBUTTONUP()
	ON_WM_CHAR()
	ON_WM_SYSKEYDOWN()
	ON_WM_SYSKEYUP()
	ON_WM_KEYDOWN()
	ON_WM_KEYUP()
	ON_WM_DROPFILES()
	ON_COMMAND(ID_VIEW_CONTROL, OnViewControl)
	ON_MESSAGE(WM_CONSOLEMSG, OnConsoleMessage)
	ON_UPDATE_COMMAND_UI(ID_VIEW_CONTROL, OnUpdateViewControl)
	ON_COMMAND(ID_VIEW_ORIGINAL, OnViewOriginal)
	ON_COMMAND(ID_VIEW_FULLSCREEN, OnViewFullscreen)
	ON_COMMAND(ID_AR_KEEP, OnArKeep)
	ON_COMMAND(ID_AR_FILL, OnArFill)
	ON_COMMAND(ID_AR_43, OnAr43)
	ON_COMMAND(ID_AR_169, OnAr169)
	ON_UPDATE_COMMAND_UI(ID_AR_169, OnUpdateAr169)
	ON_UPDATE_COMMAND_UI(ID_AR_43, OnUpdateAr43)
	ON_UPDATE_COMMAND_UI(ID_AR_FILL, OnUpdateArFill)
	ON_UPDATE_COMMAND_UI(ID_AR_KEEP, OnUpdateArKeep)
	ON_COMMAND(ID_SHORTCUTS, OnShortcuts)
	ON_COMMAND(IDD_CONFIGURE, OnConfigure)
	ON_COMMAND(ID_FILE_PROP, OnFileProp)
	ON_UPDATE_COMMAND_UI(ID_FILE_PROP, OnUpdateFileProp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	m_bShowControl = 0;
	m_icoerror = AfxGetApp()->LoadIcon(IDI_ERR);
	m_icomessage = AfxGetApp()->LoadIcon(IDI_MESSAGE);
	m_bFullScreen = 0;	
	m_aspect_ratio = M4_AR_Keep;
	m_pProps = NULL;
	m_pOpt = NULL;
	m_pWndView = new CChildView();
}

CMainFrame::~CMainFrame()
{
	if (m_pProps != NULL) m_pProps->DestroyWindow();
	if (m_pOpt != NULL) m_pOpt->DestroyWindow();
	delete m_pWndView;
}

static UINT indicators[] =
{
	ID_TIMER,
	ID_FPS,
	ID_SEPARATOR,           // status line indicator
};



int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	// create a view to occupy the client area of the frame
	if (!m_pWndView->CreateEx(0, NULL, NULL, WS_POPUP | WS_VISIBLE, 0, 0, 300, 200, m_hWnd, NULL, NULL))
	{
		TRACE0("Failed to create view window\n");
		return -1;
	}

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}

	if (!m_progBar.Create(IDD_CONTROL , this) ) {
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}

	m_progBar.UpdateWindow();
	m_progBar.ShowWindow(m_bShowControl ? SW_SHOW : SW_HIDE);

	m_wndStatusBar.SetPaneInfo(0, ID_TIMER, SBPS_NORMAL, 45);
	m_wndStatusBar.SetPaneInfo(1, ID_FPS, SBPS_NORMAL, 45);
	m_wndStatusBar.SetPaneInfo(2, ID_SEPARATOR, SBPS_STRETCH, 0);
	SetWindowPos(NULL, 100, 100, 0, 0, SWP_NOSIZE);


	SetIcon(AfxGetApp()->LoadIcon(IDR_MAINFRAME), TRUE);
	SetIcon(AfxGetApp()->LoadIcon(IDR_MAINFRAME), FALSE);


	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	cs.dwExStyle &= ~WS_EX_CLIENTEDGE;
	cs.lpszClass = AfxRegisterWndClass(0);
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers
void CMainFrame::OnSetFocus(CWnd* pOldWnd)
{
}

BOOL CMainFrame::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo)
{
	// let the view have first crack at the command
	if (m_pWndView->OnCmdMsg(nID, nCode, pExtra, pHandlerInfo))
		return TRUE;

	// otherwise, do default handling
	return CFrameWnd::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}


void CMainFrame::OnSize(UINT nType, int cx, int cy) 
{
	RECT rc, wndrc;
	CFrameWnd::OnSize(nType, cx, cy);
	
	CControlBar* pBar = GetControlBar(ID_VIEW_STATUS_BAR);
	if (pBar) {
		pBar->GetClientRect(&rc);
		cy -= rc.bottom - rc.top;
	}

	if (m_bShowControl) {
		m_progBar.GetClientRect(&rc);
		cy -= rc.bottom - rc.top;
	}

	/*no need to call M4T_SetSize, the resize is done by the video plugin*/
//	m_pWndView->SetWindowPos(this, 0, 0, cx, cy, SWP_NOMOVE);
	WinGPAC *app = GetApp();
	M4T_SetSize(app->m_term, cx, cy);

	SetActiveWindow();
	SetFocus();

	if (m_bShowControl) {
		m_pWndView->GetWindowRect(&wndrc);
		m_progBar.SetWindowPos(this, wndrc.left, wndrc.top + cy, cx, rc.bottom - rc.top, SWP_SHOWWINDOW);
	}
}


void CMainFrame::SetSize(UINT width, UINT height)
{
	// Determine how large to make the window to fit in the required
	// client area
	RECT winRect;
	winRect.left = 0;
	winRect.right = width;
	winRect.top = 0;
	winRect.bottom = height;
	AdjustWindowRectEx(&winRect, GetStyle(), TRUE, GetExStyle());
	winRect.bottom -= winRect.top;
	winRect.right -= winRect.left;

	RECT barRect;
	CControlBar* pBar = GetControlBar(ID_VIEW_STATUS_BAR);
	if (pBar != NULL) {
		pBar->GetClientRect(&barRect);
		winRect.bottom += barRect.bottom;
	}
	if (m_bShowControl) {
		m_progBar.GetClientRect(&barRect);
		winRect.bottom += barRect.bottom;
	}
	
	SetWindowPos(NULL, 0, 0, winRect.right, winRect.bottom, SWP_NOMOVE | SWP_NOZORDER | SWP_SHOWWINDOW);
}

LONG CMainFrame::OnSetSize(WPARAM wParam, LPARAM lParam)
{
	SetSize(wParam, lParam);
	GetApp()->m_url_changed = 0;
	return 0;
}

void CMainFrame::OnMove(int x, int y) 
{
	CFrameWnd::OnMove(x, y);
	RECT rc;
	m_pWndView->SetWindowPos(this, x, y, 0, 0, SWP_NOSIZE);
	m_pWndView->GetClientRect(&rc);
	y += rc.bottom;

	if (m_bShowControl) {
		m_progBar.SetWindowPos(m_pWndView, x, y, 0, 0, SWP_NOSIZE | SWP_SHOWWINDOW);
		m_progBar.GetClientRect(&rc);
		y += rc.bottom;
	}

	CControlBar* pBar = GetControlBar(ID_VIEW_STATUS_BAR);
	pBar->SetWindowPos(this, x, y, 0, 0, SWP_NOSIZE);
}


#define PROGRESS_TIMER	20
#define PROGRESS_REFRESH_MS		100

void CALLBACK EXPORT ProgressTimer(HWND , UINT , UINT nID , DWORD )
{
	u32 now;
	if (nID != PROGRESS_TIMER) return;
	WinGPAC *app = GetApp();
	CMainFrame *pFrame = (CMainFrame *) app->m_pMainWnd;
	/*shutdown*/
	if (!pFrame) return;

	now = M4T_GetCurrentTimeInMS(app->m_term);
	if (!now) return;

	if (app->max_duration && !pFrame->m_progBar.m_grabbed) {
		if (now >= app->max_duration + 100) {
			if (M4T_GetOption(app->m_term, M4O_IsOver)) {
				if (app->m_Loop) 
					pFrame->PostMessage(WM_COMMAND, MAKEWPARAM(ID_FILE_RESTART, 0), 0);
				else if (app->m_StopAtEnd && app->m_paused)
					pFrame->m_progBar.Stop();
			}
			/*if no IsOver go on forever*/
		} else {
			if (!pFrame->m_progBar.m_reset)
				pFrame->m_progBar.m_Slider.SetPos(now);
		}
	}

	if (!app->m_prev_time || (app->m_prev_time + 500 <= now)) {
		app->current_FPS = M4T_GetCurrentFPS(app->m_term, 0);
		app->current_time_ms = now;
		pFrame->PostMessage(WM_SETTIMING, 0, 0);
	}

}

LONG CMainFrame::Open(WPARAM wParam, LPARAM lParam)
{
	WinGPAC *app = GetApp();
	Stop(wParam, lParam);

	if (app->m_url_changed) {
		char txt[5000];
		strcpy(txt, "Osmo4 - ");
		char *name = strrchr(app->m_filename, '\\');
		if (!name) name = strrchr(app->m_filename, '/');
		if (name) {
			strcat(txt, name+1);
		} else {
			strcat(txt, app->m_filename);
		}
		SetWindowText(txt);
		
		app->can_seek = 0;
		m_progBar.m_Slider.EnableWindow(FALSE);
		m_progBar.m_Play.EnableWindow(TRUE);
		m_progBar.m_Stop.EnableWindow(TRUE);
	}
	SetTimer(PROGRESS_TIMER, PROGRESS_REFRESH_MS, ProgressTimer);
	M4T_ConnectURL(app->m_term, (LPCSTR) app->m_filename);
	return 1;	
}

LONG CMainFrame::Stop(WPARAM wParam, LPARAM lParam)
{
	WinGPAC *app = GetApp();
	if (app->m_isopen) {
		M4T_CloseURL(app->m_term);
		app->m_isopen = 0;
		app->m_paused = 0;
		m_progBar.m_Play.SetIcon(m_progBar.m_icoplay);
		m_progBar.m_Slider.SetPos(0);

		SetWindowText("Osmo4");
		KillTimer(PROGRESS_TIMER);
	}
	return 1;	
}

void CMainFrame::ForwardMessage()
{
	const MSG *msg = GetCurrentMessage();
	m_pWndView->SendMessage(msg->message, msg->wParam, msg->lParam);
}
void CMainFrame::OnSysKeyUp(UINT , UINT , UINT ) { ForwardMessage(); }
void CMainFrame::OnSysKeyDown(UINT , UINT , UINT ) { ForwardMessage(); }
void CMainFrame::OnChar(UINT , UINT , UINT ) { ForwardMessage(); }
void CMainFrame::OnKeyDown(UINT , UINT , UINT ) { ForwardMessage(); }
void CMainFrame::OnKeyUp(UINT , UINT , UINT ) { ForwardMessage(); }
void CMainFrame::OnLButtonDown(UINT , CPoint ) { ForwardMessage(); }
void CMainFrame::OnLButtonDblClk(UINT , CPoint ) { ForwardMessage(); }
void CMainFrame::OnLButtonUp(UINT , CPoint ) { ForwardMessage(); }

void CMainFrame::OnDropFiles(HDROP hDropInfo) 
{
	WinGPAC *app = GetApp();
	char fileName[MAX_PATH];

	::DragQueryFile (hDropInfo, 0, fileName, MAX_PATH);
	app->m_filename = fileName;
	app->m_url_changed = 1;
	PostMessage(WM_OPENURL, 0, 0);
}

void CMainFrame::OnUpdateViewControl(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(m_bShowControl);
}

void CMainFrame::OnViewControl() 
{
	RECT rc;
	m_bShowControl = !m_bShowControl;
	UpdateWindow();
	m_pWndView->GetClientRect(&rc);
	m_progBar.ShowWindow(m_bShowControl ? SW_SHOWNOACTIVATE : SW_HIDE);
	SetFocus();
	m_pWndView->SetFocus();
	SetSize(rc.right - rc.left, rc.bottom - rc.top);

}

LONG CMainFrame::SetTiming(WPARAM wParam, LPARAM lParam)
{
	char sTime[75];
	WinGPAC *gpac = GetApp();
	u32 ms = gpac->current_time_ms;
	u32 h = ms / 1000 / 3600;
	u32 m = ms / 1000 / 60 - h*60;
	u32 s = ms / 1000 - h*3600 - m*60;
	
	sprintf(sTime, "%02d:%02d.%02d", h, m, s);
	m_wndStatusBar.SetPaneText(0, sTime);
	
	sprintf(sTime, "FPS %.1f", gpac->current_FPS);
	m_wndStatusBar.SetPaneText(1, sTime);
	return 1;
}



void CALLBACK EXPORT ConsoleTimer(HWND , UINT , UINT , DWORD )
{
	CMainFrame *pFrame = (CMainFrame *) GetApp()->m_pMainWnd;
	
	pFrame->m_wndStatusBar.GetStatusBarCtrl().SetIcon(2, NULL);
	pFrame->KillTimer(pFrame->m_timer_on);
	pFrame->m_timer_on = 0;
	pFrame->m_wndStatusBar.SetPaneText(2, "Ready");
}

#define CONSOLE_DISPLAY_TIME	1000

LONG CMainFrame::OnConsoleMessage(WPARAM wParam, LPARAM lParam)
{
	if (m_timer_on) KillTimer(m_timer_on);
	
	if (console_err>=0) {
		m_wndStatusBar.GetStatusBarCtrl().SetIcon(2, m_icomessage);
		m_wndStatusBar.SetPaneText(2, console_message);
	} else {
		char msg[5000];
		m_wndStatusBar.GetStatusBarCtrl().SetIcon(2, m_icoerror);
		sprintf(msg, "%s: %s", console_message, M4ErrToString(console_err));
		m_wndStatusBar.SetPaneText(2, msg);
	}
	m_timer_on = SetTimer(10, CONSOLE_DISPLAY_TIME, ConsoleTimer);
	return 0;
}

BOOL CMainFrame::DestroyWindow() 
{
	if (GetApp()->m_isopen) KillTimer(PROGRESS_TIMER);
	/*signal close to prevent callbacks but don't close, this is done in ExitInstance (otherwise there's a
	deadlock happening not sure why yet)*/
//	GetApp()->m_open = 0;
	return CFrameWnd::DestroyWindow();
}


void CMainFrame::OnViewOriginal() 
{
	WinGPAC *gpac = GetApp();
	M4T_SetOption(gpac->m_term, M4O_OriginalView, 1);	
}

void CMainFrame::SetFullscreen() 
{
	WinGPAC *gpac = GetApp();
	if (!m_bFullScreen) {
		GetWindowRect(&backup_wnd_rc);
		if (M4T_SetOption(gpac->m_term, M4O_Fullscreen, 1) == M4OK) 
			m_bFullScreen = 1;
	} else {
		if (M4T_SetOption(gpac->m_term, M4O_Fullscreen, 0) == M4OK) 
			m_bFullScreen = 0;
		SetWindowPos(NULL, backup_wnd_rc.left, backup_wnd_rc.top, backup_wnd_rc.right-backup_wnd_rc.left, backup_wnd_rc.bottom-backup_wnd_rc.top, SWP_NOZORDER);
	}
}

void CMainFrame::OnViewFullscreen() 
{
	SetFullscreen();
}

void CMainFrame::OnArKeep() 
{
	M4T_SetOption(GetApp()->m_term, M4O_AspectRatio, M4_AR_Keep);	
	m_aspect_ratio = M4_AR_Keep;
}

void CMainFrame::OnArFill() 
{
	M4T_SetOption(GetApp()->m_term, M4O_AspectRatio, M4_AR_None);	
	m_aspect_ratio = M4_AR_None;
}

void CMainFrame::OnAr43() 
{
	M4T_SetOption(GetApp()->m_term, M4O_AspectRatio, M4_AR_4_3);	
	m_aspect_ratio = M4_AR_4_3;
}

void CMainFrame::OnAr169() 
{
	M4T_SetOption(GetApp()->m_term, M4O_AspectRatio, M4_AR_16_9);	
	m_aspect_ratio = M4_AR_16_9;
}

void CMainFrame::OnUpdateAr169(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(m_aspect_ratio == M4_AR_16_9);
}

void CMainFrame::OnUpdateAr43(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(m_aspect_ratio == M4_AR_4_3);
}

void CMainFrame::OnUpdateArFill(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(m_aspect_ratio == M4_AR_None);
}

void CMainFrame::OnUpdateArKeep(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(m_aspect_ratio == M4_AR_Keep);
}

LONG CMainFrame::OnNavigate(WPARAM /*wParam*/, LPARAM /*lParam*/)
{
	WinGPAC *gpac = GetApp();

	if (strstr(gpac->m_navigate_url , ".mp4")) {
		char _str[MAX_PATH];
		if (!strstr(gpac->m_navigate_url, "://") && !strstr(gpac->m_navigate_url, "/") && !strstr(gpac->m_navigate_url, "\\") ) {
			CString _last = gpac->m_filename;
			int res = _last.ReverseFind('\\');
			_last.SetAt(res+1, 0);
			strcpy(_str, (LPCSTR) _last);
			strcat(_str, gpac->m_navigate_url);
		} else {
			strcpy(_str, gpac->m_navigate_url);
		}
		console_message = (LPCSTR) _str;
		console_err = M4OK;
		PostMessage(WM_CONSOLEMSG);
		gpac->m_filename = _str;
		gpac->m_url_changed = 1;
		Open(0, 0);
	} else {
		console_message = gpac->m_navigate_url;
		console_err = M4OK;
		PostMessage(WM_CONSOLEMSG);
		ShellExecute(NULL, "open", (LPCSTR) gpac->m_navigate_url, NULL, NULL, SW_SHOWNORMAL);
	}
	return 0;
}

void CMainFrame::OnFileProp() 
{
	if (!m_pProps) {
		m_pProps = new CFileProps(this);
		m_pProps->Create(this);
	}
	m_pProps->ShowWindow(SW_SHOW);
}

void CMainFrame::OnUpdateFileProp(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(GetApp()->m_isopen);	
}

void CMainFrame::OnConfigure() 
{
	if (!m_pOpt) {
		m_pOpt = new COptions(this);
		m_pOpt->Create(this);
	}
	m_pOpt->ShowWindow(SW_SHOW);
}

void CMainFrame::OnShortcuts() 
{
	MessageBox(
		"Open File: Ctrl + O\n"
		"Open URL: Ctrl + U\n"
		"Reload File: Ctrl + R\n"
		"Pause/Resume File: Ctrl + P\n"
		"Step by Step: Ctrl + S\n"
		"Seek +5%: Alt + left arrow\n"
		"Seek -5%: Alt + right arrow\n"
		"Seek +1min: Alt + up arrow\n"
		"Seek -1min: Alt + down arrow\n"
		"Fullscreen On/Off: Alt+Return or Escape\n"
		"\n"
		"Show Properties: Ctrl + I\n"
		"Show Controls: Ctrl + V\n"
		"Show Options: Ctrl + C\n"
		"\n"
		"Move around Presentation: mouse down + shift\n"
		"Zoom in Presentation: mouse click + ctrl\n"
		"Zoom out Presentation: mouse click + ctrl + shift\n"
		"\n"
		"Aspect Ratio Normal: Ctrl + 1\n"
		"Aspect Ratio Fill: Ctrl + 2\n"
		"Aspect Ratio 4/3: Ctrl + 3\n"
		"Aspect Ratio 16/9: Ctrl + 4\n"
		
		
		, "Shortcuts Available on Osmo4", MB_OK);
}
