// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "Osmo4.h"
#include "Options.h"

#include "MainFrm.h"
#include <gx.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


#define PSPC_TOOLBAR_HEIGHT 24

const DWORD dwAdornmentFlags = 0; // exit button

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_WM_SETFOCUS()
	ON_WM_ERASEBKGND()
	ON_COMMAND(ID_APP_EXIT, OnAppExit)
	ON_MESSAGE(WM_OPENURL, Open)
	ON_MESSAGE(WM_STOPURL, Stop)
	ON_MESSAGE(WM_SETSIZE,OnSetSize)
	ON_MESSAGE(WM_NAVIGATE,OnNavigate)
	ON_MESSAGE(WM_SETTIMING,SetTiming)
	ON_WM_SIZE()
	ON_COMMAND(IDD_CONFIGURE, OnConfigure)
	ON_COMMAND(ID_FILE_RESTART, OnFileRestart)
	ON_UPDATE_COMMAND_UI(ID_FILE_RESTART, OnUpdateFileRestart)
	ON_COMMAND(ID_FILE_STEP, OnFileStep)
	ON_UPDATE_COMMAND_UI(ID_FILE_STEP, OnUpdateFileStep)
	ON_COMMAND(ID_FILE_PAUSE, OnFilePause)
	ON_UPDATE_COMMAND_UI(ID_FILE_PAUSE, OnUpdateFilePause)
	ON_COMMAND(ID_FILE_STOP, OnFileStop)
	ON_UPDATE_COMMAND_UI(ID_FILE_STOP, OnUpdateFileStop)
	ON_COMMAND(ID_VIEW_CONTROL, OnViewControl)
	ON_UPDATE_COMMAND_UI(ID_VIEW_CONTROL, OnUpdateViewControl)
	ON_COMMAND(ID_VIEW_FULLSCREEN, OnViewFullscreen)
	ON_UPDATE_COMMAND_UI(ID_VIEW_FULLSCREEN, OnUpdateViewFullscreen)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	m_bShowControl = 0;
	m_width = m_height = 0;
	GXOpenInput();
}

CMainFrame::~CMainFrame()
{
	GXCloseInput();
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	// create a view to occupy the client area of the frame
	if (!m_wndView.Create(NULL, NULL, AFX_WS_DEFAULT_VIEW | WS_BORDER,
		CRect(0, 0, 0, 0), this, AFX_IDW_PANE_FIRST, NULL))
	{
		TRACE0("Failed to create view window\n");
		return -1;
	}
	
	if (!m_progBar.Create(IDD_CONTROL , this) ) {
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}
	m_progBar.UpdateWindow();
	m_progBar.SetWindowPos(this, 0, 0, 240, 24, 0L);
	m_progBar.ShowWindow(m_bShowControl ? SW_SHOW : SW_HIDE);
	
	m_wndView.ShowWindow(SW_HIDE);

	m_wndCommandBar.m_bShowSharedNewButton = FALSE;

	if (!m_wndCommandBar.Create(this) 
			|| !m_wndCommandBar.AddAdornments() 
			|| !m_wndCommandBar.LoadToolBar(IDR_MAINFRAME) 
		)
	{
		TRACE0("Failed to create CommandBar\n");
		return -1;      // fail to create
	}

	SetIcon(AfxGetApp()->LoadIcon(IDR_MAINFRAME), TRUE);
	SetIcon(AfxGetApp()->LoadIcon(IDR_MAINFRAME), FALSE);
	
	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs


	cs.lpszClass = AfxRegisterWndClass(0);
	return TRUE;
}



LPTSTR CMainFrame::MakeString(UINT stringID)
{
	TCHAR buffer[255];
	TCHAR* theString;

	::LoadString(AfxGetInstanceHandle(), stringID, buffer, 255);
	theString = new TCHAR[lstrlen(buffer) + 1];
	lstrcpy(theString, buffer);
	return theString;
}   

 
/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers
void CMainFrame::OnSetFocus(CWnd* pOldWnd)
{
	// forward focus to the view window
	m_wndView.SetFocus();
}

BOOL CMainFrame::OnEraseBkgnd(CDC* pDC)
{
	M4T_RefreshWindow(GetApp()->m_term);
	return 1;
}

BOOL CMainFrame::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo)
{
	// let the view have first crack at the command
	if (m_wndView.OnCmdMsg(nID, nCode, pExtra, pHandlerInfo))
		return TRUE;

	// otherwise, do default handling
	return CFrameWnd::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}

void CMainFrame::OnAppExit() 
{
	Stop(0, 0);
	CFrameWnd::PostMessage(WM_QUIT);		
}

#define PROGRESS_TIMER	20
#define PROGRESS_REFRESH_MS		500

void CALLBACK EXPORT ProgressTimer(HWND , UINT , UINT nID , DWORD )
{
	u32 now;
	if (nID != PROGRESS_TIMER) return;
	COsmo4 *app = GetApp();
	CMainFrame *pFrame = (CMainFrame *) app->m_pMainWnd;
	/*shutdown*/
	if (!pFrame) return;

	now = M4T_GetCurrentTimeInMS(app->m_term);
	if (!now) return;

	if (app->max_duration && !pFrame->m_progBar.m_grabbed) {
		if (now>=app->max_duration) {
			if (app->m_Loop)
				pFrame->PostMessage(WM_COMMAND, MAKEWPARAM(ID_FILE_RESTART, 0), 0);
			/*if not looping go on forever*/
		} else {
			pFrame->m_progBar.m_Slider.SetPos(now);
		}
	}

	if (!app->m_prev_time || (app->m_prev_time + 500 <= now)) {
		app->current_FPS = M4T_GetCurrentFPS(app->m_term, 0);
		app->current_time_ms = now;
		if (app->m_Timing) pFrame->PostMessage(WM_SETTIMING, 0, 0);
	}

	if (app->step_mode) {
		if (!app->m_paused) {
			M4T_Pause(app->m_term, 1);
			app->m_paused = 1;
		}
	}
}

void CMainFrame::CloseURL(Bool reset_size)
{
	COsmo4 *app = GetApp();
	if (!app->m_open) return;
	if (m_bFullScreen) OnViewFullscreen();
	M4T_CloseURL(app->m_term);
	app->m_open = 0;
	app->m_paused = 0;
	m_progBar.m_Slider.SetPos(0);
	m_wndView.grabbed = 0;
	m_wndView.current_zoom = 1.0;
	SetWindowText(_T("Osmo4"));
	KillTimer(PROGRESS_TIMER);
	if (reset_size) M4T_SetSize(app->m_term, 0, 0);
}

LONG CMainFrame::Stop(WPARAM wParam, LPARAM lParam)
{
	CloseURL(1);
	return 1;	
}

LONG CMainFrame::Open(WPARAM wParam, LPARAM lParam)
{
	COsmo4 *app = GetApp();
	CloseURL(1);

	if (app->m_url_changed) {
		CString txt = _T("Osmo4 - ");

		unsigned short *name = wcsrchr(app->m_filename, '\\');
		if (!name) name = wcsrchr(app->m_filename, '/');
		if (name) {
			txt += name+1;
		} else {
			txt += app->m_filename;
		}
		SetWindowText(txt);
	}
	SetTimer(PROGRESS_TIMER, PROGRESS_REFRESH_MS, ProgressTimer);
	char filename[5000];
	CE_WideToChar((LPTSTR) (LPCTSTR) app->m_filename, filename);
	M4T_ConnectURL(app->m_term, filename);
	Sleep(100);
	return 1;	
}

void CMainFrame::OnSize(UINT nType, int cx, int cy) 
{
	RECT rc;
	u32 cw, ch, vidw, vidh, x, y;

	GetWindowRect(&rc);
	cw = rc.right - rc.left;
	ch = rc.bottom - rc.top;
	CFrameWnd::OnSize(nType, cw, ch);

	if (!m_bFullScreen && m_bShowControl) {
		m_progBar.GetClientRect(&rc);
		ch -= (rc.bottom - rc.top);
		m_progBar.ShowWindow(SW_SHOW);
	} else {
		m_progBar.ShowWindow(SW_HIDE);
	}

	vidw = cw;
	vidh = ch;
	if (!m_bFullScreen && !GetApp()->m_Fill && m_width && m_height && (m_width < cw) && (m_height < ch)) {
		vidw = m_width;
		vidh = m_height;
	}

	x = 0;
	if (vidw < cw) x = (cw - vidw) / 2;
	y = 0;
	if (vidh < ch) y = (ch - vidh) / 2;

	m_wndView.SetWindowPos(this, x, y, vidw, vidh, SWP_SHOWWINDOW);
	if (!m_bFullScreen) M4T_SetSize(GetApp()->m_term, vidw, vidh);
	M4T_RefreshWindow(GetApp()->m_term);
}

LONG CMainFrame::OnSetSize(WPARAM wParam, LPARAM lParam)
{
	if (wParam && lParam) {
		m_width = wParam;
		m_height = lParam;
	}
	RECT rc;
	GetWindowRect(&rc);
	SetWindowPos(NULL, 0, 0, rc.right-rc.left, rc.bottom-rc.top, SWP_NOZORDER | SWP_NOMOVE);
	GetApp()->m_url_changed = 0;
	return 1;	
}

LONG CMainFrame::OnNavigate(WPARAM /*wParam*/, LPARAM /*lParam*/)
{
	COsmo4 *app = GetApp();
	char to_url[MAX_PATH];
	CE_WideToChar((LPTSTR) (LPCTSTR) app->m_navigate_url, to_url);

	if (strstr(to_url, ".mp4")) {
		char _str[MAX_PATH];
		if (!strstr(to_url, "://") && !strstr(to_url, "/") && !strstr(to_url, "\\") ) {
			CString _last = app->m_filename;
			int res = _last.ReverseFind('\\');
			_last.SetAt(res+1, 0);

			CE_WideToChar((LPTSTR) (LPCTSTR) _last, _str);
			strcat(_str, to_url);
		} else {
			strcpy(_str, to_url);
		}
		console_message = (LPCSTR) _str;
		console_err = M4OK;
		PostMessage(WM_CONSOLEMSG);
		app->m_filename = _str;
		app->m_url_changed = 1;
		Open(0, 0);
	} else {
		SHELLEXECUTEINFO info;
		console_message = app->m_navigate_url;
		console_err = M4OK;
		PostMessage(WM_CONSOLEMSG);
	
		memset(&info, 0, sizeof(SHELLEXECUTEINFO));
		info.cbSize = sizeof(SHELLEXECUTEINFO);
		info.lpVerb = L"open";
		info.fMask = SEE_MASK_NOCLOSEPROCESS;
		info.lpFile = L"iexplore";
		info.lpParameters = (LPCTSTR) app->m_navigate_url;
		info.nShow = SW_SHOWNORMAL;
		ShellExecuteEx(&info);
	}
	return 1;	
}



LONG CMainFrame::SetTiming(WPARAM wParam, LPARAM lParam)
{
	TCHAR sTime[75];
	u32 time_sec;
	COsmo4 *app = GetApp();

	time_sec = app->current_time_ms / 1000;
	wsprintf(sTime, _T("%02d:%02d.%02d - FPS %.1f"), time_sec / 3600, time_sec / 60, time_sec % 60, app->current_FPS);
	SetWindowText(sTime);

	return 1;
}

void CMainFrame::OnConfigure()
{
	COptions dlg;
	dlg.DoModal();
	M4T_RefreshWindow(GetApp()->m_term);
}

void CMainFrame::OnFileRestart()
{
	CloseURL(0);
	Open(0, 0);
	GetApp()->m_open = 1;
	GetApp()->m_prev_time = 0;
}
void CMainFrame::OnUpdateFileRestart(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(GetApp()->m_open ? TRUE : FALSE);
}
void CMainFrame::OnFilePause()
{
	GetApp()->Pause();
}
void CMainFrame::OnUpdateFilePause(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(GetApp()->m_open ? TRUE : FALSE);
}
void CMainFrame::OnFileStop()
{
	Stop(0, 0);
}
void CMainFrame::OnUpdateFileStop(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(GetApp()->m_open ? TRUE : FALSE);
}

void CMainFrame::OnFileStep()
{
	COsmo4 *app = GetApp();
	if (app->m_paused) M4T_Pause(app->m_term, 0);
	app->m_paused = 0;
	app->step_mode = 1;
}
void CMainFrame::OnUpdateFileStep(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(GetApp()->m_open ? TRUE : FALSE);
}

void CMainFrame::OnViewControl()
{
	m_bShowControl = !m_bShowControl;
	OnSetSize(0, 0);
	Invalidate();
}

void CMainFrame::OnUpdateViewControl(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable( (GetApp()->can_seek && GetApp()->m_open) ? TRUE : FALSE);
}

void CMainFrame::OnViewFullscreen() 
{
	COsmo4 *gpac = GetApp();
	if (!gpac->m_open) return;
	
	if (!m_bFullScreen) {
		m_bShowControl = 0;
		m_bFullScreen = 1;
		OnSetSize(0, 0);
		if (M4T_SetOption(gpac->m_term, M4O_Fullscreen, 1) != M4OK) {
			m_bFullScreen = 0;
			OnSetSize(0, 0);
		}
	} else {
		if (M4T_SetOption(gpac->m_term, M4O_Fullscreen, 0) == M4OK) {
			m_bFullScreen = 0;
		}
		OnSetSize(0, 0);
	}
}

void CMainFrame::OnUpdateViewFullscreen(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(GetApp()->m_open ? TRUE : FALSE);
}
