// OptDecoder.cpp : implementation file
//
#include "stdafx.h"
#include "resource.h"
#include "OptDecoder.h"
#include "Osmo4.h"
#include <gpac/m4_decoder.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COptDecoder dialog


COptDecoder::COptDecoder(CWnd* pParent /*=NULL*/)
	: CDialog(COptDecoder::IDD, pParent)
{
	//{{AFX_DATA_INIT(COptDecoder)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void COptDecoder::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COptDecoder)
	DDX_Control(pDX, IDC_VIDEC_LIST, m_Video);
	DDX_Control(pDX, IDC_AUDEC_LIST, m_Audio);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(COptDecoder, CDialog)
	//{{AFX_MSG_MAP(COptDecoder)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COptDecoder message handlers

BOOL COptDecoder::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	COsmo4 *gpac = GetApp();
	char *sOpt;

	/*audio dec enum*/
	while (m_Audio.GetCount()) m_Audio.DeleteString(0);
	sOpt = IF_GetKey(gpac->m_config, "Systems", "DefAudioDec");
	u32 count = PM_GetPluginsCount(gpac->m_plugins);
	DecoderInterface *ifce;
	s32 select = 0;
	s32 to_sel = 0;
	for (u32 i=0; i<count; i++) {
		if (!PM_LoadInterface(gpac->m_plugins, i, M4MEDIADECODERINTERFACE, (void **) &ifce)) continue;
		if (ifce->CanHandleStream(ifce, M4ST_AUDIO, 0, NULL, 0, 0)) {
			if (sOpt && !stricmp(((BaseInterface *)ifce)->plugin_name, sOpt)) select = to_sel;
			TCHAR wzTmp[500];
			CE_CharToWide((char *) ((BaseInterface *)ifce)->plugin_name, wzTmp);
			m_Audio.AddString(wzTmp);
			to_sel++;
		}
		PM_ShutdownInterface(ifce);
	}
	m_Audio.SetCurSel(select);

	/*audio dec enum*/
	while (m_Video.GetCount()) m_Video.DeleteString(0);
	sOpt = IF_GetKey(gpac->m_config, "Systems", "DefVideoDec");
	count = PM_GetPluginsCount(gpac->m_plugins);
	select = 0;
	to_sel = 0;
	for (i=0; i<count; i++) {
		if (!PM_LoadInterface(gpac->m_plugins, i, M4MEDIADECODERINTERFACE, (void **) &ifce)) continue;
		if (ifce->CanHandleStream(ifce, M4ST_VISUAL, 0, NULL, 0, 0)) {
			if (sOpt && !stricmp(((BaseInterface *)ifce)->plugin_name, sOpt)) select = to_sel;
			TCHAR wzTmp[500];
			CE_CharToWide((char *) ((BaseInterface *)ifce)->plugin_name, wzTmp);
			m_Video.AddString(wzTmp);
			to_sel++;
		}
		PM_ShutdownInterface(ifce);
	}
	m_Video.SetCurSel(select);

	return TRUE;
}

void COptDecoder::SaveOptions()
{
	COsmo4 *gpac = GetApp();
	TCHAR wstr[100];
	char str[100];

	m_Audio.GetWindowText(wstr, 50);
	CE_WideToChar(wstr, str);
	IF_SetKey(gpac->m_config, "Systems", "DefAudioDec", str);
	m_Video.GetWindowText(wstr, 50);
	CE_WideToChar(wstr, str);
	IF_SetKey(gpac->m_config, "Systems", "DefVideoDec", str);
}

