// OptGen.cpp : implementation file
//

#include "stdafx.h"
#include "Osmo4.h"
#include "OptGen.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COptGen dialog


COptGen::COptGen(CWnd* pParent /*=NULL*/)
	: CDialog(COptGen::IDD, pParent)
{
	//{{AFX_DATA_INIT(COptGen)
	//}}AFX_DATA_INIT
}


void COptGen::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COptGen)
	DDX_Control(pDX, IDC_FILL_SCREEN, m_Fill);
	DDX_Control(pDX, IDC_VIEW_FPS, m_Timing);
	DDX_Control(pDX, IDC_NO_CONSOLE, m_NoConsole);
	DDX_Control(pDX, IDC_AUTOSTART, m_Start);
	DDX_Control(pDX, IDC_LOOP, m_Loop);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(COptGen, CDialog)
	//{{AFX_MSG_MAP(COptGen)
	ON_BN_CLICKED(IDC_FILEASSOC, OnFileassoc)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COptGen message handlers



BOOL COptGen::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	COsmo4 *gpac = GetApp();
	char *sOpt;
	
	sOpt = IF_GetKey(gpac->m_config, "General", "Loop");
	if (sOpt && !stricmp(sOpt, "yes")) {
		m_Loop.SetCheck(1);
	} else {
		m_Loop.SetCheck(0);
	}
	sOpt = IF_GetKey(gpac->m_config, "General", "AutoStart");
	if (sOpt && !stricmp(sOpt, "no")) {
		m_Start.SetCheck(0);
	} else {
		m_Start.SetCheck(1);
	}
	sOpt = IF_GetKey(gpac->m_config, "General", "ConsoleOff");
	if (sOpt && !stricmp(sOpt, "yes")) {
		m_NoConsole.SetCheck(1);
	} else {
		m_NoConsole.SetCheck(0);
	}
	sOpt = IF_GetKey(gpac->m_config, "General", "FillScreen");
	if (sOpt && !stricmp(sOpt, "yes")) {
		m_Fill.SetCheck(1);
	} else {
		m_Fill.SetCheck(0);
	}
	sOpt = IF_GetKey(gpac->m_config, "General", "ViewTiming");
	if (sOpt && !stricmp(sOpt, "yes")) {
		m_Timing.SetCheck(1);
	} else {
		m_Timing.SetCheck(0);
	}
	
	return TRUE; 
}

void COptGen::SaveOptions()
{
	COsmo4 *gpac = GetApp();

	gpac->m_Loop = m_Loop.GetCheck();
	IF_SetKey(gpac->m_config, "General", "Loop", gpac->m_Loop ? "yes" : "no");
	gpac->m_AutoStart = m_Start.GetCheck();
	IF_SetKey(gpac->m_config, "General", "AutoStart",  gpac->m_AutoStart ? "yes" : "no");
	gpac->m_NoConsole = m_NoConsole.GetCheck();
	IF_SetKey(gpac->m_config, "General", "ConsoleOff", gpac->m_NoConsole ? "yes" : "no");
	gpac->m_Fill = m_Fill.GetCheck();
	IF_SetKey(gpac->m_config, "General", "FillScreen", gpac->m_Fill ? "yes" : "no");
	gpac->m_Timing = m_Timing.GetCheck();
	IF_SetKey(gpac->m_config, "General", "ViewTiming", gpac->m_Timing ? "yes" : "no");

}

void COptGen::OnFileassoc() 
{
	HKEY hSection;
	TCHAR szDir[MAX_PATH];
	char szTemp[MAX_PATH];
	TCHAR cmd[MAX_PATH];
	DWORD ioSize = MAX_PATH;
	DWORD dwDisp;

	RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("SOFTWARE\\Osmo4"), 0, KEY_READ, &hSection);
	wcscpy(szDir, AfxGetApp()->m_pszHelpFilePath);
	while (szDir[strlen((char *) szDir)-1] != (TCHAR) '\\') szDir[strlen((char *) szDir)-1] = 0;
	if (!hSection) 
		RegCreateKeyEx(HKEY_LOCAL_MACHINE, _T("SOFTWARE\\Osmo4"), 0, NULL, REG_OPTION_NON_VOLATILE, KEY_WRITE, NULL, &hSection, &dwDisp);

	CE_WideToChar(szDir, szTemp);
	/*overwrite install dir with current path*/
	RegSetValueEx(hSection, _T("Install_Dir"), 0, REG_SZ, (const unsigned char *) szTemp, strlen(szTemp)+1);
	RegCloseKey(hSection);


	/*overwrite .mp4 file associations */
	RegCreateKeyEx(HKEY_CLASSES_ROOT, _T("mp4file\\DefaultIcon"), 0, NULL, REG_OPTION_NON_VOLATILE, KEY_WRITE, NULL, &hSection, &dwDisp);
	wcscpy(cmd, szDir);
	wcscat(cmd, _T("Osmo4.ico") );
	CE_WideToChar(cmd, szTemp);

	RegSetValueEx(hSection, _T(""), 0, REG_SZ, (const unsigned char *) szTemp, strlen((const char *) szTemp)+1);
	RegCloseKey(hSection);

	RegCreateKeyEx(HKEY_CLASSES_ROOT, _T("mp4file\\Shell\\open\\command"), 0, NULL, REG_OPTION_NON_VOLATILE, KEY_WRITE, NULL, &hSection, &dwDisp);
	wcscpy(cmd, szDir);
	wcscat(cmd, _T("Osmo4.exe \"%L\"") );
	CE_WideToChar(cmd, szTemp);
	RegSetValueEx(hSection, _T(""), 0, REG_SZ, (const unsigned char *) szTemp, strlen(szTemp)+1);
	RegCloseKey(hSection);

	RegCreateKeyEx(HKEY_CLASSES_ROOT, _T(".mp4"), 0, NULL, REG_OPTION_NON_VOLATILE, KEY_WRITE, NULL, &hSection, &dwDisp);
	RegSetValueEx(hSection, _T(""), 0, REG_SZ, (const unsigned char *) "mp4file", strlen("mp4file")+1);
	RegCloseKey(hSection);
}

