// Osmo4.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "Osmo4.h"

#include "MainFrm.h"
#include "OpenDlg.h"
#include <gx.h>


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COsmo4

BEGIN_MESSAGE_MAP(COsmo4, CWinApp)
	//{{AFX_MSG_MAP(COsmo4)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()





Bool Osmo4CE_EventProc(void *priv, M4Event *event)
{
	u32 dur;
	COsmo4 *app = (COsmo4 *) priv;
	CMainFrame *pFrame = (CMainFrame *) app->m_pMainWnd;
	/*shutdown*/
	if (!pFrame) return 0;

	switch (event->type) {
	case M4E_MESSAGE:
		if (event->message.error!=M4OK) {
			if (event->message.error<M4OK || !app->m_NoConsole) {
				pFrame->console_err = event->message.error;
				pFrame->console_message = event->message.message;
				pFrame->PostMessage(WM_CONSOLEMSG, 0, 0);
			}
			return 0;
		}
		if (app->m_NoConsole) return 0;
		/*process user message*/
		pFrame->console_err = M4OK;
		pFrame->console_message = event->message.message;
		pFrame->PostMessage(WM_CONSOLEMSG, 0, 0);
		break;
	case M4E_SCENESIZE:
		app->m_open = 1;
		app->max_duration = (u32) -1;
		if (app->m_url_changed) app->m_CheckOpen = 1;
		app->m_prev_time = 0;
		pFrame->PostMessage(WM_SETSIZE, event->size.width, event->size.height);
		break;
	case M4E_DURATION:
		dur = (u32) (1000 * event->duration.duration);
		if (dur<2000) dur = 0;
		app->max_duration = dur;

		if (!dur) {
			if(pFrame->m_bShowControl) pFrame->PostMessage(WM_COMMAND, ID_VIEW_CONTROL, 0L);
			app->can_seek = 0;
			pFrame->m_progBar.m_Slider.EnableWindow(FALSE);
		} else {
			app->can_seek = 1;
			pFrame->m_progBar.m_Slider.EnableWindow(TRUE);
			pFrame->m_progBar.m_Slider.SetRangeMin(0);
			pFrame->m_progBar.m_Slider.SetRangeMax(dur);
			if (!app->m_AutoStart && app->m_CheckOpen) app->m_pMainWnd->PostMessage(WM_STOPURL, 0, 0);
			app->m_CheckOpen = 0;
		}
		break;
	case M4E_NAVIGATE:
		/*store URL since it may be destroyed, and post message*/
		app->m_navigate_url = event->navigate.to_url;
		pFrame->PostMessage(WM_NAVIGATE, NULL, NULL);
		return 1;
	case M4E_QUIT:
		pFrame->PostMessage(WM_CLOSE, 0L, 0L);
		break;
	/*ipaq keys*/
	case M4E_VKEYDOWN:
		switch (event->key.m4_vk_code) {
		case M4VK_F1: 
			pFrame->PostMessage(WM_COMMAND, ID_FILE_OPEN); 
			break;
		case M4VK_F2:
			pFrame->PostMessage(WM_QUIT); 
			break;
		case M4VK_F3:
			pFrame->PostMessage(WM_COMMAND, ID_FILE_RESTART);
			break;
		case M4VK_F5:
			pFrame->PostMessage(WM_COMMAND, ID_VIEW_FULLSCREEN);
			break;
		case M4VK_RETURN:
			pFrame->PostMessage(WM_COMMAND, ID_FILE_PAUSE);
			break;
		case M4VK_LEFT:
			if (app->max_duration>=2000) {
				s32 res = M4T_GetCurrentTimeInMS(app->m_term) - 5*app->max_duration/100;
				if (res<0) res=0;
				M4T_PlayFromTime(app->m_term, res);
			}
			break;
		case M4VK_RIGHT:
			if (app->max_duration>=2000) {
				u32 res = M4T_GetCurrentTimeInMS(app->m_term) + 5*app->max_duration/100;
				if (res>=app->max_duration) res = 0;
				M4T_PlayFromTime(app->m_term, res);
			}
			break;
		case M4VK_UP:
			if (app->max_duration>=2000) pFrame->PostMessage(WM_COMMAND, ID_FILE_STEP);	
			break;
		case M4VK_DOWN:
			M4T_RefreshWindow(app->m_term);
			break;
		}
		break;
	}
	return 0;
}

COsmo4::COsmo4()
	: CWinApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only COsmo4 object

COsmo4 theApp;

/////////////////////////////////////////////////////////////////////////////
// COsmo4 initialization

BOOL COsmo4::InitInstance()
{
	if (!AfxSocketInit())
	{
		AfxMessageBox(IDP_SOCKETS_INIT_FAILED);
		return FALSE;
	}

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

	// Change the registry key under which our settings are stored.
	// You should modify this string to be something appropriate
	// such as the name of your company or organization.
	SetRegistryKey(_T("GPAC"));

	// To create the main window, this code creates a new frame window
	// object and then sets it as the application's main window object.

	CMainFrame* pFrame = new CMainFrame;
	m_pMainWnd = pFrame;


	// create and load the frame with its resources

	pFrame->LoadFrame(IDR_MAINFRAME,
		WS_OVERLAPPEDWINDOW | FWS_ADDTOTITLE, NULL,
		NULL);

	pFrame->ShowWindow(m_nCmdShow);
	pFrame->UpdateWindow();


	unsigned char config_path[MAX_PATH];
	CE_WideToChar((unsigned short *) (LPCTSTR) AfxGetApp()->m_pszHelpFilePath, (char *) config_path);

	while (config_path[strlen((char *) config_path)-1] != '\\') config_path[strlen((char *) config_path)-1] = 0;

	/*init config and plugins*/
	m_config = NewIniFile((const char *) config_path, "GPAC.cfg");
	if (!m_config) {
		/*create blank config file in the exe dir*/
		unsigned char config_file[MAX_PATH];
		strcpy((char *) config_file, (const char *) config_path);
		strcat((char *) config_file, "GPAC.cfg");
		FILE *ft = fopen((const char *) config_file, "wt");
		fclose(ft);
		m_config = NewIniFile((const char *) config_path, "GPAC.cfg");
		if (!m_config) {
			MessageBox(NULL, _T("GPAC Configuration file not found"), _T("Fatal Error"), MB_OK);
			m_pMainWnd->PostMessage(WM_CLOSE);
		}
	}
	char *str = IF_GetKey(m_config, "General", "PluginsDirectory");
	m_plugins = NewPluginManager((const unsigned char *) str, m_config);
	if (!m_plugins) {
		char *sOpt;
		/*inital launch*/
		m_plugins = NewPluginManager((const unsigned char *) config_path, m_config);
		if (m_plugins) {
			IF_SetKey(m_config, "General", "PluginsDirectory", (const char *) config_path);

			sOpt = IF_GetKey(m_config, "Render2D", "GraphicsDriver");
			if (!sOpt) IF_SetKey(m_config, "Render2D", "GraphicsDriver", "m4_rend");

			sOpt = IF_GetKey(m_config, "Downloader", "CacheDirectory");
			if (!sOpt) {
				unsigned char str_path[MAX_PATH];
				sprintf((char *) str_path, "%scache", config_path);
				IF_SetKey(m_config, "Downloader", "CacheDirectory", (const char *) str_path);
			}
			/*setup UDP traffic autodetect*/
			IF_SetKey(m_config, "Network", "AutoReconfigUDP", "yes");
			IF_SetKey(m_config, "Network", "UDPNotAvailable", "no");
			IF_SetKey(m_config, "Network", "UDPTimeout", "10000");
			IF_SetKey(m_config, "Network", "BufferLength", "3000");
		}

		/*check audio config on windows, force config*/
		sOpt = IF_GetKey(m_config, "Audio", "ForceConfig");
		if (!sOpt) {
			IF_SetKey(m_config, "Audio", "ForceConfig", "no");
			IF_SetKey(m_config, "Audio", "NumBuffers", "8");
			IF_SetKey(m_config, "Audio", "BuffersPerSecond", "16");
		}
		/*by default use GDIplus, much faster than freetype on font loading*/
		IF_SetKey(m_config, "FontEngine", "DriverName", "gdip_rend");
	}	
	if (! PM_GetPluginsCount(m_plugins) ) {
		MessageBox(NULL, _T("No plugins available - system cannot work"), _T("Fatal Error"), MB_OK);
		m_pMainWnd->PostMessage(WM_QUIT);
	}

	/*setup font dir*/
	str = IF_GetKey(m_config, "FontEngine", "FontDirectory");
	if (!str || !strlen(str) ) {
		strcpy((char *) config_path, "\\Windows");
		IF_SetKey(m_config, "FontEngine", "FontDirectory", (const char *) config_path);
	}
	/*work with iPaq's default fonts ...*/
	str = IF_GetKey(m_config, "FontEngine", "FontSerif");
	if (!str) IF_SetKey(m_config, "FontEngine", "FontSerif", "Tahoma");
	str = IF_GetKey(m_config, "FontEngine", "FontSans");
	if (!str) IF_SetKey(m_config, "FontEngine", "FontSans", "Frutiger");
	str = IF_GetKey(m_config, "FontEngine", "FontFixed");
	if (!str) IF_SetKey(m_config, "FontEngine", "FontFixed", "Courier New");

	/*audio only works with free config*/
	IF_SetKey(m_config, "Audio", "ForceConfig", "no");

	/*check video driver, if none or raw_out use dx_hw by default*/
	str = IF_GetKey(m_config, "Video", "DriverName");
	if (!str || !stricmp(str, "raw_out")) {
		IF_SetKey(m_config, "Video", "DriverName", "dx_hw");
	}

	/*setup user*/
	memset(&m_user, 0, sizeof(M4User));
	m_user.config = m_config;
	m_user.plugins = m_plugins;
	m_user.EventProc = Osmo4CE_EventProc;
	m_user.opaque = this;
	m_user.os_window_handler = pFrame->m_wndView.m_hWnd;


	m_term = NewMPEG4Term(&m_user);
	if (! m_term) {
		MessageBox(NULL, _T("Cannot load MPEG-4 Terminal"), _T("Fatal Error"), MB_OK);
		m_pMainWnd->PostMessage(WM_QUIT);
	}

	SetOptions();

	pFrame->m_wndView.SetWindowPos(NULL, 0, 0, 240, 320-2*26, SWP_NOZORDER | SWP_SHOWWINDOW);
	M4T_RefreshWindow(m_term);

	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);


	m_url_changed = 0;
	if (! cmdInfo.m_strFileName.IsEmpty()) {
		m_filename = cmdInfo.m_strFileName;
		m_url_changed = 1;
		m_pMainWnd->PostMessage(WM_OPENURL);
	}

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// COsmo4 message handlers





/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	CStatic	m_Version;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	virtual BOOL OnInitDialog();		// Added for WCE apps
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	DDX_Control(pDX, IDC_VERSION, m_Version);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void COsmo4::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// COsmo4 commands
// Added for WCE apps

BOOL CAboutDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	CString str = _T("GPAC Version ");
	str += _T(M4_VERSION);
	m_Version.SetWindowText(str);
	return TRUE;  
}

int COsmo4::ExitInstance() 
{
	M4T_Delete(m_term);
	PM_Delete(m_plugins);
	IF_Delete(m_config);
	
	return CWinApp::ExitInstance();
}

void COsmo4::SetOptions()
{
	char *sOpt = IF_GetKey(m_config, "General", "Loop");
	if (sOpt && !stricmp(sOpt, "yes")) {
		m_Loop = 1;
	} else {
		m_Loop = 0;
	}
	sOpt = IF_GetKey(m_config, "General", "AutoStart");
	if (sOpt && !stricmp(sOpt, "no")) {
		m_AutoStart = 0;
	} else {
		m_AutoStart = 1;
	}
	sOpt = IF_GetKey(m_config, "General", "ConsoleOff");
	if (sOpt && !stricmp(sOpt, "yes")) {
		m_NoConsole = 1;
	} else {
		m_NoConsole = 0;
	}
	sOpt = IF_GetKey(m_config, "General", "FillScreen");
	if (sOpt && !stricmp(sOpt, "yes")) {
		m_Fill = 1;
	} else {
		m_Fill = 0;
	}
	sOpt = IF_GetKey(m_config, "General", "ViewTiming");
	if (sOpt && !stricmp(sOpt, "yes")) {
		m_Timing = 1;
	} else {
		m_Timing = 0;
	}
	M4T_SetOption(m_term, M4O_AspectRatio, M4_AR_Keep);
	m_prev_time = 0;
}


void COsmo4::Pause()
{
	if (!m_open) return;
	m_paused = !m_paused;
	step_mode = 0;
	
	if (m_paused) GXSuspend();
	M4T_Pause(m_term, m_paused);
	if (!m_paused) GXResume();

}

void COsmo4::OnFileOpen() 
{
	OpenDlg dlg;

	Pause();
	Sleep(500);
	if (dlg.DoModal() == IDOK) {
		m_url_changed = 1;
		m_pMainWnd->PostMessage(WM_OPENURL);
	}
	Pause();
	M4T_RefreshWindow(m_term);
}
