// ProgressBar.cpp : implementation file
//

#include "stdafx.h"
#include "Osmo4.h"
#include "ProgressBar.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// ProgressBar dialog


ProgressBar::ProgressBar(CWnd* pParent /*=NULL*/)
	: CDialog(ProgressBar::IDD, pParent)
{
	//{{AFX_DATA_INIT(ProgressBar)
	//}}AFX_DATA_INIT

	m_grabbed = 0;
}


void ProgressBar::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(ProgressBar)
	DDX_Control(pDX, IDC_SLIDER, m_Slider);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(ProgressBar, CDialog)
	//{{AFX_MSG_MAP(ProgressBar)
	ON_WM_SIZE()
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_PLAY, OnPlay)
	ON_BN_CLICKED(IDC_STOP, OnStop)
	ON_WM_HSCROLL()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// ProgressBar message handlers

void ProgressBar::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);

	if (!m_Slider.m_hWnd) return;

	RECT rc;
	m_Slider.GetClientRect(&rc);
	rc.right = rc.left + cx;
	m_Slider.MoveWindow(&rc);
}

void ProgressBar::OnClose() 
{
	GetApp()->GetMainWnd()->PostMessage(WM_CLOSE);
}

void ProgressBar::OnPlay() 
{
	COsmo4 *gpac = GetApp();
	
	if (!gpac->m_open) {
		gpac->m_pMainWnd->PostMessage(WM_OPENURL);
	} else {
		gpac->Pause();
	}
}

void ProgressBar::OnStop() 
{
	COsmo4 *gpac = GetApp();
	GetApp()->GetMainWnd()->PostMessage(WM_STOPURL);
}

void ProgressBar::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	COsmo4 *gpac = GetApp();
	

	if (pScrollBar->GetDlgCtrlID() == IDC_SLIDER) {
		switch (nSBCode) {
		case TB_LINEUP:
		case TB_LINEDOWN:
		case TB_PAGEUP:
		case TB_PAGEDOWN:
		case TB_THUMBPOSITION:
		case TB_THUMBTRACK:
		case TB_TOP:
		case TB_BOTTOM:
			m_grabbed = 1;
			break;
		case TB_ENDTRACK:
			if (!gpac->can_seek || !gpac->m_open) {
				m_Slider.SetPos(0);
			} else {
				u32 seek_to = m_Slider.GetPos();
				M4T_PlayFromTime(gpac->m_term, seek_to);
			}
			m_grabbed = 0;
			break;
		}
	}
	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}
