#ifndef _V4_FIELD_LIST_H
#define _V4_FIELD_LIST_H

#include "safe_include.h" 
#include <gpac/m4_scenegraph.h>

#include <wx/grid.h>


class V4FieldList: public wxGrid {

public:
	V4FieldList(wxWindow *parent, wxSize size);
	~V4FieldList(); 

	void SetNode(SFNode *node) { m_pNode = node; }
	
	void Create(); 
	void GetFieldValue(FieldInfo f, wxString *s, int pos);
	void SetFieldValue(FieldInfo f, wxString *s, int pos);

	void OnCellChanged(wxGridEvent &evt);
	void OnCellLeftClick(wxGridEvent &evt);
	void OnCellRightClick(wxGridEvent &evt);
	void OnCellLeftDClick(wxGridEvent &evt);
protected:
    DECLARE_EVENT_TABLE()

private:
	void SetLog(wxString s);

	void InsertOneFieldRow(u32 position, FieldInfo field);

	void SetCellFieldValue(FieldInfo field, u32 pos);

	SFNode * m_pNode;
	Chain *positions;
};

#endif
