#include "safe_include.h" 

#include "wx/wxprec.h"

#ifndef WX_PRECOMP
  #include "wx/wx.h"
#endif

#include "V4StudioFrame.h"
#include "wx/xrc/xmlres.h"

V4StudioFrame::V4StudioFrame():
    wxFrame((wxFrame *) NULL, -1, "V4Studio", wxPoint(50, 50), wxSize(800, 700))
{

	// Initialization of a V4SceneGraph to pass it to GPACPanel, TreeView ...
	m_pV4sg = new V4SceneGraph();
	m_selection = NULL;
	m_parentSelection = NULL;
	m_clipboardNode = NULL;

    gpacPanel = new wxGPACPanel(this);

	m_pV4sg->SetRenderer(gpacPanel->GetSceneRenderer());
	m_pV4sg->SetSceneSize(100, 100);

    fieldView = new V4FieldList(this, wxSize(100,250));

    treeView = new V4StudioTree(this, wxSize(100,250), fieldView);

	SetMenuBar(wxXmlResource::Get()->LoadMenuBar("MB_V4STUDIO"));
	
    m_pStatusbar = CreateStatusBar();
    m_pToolbar = new wxToolBar(this, -1, wxDefaultPosition, wxDefaultSize, wxTB_HORIZONTAL|wxTB_FLAT);
    m_pToolbar->AddTool(TOOL_FILE_NEW, _("New"), wxBitmap (wxT("rc\\new.bmp"), wxBITMAP_TYPE_ANY), wxNullBitmap, wxITEM_NORMAL, _("Open a new file"), wxT(""));
    m_pToolbar->AddTool(TOOL_FILE_OPEN_BT, _("BTOpen"), wxBitmap (wxT("rc\\open.bmp"), wxBITMAP_TYPE_ANY), wxNullBitmap, wxITEM_NORMAL, _("Open an existing BT file"), wxT(""));
    m_pToolbar->AddTool(TOOL_FILE_OPEN_MP4, _("MP4Open"), wxBitmap (wxT("rc\\open.bmp"), wxBITMAP_TYPE_ANY), wxNullBitmap, wxITEM_NORMAL, _("Open an existing MP4 file"), wxT(""));
    m_pToolbar->AddTool(TOOL_FILE_SAVE, _("Save"), wxBitmap (wxT("rc\\save.bmp"), wxBITMAP_TYPE_ANY), wxNullBitmap, wxITEM_NORMAL, _("Save to a file"), wxT(""));
    m_pToolbar->AddTool(TOOL_FILE_PREVIEW, _("Preview"), wxBitmap (wxT("rc\\preview.bmp"), wxBITMAP_TYPE_ANY), wxNullBitmap, wxITEM_NORMAL, _("Preview in player"), wxT(""));
    m_pToolbar->AddSeparator();
    m_pToolbar->AddTool(TOOL_EDIT_CUT, _("Cut"), wxBitmap (wxT("rc\\cut.bmp"), wxBITMAP_TYPE_ANY), wxNullBitmap, wxITEM_NORMAL, _("Cut"), wxT(""));
    m_pToolbar->AddTool(TOOL_EDIT_COPY, _("Copy"), wxBitmap (wxT("rc\\copy.bmp"), wxBITMAP_TYPE_ANY), wxNullBitmap, wxITEM_NORMAL, _("Copy"), wxT(""));
    m_pToolbar->AddTool(TOOL_EDIT_PASTE, _("Paste"), wxBitmap (wxT("rc\\paste.bmp"), wxBITMAP_TYPE_ANY), wxNullBitmap, wxITEM_NORMAL, _("Paste"), wxT(""));
    m_pToolbar->AddTool(TOOL_EDIT_PASTE_USE, _("PastePlus"), wxBitmap (wxT("rc\\paste_use.bmp"), wxBITMAP_TYPE_ANY), wxNullBitmap, wxITEM_NORMAL, _("Paste a USE"), wxT(""));
    m_pToolbar->AddTool(TOOL_EDIT_DELETE, _("Delete"), wxBitmap (wxT("rc\\delete.bmp"), wxBITMAP_TYPE_ANY), wxNullBitmap, wxITEM_NORMAL, _("Delete"), wxT(""));
    m_pToolbar->AddSeparator();
    m_pToolbar->AddTool(TOOL_EDIT_UNDO, _("Undo"), wxBitmap (wxT("rc\\undo.bmp"), wxBITMAP_TYPE_ANY), wxNullBitmap, wxITEM_NORMAL, _("Undo"), wxT(""));
    m_pToolbar->AddTool(TOOL_EDIT_REDO, _("Redo"), wxBitmap (wxT("rc\\redo.bmp"), wxBITMAP_TYPE_ANY), wxNullBitmap, wxITEM_NORMAL, _("Redo"), wxT(""));
    m_pToolbar->AddSeparator();
    wxComboBox *combo = new wxComboBox(m_pToolbar, TOOL_FRAME_COMBO, _T("0"), wxDefaultPosition, wxSize(50,-1) );
    combo->Append(_T("0"));
    combo->Append(_T("1"));
    combo->Append(_T("2"));
    combo->Append(_T("3"));
    m_pToolbar->AddControl(combo);
   
	m_pToolbar->EnableTool(TOOL_EDIT_CUT, false);
	m_pToolbar->EnableTool(TOOL_EDIT_COPY, false);
	m_pToolbar->EnableTool(TOOL_EDIT_PASTE, false);
	m_pToolbar->EnableTool(TOOL_EDIT_PASTE_USE, false);
	m_pToolbar->EnableTool(TOOL_EDIT_DELETE, false);
	m_pToolbar->Realize();
	SetToolBar(m_pToolbar);

    aToolbar = new wxToolBar(this, -1, wxDefaultPosition, wxDefaultSize, wxTB_VERTICAL|wxTB_FLAT);
    aToolbar->AddTool(TOOL_NEW_ORDEREDGROUP, _("OrderedGroup"), wxBitmap (wxT("rc\\orderedgroup.bmp"), wxBITMAP_TYPE_ANY), wxNullBitmap, wxITEM_NORMAL, _("Create an OrderedGroup"), wxT(""));
    aToolbar->AddTool(TOOL_NEW_LAYER2D, _("Layer2D"), wxBitmap (wxT("rc\\layer2d.bmp"), wxBITMAP_TYPE_ANY), wxNullBitmap, wxITEM_NORMAL, _("Create a Layer2D"), wxT(""));
    aToolbar->AddTool(TOOL_NEW_TRANSFORM2D, _("Transform2D"), wxBitmap (wxT("rc\\t2d.bmp"), wxBITMAP_TYPE_ANY), wxNullBitmap, wxITEM_NORMAL, _("Create a Tranform2D"), wxT(""));
    aToolbar->AddTool(TOOL_NEW_TRANSFORMMATRIX2D, _("TransformMatrix2D"), wxBitmap (wxT("rc\\tm2d.bmp"), wxBITMAP_TYPE_ANY), wxNullBitmap, wxITEM_NORMAL, _("Create a TranformMatrix2D"), wxT(""));
	aToolbar->AddTool(TOOL_NEW_COLOR_TRANSFORM, _("ColorTransform"), wxBitmap (wxT("rc\\colortransform.bmp"), wxBITMAP_TYPE_ANY), wxNullBitmap, wxITEM_NORMAL, _("Create a ColorTransform"), wxT(""));
    aToolbar->AddTool(TOOL_NEW_SHAPE, _("Shape"), wxBitmap (wxT("rc\\shape.bmp"), wxBITMAP_TYPE_ANY), wxNullBitmap, wxITEM_NORMAL, _("Create a Shape"), wxT(""));
    aToolbar->AddSeparator();
    aToolbar->AddTool(TOOL_NEW_APPEARANCE, _("Appearance"), wxBitmap (wxT("rc\\appearance.bmp"), wxBITMAP_TYPE_ANY), wxNullBitmap, wxITEM_NORMAL, _("Create an Appearance"), wxT(""));
    aToolbar->AddTool(TOOL_NEW_MATERIAL2D, _("Material2D"), wxBitmap (wxT("rc\\material2d.bmp"), wxBITMAP_TYPE_ANY), wxNullBitmap, wxITEM_NORMAL, _("Create a Material2D"), wxT(""));
    aToolbar->AddTool(TOOL_NEW_LINEPROPS, _("LineProps"), wxBitmap (wxT("rc\\lineproperties.bmp"), wxBITMAP_TYPE_ANY), wxNullBitmap, wxITEM_NORMAL, _("Create a LineProperties"), wxT(""));
    aToolbar->AddTool(TOOL_NEW_LINEAR_GRADIENT, _("LinearGradient"), wxBitmap (wxT("rc\\lg.bmp"), wxBITMAP_TYPE_ANY), wxNullBitmap, wxITEM_NORMAL, _("Create a Linear Gradient"), wxT(""));
    aToolbar->AddTool(TOOL_NEW_RADIAL_GRADIENT, _("RadialGradient"), wxBitmap (wxT("rc\\rg.bmp"), wxBITMAP_TYPE_ANY), wxNullBitmap, wxITEM_NORMAL, _("Create a Radial Gradient"), wxT(""));
    aToolbar->AddSeparator();
    aToolbar->AddTool(TOOL_NEW_RECT, _("Rectangle"), wxBitmap (wxT("rc\\rect.bmp"), wxBITMAP_TYPE_ANY), wxNullBitmap, wxITEM_NORMAL, _("Create a Rectangle"), wxT(""));
    aToolbar->AddTool(TOOL_NEW_CIRCLE, _("Circle"), wxBitmap (wxT("rc\\circle.bmp"), wxBITMAP_TYPE_ANY), wxNullBitmap, wxITEM_NORMAL, _("Create a Rectangle"), wxT(""));
    aToolbar->AddTool(TOOL_NEW_IFS2D, _("IndexedFaceSet2D"), wxBitmap (wxT("rc\\ifs2d.bmp"), wxBITMAP_TYPE_ANY), wxNullBitmap, wxITEM_NORMAL, _("Create an IndexedFaceSet2D"), wxT(""));
    aToolbar->AddTool(TOOL_NEW_ILS2D, _("IndexedLineSet2D"), wxBitmap (wxT("rc\\ils2d.bmp"), wxBITMAP_TYPE_ANY), wxNullBitmap, wxITEM_NORMAL, _("Create an IndexedLineSet2D"), wxT(""));
    aToolbar->AddTool(TOOL_NEW_XLINEPROPS, _("XLineProps"), wxBitmap (wxT("rc\\xlineproperties.bmp"), wxBITMAP_TYPE_ANY), wxNullBitmap, wxITEM_NORMAL, _("Create an XLineProperties"), wxT(""));
    aToolbar->AddSeparator();
    aToolbar->AddTool(TOOL_NEW_TEXT, _("Text"), wxBitmap (wxT("rc\\text.bmp"), wxBITMAP_TYPE_ANY), wxNullBitmap, wxITEM_NORMAL, _("Create a Text"), wxT(""));
    aToolbar->AddTool(TOOL_NEW_FONTSTYLE, _("FontStyle"), wxBitmap (wxT("rc\\fs.bmp"), wxBITMAP_TYPE_ANY), wxNullBitmap, wxITEM_NORMAL, _("Create a FontStyle"), wxT(""));
    aToolbar->AddSeparator();
    aToolbar->AddTool(TOOL_NEW_BACKGROUND2D, _("Background2D"), wxBitmap (wxT("rc\\image.bmp"), wxBITMAP_TYPE_ANY), wxNullBitmap, wxITEM_NORMAL, _("Add a Background2D"), wxT(""));
    aToolbar->AddTool(TOOL_NEW_MOVIE, _("Movie"), wxBitmap (wxT("rc\\movie.bmp"), wxBITMAP_TYPE_ANY), wxNullBitmap, wxITEM_NORMAL, _("Add a Movie"), wxT(""));
    aToolbar->AddTool(TOOL_NEW_IMAGE, _("Image"), wxBitmap (wxT("rc\\image.bmp"), wxBITMAP_TYPE_ANY), wxNullBitmap, wxITEM_NORMAL, _("Add an Image"), wxT(""));
    aToolbar->AddTool(TOOL_NEW_SOUND, _("Sound"), wxBitmap (wxT("rc\\sound.bmp"), wxBITMAP_TYPE_ANY), wxNullBitmap, wxITEM_NORMAL, _("Add a Sound"), wxT(""));
	aToolbar->Realize();

    set_properties();
    do_layout();

	m_pV4sg->LoadNew();	
	SceneGraphChanged();
}

V4StudioFrame::~V4StudioFrame()
{
	if (m_pV4sg) delete m_pV4sg;
	/*renderer shall be destroyed last*/
	if (gpacPanel) delete gpacPanel;
}

void V4StudioFrame::OnChangeSize(wxCommandEvent &event) 
{
    u32 w, h;
	wxSize sceneSize;
	m_pV4sg->GetSceneSize(sceneSize);	
	w = sceneSize.GetX();
	h = sceneSize.GetY();
	wxString sSize;
	sSize.Printf("%d %d", w, h);
	wxTextEntryDialog dialog(this,
                           _T("Enter the scene width and height"),
                           _T("Please enter two integer numbers"),
                           sSize,
                           wxOK | wxCANCEL);

	while (dialog.ShowModal() != wxID_OK) {}
	sscanf(dialog.GetValue(), "%d %d", &w, &h);
	m_pV4sg->SetSceneSize(w,h);
	dialog.Destroy();
	SceneGraphChanged();
}

void V4StudioFrame::SceneGraphChanged() 
{
	m_selection = m_pV4sg->GetRootNode();
	treeView->SetSceneGraph(m_pV4sg->GetSceneGraph());
	m_parentSelection = NULL;
	wxSize sceneSize;
	m_pV4sg->GetSceneSize(sceneSize);	
	gpacPanel->SetSize(sceneSize.x, sceneSize.y);
    Layout();
	Update();
}

void V4StudioFrame::set_properties()
{
    SetTitle(_("V4Studio"));
    wxIcon _icon;
    _icon.CopyFromBitmap(wxBitmap(_("rc\\v4.bmp"), wxBITMAP_TYPE_ANY));
    SetIcon(_icon);
    SetSize(wxSize(500, 500));
}


void V4StudioFrame::do_layout()
{

	wxBoxSizer* sizer_8 = new wxBoxSizer(wxHORIZONTAL);
	sizer_8->Add(treeView, 1, wxEXPAND, 0);
    sizer_8->Add(fieldView, 1, wxEXPAND, 0);
    

	wxBoxSizer* sizer_9 = new wxBoxSizer(wxHORIZONTAL);
	sizer_9->Add(aToolbar, 0, wxEXPAND, 0);
	sizer_9->Add(sizer_8, 1, wxEXPAND, 0);

    //wxBoxSizer* sizer_7 = new wxBoxSizer(wxHORIZONTAL);
	//sizer_7->Add(sizer_9, 1, wxEXPAND, 0);
    //sizer_7->Add(gpacPanel, 1, wxALL | wxALIGN_CENTER, 5);
    SetAutoLayout(true);
    SetSizer(sizer_9);
    Layout();
}


BEGIN_EVENT_TABLE(V4StudioFrame, wxFrame)
EVT_MENU(MENU_FILE_NEW, V4StudioFrame::OnMenuFileNew)
EVT_MENU(MENU_FILE_OPEN, V4StudioFrame::OnMenuFileOpen)
EVT_MENU(MENU_FILE_SAVE, V4StudioFrame::OnMenuFileSave)
EVT_MENU(MENU_FILE_QUIT, V4StudioFrame::OnMenuFileQuit)
EVT_MENU(CHANGE_SIZE_DIALOG, V4StudioFrame::OnChangeSize)
EVT_TOOL(TOOL_FILE_NEW, V4StudioFrame::OnNew)
EVT_TOOL(TOOL_FILE_OPEN_BT, V4StudioFrame::OnBTFileOpen)
EVT_TOOL(TOOL_FILE_OPEN_MP4, V4StudioFrame::OnMP4FileOpen)
EVT_TOOL(TOOL_FILE_SAVE, V4StudioFrame::OnMenuFileSave)
EVT_TOOL(TOOL_EDIT_CUT, V4StudioFrame::OnEditCut)
EVT_TOOL(TOOL_EDIT_COPY, V4StudioFrame::OnEditCopy)
EVT_TOOL(TOOL_EDIT_PASTE, V4StudioFrame::OnEditPaste)
EVT_TOOL(TOOL_EDIT_PASTE_USE, V4StudioFrame::OnEditPasteUse)
EVT_TOOL(TOOL_EDIT_DELETE, V4StudioFrame::OnEditDelete)
EVT_TOOL(TOOL_NEW_ORDEREDGROUP, V4StudioFrame::OnNewOrderedGroup)
EVT_TOOL(TOOL_NEW_LAYER2D, V4StudioFrame::OnNewLayer2D)
EVT_TOOL(TOOL_NEW_TRANSFORM2D, V4StudioFrame::OnNewTransform2D)
EVT_TOOL(TOOL_NEW_TRANSFORMMATRIX2D, V4StudioFrame::OnNewTransformMatrix2D)
EVT_TOOL(TOOL_NEW_COLOR_TRANSFORM, V4StudioFrame::OnNewColorTransform)
EVT_TOOL(TOOL_NEW_SHAPE, V4StudioFrame::OnNewShape)
EVT_TOOL(TOOL_NEW_APPEARANCE, V4StudioFrame::OnNewAppearance)
EVT_TOOL(TOOL_NEW_LINEAR_GRADIENT, V4StudioFrame::OnNewLinearGradient)
EVT_TOOL(TOOL_NEW_RADIAL_GRADIENT, V4StudioFrame::OnNewRadialGradient)
EVT_TOOL(TOOL_NEW_MATERIAL2D, V4StudioFrame::OnNewMaterial2D)
EVT_TOOL(TOOL_NEW_LINEPROPS, V4StudioFrame::OnNewLineProps)
EVT_TOOL(TOOL_NEW_XLINEPROPS, V4StudioFrame::OnNewXLineProps)
EVT_TOOL(TOOL_NEW_RECT, V4StudioFrame::OnNewRect)
EVT_TOOL(TOOL_NEW_CIRCLE, V4StudioFrame::OnNewCircle)
EVT_TOOL(TOOL_NEW_TEXT, V4StudioFrame::OnNewText)
EVT_TOOL(TOOL_NEW_FONTSTYLE, V4StudioFrame::OnNewFontStyle)
EVT_TOOL(TOOL_NEW_SOUND, V4StudioFrame::OnNewSound)
EVT_TOOL(TOOL_NEW_BACKGROUND2D, V4StudioFrame::OnNewBackground2D)
EVT_TOOL(TOOL_NEW_IMAGE, V4StudioFrame::OnNewImageTexture)
EVT_TOOL(TOOL_NEW_MOVIE, V4StudioFrame::OnNewMovieTexture)
EVT_COMBOBOX(TOOL_FRAME_COMBO, V4StudioFrame::OnCombo)
END_EVENT_TABLE()


void V4StudioFrame::OnMenuFileNew(wxCommandEvent &event)
{
	wxLogMessage("New File Selected");	
}

void V4StudioFrame::OnMenuFileOpen(wxCommandEvent &event)
{
	wxLogMessage("Menu File Open Selected");
}

void V4StudioFrame::OnNew(wxCommandEvent &event)
{
	m_pV4sg->LoadNew();
	Layout();
	SetStatusText("New scene", 0);
	SceneGraphChanged();
}

void V4StudioFrame::OnBTFileOpen(wxCommandEvent &event)
{
  wxFileDialog *dlg = new wxFileDialog(this, "Open a bt scene",
									   "", "", "BT Files (*.bt)|*.bt|All files (*.*)|*.*",
									   wxOPEN, wxDefaultPosition);
  if ( dlg->ShowModal() == wxID_OK )
  {
	m_pV4sg->LoadBTFile(dlg->GetPath().c_str());
	wxSize sceneSize;
	m_pV4sg->GetSceneSize(sceneSize);
	gpacPanel->SetSize(sceneSize.x, sceneSize.y);
	Layout();
	SetStatusText(dlg->GetFilename(), 0);
  }
  dlg->Destroy();
  SceneGraphChanged();
}

void V4StudioFrame::OnMP4FileOpen(wxCommandEvent &event)
{
  wxFileDialog *dlg = new wxFileDialog(this, "Open an mp4 file",
									   "", "", "MPEG-4 Files (*.mp4)|*.mp4|All files (*.*)|*.*",
									   wxOPEN, wxDefaultPosition);
  if ( dlg->ShowModal() == wxID_OK )
  {
	m_pV4sg->LoadMP4File(dlg->GetPath().c_str());
	SetStatusText(dlg->GetFilename(), 0);
  }
  dlg->Destroy();
  SceneGraphChanged();
}

void V4StudioFrame::OnMenuFileSave(wxCommandEvent &event)
{
  wxFileDialog *dlg = new wxFileDialog(this, "Save the scene to an mp4 file",
									   "", "", "MPEG-4 Files (*.mp4)|*.mp4|All files (*.*)|*.*",
									   wxSAVE, wxDefaultPosition);
  if ( dlg->ShowModal() == wxID_OK )
  {
	m_pV4sg->SaveFile(dlg->GetPath().c_str());
	SetStatusText(dlg->GetFilename(), 0);
  }
  dlg->Destroy();
}

void V4StudioFrame::OnMenuFileQuit(wxCommandEvent &event)
{
	Close(FALSE);
}

void V4StudioFrame::OnNewOrderedGroup(wxCommandEvent &event) 
{
	SFNode *top = m_pV4sg->GetRootNode();
	if (!top) {
		top = m_pV4sg->SetTopNode(TAG_OrderedGroup);
		m_selection = top;
		m_parentSelection = NULL;
	} else {
		B_OrderedGroup *og = (B_OrderedGroup *)m_pV4sg->NewNode(TAG_OrderedGroup);
		Node_InsertChild(m_selection, (SFNode *)og, -1);
		m_parentSelection = (SFNode *)m_selection;
		m_selection = (SFNode *)og;
	}
	Update();
}

void V4StudioFrame::OnNewLayer2D(wxCommandEvent &event) 
{
	SFNode *top = m_pV4sg->GetRootNode();
	if (!top) {
		top = m_pV4sg->SetTopNode(TAG_Layer2D);
		m_selection = top;
		m_parentSelection = NULL;
	} else {
		B_Layer2D *l2d = (B_Layer2D *)m_pV4sg->NewNode(TAG_Layer2D);
		Node_InsertChild(m_selection, (SFNode *)l2d, -1);
		m_parentSelection = (SFNode *)m_selection;
		m_selection = (SFNode *)l2d;
	}
	Update();
}

void V4StudioFrame::OnNewText(wxCommandEvent &event) 
{
	B_Text *text = (B_Text *) m_pV4sg->NewNode(TAG_Text);
	B_Shape *shape = (B_Shape *)m_selection;
	shape->geometry = (SFNode *)text;
	m_selection = (SFNode *)text;
	m_parentSelection = (SFNode *)shape;
	Update();
}

void V4StudioFrame::OnNewFontStyle(wxCommandEvent &event) 
{
	B_FontStyle *fs = (B_FontStyle *) m_pV4sg->NewNode(TAG_FontStyle);
	B_Text *text = (B_Text *)m_selection;
	text->fontStyle = (SFNode *)fs;
	m_selection = (SFNode *)fs;
	m_parentSelection = (SFNode *)text;
	Update();
}

void V4StudioFrame::OnNewRect(wxCommandEvent &event) 
{
	B_Rectangle *rect = (B_Rectangle *) m_pV4sg->NewNode(TAG_Rectangle);
	B_Shape *shape = (B_Shape *)m_selection;
	shape->geometry = (SFNode *)rect;
	m_selection = (SFNode *)rect;
	m_parentSelection = (SFNode *)shape;
	Update();
}

void V4StudioFrame::OnNewCircle(wxCommandEvent &event) 
{
	B_Circle *circle = (B_Circle *) m_pV4sg->NewNode(TAG_Circle);
	B_Shape *shape = (B_Shape *)m_selection;
	shape->geometry = (SFNode *)circle;
	circle->radius = 75;
	m_selection = (SFNode *)circle;
	m_parentSelection = (SFNode *)shape;
	Update();
}

void V4StudioFrame::OnNewTransform2D(wxCommandEvent &event)
{
	B_Transform2D *t2d = (B_Transform2D *)m_pV4sg->NewNode(TAG_Transform2D);
	if (!m_selection) m_selection = m_pV4sg->GetRootNode();
	Node_InsertChild(m_selection, (SFNode *)t2d, -1);
	m_parentSelection = (SFNode *)m_selection;
	m_selection = (SFNode *)t2d;
	Update();
}

void V4StudioFrame::OnNewColorTransform(wxCommandEvent &event)
{
	B_ColorTransform *ct = (B_ColorTransform *)m_pV4sg->NewNode(TAG_ColorTransform);
	if (!m_selection) m_selection = m_pV4sg->GetRootNode();
	Node_InsertChild(m_selection, (SFNode *)ct, -1);
	m_parentSelection = (SFNode *)m_selection;
	m_selection = (SFNode *)ct;
	Update();
}

void V4StudioFrame::OnNewTransformMatrix2D(wxCommandEvent &event)
{
	B_TransformMatrix2D *tm2d = (B_TransformMatrix2D *)m_pV4sg->NewNode(TAG_TransformMatrix2D);
	if (!m_selection) m_selection = m_pV4sg->GetRootNode();
	Node_InsertChild(m_selection, (SFNode *)tm2d, -1);
	m_parentSelection = (SFNode *)m_selection;
	m_selection = (SFNode *)tm2d;
	Update();
}

void V4StudioFrame::OnNewShape(wxCommandEvent &event)
{
	B_Shape *shape = (B_Shape *)m_pV4sg->NewNode(TAG_Shape);
	Node_InsertChild(m_selection, (SFNode *)shape, -1);
	m_parentSelection = (SFNode *)m_selection;
	m_selection = (SFNode *)shape;
	Update();
}

void V4StudioFrame::OnNewAppearance(wxCommandEvent &event) 
{
	B_Appearance *app = (B_Appearance*)m_pV4sg->NewNode(TAG_Appearance);
	B_Shape *shape = (B_Shape *)m_selection;
	shape->appearance = (SFNode *)app;
	m_parentSelection = (SFNode *)m_selection;
	m_selection = (SFNode *)app;
	Update();
}

void V4StudioFrame::OnNewLinearGradient(wxCommandEvent &event)
{
	B_LinearGradient *lg = (B_LinearGradient *)m_pV4sg->NewNode(TAG_LinearGradient);
	B_Appearance *app = (B_Appearance *)m_selection;
	app->texture = (SFNode *)lg;
	m_parentSelection = (SFNode *)m_selection;
	m_selection = (SFNode *)lg;
	Update();
}

void V4StudioFrame::OnNewRadialGradient(wxCommandEvent &event)
{
	B_RadialGradient *rg = (B_RadialGradient*)m_pV4sg->NewNode(TAG_RadialGradient);
	B_Appearance *app = (B_Appearance *)m_selection;
	app->texture = (SFNode *)rg;
	m_parentSelection = (SFNode *)m_selection;
	m_selection = (SFNode *)rg;
	Update();
}


void V4StudioFrame::OnNewMaterial2D(wxCommandEvent &event)
{
	B_Material2D *mat2d = (B_Material2D*)m_pV4sg->NewNode(TAG_Material2D);
	B_Appearance *app = (B_Appearance *)m_selection;
	app->material = (SFNode *)mat2d;
	m_parentSelection = (SFNode *)m_selection;
	m_selection = (SFNode *)mat2d;
	Update();
}

void V4StudioFrame::OnNewLineProps(wxCommandEvent &event)
{
	B_LineProperties *lp = (B_LineProperties*)m_pV4sg->NewNode(TAG_LineProperties);
	B_Material2D *mat2d= (B_Material2D *)m_selection;
	mat2d->lineProps = (SFNode *)lp;
	m_parentSelection = (SFNode *)m_selection;
	m_selection = (SFNode *)lp;
	Update();
}

void V4StudioFrame::OnNewXLineProps(wxCommandEvent &event)
{
	B_XLineProperties *lp = (B_XLineProperties*)m_pV4sg->NewNode(TAG_XLineProperties);
	B_Material2D *mat2d= (B_Material2D *)m_selection;
	mat2d->lineProps = (SFNode *)lp;
	m_parentSelection = (SFNode *)m_selection;
	m_selection = (SFNode *)lp;
	Update();
}

void V4StudioFrame::OnNewSound(wxCommandEvent &event)
{
}

void V4StudioFrame::OnNewBackground2D(wxCommandEvent &event)
{
	B_Background2D *b2d = (B_Background2D *)m_pV4sg->NewNode(TAG_Background2D);
	Node_InsertChild(m_selection, (SFNode *)b2d, -1);
	m_parentSelection = (SFNode *)m_selection;
	m_selection = (SFNode *)b2d;
	Update();
}

void V4StudioFrame::OnNewImageTexture(wxCommandEvent &event)
{
	B_ImageTexture *it = (B_ImageTexture *)m_pV4sg->NewNode(TAG_ImageTexture);
	B_Appearance *app = (B_Appearance *)m_selection;
	app->texture = (SFNode *)it;
	m_parentSelection = (SFNode *)m_selection;
	m_selection = (SFNode *)it;
	Update();
}

void V4StudioFrame::OnNewMovieTexture(wxCommandEvent &event)
{
	B_MovieTexture *mt = (B_MovieTexture *)m_pV4sg->NewNode(TAG_MovieTexture);
	B_Appearance *app = (B_Appearance *)m_selection;
	app->texture = (SFNode *)mt;
	m_parentSelection = (SFNode *)m_selection;
	m_selection = (SFNode *)mt;
	Update();
}

void V4StudioFrame::UpdateSelection(SFNode *node, SFNode *parent) 
{
	SetSelection(node);
	SetParentSelection(parent);
	m_pToolbar->EnableTool(TOOL_EDIT_CUT, true);
	m_pToolbar->EnableTool(TOOL_EDIT_COPY, true);
	m_pToolbar->EnableTool(TOOL_EDIT_DELETE, true);
	UpdateToolBar();
	fieldView->SetNode(node);
	fieldView->Create();
}


void V4StudioFrame::Update() 
{
	gpacPanel->Update();
	treeView->Refresh();
	UpdateToolBar();
}

void V4StudioFrame::UpdateToolBar()
{
	bool enableGeometry = false, enableAppearance =false, 
		 enableMaterial = false, enableGroupNode = false,
		 enableLineProps = false, enableFontStyle = false, 
		 enable2DNode = false, enableTexture = false, enableTopNode = false;
	if (m_selection == NULL) {
		enableTopNode = true;
	} else {
		u32 tag = (m_selection != NULL?Node_GetTag(m_selection):TAG_OrderedGroup);
		SFNode * node = m_selection;
		switch (tag) {
		case TAG_OrderedGroup:
		case TAG_Layer2D:
		case TAG_Transform2D:
		case TAG_TransformMatrix2D:
		case TAG_ColorTransform:
			enableGroupNode = true;
			enable2DNode = true;
			break;
		case TAG_Shape:
			if (!((B_Shape *)node)->geometry) enableGeometry = true;
			if (!((B_Shape *)node)->appearance) enableAppearance = true;
			break;
		case TAG_Appearance:
			if (!((B_Appearance *)node)->material) enableMaterial = true;
			if (!((B_Appearance *)node)->texture) enableTexture = true;
			break;
		case TAG_Material2D:
			if (!((B_Material2D *)node)->lineProps) enableLineProps = true;
			break;
		case TAG_Text:
			if (!((B_Text *)node)->fontStyle) enableFontStyle = true;
			break;
		case TAG_Rectangle:
		case TAG_Circle:
		case TAG_ImageTexture:
		case TAG_MovieTexture:
		case TAG_Background2D:
			break;
		}
	}
	aToolbar->EnableTool(TOOL_NEW_ORDEREDGROUP, enableGroupNode || enable2DNode || enableTopNode);
	aToolbar->EnableTool(TOOL_NEW_LAYER2D, enableGroupNode || enable2DNode || enableTopNode);
	aToolbar->EnableTool(TOOL_NEW_TRANSFORM2D, enableGroupNode || enable2DNode);
	aToolbar->EnableTool(TOOL_NEW_COLOR_TRANSFORM, enableGroupNode || enable2DNode);
	aToolbar->EnableTool(TOOL_NEW_TRANSFORMMATRIX2D, enableGroupNode || enable2DNode);
	aToolbar->EnableTool(TOOL_NEW_SHAPE, enable2DNode);
    aToolbar->EnableTool(TOOL_NEW_RECT, enableGeometry);
	aToolbar->EnableTool(TOOL_NEW_CIRCLE, enableGeometry);
	aToolbar->EnableTool(TOOL_NEW_IFS2D, enableGeometry);
	aToolbar->EnableTool(TOOL_NEW_ILS2D, enableGeometry);
	aToolbar->EnableTool(TOOL_NEW_TEXT, enableGeometry);
    aToolbar->EnableTool(TOOL_NEW_MOVIE, enableTexture);
    aToolbar->EnableTool(TOOL_NEW_IMAGE, enableTexture);
	aToolbar->EnableTool(TOOL_NEW_SOUND, enable2DNode);
	aToolbar->EnableTool(TOOL_NEW_APPEARANCE, enableAppearance);
	aToolbar->EnableTool(TOOL_NEW_MATERIAL2D, enableMaterial);
	aToolbar->EnableTool(TOOL_NEW_LINEAR_GRADIENT, enableTexture);
	aToolbar->EnableTool(TOOL_NEW_RADIAL_GRADIENT, enableTexture);
	aToolbar->EnableTool(TOOL_NEW_LINEPROPS, enableLineProps);
	aToolbar->EnableTool(TOOL_NEW_XLINEPROPS, enableLineProps);
	aToolbar->EnableTool(TOOL_NEW_FONTSTYLE, enableFontStyle);
}

void V4StudioFrame::OnEditCut(wxCommandEvent &WXUNUSED(event))
{
    if (m_selection) {
		m_clipboardNode = m_selection;
		m_clipboardParentNode = m_parentSelection;
		Node_RemoveChild(m_parentSelection, m_selection);
		m_pToolbar->EnableTool(TOOL_EDIT_CUT, true);
		m_pToolbar->EnableTool(TOOL_EDIT_COPY, true);
		m_pToolbar->EnableTool(TOOL_EDIT_PASTE, true);
		m_pToolbar->EnableTool(TOOL_EDIT_PASTE_USE, false);
		m_pToolbar->EnableTool(TOOL_EDIT_DELETE, false);
	}
	Update();
}

void V4StudioFrame::OnEditDelete(wxCommandEvent &WXUNUSED(event))
{
    if (m_selection) {
		Node_RemoveChild(m_parentSelection, m_selection);
		m_clipboardNode = NULL;
		m_clipboardParentNode = NULL;
		m_pToolbar->EnableTool(TOOL_EDIT_CUT, false);
		m_pToolbar->EnableTool(TOOL_EDIT_COPY, false);
		m_pToolbar->EnableTool(TOOL_EDIT_PASTE, false);
		m_pToolbar->EnableTool(TOOL_EDIT_PASTE_USE, false);
		m_pToolbar->EnableTool(TOOL_EDIT_DELETE, false);
	}
	Update();
}

void V4StudioFrame::OnEditCopy(wxCommandEvent &WXUNUSED(event))
{
    if (m_selection) {
		m_clipboardNode = m_selection;
		m_clipboardParentNode = m_parentSelection;
		m_pToolbar->EnableTool(TOOL_EDIT_CUT, true);
		m_pToolbar->EnableTool(TOOL_EDIT_COPY, true);
		m_pToolbar->EnableTool(TOOL_EDIT_PASTE, true);
		m_pToolbar->EnableTool(TOOL_EDIT_PASTE_USE, true);
		m_pToolbar->EnableTool(TOOL_EDIT_DELETE, false);
    }
}

void V4StudioFrame::OnEditPaste(wxCommandEvent &WXUNUSED(event))
{
    if (m_clipboardNode != NULL) {	
		SFNode *copy = m_pV4sg->CopyNode(m_clipboardNode, m_parentSelection, true);
		Node_InsertChild(m_selection, copy, -1);
		m_pToolbar->EnableTool(TOOL_EDIT_CUT, true);
		m_pToolbar->EnableTool(TOOL_EDIT_COPY, true);
		m_pToolbar->EnableTool(TOOL_EDIT_PASTE, true);
		m_pToolbar->EnableTool(TOOL_EDIT_PASTE_USE, false);
		m_pToolbar->EnableTool(TOOL_EDIT_DELETE, false);
    }
	Update();
}

void V4StudioFrame::OnEditPasteUse(wxCommandEvent &WXUNUSED(event))
{
    if (m_clipboardNode != NULL) {
		SFNode *copy = m_pV4sg->CopyNode(m_clipboardNode, m_parentSelection, false);
		Node_Register(copy, m_selection);
		Node_InsertChild(m_selection, copy, -1);
		m_pToolbar->EnableTool(TOOL_EDIT_CUT, true);
		m_pToolbar->EnableTool(TOOL_EDIT_COPY, true);
		m_pToolbar->EnableTool(TOOL_EDIT_PASTE, true);
		m_pToolbar->EnableTool(TOOL_EDIT_PASTE_USE, false);
		m_pToolbar->EnableTool(TOOL_EDIT_DELETE, false);
    }
	Update();
}

void V4StudioFrame::OnCombo(wxCommandEvent& event)
{
	u32 commandNumber;
    sscanf(event.GetString().c_str(), "%d", &commandNumber);
	m_pV4sg->LoadCommand(commandNumber);
	Update();
}

