#ifndef V4STUDIO_FRAME_H
#define V4STUDIO_FRAME_H

#include <wx/wx.h>
#include <wx/image.h>
#include <wx/listctrl.h>

#include "safe_include.h" 

#include "V4SceneGraph.h" 
#include "V4StudioTree.h"
#include "V4FieldList.h"
#include "wxGPACPanel.h"

enum {
	// Menu commands
	MENU_FILE_NEW,
	MENU_FILE_OPEN,
	MENU_FILE_SAVE,
	MENU_FILE_QUIT,

	// Generic Toolbar commands
    TOOL_FILE_NEW,
    TOOL_FILE_OPEN_BT,
    TOOL_FILE_OPEN_MP4,
    TOOL_FILE_SAVE,
    TOOL_FILE_PREVIEW,
    TOOL_EDIT_CUT,
    TOOL_EDIT_COPY,
    TOOL_EDIT_PASTE,
	TOOL_EDIT_PASTE_USE,
    TOOL_EDIT_DELETE,
    TOOL_EDIT_UNDO,
    TOOL_EDIT_REDO,
	TOOL_FRAME_COMBO,

	CHANGE_SIZE_DIALOG,

	// 2D node Toolbar commands
	TOOL_NEW_ORDEREDGROUP,
	TOOL_NEW_LAYER2D,
	TOOL_NEW_TRANSFORM2D,
	TOOL_NEW_TRANSFORMMATRIX2D,
	TOOL_NEW_COLOR_TRANSFORM,
	TOOL_NEW_SHAPE,

	// Appearance and sub-appearance Toolbar commands
	TOOL_NEW_APPEARANCE,
	TOOL_NEW_MATERIAL2D,
	TOOL_NEW_LINEPROPS,
	TOOL_NEW_XLINEPROPS,
	TOOL_NEW_FONTSTYLE,
	TOOL_NEW_LINEAR_GRADIENT,
	TOOL_NEW_RADIAL_GRADIENT,

	// Geometry Toolbar commands
    TOOL_NEW_RECT, 
    TOOL_NEW_CIRCLE,
    TOOL_NEW_IFS2D, 
    TOOL_NEW_ILS2D, 
    TOOL_NEW_TEXT, 

	// Media Toolbar commands
	TOOL_NEW_BACKGROUND2D,
	TOOL_NEW_MOVIE,
	TOOL_NEW_IMAGE,
	TOOL_NEW_SOUND
};

class V4StudioFrame: public wxFrame {
public:
    V4StudioFrame();
    ~V4StudioFrame();

	/**
	* Processes menu File|New
	*/
	void OnMenuFileNew(wxCommandEvent &event);
	/**
	* Processes menu File|Open
	*/
	void OnMenuFileOpen(wxCommandEvent &event);
	/**
	* Processes menu File|Save
	*/
	void OnMenuFileSave(wxCommandEvent &event);
	/**
	* Processes menu File|Quit
	*/
	void OnMenuFileQuit(wxCommandEvent &event);

	void OnChangeSize(wxCommandEvent &event);

	void OnNew(wxCommandEvent &event);
	void OnBTFileOpen(wxCommandEvent &event);
	void OnMP4FileOpen(wxCommandEvent &event);


	void OnEditCut(wxCommandEvent &event);
	void OnEditCopy(wxCommandEvent &event);
	void OnEditPaste(wxCommandEvent &event);
	void OnEditPasteUse(wxCommandEvent &event);
	void OnEditDelete(wxCommandEvent &event);


	void SceneGraphChanged();

	void OnNewLayer2D(wxCommandEvent &event);
	void OnNewOrderedGroup(wxCommandEvent &event);
	void OnNewTransform2D(wxCommandEvent &event);
	void OnNewTransformMatrix2D(wxCommandEvent &event);
	void OnNewColorTransform(wxCommandEvent &event);
	void OnNewShape(wxCommandEvent &event);
	void OnNewAppearance(wxCommandEvent &event);
	void OnNewMaterial2D(wxCommandEvent &event);
	void OnNewLinearGradient(wxCommandEvent &event);
	void OnNewRadialGradient(wxCommandEvent &event);
	void OnNewLineProps(wxCommandEvent &event);
	void OnNewXLineProps(wxCommandEvent &event);
	void OnNewText(wxCommandEvent &event);
	void OnNewFontStyle(wxCommandEvent &event);
	void OnNewRect(wxCommandEvent &event);
	void OnNewCircle(wxCommandEvent &event);
	void OnNewSound(wxCommandEvent &event);
	void OnNewBackground2D(wxCommandEvent &event);
	void OnNewImageTexture(wxCommandEvent &event);
	void OnNewMovieTexture(wxCommandEvent &event);
	void OnCombo(wxCommandEvent& event);

	void Update();
	void UpdateSelection(SFNode *node, SFNode *parent);

	void SetSelection(SFNode *node) { m_selection = node; }
	void SetParentSelection(SFNode *node) { m_parentSelection = node; }
	void UpdateToolBar();
	V4FieldList *GetFieldView() { return fieldView; }
	V4StudioTree *GetTreeView() { return treeView; }
	wxGPACPanel *GetGPACPanel() { return gpacPanel; }

private:
    void set_properties();
    void do_layout();

protected:

	DECLARE_EVENT_TABLE()

	V4SceneGraph *m_pV4sg;
	SFNode *m_selection;
	SFNode *m_parentSelection;
	SFNode *m_clipboardNode;
	SFNode *m_clipboardParentNode;

    V4StudioTree* treeView;
    wxGPACPanel* gpacPanel;
    V4FieldList* fieldView;
    wxMenuBar* m_pMenubar;
    wxStatusBar* m_pStatusbar;
    wxToolBar* m_pToolbar;
	wxToolBar *aToolbar;
};


#endif 

