#ifndef _V4STUDIO_TREE_H
#define _V4STUDIO_TREE_H

#include "safe_include.h" 
#include <gpac/m4_scenegraph.h>
#include "V4FieldList.h"

#include <wx/treectrl.h>

class V4StudioTreeItemData : public wxTreeItemData {
public:
	V4StudioTreeItemData(SFNode *n, SFNode *p, s32 fi, s32 pos = -1) : node(n), parent(p), fieldIndex(fi), position(pos) {}

public:
	SFNode *GetNode() { return node; }
	void SetNode(SFNode *n) { node = n; }
	M4Err GetField(FieldInfo *f);

	SFNode *GetNodeParent() { return parent; }
	void SetNodeParent(SFNode *n) { parent = n; }
	s32 GetPosition() { return position; }
	void SetPosition(s32 pos) { position = pos; }
	void SetFieldIndex(s32 i) { fieldIndex = i; }
	s32 GetFieldIndex() { return fieldIndex; }

private:
	SFNode *node;
	SFNode *parent;
	s32 fieldIndex;
	s32 position;

};

class V4StudioTree: public wxTreeCtrl {

public:
    enum
    {
        TreeCtrlIcon_File,
        TreeCtrlIcon_FileSelected,
        TreeCtrlIcon_Folder,
        TreeCtrlIcon_FolderSelected,
        TreeCtrlIcon_FolderOpened
    };

	V4StudioTree(wxWindow *parent, wxSize size, V4FieldList *fieldView);

	void CreateImageList(int size = 16);

	void SetSceneGraph(LPSCENEGRAPH sg) { m_pSg = sg; }
	
	void Refresh(); 

	void OnSelChanged(wxTreeEvent& event);
	void OnItemRightClick(wxTreeEvent &event);
	void ShowMenu(wxTreeItemId id, const wxPoint& pt);
	void OnBeginDrag(wxTreeEvent& event);
	void OnEndDrag(wxTreeEvent& event);

	void SetSelectedItem(SFNode *node);
	void Translate(int dX, int dY);
	void Scale(int dX, int dY);
	void Rotate(int dX, int dY);
	wxTreeItemId FindNodeItem(wxTreeItemId itemId, SFNode *node);
	SFNode *FindTransformNode(wxTreeItemId itemId);

protected:
    DECLARE_EVENT_TABLE()

private:
	void AddNodesToItem(wxTreeItemId parentItemId, SFNode * node, s32 fieldIndex, s32 position);
	LPSCENEGRAPH m_pSg;
	V4FieldList *m_pFieldView;

    wxTreeItemId m_selectedItem;             // item being dragged right now
    wxTreeItemId m_draggedItem;             // item being dragged right now

	SFNode * m_selectedNode;
	SFNode * m_transformNode;

};

#endif
