/*
 *			GPAC - MPEG-4 Systems C Development Kit
 *
 *			Copyright (c) Jean Le Feuvre 2000-2003
 *					All rights reserved
 *
 *  This file is part of GPAC / Scene Graph sub-project
 *
 *  GPAC is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  GPAC is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.	
 *
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


/*FILE AUTOMATICALLY GENERATED BY SGGen - DO NOT MOFIFY*/



#include <gpac/intern/m4_node_tables.h>


u32 ALL_GetNodeType(const u32 *table, const u32 count, u32 NodeTag, u32 Version)
{
	u32 i = 0;
	while (i<count) {
		if (table[i] == NodeTag) goto found;
		i++;
	}
	return 0;
found:
	if (Version == 2) return i+2;
	return i+1;
}

u32 NDT_V1_GetNodeType(u32 NDT_Tag, u32 NodeTag)
{
	if(!NDT_Tag || !NodeTag) return 0;
	switch(NDT_Tag) {
	case NDT_SFWorldNode:
		return ALL_GetNodeType(SFWorldNode_V1_TypeToTag, SFWorldNode_V1_Count, NodeTag, BIFS_V1);
	case NDT_SF3DNode:
		return ALL_GetNodeType(SF3DNode_V1_TypeToTag, SF3DNode_V1_Count, NodeTag, BIFS_V1);
	case NDT_SF2DNode:
		return ALL_GetNodeType(SF2DNode_V1_TypeToTag, SF2DNode_V1_Count, NodeTag, BIFS_V1);
	case NDT_SFStreamingNode:
		return ALL_GetNodeType(SFStreamingNode_V1_TypeToTag, SFStreamingNode_V1_Count, NodeTag, BIFS_V1);
	case NDT_SFAppearanceNode:
		return ALL_GetNodeType(SFAppearanceNode_V1_TypeToTag, SFAppearanceNode_V1_Count, NodeTag, BIFS_V1);
	case NDT_SFAudioNode:
		return ALL_GetNodeType(SFAudioNode_V1_TypeToTag, SFAudioNode_V1_Count, NodeTag, BIFS_V1);
	case NDT_SFBackground3DNode:
		return ALL_GetNodeType(SFBackground3DNode_V1_TypeToTag, SFBackground3DNode_V1_Count, NodeTag, BIFS_V1);
	case NDT_SFBackground2DNode:
		return ALL_GetNodeType(SFBackground2DNode_V1_TypeToTag, SFBackground2DNode_V1_Count, NodeTag, BIFS_V1);
	case NDT_SFGeometryNode:
		return ALL_GetNodeType(SFGeometryNode_V1_TypeToTag, SFGeometryNode_V1_Count, NodeTag, BIFS_V1);
	case NDT_SFColorNode:
		return ALL_GetNodeType(SFColorNode_V1_TypeToTag, SFColorNode_V1_Count, NodeTag, BIFS_V1);
	case NDT_SFTextureNode:
		return ALL_GetNodeType(SFTextureNode_V1_TypeToTag, SFTextureNode_V1_Count, NodeTag, BIFS_V1);
	case NDT_SFCoordinateNode:
		return ALL_GetNodeType(SFCoordinateNode_V1_TypeToTag, SFCoordinateNode_V1_Count, NodeTag, BIFS_V1);
	case NDT_SFCoordinate2DNode:
		return ALL_GetNodeType(SFCoordinate2DNode_V1_TypeToTag, SFCoordinate2DNode_V1_Count, NodeTag, BIFS_V1);
	case NDT_SFExpressionNode:
		return ALL_GetNodeType(SFExpressionNode_V1_TypeToTag, SFExpressionNode_V1_Count, NodeTag, BIFS_V1);
	case NDT_SFFaceDefMeshNode:
		return ALL_GetNodeType(SFFaceDefMeshNode_V1_TypeToTag, SFFaceDefMeshNode_V1_Count, NodeTag, BIFS_V1);
	case NDT_SFFaceDefTablesNode:
		return ALL_GetNodeType(SFFaceDefTablesNode_V1_TypeToTag, SFFaceDefTablesNode_V1_Count, NodeTag, BIFS_V1);
	case NDT_SFFaceDefTransformNode:
		return ALL_GetNodeType(SFFaceDefTransformNode_V1_TypeToTag, SFFaceDefTransformNode_V1_Count, NodeTag, BIFS_V1);
	case NDT_SFFAPNode:
		return ALL_GetNodeType(SFFAPNode_V1_TypeToTag, SFFAPNode_V1_Count, NodeTag, BIFS_V1);
	case NDT_SFFDPNode:
		return ALL_GetNodeType(SFFDPNode_V1_TypeToTag, SFFDPNode_V1_Count, NodeTag, BIFS_V1);
	case NDT_SFFITNode:
		return ALL_GetNodeType(SFFITNode_V1_TypeToTag, SFFITNode_V1_Count, NodeTag, BIFS_V1);
	case NDT_SFFogNode:
		return ALL_GetNodeType(SFFogNode_V1_TypeToTag, SFFogNode_V1_Count, NodeTag, BIFS_V1);
	case NDT_SFFontStyleNode:
		return ALL_GetNodeType(SFFontStyleNode_V1_TypeToTag, SFFontStyleNode_V1_Count, NodeTag, BIFS_V1);
	case NDT_SFTopNode:
		return ALL_GetNodeType(SFTopNode_V1_TypeToTag, SFTopNode_V1_Count, NodeTag, BIFS_V1);
	case NDT_SFLinePropertiesNode:
		return ALL_GetNodeType(SFLinePropertiesNode_V1_TypeToTag, SFLinePropertiesNode_V1_Count, NodeTag, BIFS_V1);
	case NDT_SFMaterialNode:
		return ALL_GetNodeType(SFMaterialNode_V1_TypeToTag, SFMaterialNode_V1_Count, NodeTag, BIFS_V1);
	case NDT_SFNavigationInfoNode:
		return ALL_GetNodeType(SFNavigationInfoNode_V1_TypeToTag, SFNavigationInfoNode_V1_Count, NodeTag, BIFS_V1);
	case NDT_SFNormalNode:
		return ALL_GetNodeType(SFNormalNode_V1_TypeToTag, SFNormalNode_V1_Count, NodeTag, BIFS_V1);
	case NDT_SFTextureCoordinateNode:
		return ALL_GetNodeType(SFTextureCoordinateNode_V1_TypeToTag, SFTextureCoordinateNode_V1_Count, NodeTag, BIFS_V1);
	case NDT_SFTextureTransformNode:
		return ALL_GetNodeType(SFTextureTransformNode_V1_TypeToTag, SFTextureTransformNode_V1_Count, NodeTag, BIFS_V1);
	case NDT_SFViewpointNode:
		return ALL_GetNodeType(SFViewpointNode_V1_TypeToTag, SFViewpointNode_V1_Count, NodeTag, BIFS_V1);
	case NDT_SFVisemeNode:
		return ALL_GetNodeType(SFVisemeNode_V1_TypeToTag, SFVisemeNode_V1_Count, NodeTag, BIFS_V1);
	default:
		return 0;
	}
}

u32 NDT_V2_GetNodeType(u32 NDT_Tag, u32 NodeTag)
{
	if(!NDT_Tag || !NodeTag) return 0;
	switch(NDT_Tag) {
	case NDT_SFWorldNode:
		return ALL_GetNodeType(SFWorldNode_V2_TypeToTag, SFWorldNode_V2_Count, NodeTag, BIFS_V2);
	case NDT_SF3DNode:
		return ALL_GetNodeType(SF3DNode_V2_TypeToTag, SF3DNode_V2_Count, NodeTag, BIFS_V2);
	case NDT_SF2DNode:
		return ALL_GetNodeType(SF2DNode_V2_TypeToTag, SF2DNode_V2_Count, NodeTag, BIFS_V2);
	case NDT_SFGeometryNode:
		return ALL_GetNodeType(SFGeometryNode_V2_TypeToTag, SFGeometryNode_V2_Count, NodeTag, BIFS_V2);
	case NDT_SFMaterialNode:
		return ALL_GetNodeType(SFMaterialNode_V2_TypeToTag, SFMaterialNode_V2_Count, NodeTag, BIFS_V2);
	case NDT_SFBAPNode:
		return ALL_GetNodeType(SFBAPNode_V2_TypeToTag, SFBAPNode_V2_Count, NodeTag, BIFS_V2);
	case NDT_SFBDPNode:
		return ALL_GetNodeType(SFBDPNode_V2_TypeToTag, SFBDPNode_V2_Count, NodeTag, BIFS_V2);
	case NDT_SFBodyDefTableNode:
		return ALL_GetNodeType(SFBodyDefTableNode_V2_TypeToTag, SFBodyDefTableNode_V2_Count, NodeTag, BIFS_V2);
	case NDT_SFBodySegmentConnectionHintNode:
		return ALL_GetNodeType(SFBodySegmentConnectionHintNode_V2_TypeToTag, SFBodySegmentConnectionHintNode_V2_Count, NodeTag, BIFS_V2);
	case NDT_SFPerceptualParameterNode:
		return ALL_GetNodeType(SFPerceptualParameterNode_V2_TypeToTag, SFPerceptualParameterNode_V2_Count, NodeTag, BIFS_V2);
	default:
		return 0;
	}
}

u32 NDT_V3_GetNodeType(u32 NDT_Tag, u32 NodeTag)
{
	if(!NDT_Tag || !NodeTag) return 0;
	switch(NDT_Tag) {
	case NDT_SFWorldNode:
		return ALL_GetNodeType(SFWorldNode_V3_TypeToTag, SFWorldNode_V3_Count, NodeTag, BIFS_V3);
	case NDT_SF3DNode:
		return ALL_GetNodeType(SF3DNode_V3_TypeToTag, SF3DNode_V3_Count, NodeTag, BIFS_V3);
	case NDT_SF2DNode:
		return ALL_GetNodeType(SF2DNode_V3_TypeToTag, SF2DNode_V3_Count, NodeTag, BIFS_V3);
	case NDT_SFTemporalNode:
		return ALL_GetNodeType(SFTemporalNode_V3_TypeToTag, SFTemporalNode_V3_Count, NodeTag, BIFS_V3);
	default:
		return 0;
	}
}

u32 NDT_V4_GetNodeType(u32 NDT_Tag, u32 NodeTag)
{
	if(!NDT_Tag || !NodeTag) return 0;
	switch(NDT_Tag) {
	case NDT_SFWorldNode:
		return ALL_GetNodeType(SFWorldNode_V4_TypeToTag, SFWorldNode_V4_Count, NodeTag, BIFS_V4);
	case NDT_SF3DNode:
		return ALL_GetNodeType(SF3DNode_V4_TypeToTag, SF3DNode_V4_Count, NodeTag, BIFS_V4);
	case NDT_SF2DNode:
		return ALL_GetNodeType(SF2DNode_V4_TypeToTag, SF2DNode_V4_Count, NodeTag, BIFS_V4);
	case NDT_SFTextureNode:
		return ALL_GetNodeType(SFTextureNode_V4_TypeToTag, SFTextureNode_V4_Count, NodeTag, BIFS_V4);
	default:
		return 0;
	}
}

u32 NDT_V5_GetNodeType(u32 NDT_Tag, u32 NodeTag)
{
	if(!NDT_Tag || !NodeTag) return 0;
	switch(NDT_Tag) {
	case NDT_SFWorldNode:
		return ALL_GetNodeType(SFWorldNode_V5_TypeToTag, SFWorldNode_V5_Count, NodeTag, BIFS_V5);
	case NDT_SF3DNode:
		return ALL_GetNodeType(SF3DNode_V5_TypeToTag, SF3DNode_V5_Count, NodeTag, BIFS_V5);
	case NDT_SF2DNode:
		return ALL_GetNodeType(SF2DNode_V5_TypeToTag, SF2DNode_V5_Count, NodeTag, BIFS_V5);
	case NDT_SFAppearanceNode:
		return ALL_GetNodeType(SFAppearanceNode_V5_TypeToTag, SFAppearanceNode_V5_Count, NodeTag, BIFS_V5);
	case NDT_SFGeometryNode:
		return ALL_GetNodeType(SFGeometryNode_V5_TypeToTag, SFGeometryNode_V5_Count, NodeTag, BIFS_V5);
	case NDT_SFTextureNode:
		return ALL_GetNodeType(SFTextureNode_V5_TypeToTag, SFTextureNode_V5_Count, NodeTag, BIFS_V5);
	case NDT_SFDepthImageNode:
		return ALL_GetNodeType(SFDepthImageNode_V5_TypeToTag, SFDepthImageNode_V5_Count, NodeTag, BIFS_V5);
	case NDT_SFBlendListNode:
		return ALL_GetNodeType(SFBlendListNode_V5_TypeToTag, SFBlendListNode_V5_Count, NodeTag, BIFS_V5);
	case NDT_SFFrameListNode:
		return ALL_GetNodeType(SFFrameListNode_V5_TypeToTag, SFFrameListNode_V5_Count, NodeTag, BIFS_V5);
	case NDT_SFLightMapNode:
		return ALL_GetNodeType(SFLightMapNode_V5_TypeToTag, SFLightMapNode_V5_Count, NodeTag, BIFS_V5);
	case NDT_SFSurfaceMapNode:
		return ALL_GetNodeType(SFSurfaceMapNode_V5_TypeToTag, SFSurfaceMapNode_V5_Count, NodeTag, BIFS_V5);
	case NDT_SFViewMapNode:
		return ALL_GetNodeType(SFViewMapNode_V5_TypeToTag, SFViewMapNode_V5_Count, NodeTag, BIFS_V5);
	case NDT_SFParticleInitializerNode:
		return ALL_GetNodeType(SFParticleInitializerNode_V5_TypeToTag, SFParticleInitializerNode_V5_Count, NodeTag, BIFS_V5);
	case NDT_SFInfluenceNode:
		return ALL_GetNodeType(SFInfluenceNode_V5_TypeToTag, SFInfluenceNode_V5_Count, NodeTag, BIFS_V5);
	case NDT_SFDepthTextureNode:
		return ALL_GetNodeType(SFDepthTextureNode_V5_TypeToTag, SFDepthTextureNode_V5_Count, NodeTag, BIFS_V5);
	case NDT_SFSBBoneNode:
		return ALL_GetNodeType(SFSBBoneNode_V5_TypeToTag, SFSBBoneNode_V5_Count, NodeTag, BIFS_V5);
	case NDT_SFSBMuscleNode:
		return ALL_GetNodeType(SFSBMuscleNode_V5_TypeToTag, SFSBMuscleNode_V5_Count, NodeTag, BIFS_V5);
	case NDT_SFSBSegmentNode:
		return ALL_GetNodeType(SFSBSegmentNode_V5_TypeToTag, SFSBSegmentNode_V5_Count, NodeTag, BIFS_V5);
	case NDT_SFSBSiteNode:
		return ALL_GetNodeType(SFSBSiteNode_V5_TypeToTag, SFSBSiteNode_V5_Count, NodeTag, BIFS_V5);
	case NDT_SFBaseMeshNode:
		return ALL_GetNodeType(SFBaseMeshNode_V5_TypeToTag, SFBaseMeshNode_V5_Count, NodeTag, BIFS_V5);
	case NDT_SFSubdivSurfaceSectorNode:
		return ALL_GetNodeType(SFSubdivSurfaceSectorNode_V5_TypeToTag, SFSubdivSurfaceSectorNode_V5_Count, NodeTag, BIFS_V5);
	default:
		return 0;
	}
}

u32 NDT_V6_GetNodeType(u32 NDT_Tag, u32 NodeTag)
{
	if(!NDT_Tag || !NodeTag) return 0;
	switch(NDT_Tag) {
	case NDT_SFWorldNode:
		return ALL_GetNodeType(SFWorldNode_V6_TypeToTag, SFWorldNode_V6_Count, NodeTag, BIFS_V6);
	case NDT_SF3DNode:
		return ALL_GetNodeType(SF3DNode_V6_TypeToTag, SF3DNode_V6_Count, NodeTag, BIFS_V6);
	case NDT_SF2DNode:
		return ALL_GetNodeType(SF2DNode_V6_TypeToTag, SF2DNode_V6_Count, NodeTag, BIFS_V6);
	case NDT_SFGeometryNode:
		return ALL_GetNodeType(SFGeometryNode_V6_TypeToTag, SFGeometryNode_V6_Count, NodeTag, BIFS_V6);
	case NDT_SFTextureNode:
		return ALL_GetNodeType(SFTextureNode_V6_TypeToTag, SFTextureNode_V6_Count, NodeTag, BIFS_V6);
	case NDT_SFFontStyleNode:
		return ALL_GetNodeType(SFFontStyleNode_V6_TypeToTag, SFFontStyleNode_V6_Count, NodeTag, BIFS_V6);
	case NDT_SFLinePropertiesNode:
		return ALL_GetNodeType(SFLinePropertiesNode_V6_TypeToTag, SFLinePropertiesNode_V6_Count, NodeTag, BIFS_V6);
	case NDT_SFTextureTransformNode:
		return ALL_GetNodeType(SFTextureTransformNode_V6_TypeToTag, SFTextureTransformNode_V6_Count, NodeTag, BIFS_V6);
	case NDT_SFViewportNode:
		return ALL_GetNodeType(SFViewportNode_V6_TypeToTag, SFViewportNode_V6_Count, NodeTag, BIFS_V6);
	default:
		return 0;
	}
}



u32 NDT_GetNodeType(u32 NDT_Tag, u32 NodeTag, u32 Version)
{
	switch (Version) {
	case BIFS_V1:
		return NDT_V1_GetNodeType(NDT_Tag, NodeTag);
	case BIFS_V2:
		return NDT_V2_GetNodeType(NDT_Tag, NodeTag);
	case BIFS_V3:
		return NDT_V3_GetNodeType(NDT_Tag, NodeTag);
	case BIFS_V4:
		return NDT_V4_GetNodeType(NDT_Tag, NodeTag);
	case BIFS_V5:
		return NDT_V5_GetNodeType(NDT_Tag, NodeTag);
	case BIFS_V6:
		return NDT_V6_GetNodeType(NDT_Tag, NodeTag);
	default:
		return 0;
	}
}u32 Node_GetTagByName(const char *node_name)
{
	if(!node_name) return 0;
	if (!stricmp(node_name, "Anchor")) return TAG_Anchor;
	if (!stricmp(node_name, "AnimationStream")) return TAG_AnimationStream;
	if (!stricmp(node_name, "Appearance")) return TAG_Appearance;
	if (!stricmp(node_name, "AudioBuffer")) return TAG_AudioBuffer;
	if (!stricmp(node_name, "AudioClip")) return TAG_AudioClip;
	if (!stricmp(node_name, "AudioDelay")) return TAG_AudioDelay;
	if (!stricmp(node_name, "AudioFX")) return TAG_AudioFX;
	if (!stricmp(node_name, "AudioMix")) return TAG_AudioMix;
	if (!stricmp(node_name, "AudioSource")) return TAG_AudioSource;
	if (!stricmp(node_name, "AudioSwitch")) return TAG_AudioSwitch;
	if (!stricmp(node_name, "Background")) return TAG_Background;
	if (!stricmp(node_name, "Background2D")) return TAG_Background2D;
	if (!stricmp(node_name, "Billboard")) return TAG_Billboard;
	if (!stricmp(node_name, "Bitmap")) return TAG_Bitmap;
	if (!stricmp(node_name, "Box")) return TAG_Box;
	if (!stricmp(node_name, "Circle")) return TAG_Circle;
	if (!stricmp(node_name, "Collision")) return TAG_Collision;
	if (!stricmp(node_name, "Color")) return TAG_Color;
	if (!stricmp(node_name, "ColorInterpolator")) return TAG_ColorInterpolator;
	if (!stricmp(node_name, "CompositeTexture2D")) return TAG_CompositeTexture2D;
	if (!stricmp(node_name, "CompositeTexture3D")) return TAG_CompositeTexture3D;
	if (!stricmp(node_name, "Conditional")) return TAG_Conditional;
	if (!stricmp(node_name, "Cone")) return TAG_Cone;
	if (!stricmp(node_name, "Coordinate")) return TAG_Coordinate;
	if (!stricmp(node_name, "Coordinate2D")) return TAG_Coordinate2D;
	if (!stricmp(node_name, "CoordinateInterpolator")) return TAG_CoordinateInterpolator;
	if (!stricmp(node_name, "CoordinateInterpolator2D")) return TAG_CoordinateInterpolator2D;
	if (!stricmp(node_name, "Curve2D")) return TAG_Curve2D;
	if (!stricmp(node_name, "Cylinder")) return TAG_Cylinder;
	if (!stricmp(node_name, "CylinderSensor")) return TAG_CylinderSensor;
	if (!stricmp(node_name, "DirectionalLight")) return TAG_DirectionalLight;
	if (!stricmp(node_name, "DiscSensor")) return TAG_DiscSensor;
	if (!stricmp(node_name, "ElevationGrid")) return TAG_ElevationGrid;
	if (!stricmp(node_name, "Expression")) return TAG_Expression;
	if (!stricmp(node_name, "Extrusion")) return TAG_Extrusion;
	if (!stricmp(node_name, "Face")) return TAG_Face;
	if (!stricmp(node_name, "FaceDefMesh")) return TAG_FaceDefMesh;
	if (!stricmp(node_name, "FaceDefTables")) return TAG_FaceDefTables;
	if (!stricmp(node_name, "FaceDefTransform")) return TAG_FaceDefTransform;
	if (!stricmp(node_name, "FAP")) return TAG_FAP;
	if (!stricmp(node_name, "FDP")) return TAG_FDP;
	if (!stricmp(node_name, "FIT")) return TAG_FIT;
	if (!stricmp(node_name, "Fog")) return TAG_Fog;
	if (!stricmp(node_name, "FontStyle")) return TAG_FontStyle;
	if (!stricmp(node_name, "Form")) return TAG_Form;
	if (!stricmp(node_name, "Group")) return TAG_Group;
	if (!stricmp(node_name, "ImageTexture")) return TAG_ImageTexture;
	if (!stricmp(node_name, "IndexedFaceSet")) return TAG_IndexedFaceSet;
	if (!stricmp(node_name, "IndexedFaceSet2D")) return TAG_IndexedFaceSet2D;
	if (!stricmp(node_name, "IndexedLineSet")) return TAG_IndexedLineSet;
	if (!stricmp(node_name, "IndexedLineSet2D")) return TAG_IndexedLineSet2D;
	if (!stricmp(node_name, "Inline")) return TAG_Inline;
	if (!stricmp(node_name, "LOD")) return TAG_LOD;
	if (!stricmp(node_name, "Layer2D")) return TAG_Layer2D;
	if (!stricmp(node_name, "Layer3D")) return TAG_Layer3D;
	if (!stricmp(node_name, "Layout")) return TAG_Layout;
	if (!stricmp(node_name, "LineProperties")) return TAG_LineProperties;
	if (!stricmp(node_name, "ListeningPoint")) return TAG_ListeningPoint;
	if (!stricmp(node_name, "Material")) return TAG_Material;
	if (!stricmp(node_name, "Material2D")) return TAG_Material2D;
	if (!stricmp(node_name, "MovieTexture")) return TAG_MovieTexture;
	if (!stricmp(node_name, "NavigationInfo")) return TAG_NavigationInfo;
	if (!stricmp(node_name, "Normal")) return TAG_Normal;
	if (!stricmp(node_name, "NormalInterpolator")) return TAG_NormalInterpolator;
	if (!stricmp(node_name, "OrderedGroup")) return TAG_OrderedGroup;
	if (!stricmp(node_name, "OrientationInterpolator")) return TAG_OrientationInterpolator;
	if (!stricmp(node_name, "PixelTexture")) return TAG_PixelTexture;
	if (!stricmp(node_name, "PlaneSensor")) return TAG_PlaneSensor;
	if (!stricmp(node_name, "PlaneSensor2D")) return TAG_PlaneSensor2D;
	if (!stricmp(node_name, "PointLight")) return TAG_PointLight;
	if (!stricmp(node_name, "PointSet")) return TAG_PointSet;
	if (!stricmp(node_name, "PointSet2D")) return TAG_PointSet2D;
	if (!stricmp(node_name, "PositionInterpolator")) return TAG_PositionInterpolator;
	if (!stricmp(node_name, "PositionInterpolator2D")) return TAG_PositionInterpolator2D;
	if (!stricmp(node_name, "ProximitySensor2D")) return TAG_ProximitySensor2D;
	if (!stricmp(node_name, "ProximitySensor")) return TAG_ProximitySensor;
	if (!stricmp(node_name, "QuantizationParameter")) return TAG_QuantizationParameter;
	if (!stricmp(node_name, "Rectangle")) return TAG_Rectangle;
	if (!stricmp(node_name, "ScalarInterpolator")) return TAG_ScalarInterpolator;
	if (!stricmp(node_name, "Script")) return TAG_Script;
	if (!stricmp(node_name, "Shape")) return TAG_Shape;
	if (!stricmp(node_name, "Sound")) return TAG_Sound;
	if (!stricmp(node_name, "Sound2D")) return TAG_Sound2D;
	if (!stricmp(node_name, "Sphere")) return TAG_Sphere;
	if (!stricmp(node_name, "SphereSensor")) return TAG_SphereSensor;
	if (!stricmp(node_name, "SpotLight")) return TAG_SpotLight;
	if (!stricmp(node_name, "Switch")) return TAG_Switch;
	if (!stricmp(node_name, "TermCap")) return TAG_TermCap;
	if (!stricmp(node_name, "Text")) return TAG_Text;
	if (!stricmp(node_name, "TextureCoordinate")) return TAG_TextureCoordinate;
	if (!stricmp(node_name, "TextureTransform")) return TAG_TextureTransform;
	if (!stricmp(node_name, "TimeSensor")) return TAG_TimeSensor;
	if (!stricmp(node_name, "TouchSensor")) return TAG_TouchSensor;
	if (!stricmp(node_name, "Transform")) return TAG_Transform;
	if (!stricmp(node_name, "Transform2D")) return TAG_Transform2D;
	if (!stricmp(node_name, "Valuator")) return TAG_Valuator;
	if (!stricmp(node_name, "Viewpoint")) return TAG_Viewpoint;
	if (!stricmp(node_name, "VisibilitySensor")) return TAG_VisibilitySensor;
	if (!stricmp(node_name, "Viseme")) return TAG_Viseme;
	if (!stricmp(node_name, "WorldInfo")) return TAG_WorldInfo;
	if (!stricmp(node_name, "AcousticMaterial")) return TAG_AcousticMaterial;
	if (!stricmp(node_name, "AcousticScene")) return TAG_AcousticScene;
	if (!stricmp(node_name, "ApplicationWindow")) return TAG_ApplicationWindow;
	if (!stricmp(node_name, "BAP")) return TAG_BAP;
	if (!stricmp(node_name, "BDP")) return TAG_BDP;
	if (!stricmp(node_name, "Body")) return TAG_Body;
	if (!stricmp(node_name, "BodyDefTable")) return TAG_BodyDefTable;
	if (!stricmp(node_name, "BodySegmentConnectionHint")) return TAG_BodySegmentConnectionHint;
	if (!stricmp(node_name, "DirectiveSound")) return TAG_DirectiveSound;
	if (!stricmp(node_name, "Hierarchical3DMesh")) return TAG_Hierarchical3DMesh;
	if (!stricmp(node_name, "MaterialKey")) return TAG_MaterialKey;
	if (!stricmp(node_name, "PerceptualParameters")) return TAG_PerceptualParameters;
	if (!stricmp(node_name, "TemporalTransform")) return TAG_TemporalTransform;
	if (!stricmp(node_name, "TemporalGroup")) return TAG_TemporalGroup;
	if (!stricmp(node_name, "ServerCommand")) return TAG_ServerCommand;
	if (!stricmp(node_name, "InputSensor")) return TAG_InputSensor;
	if (!stricmp(node_name, "MatteTexture")) return TAG_MatteTexture;
	if (!stricmp(node_name, "MediaBuffer")) return TAG_MediaBuffer;
	if (!stricmp(node_name, "MediaControl")) return TAG_MediaControl;
	if (!stricmp(node_name, "MediaSensor")) return TAG_MediaSensor;
	if (!stricmp(node_name, "Clipper2D")) return TAG_Clipper2D;
	if (!stricmp(node_name, "ColorTransform")) return TAG_ColorTransform;
	if (!stricmp(node_name, "Ellipse")) return TAG_Ellipse;
	if (!stricmp(node_name, "LinearGradient")) return TAG_LinearGradient;
	if (!stricmp(node_name, "PathLayout")) return TAG_PathLayout;
	if (!stricmp(node_name, "RadialGradient")) return TAG_RadialGradient;
	if (!stricmp(node_name, "SynthesizedTexture")) return TAG_SynthesizedTexture;
	if (!stricmp(node_name, "TransformMatrix2D")) return TAG_TransformMatrix2D;
	if (!stricmp(node_name, "Viewport")) return TAG_Viewport;
	if (!stricmp(node_name, "XCurve2D")) return TAG_XCurve2D;
	if (!stricmp(node_name, "XFontStyle")) return TAG_XFontStyle;
	if (!stricmp(node_name, "XLineProperties")) return TAG_XLineProperties;
	return 0;
}

