/*
 *			GPAC - MPEG-4 Systems C Development Kit
 *
 *			Copyright (c) Jean Le Feuvre 2000-2004 
 *					All rights reserved
 *
 *  This file is part of GPAC / Scene Rendering sub-project
 *
 *  GPAC is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  GPAC is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#include <gpac/intern/m4_render_dev.h>

#define M4SETCURSOR(t) { M4Event evt; evt.type = M4E_SET_CURSOR; evt.cursor.cursor_type = (t); sr->video_out->PushEvent(sr->video_out, &evt); }


void SR_OnEvent(void *cbck, M4Event *event)
{
	u32 s, c, m;
	SceneRenderer *sr = (SceneRenderer *)cbck;
	/*not assigned yet*/
	if (!sr || !sr->video_out) return;

	switch (event->type) {
	case M4E_REFRESH:
		SR_RefreshWindow(sr);
		break;
	case M4E_GL_CHANGED:
		SR_ResetGraphics(sr);
		break;
	case M4E_WINDOWSIZE:
		SR_SizeChanged(sr, event->size.width, event->size.height);
		break;
	case M4E_NEEDRESIZE:
		SR_SetSize(sr, event->size.width, event->size.height);
		break;
	case M4E_VKEYDOWN:
		s = c = m = 0;
		switch (event->key.m4_vk_code) {
		case M4VK_SHIFT: s = 2; sr->key_states |= M4KM_SHIFT; break;
		case M4VK_CONTROL: c = 2; sr->key_states |= M4KM_CTRL; break;
		case M4VK_MENU: m = 2; sr->key_states |= M4KM_ALT; break;
		}
		event->key.key_states = sr->key_states;
		/*key sensor*/
		if (sr->term && (sr->interaction_level & M4_InteractInputSensor) ) {
			if (event->key.m4_vk_code<=M4VK_RIGHT) M4T_KeyboardInput(sr->term, 0, 0, event->key.m4_vk_code, 0, s, c, m);
			else M4T_KeyboardInput(sr->term, event->key.virtual_code, 0, 0, 0, s, c, m);
		}
		/*shorctuts*/
		if (sr->interaction_level & M4_InteractWM) {
			if ((event->key.m4_vk_code == M4VK_ESCAPE) || ((sr->key_states & M4KM_ALT) && (event->key.m4_vk_code == M4VK_RETURN))) {
				SR_SetOption(sr, M4O_Fullscreen, !sr->fullscreen);
			} else {
				M4USER_SENDEVENT(sr->client, event);
			}
		}
		
		SR_UserInput(sr, &event->mouse);
		
		break;
	case M4E_VKEYUP:
		s = c = m = 0;
		switch (event->key.m4_vk_code) {
		case M4VK_SHIFT: s = 1; sr->key_states &= ~M4KM_SHIFT; break;
		case M4VK_CONTROL: c = 1; sr->key_states &= ~M4KM_CTRL; break;
		case M4VK_MENU: m = 1; sr->key_states &= ~M4KM_ALT; break;
		}
		event->key.key_states = sr->key_states;

		/*key sensor*/
		if (sr->term && (sr->interaction_level & M4_InteractInputSensor) ) {
			if (event->key.m4_vk_code<=M4VK_RIGHT) M4T_KeyboardInput(sr->term, 0, 0, 0, event->key.m4_vk_code, s, c, m);
			else M4T_KeyboardInput(sr->term, 0, event->key.virtual_code, 0, 0, s, c, m);
		}

		SR_UserInput(sr, &event->mouse);
		
		break;

	/*for key sensor*/
	case M4E_KEYDOWN:
		event->key.key_states = sr->key_states;
		if (sr->term && (sr->interaction_level & M4_InteractInputSensor) )
			M4T_KeyboardInput(sr->term, event->key.virtual_code, 0, 0, 0, 0, 0, 0);
		if (sr->interaction_level & M4_InteractWM) M4USER_SENDEVENT(sr->client, event);
		break;
	case M4E_KEYUP:
		event->key.key_states = sr->key_states;
		if (sr->term && (sr->interaction_level & M4_InteractInputSensor) )
			M4T_KeyboardInput(sr->term, 0, event->key.virtual_code, 0, 0, 0, 0, 0);
		if (sr->interaction_level & M4_InteractWM) M4USER_SENDEVENT(sr->client, event);
		break;
	case M4E_CHAR:
		if (sr->term && (sr->interaction_level & M4_InteractInputSensor) )
			M4T_StringInput(sr->term , event->character.unicode_char);
		if (sr->interaction_level & M4_InteractWM) M4USER_SENDEVENT(sr->client, event);
		break;

	case M4E_MOUSEMOVE:
	case M4E_LEFTDOWN:
	case M4E_LEFTUP:
	case M4E_RIGHTDOWN:
	case M4E_RIGHTUP:
	case M4E_MIDDLEDOWN:
	case M4E_MIDDLEUP:
	case M4E_MOUSEWHEEL:
		event->mouse.key_states = sr->key_states;
		SR_UserInput(sr, &event->mouse);
		break;

	/*when we process events we don't forward them to the user*/
	default:
		if (sr->interaction_level & M4_InteractWM) M4USER_SENDEVENT(sr->client, event);
		break;
	}

	/*send ALL events to the user*/
	if (!(sr->interaction_level & M4_InteractWM)) M4USER_SENDEVENT(sr->client, event);

}
