/*
 *			GPAC - MPEG-4 Systems C Development Kit
 *
 *			Copyright (c) Jean Le Feuvre 2000-2003 
 *					All rights reserved
 *
 *  This file is part of GPAC / codec pack plugin
 *
 *  GPAC is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  GPAC is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */


#ifndef _CODECPACK_H
#define _CODECPACK_H

/*all codecs are regular */
#include <gpac/m4_decoder.h>

/*default size in CU of composition memory for audio*/
#define DEFAULT_AUDIO_CM_SIZE			12
/*default critical size in CU of composition memory for audio*/
#define DEFAULT_AUDIO_CM_TRIGGER		4
/*default size in CU of composition memory for video*/
#define DEFAULT_VIDEO_CM_SIZE			4
/*default critical size in CU of composition memory for audio*/
#define DEFAULT_VIDEO_CM_TRIGGER		1


/*our private types*/
enum
{
	DEC_RESERVED = 0,
	DEC_PNG,
	DEC_JPEG,
	DEC_XVID,
	DEC_MAD,
	DEC_FAAD
};

typedef struct
{
	u32 type;
	void *opaque;
} CodecWraper;

/*all constructors shall setup the wraper type and handle
	return 1 for success, 0 otherwise
all destructors only destroy their private stacks (eg not the interface nor the wraper)
*/
#ifdef M4_BUILD_PNG
u32 NewPNGDec(DecoderInterface *dec);
void DeletePNGDec(DecoderInterface *dec);
#endif

#ifdef M4_BUILD_JPEG
u32 NewJPEGDec(DecoderInterface *dec);
void DeleteJPEGDec(DecoderInterface *dec);
#endif

#ifdef M4_BUILD_MAD
u32 NewMADDec(DecoderInterface *dec);
void DeleteMADDec(DecoderInterface *dec);
#endif

#ifdef M4_BUILD_XVID
u32 NewXVIDDec(DecoderInterface *dec);
void DeleteXVIDDec(DecoderInterface *dec);
#endif

#ifdef M4_BUILD_FAAD
u32 NewFAADDec(DecoderInterface *dec);
void DeleteFAADDec(DecoderInterface *dec);
#endif

void *NewLoaderInterface();
void DeleteLoaderInterface(void *ifce);

#endif
