/*
 *			GPAC - MPEG-4 Systems C Development Kit
 *
 *			Copyright (c) Jean Le Feuvre 2000-2003 
 *					All rights reserved
 *
 *  This file is part of GPAC / MP4 reader plugin
 *
 *  GPAC is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  GPAC is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *		
 */


#ifndef __FFMPEG_IN_H
#define __FFMPEG_IN_H



/*include net API*/
#include <gpac/m4_network.h>
/*include decoder API*/
#include <gpac/m4_decoder.h>

#if defined(WIN32) && !defined(__MINGW32__)
#define EMULATE_INTTYPES
#ifndef inline
#define inline __inline
#endif
#ifndef __MINGW32__
#define __attribute__(s)
#endif
#endif


/*uncomment to enable demuxer (not working)...*/
//#define FF_NO_DEMUX

/*include FFMPEG APIs*/
#include "avformat.h"

/*FFMPEG decoder plugin */
typedef struct 
{
	u32 ES_ID;
	u32 out_size;
	u32 oti, st;
	u32 frame_start;

	AVCodecContext *ctx;
    AVCodec *codec;
	AVFrame *frame;
} FFDec;

void *FFDEC_Load();
void FFDEC_Delete(void *ifce);


#ifndef FF_NO_DEMUX
/*
		reader interface

*/

typedef struct
{
	/*the service we're responsible for*/
	LPNETSERVICE service;

	/*input file*/
	AVFormatContext *ctx;
	
	u32 status;
	Double seek_time;

	s32 audio_st, video_st;
	u32 bifs_es_id, od_es_id;
	/*app channels*/
	LPNETCHANNEL bifs_ch;
	LPNETCHANNEL od_ch;
	LPNETCHANNEL audio_ch;
	LPNETCHANNEL video_ch;
	u32 bifs_status, od_status, audio_status, video_status;
	/*stream fetch state*/
	u32 bifs_state, od_state;
	u32 data_buffer_ms;
	Bool use_packet_durations;

	/*demuxer thread - we cannot use direct fetching because of demultiplex structure of libavformat
	(reading one channel may lock the other)*/
	M4Thread *thread;
	M4Mutex *mx;
	u32 is_paused, is_running;

	u32 service_type;

	char *od_au;
	u32 od_au_size;
} FFDemux;

void *New_FFMPEG_Demux();
void Delete_FFMPEG_Demux(void *ifce);

#endif

/*this is the OTI (user-priv) used for all undefined codec used by ffmpeg (carrying specific info from
AVContext*/
#define GPAC_FFMPEG_CODECS_OTI			0x81

/*The DSI sent is:

	u32 codec_id

- for audio - 
	u32 sample_rate: sampling rate or 0 if unknown
	u16 nb_channels: num channels or 0 if unknown
	u16 nb_bits_per_sample: nb bits or 0 if unknown
	u16 num_samples: num audio samples per frame or 0 if unknown
	u16 block_align: audio block align

- for video - 
	u32 width: video width or 0 if unknown;
	u32 height: video height or 0 if unknown;

- for both -
	u32 codec_tag: ffmpeg ctx codec tag
	u32 bit_rate: ffmpeg ctx bit rate

- till end of DSI bitstream-
	char *data: extra_data
*/



#endif

