/*
 *			GPAC - MPEG-4 Systems C Development Kit
 *
 *			Copyright (c) Jean Le Feuvre 2000-2003 
 *					All rights reserved
 *
 *  This file is part of GPAC / MP4 reader plugin
 *
 *  GPAC is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  GPAC is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *		
 */


#ifndef __MP4_IO_H
#define __MP4_IO_H

#include <gpac/m4_network.h>
#include <gpac/m4_isomedia.h>

/*
			reader plugin

*/

typedef struct
{
	/*the service we're responsible for*/
	LPNETSERVICE service;

	/*current channels*/
	Chain *channels;

	/*input file*/
	M4File *mov;
	u32 status;
	u32 time_scale;

	/*remote file handling*/
	NetDownloader *dnload;
	u64 missing_bytes, last_size;

	/*IOD emulation mode: 0: audio, 1: video, 2: both*/
	u32 av_mode;
	u16 BIFS_ESID, OD_ESID;
	char *od_au;
	u32 od_au_size;
} M4Reader;

typedef struct
{
	u32 track;
	LPNETCHANNEL channel;
	M4Reader *owner;
	u32 status;
	u32 duration;


	/*current sample*/
	M4Sample *sample;
	SLHeader current_slh;
	M4Err last_state;

	Bool is_pulling;

	Bool has_edit_list;
	u32 sample_num;
	u32 sample_time;
	u32 start, end;
	Double speed;

	u32 time_scale;
	Bool to_init, is_playing, is_ocr;
	
	u16 FAKE_ESID;
} M4Channel;
void m4_reset_reader(M4Channel *ch);
void m4_reader_get_sample(M4Channel *ch);
void m4_reader_release_sample(M4Channel *ch);

NetClientPlugin *M4R_LoadPlugin();
void M4Read_Delete(BaseInterface *bi);

void MP4_SetupDownload(NetClientPlugin *plug, const char *url);


/*loads a default IOD for single-track media files*/
M4Err M4R_LoadIOD(M4Reader *read, InitialObjectDescriptor *iod, char **raw_iod, u32 *raw_iod_size);
/*emulate an IOD for single/2track files */
M4Err M4R_EmulateIOD(M4Reader *read, char **raw_iod, u32 *raw_iod_size);

#endif

