/*
 *			GPAC - MPEG-4 Systems C Development Kit
 *
 *			Copyright (c) Jean Le Feuvre 2000-2004 
 *					All rights reserved
 *
 *  This file is part of GPAC / Scene Rendering sub-project
 *
 *  GPAC is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  GPAC is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */



#include "stacks3d.h"

#ifdef M4_DEF_Bitmap

static void RenderBitmap(SFNode *node, void *rs)
{
	Float x, y;
	Aspect2D asp;
	char *data;
	u32 format;
	TextureHandler *txh;
	Float sx, sy;
	SFVec2f size;
	BitmapStack *st = (BitmapStack *)Node_GetPrivate(node);
	RenderEffect *eff = (RenderEffect *)rs;
	B_Bitmap *bmp = (B_Bitmap *)st->owner;
	Render3D *sr = (Render3D*)st->compositor->visual_renderer->user_priv;
	if (!eff->appear) return;
	if (! ((B_Appearance *)eff->appear)->texture) return;

	txh = R3D_GetTextureHandler(((B_Appearance *)eff->appear)->texture);
	if (!txh || !txh->width || !txh->height) return;

	sx = bmp->scale.x; if (sx<0) sx = 1;
	sy = bmp->scale.y; if (sy<0) sy = 1;

	/*check size change*/
	size.x = txh->width*sx;
	size.y = txh->height*sy;
	if ((st->size.x != size.x) || (st->size.y != size.y) || (Node_GetDirty(node) & SG_NODE_DIRTY)) {
		st->size = size;
		Node_ClearDirty(node);
		mesh_new_rectangle(st->mesh, size);
	}
	if (eff->trav_flags & TF_SWITCHED_OFF) return;
	else if (eff->traversing_mode==TRAVERSE_PICK) return;
	else if (eff->traversing_mode==TRAVERSE_GET_BOUNDS) {
		eff->bbox = st->mesh->bounds;
		return;
	}

	VS_GetAspect2D(eff, &asp);

	/*texture is available in hw, use it - if blending, force using texture*/
	if (!tx_needs_reload(txh) || (asp.alpha!=1.0f) || !sr->bitmap_use_pixels) {
		if (tx_set_image(txh, 0)) {
			VS3D_SetAntiAlias(eff->surface, 0);
			if (asp.alpha != 1.0f) VS3D_SetMaterial2D(eff->surface, asp.fill_color, asp.alpha);
			/*ignore texture transform for bitmap*/
 			tx_enable(txh, NULL);
			VS3D_DrawMesh(eff->surface, st->mesh);
			return;
		}
	}


	/*otherwise use glDrawPixels*/
	data = tx_get_data(txh, &format);
	if (!data) return;

	x = -0.5f * txh->width;
	y = 0.5f * txh->height;

	{
	Float g[16];

	/*add top level scale if any*/
	sx*=sr->scale_x;
	sy*=sr->scale_y;

	/*get & apply current transform scale*/
	VS3D_GetMatrix(eff->surface, MAT_MODELVIEW, g);

	if (g[0]<0) g[0] *= -1;
	if (g[5]<0) g[5] *= -1;
	sx*=g[0];
	sy*=g[5];

	x *= sx;
	y *= sy;
	
	}

	VS3D_DrawImage(eff->surface, x, y, txh->width, txh->height, format, data, sx, sy);
}

static void Bitmap_PreDestroy(SFNode *n)
{
	BitmapStack *st = (BitmapStack *)Node_GetPrivate(n);
	free(st);
}

void R3D_InitBitmap(Render3D *sr, SFNode *node)
{
	BitmapStack *st = SAFEALLOC(st, sizeof(BitmapStack));
	stack_setup(st, node, sr->compositor);
	Node_SetPrivate(node, st);
	Node_SetPreDestroyFunction(node, Bitmap_PreDestroy);
	Node_SetRenderFunction(node, RenderBitmap);
}

#endif

