/*
 *			GPAC - MPEG-4 Systems C Development Kit
 *
 *			Copyright (c) Jean Le Feuvre 2000-2003
 *					All rights reserved
 *
 *  This file is part of GPAC / Scene Graph sub-project
 *
 *  GPAC is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  GPAC is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.	
 *
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


/*FILE AUTOMATICALLY GENERATED BY SGGen - DO NOT MOFIFY*/

#ifndef _NDT_H
#define _NDT_H

#include <gpac/m4_nodes.h>



u32 ALL_GetNodeType(const u32 *table, const u32 count, u32 NodeTag, u32 Version);



/* NDT BIFS Version 1 */

#define SFWorldNode_V1_NUMBITS		7
#define SFWorldNode_V1_Count	100

static const u32 SFWorldNode_V1_TypeToTag[100] = {
 TAG_Anchor, TAG_AnimationStream, TAG_Appearance, TAG_AudioBuffer, TAG_AudioClip, TAG_AudioDelay, TAG_AudioFX, TAG_AudioMix, TAG_AudioSource, TAG_AudioSwitch, TAG_Background, TAG_Background2D, TAG_Billboard, TAG_Bitmap, TAG_Box, TAG_Circle, TAG_Collision, TAG_Color, TAG_ColorInterpolator, TAG_CompositeTexture2D, TAG_CompositeTexture3D, TAG_Conditional, TAG_Cone, TAG_Coordinate, TAG_Coordinate2D, TAG_CoordinateInterpolator, TAG_CoordinateInterpolator2D, TAG_Curve2D, TAG_Cylinder, TAG_CylinderSensor, TAG_DirectionalLight, TAG_DiscSensor, TAG_ElevationGrid, TAG_Expression, TAG_Extrusion, TAG_Face, TAG_FaceDefMesh, TAG_FaceDefTables, TAG_FaceDefTransform, TAG_FAP, TAG_FDP, TAG_FIT, TAG_Fog, TAG_FontStyle, TAG_Form, TAG_Group, TAG_ImageTexture, TAG_IndexedFaceSet, TAG_IndexedFaceSet2D, TAG_IndexedLineSet, TAG_IndexedLineSet2D, TAG_Inline, TAG_LOD, TAG_Layer2D, TAG_Layer3D, TAG_Layout, TAG_LineProperties, TAG_ListeningPoint, TAG_Material, TAG_Material2D, TAG_MovieTexture, TAG_NavigationInfo, TAG_Normal, TAG_NormalInterpolator, TAG_OrderedGroup, TAG_OrientationInterpolator, TAG_PixelTexture, TAG_PlaneSensor, TAG_PlaneSensor2D, TAG_PointLight, TAG_PointSet, TAG_PointSet2D, TAG_PositionInterpolator, TAG_PositionInterpolator2D, TAG_ProximitySensor2D, TAG_ProximitySensor, TAG_QuantizationParameter, TAG_Rectangle, TAG_ScalarInterpolator, TAG_Script, TAG_Shape, TAG_Sound, TAG_Sound2D, TAG_Sphere, TAG_SphereSensor, TAG_SpotLight, TAG_Switch, TAG_TermCap, TAG_Text, TAG_TextureCoordinate, TAG_TextureTransform, TAG_TimeSensor, TAG_TouchSensor, TAG_Transform, TAG_Transform2D, TAG_Valuator, TAG_Viewpoint, TAG_VisibilitySensor, TAG_Viseme, TAG_WorldInfo
};

#define SF3DNode_V1_NUMBITS		6
#define SF3DNode_V1_Count	52

static const u32 SF3DNode_V1_TypeToTag[52] = {
 TAG_Anchor, TAG_AnimationStream, TAG_Background, TAG_Background2D, TAG_Billboard, TAG_Collision, TAG_ColorInterpolator, TAG_Conditional, TAG_CoordinateInterpolator, TAG_CoordinateInterpolator2D, TAG_CylinderSensor, TAG_DirectionalLight, TAG_DiscSensor, TAG_Face, TAG_Fog, TAG_Form, TAG_Group, TAG_Inline, TAG_LOD, TAG_Layer2D, TAG_Layer3D, TAG_Layout, TAG_ListeningPoint, TAG_NavigationInfo, TAG_NormalInterpolator, TAG_OrderedGroup, TAG_OrientationInterpolator, TAG_PlaneSensor, TAG_PlaneSensor2D, TAG_PointLight, TAG_PositionInterpolator, TAG_PositionInterpolator2D, TAG_ProximitySensor2D, TAG_ProximitySensor, TAG_QuantizationParameter, TAG_ScalarInterpolator, TAG_Script, TAG_Shape, TAG_Sound, TAG_Sound2D, TAG_SphereSensor, TAG_SpotLight, TAG_Switch, TAG_TermCap, TAG_TimeSensor, TAG_TouchSensor, TAG_Transform, TAG_Transform2D, TAG_Valuator, TAG_Viewpoint, TAG_VisibilitySensor, TAG_WorldInfo
};

#define SF2DNode_V1_NUMBITS		5
#define SF2DNode_V1_Count	31

static const u32 SF2DNode_V1_TypeToTag[31] = {
 TAG_Anchor, TAG_AnimationStream, TAG_Background2D, TAG_ColorInterpolator, TAG_Conditional, TAG_CoordinateInterpolator2D, TAG_DiscSensor, TAG_Face, TAG_Form, TAG_Group, TAG_Inline, TAG_LOD, TAG_Layer2D, TAG_Layer3D, TAG_Layout, TAG_OrderedGroup, TAG_PlaneSensor2D, TAG_PositionInterpolator2D, TAG_ProximitySensor2D, TAG_QuantizationParameter, TAG_ScalarInterpolator, TAG_Script, TAG_Shape, TAG_Sound2D, TAG_Switch, TAG_TermCap, TAG_TimeSensor, TAG_TouchSensor, TAG_Transform2D, TAG_Valuator, TAG_WorldInfo
};

#define SFStreamingNode_V1_NUMBITS		3
#define SFStreamingNode_V1_Count	5

static const u32 SFStreamingNode_V1_TypeToTag[5] = {
 TAG_AnimationStream, TAG_AudioClip, TAG_AudioSource, TAG_Inline, TAG_MovieTexture
};

#define SFAppearanceNode_V1_NUMBITS		1
#define SFAppearanceNode_V1_Count	1

static const u32 SFAppearanceNode_V1_TypeToTag[1] = {
 TAG_Appearance
};

#define SFAudioNode_V1_NUMBITS		3
#define SFAudioNode_V1_Count	7

static const u32 SFAudioNode_V1_TypeToTag[7] = {
 TAG_AudioBuffer, TAG_AudioClip, TAG_AudioDelay, TAG_AudioFX, TAG_AudioMix, TAG_AudioSource, TAG_AudioSwitch
};

#define SFBackground3DNode_V1_NUMBITS		1
#define SFBackground3DNode_V1_Count	1

static const u32 SFBackground3DNode_V1_TypeToTag[1] = {
 TAG_Background
};

#define SFBackground2DNode_V1_NUMBITS		1
#define SFBackground2DNode_V1_Count	1

static const u32 SFBackground2DNode_V1_TypeToTag[1] = {
 TAG_Background2D
};

#define SFGeometryNode_V1_NUMBITS		5
#define SFGeometryNode_V1_Count	17

static const u32 SFGeometryNode_V1_TypeToTag[17] = {
 TAG_Bitmap, TAG_Box, TAG_Circle, TAG_Cone, TAG_Curve2D, TAG_Cylinder, TAG_ElevationGrid, TAG_Extrusion, TAG_IndexedFaceSet, TAG_IndexedFaceSet2D, TAG_IndexedLineSet, TAG_IndexedLineSet2D, TAG_PointSet, TAG_PointSet2D, TAG_Rectangle, TAG_Sphere, TAG_Text
};

#define SFColorNode_V1_NUMBITS		1
#define SFColorNode_V1_Count	1

static const u32 SFColorNode_V1_TypeToTag[1] = {
 TAG_Color
};

#define SFTextureNode_V1_NUMBITS		3
#define SFTextureNode_V1_Count	5

static const u32 SFTextureNode_V1_TypeToTag[5] = {
 TAG_CompositeTexture2D, TAG_CompositeTexture3D, TAG_ImageTexture, TAG_MovieTexture, TAG_PixelTexture
};

#define SFCoordinateNode_V1_NUMBITS		1
#define SFCoordinateNode_V1_Count	1

static const u32 SFCoordinateNode_V1_TypeToTag[1] = {
 TAG_Coordinate
};

#define SFCoordinate2DNode_V1_NUMBITS		1
#define SFCoordinate2DNode_V1_Count	1

static const u32 SFCoordinate2DNode_V1_TypeToTag[1] = {
 TAG_Coordinate2D
};

#define SFExpressionNode_V1_NUMBITS		1
#define SFExpressionNode_V1_Count	1

static const u32 SFExpressionNode_V1_TypeToTag[1] = {
 TAG_Expression
};

#define SFFaceDefMeshNode_V1_NUMBITS		1
#define SFFaceDefMeshNode_V1_Count	1

static const u32 SFFaceDefMeshNode_V1_TypeToTag[1] = {
 TAG_FaceDefMesh
};

#define SFFaceDefTablesNode_V1_NUMBITS		1
#define SFFaceDefTablesNode_V1_Count	1

static const u32 SFFaceDefTablesNode_V1_TypeToTag[1] = {
 TAG_FaceDefTables
};

#define SFFaceDefTransformNode_V1_NUMBITS		1
#define SFFaceDefTransformNode_V1_Count	1

static const u32 SFFaceDefTransformNode_V1_TypeToTag[1] = {
 TAG_FaceDefTransform
};

#define SFFAPNode_V1_NUMBITS		1
#define SFFAPNode_V1_Count	1

static const u32 SFFAPNode_V1_TypeToTag[1] = {
 TAG_FAP
};

#define SFFDPNode_V1_NUMBITS		1
#define SFFDPNode_V1_Count	1

static const u32 SFFDPNode_V1_TypeToTag[1] = {
 TAG_FDP
};

#define SFFITNode_V1_NUMBITS		1
#define SFFITNode_V1_Count	1

static const u32 SFFITNode_V1_TypeToTag[1] = {
 TAG_FIT
};

#define SFFogNode_V1_NUMBITS		1
#define SFFogNode_V1_Count	1

static const u32 SFFogNode_V1_TypeToTag[1] = {
 TAG_Fog
};

#define SFFontStyleNode_V1_NUMBITS		1
#define SFFontStyleNode_V1_Count	1

static const u32 SFFontStyleNode_V1_TypeToTag[1] = {
 TAG_FontStyle
};

#define SFTopNode_V1_NUMBITS		3
#define SFTopNode_V1_Count	4

static const u32 SFTopNode_V1_TypeToTag[4] = {
 TAG_Group, TAG_Layer2D, TAG_Layer3D, TAG_OrderedGroup
};

#define SFLinePropertiesNode_V1_NUMBITS		1
#define SFLinePropertiesNode_V1_Count	1

static const u32 SFLinePropertiesNode_V1_TypeToTag[1] = {
 TAG_LineProperties
};

#define SFMaterialNode_V1_NUMBITS		2
#define SFMaterialNode_V1_Count	2

static const u32 SFMaterialNode_V1_TypeToTag[2] = {
 TAG_Material, TAG_Material2D
};

#define SFNavigationInfoNode_V1_NUMBITS		1
#define SFNavigationInfoNode_V1_Count	1

static const u32 SFNavigationInfoNode_V1_TypeToTag[1] = {
 TAG_NavigationInfo
};

#define SFNormalNode_V1_NUMBITS		1
#define SFNormalNode_V1_Count	1

static const u32 SFNormalNode_V1_TypeToTag[1] = {
 TAG_Normal
};

#define SFTextureCoordinateNode_V1_NUMBITS		1
#define SFTextureCoordinateNode_V1_Count	1

static const u32 SFTextureCoordinateNode_V1_TypeToTag[1] = {
 TAG_TextureCoordinate
};

#define SFTextureTransformNode_V1_NUMBITS		1
#define SFTextureTransformNode_V1_Count	1

static const u32 SFTextureTransformNode_V1_TypeToTag[1] = {
 TAG_TextureTransform
};

#define SFViewpointNode_V1_NUMBITS		1
#define SFViewpointNode_V1_Count	1

static const u32 SFViewpointNode_V1_TypeToTag[1] = {
 TAG_Viewpoint
};

#define SFVisemeNode_V1_NUMBITS		1
#define SFVisemeNode_V1_Count	1

static const u32 SFVisemeNode_V1_TypeToTag[1] = {
 TAG_Viseme
};


u32 NDT_V1_GetNumBits(u32 NDT_Tag);
u32 NDT_V1_GetNodeTag(u32 Context_NDT_Tag, u32 NodeType);
u32 NDT_V1_GetNodeType(u32 NDT_Tag, u32 NodeTag);




/* NDT BIFS Version 2 */

#define SFWorldNode_V2_NUMBITS		4
#define SFWorldNode_V2_Count	12

static const u32 SFWorldNode_V2_TypeToTag[12] = {
 TAG_AcousticMaterial, TAG_AcousticScene, TAG_ApplicationWindow, TAG_BAP, TAG_BDP, TAG_Body, TAG_BodyDefTable, TAG_BodySegmentConnectionHint, TAG_DirectiveSound, TAG_Hierarchical3DMesh, TAG_MaterialKey, TAG_PerceptualParameters
};

#define SF3DNode_V2_NUMBITS		3
#define SF3DNode_V2_Count	3

static const u32 SF3DNode_V2_TypeToTag[3] = {
 TAG_AcousticScene, TAG_Body, TAG_DirectiveSound
};

#define SF2DNode_V2_NUMBITS		2
#define SF2DNode_V2_Count	2

static const u32 SF2DNode_V2_TypeToTag[2] = {
 TAG_ApplicationWindow, TAG_Body
};

#define SFGeometryNode_V2_NUMBITS		2
#define SFGeometryNode_V2_Count	1

static const u32 SFGeometryNode_V2_TypeToTag[1] = {
 TAG_Hierarchical3DMesh
};

#define SFMaterialNode_V2_NUMBITS		2
#define SFMaterialNode_V2_Count	2

static const u32 SFMaterialNode_V2_TypeToTag[2] = {
 TAG_AcousticMaterial, TAG_MaterialKey
};

#define SFBAPNode_V2_NUMBITS		2
#define SFBAPNode_V2_Count	1

static const u32 SFBAPNode_V2_TypeToTag[1] = {
 TAG_BAP
};

#define SFBDPNode_V2_NUMBITS		2
#define SFBDPNode_V2_Count	1

static const u32 SFBDPNode_V2_TypeToTag[1] = {
 TAG_BDP
};

#define SFBodyDefTableNode_V2_NUMBITS		2
#define SFBodyDefTableNode_V2_Count	1

static const u32 SFBodyDefTableNode_V2_TypeToTag[1] = {
 TAG_BodyDefTable
};

#define SFBodySegmentConnectionHintNode_V2_NUMBITS		2
#define SFBodySegmentConnectionHintNode_V2_Count	1

static const u32 SFBodySegmentConnectionHintNode_V2_TypeToTag[1] = {
 TAG_BodySegmentConnectionHint
};

#define SFPerceptualParameterNode_V2_NUMBITS		2
#define SFPerceptualParameterNode_V2_Count	1

static const u32 SFPerceptualParameterNode_V2_TypeToTag[1] = {
 TAG_PerceptualParameters
};


u32 NDT_V2_GetNumBits(u32 NDT_Tag);
u32 NDT_V2_GetNodeTag(u32 Context_NDT_Tag, u32 NodeType);
u32 NDT_V2_GetNodeType(u32 NDT_Tag, u32 NodeTag);




/* NDT BIFS Version 3 */

#define SFWorldNode_V3_NUMBITS		2
#define SFWorldNode_V3_Count	3

static const u32 SFWorldNode_V3_TypeToTag[3] = {
 TAG_TemporalTransform, TAG_TemporalGroup, TAG_ServerCommand
};

#define SF3DNode_V3_NUMBITS		2
#define SF3DNode_V3_Count	3

static const u32 SF3DNode_V3_TypeToTag[3] = {
 TAG_TemporalTransform, TAG_TemporalGroup, TAG_ServerCommand
};

#define SF2DNode_V3_NUMBITS		2
#define SF2DNode_V3_Count	3

static const u32 SF2DNode_V3_TypeToTag[3] = {
 TAG_TemporalTransform, TAG_TemporalGroup, TAG_ServerCommand
};

#define SFTemporalNode_V3_NUMBITS		2
#define SFTemporalNode_V3_Count	2

static const u32 SFTemporalNode_V3_TypeToTag[2] = {
 TAG_TemporalTransform, TAG_TemporalGroup
};


u32 NDT_V3_GetNumBits(u32 NDT_Tag);
u32 NDT_V3_GetNodeTag(u32 Context_NDT_Tag, u32 NodeType);
u32 NDT_V3_GetNodeType(u32 NDT_Tag, u32 NodeTag);




/* NDT BIFS Version 4 */

#define SFWorldNode_V4_NUMBITS		3
#define SFWorldNode_V4_Count	5

static const u32 SFWorldNode_V4_TypeToTag[5] = {
 TAG_InputSensor, TAG_MatteTexture, TAG_MediaBuffer, TAG_MediaControl, TAG_MediaSensor
};

#define SF3DNode_V4_NUMBITS		3
#define SF3DNode_V4_Count	5

static const u32 SF3DNode_V4_TypeToTag[5] = {
 TAG_InputSensor, TAG_MatteTexture, TAG_MediaBuffer, TAG_MediaControl, TAG_MediaSensor
};

#define SF2DNode_V4_NUMBITS		3
#define SF2DNode_V4_Count	5

static const u32 SF2DNode_V4_TypeToTag[5] = {
 TAG_InputSensor, TAG_MatteTexture, TAG_MediaBuffer, TAG_MediaControl, TAG_MediaSensor
};

#define SFTextureNode_V4_NUMBITS		1
#define SFTextureNode_V4_Count	1

static const u32 SFTextureNode_V4_TypeToTag[1] = {
 TAG_MatteTexture
};


u32 NDT_V4_GetNumBits(u32 NDT_Tag);
u32 NDT_V4_GetNodeTag(u32 Context_NDT_Tag, u32 NodeType);
u32 NDT_V4_GetNodeType(u32 NDT_Tag, u32 NodeTag);




/* NDT BIFS Version 5 */

#define SFWorldNode_V5_NUMBITS		6
#define SFWorldNode_V5_Count	39

static const u32 SFWorldNode_V5_TypeToTag[39] = {
 TAG_BitWrapper, TAG_CoordinateInterpolator4D, TAG_DepthImage, TAG_FFD, TAG_XXImplicit, TAG_XXLFM_Appearance, TAG_XXLFM_BlendList, TAG_XXLFM_FrameList, TAG_XXLFM_LightMap, TAG_XXLFM_SurfaceMapList, TAG_XXLFM_ViewMapList, TAG_MeshGrid, TAG_NonLinearDeformer, TAG_NurbsCurve, TAG_NurbsCurve2D, TAG_NurbsSurface, TAG_OctreeImage, TAG_XXParticles, TAG_XXParticleInitBox, TAG_XXPlanarObstacle, TAG_XXPointAttractor, TAG_PointTexture, TAG_PositionAnimator, TAG_PositionAnimator2D, TAG_PositionInterpolator4D, TAG_ProceduralTexture, TAG_XXQuadric, TAG_SBBone, TAG_SBMuscle, TAG_SBSegment, TAG_SBSite, TAG_SBSkinnedModel, TAG_SBVCAnimation, TAG_ScalarAnimator, TAG_SimpleTexture, TAG_XXSolidRep, TAG_SubdivisionSurface, TAG_SubdivSurfaceSector, TAG_WaveletSubdivisionSurface
};

#define SF3DNode_V5_NUMBITS		5
#define SF3DNode_V5_Count	17

static const u32 SF3DNode_V5_TypeToTag[17] = {
 TAG_BitWrapper, TAG_CoordinateInterpolator4D, TAG_DepthImage, TAG_FFD, TAG_OctreeImage, TAG_XXParticles, TAG_PositionAnimator, TAG_PositionAnimator2D, TAG_PositionInterpolator4D, TAG_SBBone, TAG_SBMuscle, TAG_SBSegment, TAG_SBSite, TAG_SBSkinnedModel, TAG_SBVCAnimation, TAG_ScalarAnimator, TAG_WaveletSubdivisionSurface
};

#define SF2DNode_V5_NUMBITS		4
#define SF2DNode_V5_Count	9

static const u32 SF2DNode_V5_TypeToTag[9] = {
 TAG_BitWrapper, TAG_PositionAnimator2D, TAG_SBBone, TAG_SBMuscle, TAG_SBSegment, TAG_SBSite, TAG_SBSkinnedModel, TAG_SBVCAnimation, TAG_ScalarAnimator
};

#define SFAppearanceNode_V5_NUMBITS		1
#define SFAppearanceNode_V5_Count	1

static const u32 SFAppearanceNode_V5_TypeToTag[1] = {
 TAG_XXLFM_Appearance
};

#define SFGeometryNode_V5_NUMBITS		4
#define SFGeometryNode_V5_Count	10

static const u32 SFGeometryNode_V5_TypeToTag[10] = {
 TAG_BitWrapper, TAG_XXImplicit, TAG_MeshGrid, TAG_NonLinearDeformer, TAG_NurbsCurve, TAG_NurbsCurve2D, TAG_NurbsSurface, TAG_XXQuadric, TAG_XXSolidRep, TAG_SubdivisionSurface
};

#define SFTextureNode_V5_NUMBITS		1
#define SFTextureNode_V5_Count	1

static const u32 SFTextureNode_V5_TypeToTag[1] = {
 TAG_ProceduralTexture
};

#define SFDepthImageNode_V5_NUMBITS		1
#define SFDepthImageNode_V5_Count	1

static const u32 SFDepthImageNode_V5_TypeToTag[1] = {
 TAG_DepthImage
};

#define SFBlendListNode_V5_NUMBITS		1
#define SFBlendListNode_V5_Count	1

static const u32 SFBlendListNode_V5_TypeToTag[1] = {
 TAG_XXLFM_BlendList
};

#define SFFrameListNode_V5_NUMBITS		1
#define SFFrameListNode_V5_Count	1

static const u32 SFFrameListNode_V5_TypeToTag[1] = {
 TAG_XXLFM_FrameList
};

#define SFLightMapNode_V5_NUMBITS		1
#define SFLightMapNode_V5_Count	1

static const u32 SFLightMapNode_V5_TypeToTag[1] = {
 TAG_XXLFM_LightMap
};

#define SFSurfaceMapNode_V5_NUMBITS		1
#define SFSurfaceMapNode_V5_Count	1

static const u32 SFSurfaceMapNode_V5_TypeToTag[1] = {
 TAG_XXLFM_SurfaceMapList
};

#define SFViewMapNode_V5_NUMBITS		1
#define SFViewMapNode_V5_Count	1

static const u32 SFViewMapNode_V5_TypeToTag[1] = {
 TAG_XXLFM_ViewMapList
};

#define SFParticleInitializerNode_V5_NUMBITS		1
#define SFParticleInitializerNode_V5_Count	1

static const u32 SFParticleInitializerNode_V5_TypeToTag[1] = {
 TAG_XXParticleInitBox
};

#define SFInfluenceNode_V5_NUMBITS		2
#define SFInfluenceNode_V5_Count	2

static const u32 SFInfluenceNode_V5_TypeToTag[2] = {
 TAG_XXPlanarObstacle, TAG_XXPointAttractor
};

#define SFDepthTextureNode_V5_NUMBITS		2
#define SFDepthTextureNode_V5_Count	2

static const u32 SFDepthTextureNode_V5_TypeToTag[2] = {
 TAG_PointTexture, TAG_SimpleTexture
};

#define SFSBBoneNode_V5_NUMBITS		1
#define SFSBBoneNode_V5_Count	1

static const u32 SFSBBoneNode_V5_TypeToTag[1] = {
 TAG_SBBone
};

#define SFSBMuscleNode_V5_NUMBITS		1
#define SFSBMuscleNode_V5_Count	1

static const u32 SFSBMuscleNode_V5_TypeToTag[1] = {
 TAG_SBMuscle
};

#define SFSBSegmentNode_V5_NUMBITS		1
#define SFSBSegmentNode_V5_Count	1

static const u32 SFSBSegmentNode_V5_TypeToTag[1] = {
 TAG_SBSegment
};

#define SFSBSiteNode_V5_NUMBITS		1
#define SFSBSiteNode_V5_Count	1

static const u32 SFSBSiteNode_V5_TypeToTag[1] = {
 TAG_SBSite
};

#define SFBaseMeshNode_V5_NUMBITS		1
#define SFBaseMeshNode_V5_Count	1

static const u32 SFBaseMeshNode_V5_TypeToTag[1] = {
 TAG_SubdivisionSurface
};

#define SFSubdivSurfaceSectorNode_V5_NUMBITS		1
#define SFSubdivSurfaceSectorNode_V5_Count	1

static const u32 SFSubdivSurfaceSectorNode_V5_TypeToTag[1] = {
 TAG_SubdivSurfaceSector
};


u32 NDT_V5_GetNumBits(u32 NDT_Tag);
u32 NDT_V5_GetNodeTag(u32 Context_NDT_Tag, u32 NodeType);
u32 NDT_V5_GetNodeType(u32 NDT_Tag, u32 NodeTag);




/* NDT BIFS Version 6 */

#define SFWorldNode_V6_NUMBITS		4
#define SFWorldNode_V6_Count	12

static const u32 SFWorldNode_V6_TypeToTag[12] = {
 TAG_Clipper2D, TAG_ColorTransform, TAG_Ellipse, TAG_LinearGradient, TAG_PathLayout, TAG_RadialGradient, TAG_SynthesizedTexture, TAG_TransformMatrix2D, TAG_Viewport, TAG_XCurve2D, TAG_XFontStyle, TAG_XLineProperties
};

#define SF3DNode_V6_NUMBITS		3
#define SF3DNode_V6_Count	5

static const u32 SF3DNode_V6_TypeToTag[5] = {
 TAG_Clipper2D, TAG_ColorTransform, TAG_PathLayout, TAG_TransformMatrix2D, TAG_Viewport
};

#define SF2DNode_V6_NUMBITS		3
#define SF2DNode_V6_Count	5

static const u32 SF2DNode_V6_TypeToTag[5] = {
 TAG_Clipper2D, TAG_ColorTransform, TAG_PathLayout, TAG_TransformMatrix2D, TAG_Viewport
};

#define SFGeometryNode_V6_NUMBITS		2
#define SFGeometryNode_V6_Count	2

static const u32 SFGeometryNode_V6_TypeToTag[2] = {
 TAG_Ellipse, TAG_XCurve2D
};

#define SFTextureNode_V6_NUMBITS		2
#define SFTextureNode_V6_Count	3

static const u32 SFTextureNode_V6_TypeToTag[3] = {
 TAG_LinearGradient, TAG_RadialGradient, TAG_SynthesizedTexture
};

#define SFFontStyleNode_V6_NUMBITS		1
#define SFFontStyleNode_V6_Count	1

static const u32 SFFontStyleNode_V6_TypeToTag[1] = {
 TAG_XFontStyle
};

#define SFLinePropertiesNode_V6_NUMBITS		1
#define SFLinePropertiesNode_V6_Count	1

static const u32 SFLinePropertiesNode_V6_TypeToTag[1] = {
 TAG_XLineProperties
};

#define SFTextureTransformNode_V6_NUMBITS		1
#define SFTextureTransformNode_V6_Count	1

static const u32 SFTextureTransformNode_V6_TypeToTag[1] = {
 TAG_TransformMatrix2D
};

#define SFViewportNode_V6_NUMBITS		1
#define SFViewportNode_V6_Count	1

static const u32 SFViewportNode_V6_TypeToTag[1] = {
 TAG_Viewport
};


u32 NDT_V6_GetNumBits(u32 NDT_Tag);
u32 NDT_V6_GetNodeTag(u32 Context_NDT_Tag, u32 NodeType);
u32 NDT_V6_GetNodeType(u32 NDT_Tag, u32 NodeTag);



u32 NDT_GetChildTable(u32 NodeTag);




#endif		/*_NDT_H*/

