/*
 *			GPAC - MPEG-4 Systems C Development Kit
 *
 *			Copyright (c) Jean Le Feuvre 2000-2003
 *					All rights reserved
 *
 *  This file is part of GPAC / Scene Graph sub-project
 *
 *  GPAC is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  GPAC is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.	
 *
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


/*FILE AUTOMATICALLY GENERATED BY SGGen - DO NOT MOFIFY*/

#ifndef _m4_nodes_H
#define _m4_nodes_H

#ifdef __cplusplus
extern "C" {
#endif

#include <gpac/m4_scenegraph.h>



enum {
	TAG_NULL = 0,
	TAG_Anchor,
	TAG_AnimationStream,
	TAG_Appearance,
	TAG_AudioBuffer,
	TAG_AudioClip,
	TAG_AudioDelay,
	TAG_AudioFX,
	TAG_AudioMix,
	TAG_AudioSource,
	TAG_AudioSwitch,
	TAG_Background,
	TAG_Background2D,
	TAG_Billboard,
	TAG_Bitmap,
	TAG_Box,
	TAG_Circle,
	TAG_Collision,
	TAG_Color,
	TAG_ColorInterpolator,
	TAG_CompositeTexture2D,
	TAG_CompositeTexture3D,
	TAG_Conditional,
	TAG_Cone,
	TAG_Coordinate,
	TAG_Coordinate2D,
	TAG_CoordinateInterpolator,
	TAG_CoordinateInterpolator2D,
	TAG_Curve2D,
	TAG_Cylinder,
	TAG_CylinderSensor,
	TAG_DirectionalLight,
	TAG_DiscSensor,
	TAG_ElevationGrid,
	TAG_Expression,
	TAG_Extrusion,
	TAG_Face,
	TAG_FaceDefMesh,
	TAG_FaceDefTables,
	TAG_FaceDefTransform,
	TAG_FAP,
	TAG_FDP,
	TAG_FIT,
	TAG_Fog,
	TAG_FontStyle,
	TAG_Form,
	TAG_Group,
	TAG_ImageTexture,
	TAG_IndexedFaceSet,
	TAG_IndexedFaceSet2D,
	TAG_IndexedLineSet,
	TAG_IndexedLineSet2D,
	TAG_Inline,
	TAG_LOD,
	TAG_Layer2D,
	TAG_Layer3D,
	TAG_Layout,
	TAG_LineProperties,
	TAG_ListeningPoint,
	TAG_Material,
	TAG_Material2D,
	TAG_MovieTexture,
	TAG_NavigationInfo,
	TAG_Normal,
	TAG_NormalInterpolator,
	TAG_OrderedGroup,
	TAG_OrientationInterpolator,
	TAG_PixelTexture,
	TAG_PlaneSensor,
	TAG_PlaneSensor2D,
	TAG_PointLight,
	TAG_PointSet,
	TAG_PointSet2D,
	TAG_PositionInterpolator,
	TAG_PositionInterpolator2D,
	TAG_ProximitySensor2D,
	TAG_ProximitySensor,
	TAG_QuantizationParameter,
	TAG_Rectangle,
	TAG_ScalarInterpolator,
	TAG_Script,
	TAG_Shape,
	TAG_Sound,
	TAG_Sound2D,
	TAG_Sphere,
	TAG_SphereSensor,
	TAG_SpotLight,
	TAG_Switch,
	TAG_TermCap,
	TAG_Text,
	TAG_TextureCoordinate,
	TAG_TextureTransform,
	TAG_TimeSensor,
	TAG_TouchSensor,
	TAG_Transform,
	TAG_Transform2D,
	TAG_Valuator,
	TAG_Viewpoint,
	TAG_VisibilitySensor,
	TAG_Viseme,
	TAG_WorldInfo,
	TAG_AcousticMaterial,
	TAG_AcousticScene,
	TAG_ApplicationWindow,
	TAG_BAP,
	TAG_BDP,
	TAG_Body,
	TAG_BodyDefTable,
	TAG_BodySegmentConnectionHint,
	TAG_DirectiveSound,
	TAG_Hierarchical3DMesh,
	TAG_MaterialKey,
	TAG_PerceptualParameters,
	TAG_TemporalTransform,
	TAG_TemporalGroup,
	TAG_ServerCommand,
	TAG_InputSensor,
	TAG_MatteTexture,
	TAG_MediaBuffer,
	TAG_MediaControl,
	TAG_MediaSensor,
	TAG_BitWrapper,
	TAG_CoordinateInterpolator4D,
	TAG_DepthImage,
	TAG_FFD,
	TAG_XXImplicit,
	TAG_XXLFM_Appearance,
	TAG_XXLFM_BlendList,
	TAG_XXLFM_FrameList,
	TAG_XXLFM_LightMap,
	TAG_XXLFM_SurfaceMapList,
	TAG_XXLFM_ViewMapList,
	TAG_MeshGrid,
	TAG_NonLinearDeformer,
	TAG_NurbsCurve,
	TAG_NurbsCurve2D,
	TAG_NurbsSurface,
	TAG_OctreeImage,
	TAG_XXParticles,
	TAG_XXParticleInitBox,
	TAG_XXPlanarObstacle,
	TAG_XXPointAttractor,
	TAG_PointTexture,
	TAG_PositionAnimator,
	TAG_PositionAnimator2D,
	TAG_PositionInterpolator4D,
	TAG_ProceduralTexture,
	TAG_XXQuadric,
	TAG_SBBone,
	TAG_SBMuscle,
	TAG_SBSegment,
	TAG_SBSite,
	TAG_SBSkinnedModel,
	TAG_SBVCAnimation,
	TAG_ScalarAnimator,
	TAG_SimpleTexture,
	TAG_XXSolidRep,
	TAG_SubdivisionSurface,
	TAG_SubdivSurfaceSector,
	TAG_WaveletSubdivisionSurface,
	TAG_Clipper2D,
	TAG_ColorTransform,
	TAG_Ellipse,
	TAG_LinearGradient,
	TAG_PathLayout,
	TAG_RadialGradient,
	TAG_SynthesizedTexture,
	TAG_TransformMatrix2D,
	TAG_Viewport,
	TAG_XCurve2D,
	TAG_XFontStyle,
	TAG_XLineProperties,
	/*all proto instances have this tag*/
	TAG_ProtoNode,
	/*undefined nodes (when parsing) use this tag*/
	TAG_UndefinedNode
};

typedef struct _tagAnchor
{
	BASE_NODE
	CHILDREN
	SFString description;	/*exposedField*/
	MFString parameter;	/*exposedField*/
	MFURL url;	/*exposedField*/
	SFBool activate;	/*eventIn*/
	void (*on_activate)(SFNode *pThis);	/*eventInHandler*/
} B_Anchor;


typedef struct _tagAnimationStream
{
	BASE_NODE
	SFBool loop;	/*exposedField*/
	SFFloat speed;	/*exposedField*/
	SFTime startTime;	/*exposedField*/
	SFTime stopTime;	/*exposedField*/
	MFURL url;	/*exposedField*/
	SFTime duration_changed;	/*eventOut*/
	SFBool isActive;	/*eventOut*/
} B_AnimationStream;


typedef struct _tagAppearance
{
	BASE_NODE
	SFNode *material;	/*exposedField*/
	SFNode *texture;	/*exposedField*/
	SFNode *textureTransform;	/*exposedField*/
} B_Appearance;


typedef struct _tagAudioBuffer
{
	BASE_NODE
	SFBool loop;	/*exposedField*/
	SFFloat pitch;	/*exposedField*/
	SFTime startTime;	/*exposedField*/
	SFTime stopTime;	/*exposedField*/
	Chain *children;	/*exposedField*/
	SFInt32 numChan;	/*exposedField*/
	MFInt32 phaseGroup;	/*exposedField*/
	SFFloat length;	/*exposedField*/
	SFTime duration_changed;	/*eventOut*/
	SFBool isActive;	/*eventOut*/
} B_AudioBuffer;


typedef struct _tagAudioClip
{
	BASE_NODE
	SFString description;	/*exposedField*/
	SFBool loop;	/*exposedField*/
	SFFloat pitch;	/*exposedField*/
	SFTime startTime;	/*exposedField*/
	SFTime stopTime;	/*exposedField*/
	MFURL url;	/*exposedField*/
	SFTime duration_changed;	/*eventOut*/
	SFBool isActive;	/*eventOut*/
} B_AudioClip;


typedef struct _tagAudioDelay
{
	BASE_NODE
	CHILDREN
	SFTime delay;	/*exposedField*/
	SFInt32 numChan;	/*field*/
	MFInt32 phaseGroup;	/*field*/
} B_AudioDelay;


typedef struct _tagAudioFX
{
	BASE_NODE
	CHILDREN
	SFString orch;	/*exposedField*/
	SFString score;	/*exposedField*/
	MFFloat params;	/*exposedField*/
	SFInt32 numChan;	/*field*/
	MFInt32 phaseGroup;	/*field*/
} B_AudioFX;


typedef struct _tagAudioMix
{
	BASE_NODE
	CHILDREN
	SFInt32 numInputs;	/*exposedField*/
	MFFloat matrix;	/*exposedField*/
	SFInt32 numChan;	/*field*/
	MFInt32 phaseGroup;	/*field*/
} B_AudioMix;


typedef struct _tagAudioSource
{
	BASE_NODE
	CHILDREN
	MFURL url;	/*exposedField*/
	SFFloat pitch;	/*exposedField*/
	SFFloat speed;	/*exposedField*/
	SFTime startTime;	/*exposedField*/
	SFTime stopTime;	/*exposedField*/
	SFInt32 numChan;	/*field*/
	MFInt32 phaseGroup;	/*field*/
} B_AudioSource;


typedef struct _tagAudioSwitch
{
	BASE_NODE
	CHILDREN
	MFInt32 whichChoice;	/*exposedField*/
	SFInt32 numChan;	/*field*/
	MFInt32 phaseGroup;	/*field*/
} B_AudioSwitch;


typedef struct _tagBackground
{
	BASE_NODE
	SFBool set_bind;	/*eventIn*/
	void (*on_set_bind)(SFNode *pThis);	/*eventInHandler*/
	MFFloat groundAngle;	/*exposedField*/
	MFColor groundColor;	/*exposedField*/
	MFURL backUrl;	/*exposedField*/
	MFURL bottomUrl;	/*exposedField*/
	MFURL frontUrl;	/*exposedField*/
	MFURL leftUrl;	/*exposedField*/
	MFURL rightUrl;	/*exposedField*/
	MFURL topUrl;	/*exposedField*/
	MFFloat skyAngle;	/*exposedField*/
	MFColor skyColor;	/*exposedField*/
	SFBool isBound;	/*eventOut*/
} B_Background;


typedef struct _tagBackground2D
{
	BASE_NODE
	SFBool set_bind;	/*eventIn*/
	void (*on_set_bind)(SFNode *pThis);	/*eventInHandler*/
	SFColor backColor;	/*exposedField*/
	MFURL url;	/*exposedField*/
	SFBool isBound;	/*eventOut*/
} B_Background2D;


typedef struct _tagBillboard
{
	BASE_NODE
	CHILDREN
	SFVec3f axisOfRotation;	/*exposedField*/
} B_Billboard;


typedef struct _tagBitmap
{
	BASE_NODE
	SFVec2f scale;	/*exposedField*/
} B_Bitmap;


typedef struct _tagBox
{
	BASE_NODE
	SFVec3f size;	/*field*/
} B_Box;


typedef struct _tagCircle
{
	BASE_NODE
	SFFloat radius;	/*exposedField*/
} B_Circle;


typedef struct _tagCollision
{
	BASE_NODE
	CHILDREN
	SFBool collide;	/*exposedField*/
	SFNode *proxy;	/*field*/
	SFTime collideTime;	/*eventOut*/
} B_Collision;


typedef struct _tagColor
{
	BASE_NODE
	MFColor color;	/*exposedField*/
} B_Color;


typedef struct _tagColorInterpolator
{
	BASE_NODE
	SFFloat set_fraction;	/*eventIn*/
	void (*on_set_fraction)(SFNode *pThis);	/*eventInHandler*/
	MFFloat key;	/*exposedField*/
	MFColor keyValue;	/*exposedField*/
	SFColor value_changed;	/*eventOut*/
} B_ColorInterpolator;


typedef struct _tagCompositeTexture2D
{
	BASE_NODE
	CHILDREN
	SFInt32 pixelWidth;	/*exposedField*/
	SFInt32 pixelHeight;	/*exposedField*/
	SFNode *background;	/*exposedField*/
	SFNode *viewport;	/*exposedField*/
} B_CompositeTexture2D;


typedef struct _tagCompositeTexture3D
{
	BASE_NODE
	CHILDREN
	SFInt32 pixelWidth;	/*exposedField*/
	SFInt32 pixelHeight;	/*exposedField*/
	SFNode *background;	/*exposedField*/
	SFNode *fog;	/*exposedField*/
	SFNode *navigationInfo;	/*exposedField*/
	SFNode *viewpoint;	/*exposedField*/
} B_CompositeTexture3D;


typedef struct _tagConditional
{
	BASE_NODE
	SFBool activate;	/*eventIn*/
	void (*on_activate)(SFNode *pThis);	/*eventInHandler*/
	SFBool reverseActivate;	/*eventIn*/
	void (*on_reverseActivate)(SFNode *pThis);	/*eventInHandler*/
	SFCommandBuffer buffer;	/*exposedField*/
	SFBool isActive;	/*eventOut*/
} B_Conditional;


typedef struct _tagCone
{
	BASE_NODE
	SFFloat bottomRadius;	/*field*/
	SFFloat height;	/*field*/
	SFBool side;	/*field*/
	SFBool bottom;	/*field*/
} B_Cone;


typedef struct _tagCoordinate
{
	BASE_NODE
	MFVec3f point;	/*exposedField*/
} B_Coordinate;


typedef struct _tagCoordinate2D
{
	BASE_NODE
	MFVec2f point;	/*exposedField*/
} B_Coordinate2D;


typedef struct _tagCoordinateInterpolator
{
	BASE_NODE
	SFFloat set_fraction;	/*eventIn*/
	void (*on_set_fraction)(SFNode *pThis);	/*eventInHandler*/
	MFFloat key;	/*exposedField*/
	MFVec3f keyValue;	/*exposedField*/
	MFVec3f value_changed;	/*eventOut*/
} B_CoordinateInterpolator;


typedef struct _tagCoordinateInterpolator2D
{
	BASE_NODE
	SFFloat set_fraction;	/*eventIn*/
	void (*on_set_fraction)(SFNode *pThis);	/*eventInHandler*/
	MFFloat key;	/*exposedField*/
	MFVec2f keyValue;	/*exposedField*/
	MFVec2f value_changed;	/*eventOut*/
} B_CoordinateInterpolator2D;


typedef struct _tagCurve2D
{
	BASE_NODE
	SFNode *point;	/*exposedField*/
	SFFloat fineness;	/*exposedField*/
	MFInt32 type;	/*exposedField*/
} B_Curve2D;


typedef struct _tagCylinder
{
	BASE_NODE
	SFBool bottom;	/*field*/
	SFFloat height;	/*field*/
	SFFloat radius;	/*field*/
	SFBool side;	/*field*/
	SFBool top;	/*field*/
} B_Cylinder;


typedef struct _tagCylinderSensor
{
	BASE_NODE
	SFBool autoOffset;	/*exposedField*/
	SFFloat diskAngle;	/*exposedField*/
	SFBool enabled;	/*exposedField*/
	SFFloat maxAngle;	/*exposedField*/
	SFFloat minAngle;	/*exposedField*/
	SFFloat offset;	/*exposedField*/
	SFBool isActive;	/*eventOut*/
	SFRotation rotation_changed;	/*eventOut*/
	SFVec3f trackPoint_changed;	/*eventOut*/
} B_CylinderSensor;


typedef struct _tagDirectionalLight
{
	BASE_NODE
	SFFloat ambientIntensity;	/*exposedField*/
	SFColor color;	/*exposedField*/
	SFVec3f direction;	/*exposedField*/
	SFFloat intensity;	/*exposedField*/
	SFBool on;	/*exposedField*/
} B_DirectionalLight;


typedef struct _tagDiscSensor
{
	BASE_NODE
	SFBool autoOffset;	/*exposedField*/
	SFBool enabled;	/*exposedField*/
	SFFloat maxAngle;	/*exposedField*/
	SFFloat minAngle;	/*exposedField*/
	SFFloat offset;	/*exposedField*/
	SFBool isActive;	/*eventOut*/
	SFFloat rotation_changed;	/*eventOut*/
	SFVec2f trackPoint_changed;	/*eventOut*/
} B_DiscSensor;


typedef struct _tagElevationGrid
{
	BASE_NODE
	MFFloat set_height;	/*eventIn*/
	void (*on_set_height)(SFNode *pThis);	/*eventInHandler*/
	SFNode *color;	/*exposedField*/
	SFNode *normal;	/*exposedField*/
	SFNode *texCoord;	/*exposedField*/
	MFFloat height;	/*field*/
	SFBool ccw;	/*field*/
	SFBool colorPerVertex;	/*field*/
	SFFloat creaseAngle;	/*field*/
	SFBool normalPerVertex;	/*field*/
	SFBool solid;	/*field*/
	SFInt32 xDimension;	/*field*/
	SFFloat xSpacing;	/*field*/
	SFInt32 zDimension;	/*field*/
	SFFloat zSpacing;	/*field*/
} B_ElevationGrid;


typedef struct _tagExpression
{
	BASE_NODE
	SFInt32 expression_select1;	/*exposedField*/
	SFInt32 expression_intensity1;	/*exposedField*/
	SFInt32 expression_select2;	/*exposedField*/
	SFInt32 expression_intensity2;	/*exposedField*/
	SFBool init_face;	/*exposedField*/
	SFBool expression_def;	/*exposedField*/
} B_Expression;


typedef struct _tagExtrusion
{
	BASE_NODE
	MFVec2f set_crossSection;	/*eventIn*/
	void (*on_set_crossSection)(SFNode *pThis);	/*eventInHandler*/
	MFRotation set_orientation;	/*eventIn*/
	void (*on_set_orientation)(SFNode *pThis);	/*eventInHandler*/
	MFVec2f set_scale;	/*eventIn*/
	void (*on_set_scale)(SFNode *pThis);	/*eventInHandler*/
	MFVec3f set_spine;	/*eventIn*/
	void (*on_set_spine)(SFNode *pThis);	/*eventInHandler*/
	SFBool beginCap;	/*field*/
	SFBool ccw;	/*field*/
	SFBool convex;	/*field*/
	SFFloat creaseAngle;	/*field*/
	MFVec2f crossSection;	/*field*/
	SFBool endCap;	/*field*/
	MFRotation orientation;	/*field*/
	MFVec2f scale;	/*field*/
	SFBool solid;	/*field*/
	MFVec3f spine;	/*field*/
} B_Extrusion;


typedef struct _tagFace
{
	BASE_NODE
	SFNode *fap;	/*exposedField*/
	SFNode *fdp;	/*exposedField*/
	SFNode *fit;	/*exposedField*/
	SFNode *ttsSource;	/*exposedField*/
	Chain *renderedFace;	/*exposedField*/
} B_Face;


typedef struct _tagFaceDefMesh
{
	BASE_NODE
	SFNode *faceSceneGraphNode;	/*field*/
	MFInt32 intervalBorders;	/*field*/
	MFInt32 coordIndex;	/*field*/
	MFVec3f displacements;	/*field*/
} B_FaceDefMesh;


typedef struct _tagFaceDefTables
{
	BASE_NODE
	SFInt32 fapID;	/*field*/
	SFInt32 highLevelSelect;	/*field*/
	Chain *faceDefMesh;	/*exposedField*/
	Chain *faceDefTransform;	/*exposedField*/
} B_FaceDefTables;


typedef struct _tagFaceDefTransform
{
	BASE_NODE
	SFNode *faceSceneGraphNode;	/*field*/
	SFInt32 fieldId;	/*field*/
	SFRotation rotationDef;	/*field*/
	SFVec3f scaleDef;	/*field*/
	SFVec3f translationDef;	/*field*/
} B_FaceDefTransform;


typedef struct _tagFAP
{
	BASE_NODE
	SFNode *viseme;	/*exposedField*/
	SFNode *expression;	/*exposedField*/
	SFInt32 open_jaw;	/*exposedField*/
	SFInt32 lower_t_midlip;	/*exposedField*/
	SFInt32 raise_b_midlip;	/*exposedField*/
	SFInt32 stretch_l_corner;	/*exposedField*/
	SFInt32 stretch_r_corner;	/*exposedField*/
	SFInt32 lower_t_lip_lm;	/*exposedField*/
	SFInt32 lower_t_lip_rm;	/*exposedField*/
	SFInt32 lower_b_lip_lm;	/*exposedField*/
	SFInt32 lower_b_lip_rm;	/*exposedField*/
	SFInt32 raise_l_cornerlip;	/*exposedField*/
	SFInt32 raise_r_cornerlip;	/*exposedField*/
	SFInt32 thrust_jaw;	/*exposedField*/
	SFInt32 shift_jaw;	/*exposedField*/
	SFInt32 push_b_lip;	/*exposedField*/
	SFInt32 push_t_lip;	/*exposedField*/
	SFInt32 depress_chin;	/*exposedField*/
	SFInt32 close_t_l_eyelid;	/*exposedField*/
	SFInt32 close_t_r_eyelid;	/*exposedField*/
	SFInt32 close_b_l_eyelid;	/*exposedField*/
	SFInt32 close_b_r_eyelid;	/*exposedField*/
	SFInt32 yaw_l_eyeball;	/*exposedField*/
	SFInt32 yaw_r_eyeball;	/*exposedField*/
	SFInt32 pitch_l_eyeball;	/*exposedField*/
	SFInt32 pitch_r_eyeball;	/*exposedField*/
	SFInt32 thrust_l_eyeball;	/*exposedField*/
	SFInt32 thrust_r_eyeball;	/*exposedField*/
	SFInt32 dilate_l_pupil;	/*exposedField*/
	SFInt32 dilate_r_pupil;	/*exposedField*/
	SFInt32 raise_l_i_eyebrow;	/*exposedField*/
	SFInt32 raise_r_i_eyebrow;	/*exposedField*/
	SFInt32 raise_l_m_eyebrow;	/*exposedField*/
	SFInt32 raise_r_m_eyebrow;	/*exposedField*/
	SFInt32 raise_l_o_eyebrow;	/*exposedField*/
	SFInt32 raise_r_o_eyebrow;	/*exposedField*/
	SFInt32 squeeze_l_eyebrow;	/*exposedField*/
	SFInt32 squeeze_r_eyebrow;	/*exposedField*/
	SFInt32 puff_l_cheek;	/*exposedField*/
	SFInt32 puff_r_cheek;	/*exposedField*/
	SFInt32 lift_l_cheek;	/*exposedField*/
	SFInt32 lift_r_cheek;	/*exposedField*/
	SFInt32 shift_tongue_tip;	/*exposedField*/
	SFInt32 raise_tongue_tip;	/*exposedField*/
	SFInt32 thrust_tongue_tip;	/*exposedField*/
	SFInt32 raise_tongue;	/*exposedField*/
	SFInt32 tongue_roll;	/*exposedField*/
	SFInt32 head_pitch;	/*exposedField*/
	SFInt32 head_yaw;	/*exposedField*/
	SFInt32 head_roll;	/*exposedField*/
	SFInt32 lower_t_midlip_o;	/*exposedField*/
	SFInt32 raise_b_midlip_o;	/*exposedField*/
	SFInt32 stretch_l_cornerlip;	/*exposedField*/
	SFInt32 stretch_r_cornerlip;	/*exposedField*/
	SFInt32 lower_t_lip_lm_o;	/*exposedField*/
	SFInt32 lower_t_lip_rm_o;	/*exposedField*/
	SFInt32 raise_b_lip_lm_o;	/*exposedField*/
	SFInt32 raise_b_lip_rm_o;	/*exposedField*/
	SFInt32 raise_l_cornerlip_o;	/*exposedField*/
	SFInt32 raise_r_cornerlip_o;	/*exposedField*/
	SFInt32 stretch_l_nose;	/*exposedField*/
	SFInt32 stretch_r_nose;	/*exposedField*/
	SFInt32 raise_nose;	/*exposedField*/
	SFInt32 bend_nose;	/*exposedField*/
	SFInt32 raise_l_ear;	/*exposedField*/
	SFInt32 raise_r_ear;	/*exposedField*/
	SFInt32 pull_l_ear;	/*exposedField*/
	SFInt32 pull_r_ear;	/*exposedField*/
} B_FAP;


typedef struct _tagFDP
{
	BASE_NODE
	SFNode *featurePointsCoord;	/*exposedField*/
	SFNode *textureCoord;	/*exposedField*/
	Chain *faceDefTables;	/*exposedField*/
	Chain *faceSceneGraph;	/*exposedField*/
	SFBool useOrthoTexture;	/*field*/
} B_FDP;


typedef struct _tagFIT
{
	BASE_NODE
	MFInt32 FAPs;	/*exposedField*/
	MFInt32 Graph;	/*exposedField*/
	MFInt32 numeratorExp;	/*exposedField*/
	MFInt32 denominatorExp;	/*exposedField*/
	MFInt32 numeratorImpulse;	/*exposedField*/
	MFInt32 numeratorTerms;	/*exposedField*/
	MFInt32 denominatorTerms;	/*exposedField*/
	MFFloat numeratorCoefs;	/*exposedField*/
	MFFloat denominatorCoefs;	/*exposedField*/
} B_FIT;


typedef struct _tagFog
{
	BASE_NODE
	SFColor color;	/*exposedField*/
	SFString fogType;	/*exposedField*/
	SFFloat visibilityRange;	/*exposedField*/
	SFBool set_bind;	/*eventIn*/
	void (*on_set_bind)(SFNode *pThis);	/*eventInHandler*/
	SFBool isBound;	/*eventOut*/
} B_Fog;


typedef struct _tagFontStyle
{
	BASE_NODE
	MFString family;	/*exposedField*/
	SFBool horizontal;	/*exposedField*/
	MFString justify;	/*exposedField*/
	SFString language;	/*exposedField*/
	SFBool leftToRight;	/*exposedField*/
	SFFloat size;	/*exposedField*/
	SFFloat spacing;	/*exposedField*/
	SFString style;	/*exposedField*/
	SFBool topToBottom;	/*exposedField*/
} B_FontStyle;


typedef struct _tagForm
{
	BASE_NODE
	CHILDREN
	SFVec2f size;	/*exposedField*/
	MFInt32 groups;	/*exposedField*/
	MFString constraints;	/*exposedField*/
	MFInt32 groupsIndex;	/*exposedField*/
} B_Form;


typedef struct _tagGroup
{
	BASE_NODE
	CHILDREN
} B_Group;


typedef struct _tagImageTexture
{
	BASE_NODE
	MFURL url;	/*exposedField*/
	SFBool repeatS;	/*field*/
	SFBool repeatT;	/*field*/
} B_ImageTexture;


typedef struct _tagIndexedFaceSet
{
	BASE_NODE
	MFInt32 set_colorIndex;	/*eventIn*/
	void (*on_set_colorIndex)(SFNode *pThis);	/*eventInHandler*/
	MFInt32 set_coordIndex;	/*eventIn*/
	void (*on_set_coordIndex)(SFNode *pThis);	/*eventInHandler*/
	MFInt32 set_normalIndex;	/*eventIn*/
	void (*on_set_normalIndex)(SFNode *pThis);	/*eventInHandler*/
	MFInt32 set_texCoordIndex;	/*eventIn*/
	void (*on_set_texCoordIndex)(SFNode *pThis);	/*eventInHandler*/
	SFNode *color;	/*exposedField*/
	SFNode *coord;	/*exposedField*/
	SFNode *normal;	/*exposedField*/
	SFNode *texCoord;	/*exposedField*/
	SFBool ccw;	/*field*/
	MFInt32 colorIndex;	/*field*/
	SFBool colorPerVertex;	/*field*/
	SFBool convex;	/*field*/
	MFInt32 coordIndex;	/*field*/
	SFFloat creaseAngle;	/*field*/
	MFInt32 normalIndex;	/*field*/
	SFBool normalPerVertex;	/*field*/
	SFBool solid;	/*field*/
	MFInt32 texCoordIndex;	/*field*/
} B_IndexedFaceSet;


typedef struct _tagIndexedFaceSet2D
{
	BASE_NODE
	MFInt32 set_colorIndex;	/*eventIn*/
	void (*on_set_colorIndex)(SFNode *pThis);	/*eventInHandler*/
	MFInt32 set_coordIndex;	/*eventIn*/
	void (*on_set_coordIndex)(SFNode *pThis);	/*eventInHandler*/
	MFInt32 set_texCoordIndex;	/*eventIn*/
	void (*on_set_texCoordIndex)(SFNode *pThis);	/*eventInHandler*/
	SFNode *color;	/*exposedField*/
	SFNode *coord;	/*exposedField*/
	SFNode *texCoord;	/*exposedField*/
	MFInt32 colorIndex;	/*field*/
	SFBool colorPerVertex;	/*field*/
	SFBool convex;	/*field*/
	MFInt32 coordIndex;	/*field*/
	MFInt32 texCoordIndex;	/*field*/
} B_IndexedFaceSet2D;


typedef struct _tagIndexedLineSet
{
	BASE_NODE
	MFInt32 set_colorIndex;	/*eventIn*/
	void (*on_set_colorIndex)(SFNode *pThis);	/*eventInHandler*/
	MFInt32 set_coordIndex;	/*eventIn*/
	void (*on_set_coordIndex)(SFNode *pThis);	/*eventInHandler*/
	SFNode *color;	/*exposedField*/
	SFNode *coord;	/*exposedField*/
	MFInt32 colorIndex;	/*field*/
	SFBool colorPerVertex;	/*field*/
	MFInt32 coordIndex;	/*field*/
} B_IndexedLineSet;


typedef struct _tagIndexedLineSet2D
{
	BASE_NODE
	MFInt32 set_colorIndex;	/*eventIn*/
	void (*on_set_colorIndex)(SFNode *pThis);	/*eventInHandler*/
	MFInt32 set_coordIndex;	/*eventIn*/
	void (*on_set_coordIndex)(SFNode *pThis);	/*eventInHandler*/
	SFNode *color;	/*exposedField*/
	SFNode *coord;	/*exposedField*/
	MFInt32 colorIndex;	/*field*/
	SFBool colorPerVertex;	/*field*/
	MFInt32 coordIndex;	/*field*/
} B_IndexedLineSet2D;


typedef struct _tagInline
{
	BASE_NODE
	MFURL url;	/*exposedField*/
} B_Inline;


typedef struct _tagLOD
{
	BASE_NODE
	Chain *level;	/*exposedField*/
	SFVec3f center;	/*field*/
	MFFloat range;	/*field*/
} B_LOD;


typedef struct _tagLayer2D
{
	BASE_NODE
	CHILDREN
	SFVec2f size;	/*exposedField*/
	SFNode *background;	/*exposedField*/
	SFNode *viewport;	/*exposedField*/
} B_Layer2D;


typedef struct _tagLayer3D
{
	BASE_NODE
	CHILDREN
	SFVec2f size;	/*exposedField*/
	SFNode *background;	/*exposedField*/
	SFNode *fog;	/*exposedField*/
	SFNode *navigationInfo;	/*exposedField*/
	SFNode *viewpoint;	/*exposedField*/
} B_Layer3D;


typedef struct _tagLayout
{
	BASE_NODE
	CHILDREN
	SFBool wrap;	/*exposedField*/
	SFVec2f size;	/*exposedField*/
	SFBool horizontal;	/*exposedField*/
	MFString justify;	/*exposedField*/
	SFBool leftToRight;	/*exposedField*/
	SFBool topToBottom;	/*exposedField*/
	SFFloat spacing;	/*exposedField*/
	SFBool smoothScroll;	/*exposedField*/
	SFBool loop;	/*exposedField*/
	SFBool scrollVertical;	/*exposedField*/
	SFFloat scrollRate;	/*exposedField*/
} B_Layout;


typedef struct _tagLineProperties
{
	BASE_NODE
	SFColor lineColor;	/*exposedField*/
	SFInt32 lineStyle;	/*exposedField*/
	SFFloat width;	/*exposedField*/
} B_LineProperties;


typedef struct _tagListeningPoint
{
	BASE_NODE
	SFBool set_bind;	/*eventIn*/
	void (*on_set_bind)(SFNode *pThis);	/*eventInHandler*/
	SFBool jump;	/*exposedField*/
	SFRotation orientation;	/*exposedField*/
	SFVec3f position;	/*exposedField*/
	SFString description;	/*field*/
	SFTime bindTime;	/*eventOut*/
	SFBool isBound;	/*eventOut*/
} B_ListeningPoint;


typedef struct _tagMaterial
{
	BASE_NODE
	SFFloat ambientIntensity;	/*exposedField*/
	SFColor diffuseColor;	/*exposedField*/
	SFColor emissiveColor;	/*exposedField*/
	SFFloat shininess;	/*exposedField*/
	SFColor specularColor;	/*exposedField*/
	SFFloat transparency;	/*exposedField*/
} B_Material;


typedef struct _tagMaterial2D
{
	BASE_NODE
	SFColor emissiveColor;	/*exposedField*/
	SFBool filled;	/*exposedField*/
	SFNode *lineProps;	/*exposedField*/
	SFFloat transparency;	/*exposedField*/
} B_Material2D;


typedef struct _tagMovieTexture
{
	BASE_NODE
	SFBool loop;	/*exposedField*/
	SFFloat speed;	/*exposedField*/
	SFTime startTime;	/*exposedField*/
	SFTime stopTime;	/*exposedField*/
	MFURL url;	/*exposedField*/
	SFBool repeatS;	/*field*/
	SFBool repeatT;	/*field*/
	SFTime duration_changed;	/*eventOut*/
	SFBool isActive;	/*eventOut*/
} B_MovieTexture;


typedef struct _tagNavigationInfo
{
	BASE_NODE
	SFBool set_bind;	/*eventIn*/
	void (*on_set_bind)(SFNode *pThis);	/*eventInHandler*/
	MFFloat avatarSize;	/*exposedField*/
	SFBool headlight;	/*exposedField*/
	SFFloat speed;	/*exposedField*/
	MFString type;	/*exposedField*/
	SFFloat visibilityLimit;	/*exposedField*/
	SFBool isBound;	/*eventOut*/
} B_NavigationInfo;


typedef struct _tagNormal
{
	BASE_NODE
	MFVec3f vector;	/*exposedField*/
} B_Normal;


typedef struct _tagNormalInterpolator
{
	BASE_NODE
	SFFloat set_fraction;	/*eventIn*/
	void (*on_set_fraction)(SFNode *pThis);	/*eventInHandler*/
	MFFloat key;	/*exposedField*/
	MFVec3f keyValue;	/*exposedField*/
	MFVec3f value_changed;	/*eventOut*/
} B_NormalInterpolator;


typedef struct _tagOrderedGroup
{
	BASE_NODE
	CHILDREN
	MFFloat order;	/*exposedField*/
} B_OrderedGroup;


typedef struct _tagOrientationInterpolator
{
	BASE_NODE
	SFFloat set_fraction;	/*eventIn*/
	void (*on_set_fraction)(SFNode *pThis);	/*eventInHandler*/
	MFFloat key;	/*exposedField*/
	MFRotation keyValue;	/*exposedField*/
	SFRotation value_changed;	/*eventOut*/
} B_OrientationInterpolator;


typedef struct _tagPixelTexture
{
	BASE_NODE
	SFImage image;	/*exposedField*/
	SFBool repeatS;	/*field*/
	SFBool repeatT;	/*field*/
} B_PixelTexture;


typedef struct _tagPlaneSensor
{
	BASE_NODE
	SFBool autoOffset;	/*exposedField*/
	SFBool enabled;	/*exposedField*/
	SFVec2f maxPosition;	/*exposedField*/
	SFVec2f minPosition;	/*exposedField*/
	SFVec3f offset;	/*exposedField*/
	SFBool isActive;	/*eventOut*/
	SFVec3f trackPoint_changed;	/*eventOut*/
	SFVec3f translation_changed;	/*eventOut*/
} B_PlaneSensor;


typedef struct _tagPlaneSensor2D
{
	BASE_NODE
	SFBool autoOffset;	/*exposedField*/
	SFBool enabled;	/*exposedField*/
	SFVec2f maxPosition;	/*exposedField*/
	SFVec2f minPosition;	/*exposedField*/
	SFVec2f offset;	/*exposedField*/
	SFBool isActive;	/*eventOut*/
	SFVec2f trackPoint_changed;	/*eventOut*/
	SFVec2f translation_changed;	/*eventOut*/
} B_PlaneSensor2D;


typedef struct _tagPointLight
{
	BASE_NODE
	SFFloat ambientIntensity;	/*exposedField*/
	SFVec3f attenuation;	/*exposedField*/
	SFColor color;	/*exposedField*/
	SFFloat intensity;	/*exposedField*/
	SFVec3f location;	/*exposedField*/
	SFBool on;	/*exposedField*/
	SFFloat radius;	/*exposedField*/
} B_PointLight;


typedef struct _tagPointSet
{
	BASE_NODE
	SFNode *color;	/*exposedField*/
	SFNode *coord;	/*exposedField*/
} B_PointSet;


typedef struct _tagPointSet2D
{
	BASE_NODE
	SFNode *color;	/*exposedField*/
	SFNode *coord;	/*exposedField*/
} B_PointSet2D;


typedef struct _tagPositionInterpolator
{
	BASE_NODE
	SFFloat set_fraction;	/*eventIn*/
	void (*on_set_fraction)(SFNode *pThis);	/*eventInHandler*/
	MFFloat key;	/*exposedField*/
	MFVec3f keyValue;	/*exposedField*/
	SFVec3f value_changed;	/*eventOut*/
} B_PositionInterpolator;


typedef struct _tagPositionInterpolator2D
{
	BASE_NODE
	SFFloat set_fraction;	/*eventIn*/
	void (*on_set_fraction)(SFNode *pThis);	/*eventInHandler*/
	MFFloat key;	/*exposedField*/
	MFVec2f keyValue;	/*exposedField*/
	SFVec2f value_changed;	/*eventOut*/
} B_PositionInterpolator2D;


typedef struct _tagProximitySensor2D
{
	BASE_NODE
	SFVec2f center;	/*exposedField*/
	SFVec2f size;	/*exposedField*/
	SFBool enabled;	/*exposedField*/
	SFBool isActive;	/*eventOut*/
	SFVec2f position_changed;	/*eventOut*/
	SFFloat orientation_changed;	/*eventOut*/
	SFTime enterTime;	/*eventOut*/
	SFTime exitTime;	/*eventOut*/
} B_ProximitySensor2D;


typedef struct _tagProximitySensor
{
	BASE_NODE
	SFVec3f center;	/*exposedField*/
	SFVec3f size;	/*exposedField*/
	SFBool enabled;	/*exposedField*/
	SFBool isActive;	/*eventOut*/
	SFVec3f position_changed;	/*eventOut*/
	SFRotation orientation_changed;	/*eventOut*/
	SFTime enterTime;	/*eventOut*/
	SFTime exitTime;	/*eventOut*/
} B_ProximitySensor;


typedef struct _tagQuantizationParameter
{
	BASE_NODE
	SFBool isLocal;	/*field*/
	SFBool position3DQuant;	/*field*/
	SFVec3f position3DMin;	/*field*/
	SFVec3f position3DMax;	/*field*/
	SFInt32 position3DNbBits;	/*field*/
	SFBool position2DQuant;	/*field*/
	SFVec2f position2DMin;	/*field*/
	SFVec2f position2DMax;	/*field*/
	SFInt32 position2DNbBits;	/*field*/
	SFBool drawOrderQuant;	/*field*/
	SFFloat drawOrderMin;	/*field*/
	SFFloat drawOrderMax;	/*field*/
	SFInt32 drawOrderNbBits;	/*field*/
	SFBool colorQuant;	/*field*/
	SFFloat colorMin;	/*field*/
	SFFloat colorMax;	/*field*/
	SFInt32 colorNbBits;	/*field*/
	SFBool textureCoordinateQuant;	/*field*/
	SFFloat textureCoordinateMin;	/*field*/
	SFFloat textureCoordinateMax;	/*field*/
	SFInt32 textureCoordinateNbBits;	/*field*/
	SFBool angleQuant;	/*field*/
	SFFloat angleMin;	/*field*/
	SFFloat angleMax;	/*field*/
	SFInt32 angleNbBits;	/*field*/
	SFBool scaleQuant;	/*field*/
	SFFloat scaleMin;	/*field*/
	SFFloat scaleMax;	/*field*/
	SFInt32 scaleNbBits;	/*field*/
	SFBool keyQuant;	/*field*/
	SFFloat keyMin;	/*field*/
	SFFloat keyMax;	/*field*/
	SFInt32 keyNbBits;	/*field*/
	SFBool normalQuant;	/*field*/
	SFInt32 normalNbBits;	/*field*/
	SFBool sizeQuant;	/*field*/
	SFFloat sizeMin;	/*field*/
	SFFloat sizeMax;	/*field*/
	SFInt32 sizeNbBits;	/*field*/
	SFBool useEfficientCoding;	/*field*/
} B_QuantizationParameter;


typedef struct _tagRectangle
{
	BASE_NODE
	SFVec2f size;	/*exposedField*/
} B_Rectangle;


typedef struct _tagScalarInterpolator
{
	BASE_NODE
	SFFloat set_fraction;	/*eventIn*/
	void (*on_set_fraction)(SFNode *pThis);	/*eventInHandler*/
	MFFloat key;	/*exposedField*/
	MFFloat keyValue;	/*exposedField*/
	SFFloat value_changed;	/*eventOut*/
} B_ScalarInterpolator;


typedef struct _tagScript
{
	BASE_NODE
	MFScript url;	/*exposedField*/
	SFBool directOutput;	/*field*/
	SFBool mustEvaluate;	/*field*/
} B_Script;


typedef struct _tagShape
{
	BASE_NODE
	SFNode *appearance;	/*exposedField*/
	SFNode *geometry;	/*exposedField*/
} B_Shape;


typedef struct _tagSound
{
	BASE_NODE
	SFVec3f direction;	/*exposedField*/
	SFFloat intensity;	/*exposedField*/
	SFVec3f location;	/*exposedField*/
	SFFloat maxBack;	/*exposedField*/
	SFFloat maxFront;	/*exposedField*/
	SFFloat minBack;	/*exposedField*/
	SFFloat minFront;	/*exposedField*/
	SFFloat priority;	/*exposedField*/
	SFNode *source;	/*exposedField*/
	SFBool spatialize;	/*field*/
} B_Sound;


typedef struct _tagSound2D
{
	BASE_NODE
	SFFloat intensity;	/*exposedField*/
	SFVec2f location;	/*exposedField*/
	SFNode *source;	/*exposedField*/
	SFBool spatialize;	/*field*/
} B_Sound2D;


typedef struct _tagSphere
{
	BASE_NODE
	SFFloat radius;	/*field*/
} B_Sphere;


typedef struct _tagSphereSensor
{
	BASE_NODE
	SFBool autoOffset;	/*exposedField*/
	SFBool enabled;	/*exposedField*/
	SFRotation offset;	/*exposedField*/
	SFBool isActive;	/*eventOut*/
	SFRotation rotation_changed;	/*eventOut*/
	SFVec3f trackPoint_changed;	/*eventOut*/
} B_SphereSensor;


typedef struct _tagSpotLight
{
	BASE_NODE
	SFFloat ambientIntensity;	/*exposedField*/
	SFVec3f attenuation;	/*exposedField*/
	SFFloat beamWidth;	/*exposedField*/
	SFColor color;	/*exposedField*/
	SFFloat cutOffAngle;	/*exposedField*/
	SFVec3f direction;	/*exposedField*/
	SFFloat intensity;	/*exposedField*/
	SFVec3f location;	/*exposedField*/
	SFBool on;	/*exposedField*/
	SFFloat radius;	/*exposedField*/
} B_SpotLight;


typedef struct _tagSwitch
{
	BASE_NODE
	Chain *choice;	/*exposedField*/
	SFInt32 whichChoice;	/*exposedField*/
} B_Switch;


typedef struct _tagTermCap
{
	BASE_NODE
	SFTime evaluate;	/*eventIn*/
	void (*on_evaluate)(SFNode *pThis);	/*eventInHandler*/
	SFInt32 capability;	/*exposedField*/
	SFInt32 value;	/*eventOut*/
} B_TermCap;


typedef struct _tagText
{
	BASE_NODE
	MFString string;	/*exposedField*/
	MFFloat length;	/*exposedField*/
	SFNode *fontStyle;	/*exposedField*/
	SFFloat maxExtent;	/*exposedField*/
} B_Text;


typedef struct _tagTextureCoordinate
{
	BASE_NODE
	MFVec2f point;	/*exposedField*/
} B_TextureCoordinate;


typedef struct _tagTextureTransform
{
	BASE_NODE
	SFVec2f center;	/*exposedField*/
	SFFloat rotation;	/*exposedField*/
	SFVec2f scale;	/*exposedField*/
	SFVec2f translation;	/*exposedField*/
} B_TextureTransform;


typedef struct _tagTimeSensor
{
	BASE_NODE
	SFTime cycleInterval;	/*exposedField*/
	SFBool enabled;	/*exposedField*/
	SFBool loop;	/*exposedField*/
	SFTime startTime;	/*exposedField*/
	SFTime stopTime;	/*exposedField*/
	SFTime cycleTime;	/*eventOut*/
	SFFloat fraction_changed;	/*eventOut*/
	SFBool isActive;	/*eventOut*/
	SFTime time;	/*eventOut*/
} B_TimeSensor;


typedef struct _tagTouchSensor
{
	BASE_NODE
	SFBool enabled;	/*exposedField*/
	SFVec3f hitNormal_changed;	/*eventOut*/
	SFVec3f hitPoint_changed;	/*eventOut*/
	SFVec2f hitTexCoord_changed;	/*eventOut*/
	SFBool isActive;	/*eventOut*/
	SFBool isOver;	/*eventOut*/
	SFTime touchTime;	/*eventOut*/
} B_TouchSensor;


typedef struct _tagTransform
{
	BASE_NODE
	CHILDREN
	SFVec3f center;	/*exposedField*/
	SFRotation rotation;	/*exposedField*/
	SFVec3f scale;	/*exposedField*/
	SFRotation scaleOrientation;	/*exposedField*/
	SFVec3f translation;	/*exposedField*/
} B_Transform;


typedef struct _tagTransform2D
{
	BASE_NODE
	CHILDREN
	SFVec2f center;	/*exposedField*/
	SFFloat rotationAngle;	/*exposedField*/
	SFVec2f scale;	/*exposedField*/
	SFFloat scaleOrientation;	/*exposedField*/
	SFVec2f translation;	/*exposedField*/
} B_Transform2D;


typedef struct _tagValuator
{
	BASE_NODE
	SFBool inSFBool;	/*eventIn*/
	void (*on_inSFBool)(SFNode *pThis);	/*eventInHandler*/
	SFColor inSFColor;	/*eventIn*/
	void (*on_inSFColor)(SFNode *pThis);	/*eventInHandler*/
	MFColor inMFColor;	/*eventIn*/
	void (*on_inMFColor)(SFNode *pThis);	/*eventInHandler*/
	SFFloat inSFFloat;	/*eventIn*/
	void (*on_inSFFloat)(SFNode *pThis);	/*eventInHandler*/
	MFFloat inMFFloat;	/*eventIn*/
	void (*on_inMFFloat)(SFNode *pThis);	/*eventInHandler*/
	SFInt32 inSFInt32;	/*eventIn*/
	void (*on_inSFInt32)(SFNode *pThis);	/*eventInHandler*/
	MFInt32 inMFInt32;	/*eventIn*/
	void (*on_inMFInt32)(SFNode *pThis);	/*eventInHandler*/
	SFRotation inSFRotation;	/*eventIn*/
	void (*on_inSFRotation)(SFNode *pThis);	/*eventInHandler*/
	MFRotation inMFRotation;	/*eventIn*/
	void (*on_inMFRotation)(SFNode *pThis);	/*eventInHandler*/
	SFString inSFString;	/*eventIn*/
	void (*on_inSFString)(SFNode *pThis);	/*eventInHandler*/
	MFString inMFString;	/*eventIn*/
	void (*on_inMFString)(SFNode *pThis);	/*eventInHandler*/
	SFTime inSFTime;	/*eventIn*/
	void (*on_inSFTime)(SFNode *pThis);	/*eventInHandler*/
	SFVec2f inSFVec2f;	/*eventIn*/
	void (*on_inSFVec2f)(SFNode *pThis);	/*eventInHandler*/
	MFVec2f inMFVec2f;	/*eventIn*/
	void (*on_inMFVec2f)(SFNode *pThis);	/*eventInHandler*/
	SFVec3f inSFVec3f;	/*eventIn*/
	void (*on_inSFVec3f)(SFNode *pThis);	/*eventInHandler*/
	MFVec3f inMFVec3f;	/*eventIn*/
	void (*on_inMFVec3f)(SFNode *pThis);	/*eventInHandler*/
	SFBool outSFBool;	/*eventOut*/
	SFColor outSFColor;	/*eventOut*/
	MFColor outMFColor;	/*eventOut*/
	SFFloat outSFFloat;	/*eventOut*/
	MFFloat outMFFloat;	/*eventOut*/
	SFInt32 outSFInt32;	/*eventOut*/
	MFInt32 outMFInt32;	/*eventOut*/
	SFRotation outSFRotation;	/*eventOut*/
	MFRotation outMFRotation;	/*eventOut*/
	SFString outSFString;	/*eventOut*/
	MFString outMFString;	/*eventOut*/
	SFTime outSFTime;	/*eventOut*/
	SFVec2f outSFVec2f;	/*eventOut*/
	MFVec2f outMFVec2f;	/*eventOut*/
	SFVec3f outSFVec3f;	/*eventOut*/
	MFVec3f outMFVec3f;	/*eventOut*/
	SFFloat Factor1;	/*exposedField*/
	SFFloat Factor2;	/*exposedField*/
	SFFloat Factor3;	/*exposedField*/
	SFFloat Factor4;	/*exposedField*/
	SFFloat Offset1;	/*exposedField*/
	SFFloat Offset2;	/*exposedField*/
	SFFloat Offset3;	/*exposedField*/
	SFFloat Offset4;	/*exposedField*/
	SFBool Sum;	/*exposedField*/
} B_Valuator;


typedef struct _tagViewpoint
{
	BASE_NODE
	SFBool set_bind;	/*eventIn*/
	void (*on_set_bind)(SFNode *pThis);	/*eventInHandler*/
	SFFloat fieldOfView;	/*exposedField*/
	SFBool jump;	/*exposedField*/
	SFRotation orientation;	/*exposedField*/
	SFVec3f position;	/*exposedField*/
	SFString description;	/*field*/
	SFTime bindTime;	/*eventOut*/
	SFBool isBound;	/*eventOut*/
} B_Viewpoint;


typedef struct _tagVisibilitySensor
{
	BASE_NODE
	SFVec3f center;	/*exposedField*/
	SFBool enabled;	/*exposedField*/
	SFVec3f size;	/*exposedField*/
	SFTime enterTime;	/*eventOut*/
	SFTime exitTime;	/*eventOut*/
	SFBool isActive;	/*eventOut*/
} B_VisibilitySensor;


typedef struct _tagViseme
{
	BASE_NODE
	SFInt32 viseme_select1;	/*exposedField*/
	SFInt32 viseme_select2;	/*exposedField*/
	SFInt32 viseme_blend;	/*exposedField*/
	SFBool viseme_def;	/*exposedField*/
} B_Viseme;


typedef struct _tagWorldInfo
{
	BASE_NODE
	MFString info;	/*field*/
	SFString title;	/*field*/
} B_WorldInfo;


typedef struct _tagAcousticMaterial
{
	BASE_NODE
	SFFloat ambientIntensity;	/*exposedField*/
	SFColor diffuseColor;	/*exposedField*/
	SFColor emissiveColor;	/*exposedField*/
	SFFloat shininess;	/*exposedField*/
	SFColor specularColor;	/*exposedField*/
	SFFloat transparency;	/*exposedField*/
	MFFloat reffunc;	/*field*/
	MFFloat transfunc;	/*field*/
	MFFloat refFrequency;	/*field*/
	MFFloat transFrequency;	/*field*/
} B_AcousticMaterial;


typedef struct _tagAcousticScene
{
	BASE_NODE
	SFVec3f center;	/*field*/
	SFVec3f Size;	/*field*/
	MFTime reverbTime;	/*field*/
	MFFloat reverbFreq;	/*field*/
	SFFloat reverbLevel;	/*exposedField*/
	SFTime reverbDelay;	/*exposedField*/
} B_AcousticScene;


typedef struct _tagApplicationWindow
{
	BASE_NODE
	SFBool isActive;	/*exposedField*/
	SFTime startTime;	/*exposedField*/
	SFTime stopTime;	/*exposedField*/
	SFString description;	/*exposedField*/
	MFString parameter;	/*exposedField*/
	MFURL url;	/*exposedField*/
	SFVec2f size;	/*exposedField*/
} B_ApplicationWindow;


typedef struct _tagBAP
{
	BASE_NODE
	SFInt32 sacroiliac_tilt;	/*exposedField*/
	SFInt32 sacroiliac_torsion;	/*exposedField*/
	SFInt32 sacroiliac_roll;	/*exposedField*/
	SFInt32 l_hip_flexion;	/*exposedField*/
	SFInt32 r_hip_flexion;	/*exposedField*/
	SFInt32 l_hip_abduct;	/*exposedField*/
	SFInt32 r_hip_abduct;	/*exposedField*/
	SFInt32 l_hip_twisting;	/*exposedField*/
	SFInt32 r_hip_twisting;	/*exposedField*/
	SFInt32 l_knee_flexion;	/*exposedField*/
	SFInt32 r_knee_flexion;	/*exposedField*/
	SFInt32 l_knee_twisting;	/*exposedField*/
	SFInt32 r_knee_twisting;	/*exposedField*/
	SFInt32 l_ankle_flexion;	/*exposedField*/
	SFInt32 r_ankle_flexion;	/*exposedField*/
	SFInt32 l_ankle_twisting;	/*exposedField*/
	SFInt32 r_ankle_twisting;	/*exposedField*/
	SFInt32 l_subtalar_flexion;	/*exposedField*/
	SFInt32 r_subtalar_flexion;	/*exposedField*/
	SFInt32 l_midtarsal_flexion;	/*exposedField*/
	SFInt32 r_midtarsal_flexion;	/*exposedField*/
	SFInt32 l_metatarsal_flexion;	/*exposedField*/
	SFInt32 r_metatarsal_flexion;	/*exposedField*/
	SFInt32 l_sternoclavicular_abduct;	/*exposedField*/
	SFInt32 r_sternoclavicular_abduct;	/*exposedField*/
	SFInt32 l_sternoclavicular_rotate;	/*exposedField*/
	SFInt32 r_sternoclavicular_rotate;	/*exposedField*/
	SFInt32 l_acromioclavicular_abduct;	/*exposedField*/
	SFInt32 r_acromioclavicular_abduct;	/*exposedField*/
	SFInt32 l_acromioclavicular_rotate;	/*exposedField*/
	SFInt32 r_acromioclavicular_rotate;	/*exposedField*/
	SFInt32 l_shoulder_flexion;	/*exposedField*/
	SFInt32 r_shoulder_flexion;	/*exposedField*/
	SFInt32 l_shoulder_abduct;	/*exposedField*/
	SFInt32 r_shoulder_abduct;	/*exposedField*/
	SFInt32 l_shoulder_twisting;	/*exposedField*/
	SFInt32 r_shoulder_twisting;	/*exposedField*/
	SFInt32 l_elbow_flexion;	/*exposedField*/
	SFInt32 r_elbow_flexion;	/*exposedField*/
	SFInt32 l_elbow_twisting;	/*exposedField*/
	SFInt32 r_elbow_twisting;	/*exposedField*/
	SFInt32 l_wrist_flexion;	/*exposedField*/
	SFInt32 r_wrist_flexion;	/*exposedField*/
	SFInt32 l_wrist_pivot;	/*exposedField*/
	SFInt32 r_wrist_pivot;	/*exposedField*/
	SFInt32 l_wrist_twisting;	/*exposedField*/
	SFInt32 r_wrist_twisting;	/*exposedField*/
	SFInt32 skullbase_roll;	/*exposedField*/
	SFInt32 skullbase_torsion;	/*exposedField*/
	SFInt32 skullbase_tilt;	/*exposedField*/
	SFInt32 vc1roll;	/*exposedField*/
	SFInt32 vc1torsion;	/*exposedField*/
	SFInt32 vc1tilt;	/*exposedField*/
	SFInt32 vc2roll;	/*exposedField*/
	SFInt32 vc2torsion;	/*exposedField*/
	SFInt32 vc2tilt;	/*exposedField*/
	SFInt32 vc3roll;	/*exposedField*/
	SFInt32 vc3torsion;	/*exposedField*/
	SFInt32 vc3tilt;	/*exposedField*/
	SFInt32 vc4roll;	/*exposedField*/
	SFInt32 vc4torsion;	/*exposedField*/
	SFInt32 vc4tilt;	/*exposedField*/
	SFInt32 vc5roll;	/*exposedField*/
	SFInt32 vc5torsion;	/*exposedField*/
	SFInt32 vc5tilt;	/*exposedField*/
	SFInt32 vc6roll;	/*exposedField*/
	SFInt32 vc6torsion;	/*exposedField*/
	SFInt32 vc6tilt;	/*exposedField*/
	SFInt32 vc7roll;	/*exposedField*/
	SFInt32 vc7torsion;	/*exposedField*/
	SFInt32 vc7tilt;	/*exposedField*/
	SFInt32 vt1roll;	/*exposedField*/
	SFInt32 vt1torsion;	/*exposedField*/
	SFInt32 vt1tilt;	/*exposedField*/
	SFInt32 vt2roll;	/*exposedField*/
	SFInt32 vt2torsion;	/*exposedField*/
	SFInt32 vt2tilt;	/*exposedField*/
	SFInt32 vt3roll;	/*exposedField*/
	SFInt32 vt3torsion;	/*exposedField*/
	SFInt32 vt3tilt;	/*exposedField*/
	SFInt32 vt4roll;	/*exposedField*/
	SFInt32 vt4torsion;	/*exposedField*/
	SFInt32 vt4tilt;	/*exposedField*/
	SFInt32 vt5roll;	/*exposedField*/
	SFInt32 vt5torsion;	/*exposedField*/
	SFInt32 vt5tilt;	/*exposedField*/
	SFInt32 vt6roll;	/*exposedField*/
	SFInt32 vt6torsion;	/*exposedField*/
	SFInt32 vt6tilt;	/*exposedField*/
	SFInt32 vt7roll;	/*exposedField*/
	SFInt32 vt7torsion;	/*exposedField*/
	SFInt32 vt7tilt;	/*exposedField*/
	SFInt32 vt8roll;	/*exposedField*/
	SFInt32 vt8torsion;	/*exposedField*/
	SFInt32 vt8tilt;	/*exposedField*/
	SFInt32 vt9roll;	/*exposedField*/
	SFInt32 vt9torsion;	/*exposedField*/
	SFInt32 vt9tilt;	/*exposedField*/
	SFInt32 vt10roll;	/*exposedField*/
	SFInt32 vt10torsion;	/*exposedField*/
	SFInt32 vt10tilt;	/*exposedField*/
	SFInt32 vt11roll;	/*exposedField*/
	SFInt32 vt11torsion;	/*exposedField*/
	SFInt32 vt11tilt;	/*exposedField*/
	SFInt32 vt12roll;	/*exposedField*/
	SFInt32 vt12torsion;	/*exposedField*/
	SFInt32 vt12tilt;	/*exposedField*/
	SFInt32 vl1roll;	/*exposedField*/
	SFInt32 vl1torsion;	/*exposedField*/
	SFInt32 vl1tilt;	/*exposedField*/
	SFInt32 vl2roll;	/*exposedField*/
	SFInt32 vl2torsion;	/*exposedField*/
	SFInt32 vl2tilt;	/*exposedField*/
	SFInt32 vl3roll;	/*exposedField*/
	SFInt32 vl3torsion;	/*exposedField*/
	SFInt32 vl3tilt;	/*exposedField*/
	SFInt32 vl4roll;	/*exposedField*/
	SFInt32 vl4torsion;	/*exposedField*/
	SFInt32 vl4tilt;	/*exposedField*/
	SFInt32 vl5roll;	/*exposedField*/
	SFInt32 vl5torsion;	/*exposedField*/
	SFInt32 vl5tilt;	/*exposedField*/
	SFInt32 l_pinky0_flexion;	/*exposedField*/
	SFInt32 r_pinky0_flexion;	/*exposedField*/
	SFInt32 l_pinky1_flexion;	/*exposedField*/
	SFInt32 r_pinky1_flexion;	/*exposedField*/
	SFInt32 l_pinky1_pivot;	/*exposedField*/
	SFInt32 r_pinky1_pivot;	/*exposedField*/
	SFInt32 l_pinky1_twisting;	/*exposedField*/
	SFInt32 r_pinky1_twisting;	/*exposedField*/
	SFInt32 l_pinky2_flexion;	/*exposedField*/
	SFInt32 r_pinky2_flexion;	/*exposedField*/
	SFInt32 l_pinky3_flexion;	/*exposedField*/
	SFInt32 r_pinky3_flexion;	/*exposedField*/
	SFInt32 l_ring0_flexion;	/*exposedField*/
	SFInt32 r_ring0_flexion;	/*exposedField*/
	SFInt32 l_ring1_flexion;	/*exposedField*/
	SFInt32 r_ring1_flexion;	/*exposedField*/
	SFInt32 l_ring1_pivot;	/*exposedField*/
	SFInt32 r_ring1_pivot;	/*exposedField*/
	SFInt32 l_ring1_twisting;	/*exposedField*/
	SFInt32 r_ring1_twisting;	/*exposedField*/
	SFInt32 l_ring2_flexion;	/*exposedField*/
	SFInt32 r_ring2_flexion;	/*exposedField*/
	SFInt32 l_ring3_flexion;	/*exposedField*/
	SFInt32 r_ring3_flexion;	/*exposedField*/
	SFInt32 l_middle0_flexion;	/*exposedField*/
	SFInt32 r_middle0_flexion;	/*exposedField*/
	SFInt32 l_middle1_flexion;	/*exposedField*/
	SFInt32 r_middle1_flexion;	/*exposedField*/
	SFInt32 l_middle1_pivot;	/*exposedField*/
	SFInt32 r_middle1_pivot;	/*exposedField*/
	SFInt32 l_middle1_twisting;	/*exposedField*/
	SFInt32 r_middle1_twisting;	/*exposedField*/
	SFInt32 l_middle2_flexion;	/*exposedField*/
	SFInt32 r_middle2_flexion;	/*exposedField*/
	SFInt32 l_middle3_flexion;	/*exposedField*/
	SFInt32 r_middle3_flexion;	/*exposedField*/
	SFInt32 l_index0_flexion;	/*exposedField*/
	SFInt32 r_index0_flexion;	/*exposedField*/
	SFInt32 l_index1_flexion;	/*exposedField*/
	SFInt32 r_index1_flexion;	/*exposedField*/
	SFInt32 l_index1_pivot;	/*exposedField*/
	SFInt32 r_index1_pivot;	/*exposedField*/
	SFInt32 l_index1_twisting;	/*exposedField*/
	SFInt32 r_index1_twisting;	/*exposedField*/
	SFInt32 l_index2_flexion;	/*exposedField*/
	SFInt32 r_index2_flexion;	/*exposedField*/
	SFInt32 l_index3_flexion;	/*exposedField*/
	SFInt32 r_index3_flexion;	/*exposedField*/
	SFInt32 l_thumb1_flexion;	/*exposedField*/
	SFInt32 r_thumb1_flexion;	/*exposedField*/
	SFInt32 l_thumb1_pivot;	/*exposedField*/
	SFInt32 r_thumb1_pivot;	/*exposedField*/
	SFInt32 l_thumb1_twisting;	/*exposedField*/
	SFInt32 r_thumb1_twisting;	/*exposedField*/
	SFInt32 l_thumb2_flexion;	/*exposedField*/
	SFInt32 r_thumb2_flexion;	/*exposedField*/
	SFInt32 l_thumb3_flexion;	/*exposedField*/
	SFInt32 r_thumb3_flexion;	/*exposedField*/
	SFInt32 HumanoidRoot_tr_vertical;	/*exposedField*/
	SFInt32 HumanoidRoot_tr_lateral;	/*exposedField*/
	SFInt32 HumanoidRoot_tr_frontal;	/*exposedField*/
	SFInt32 HumanoidRoot_rt_body_turn;	/*exposedField*/
	SFInt32 HumanoidRoot_rt_body_roll;	/*exposedField*/
	SFInt32 HumanoidRoot_rt_body_tilt;	/*exposedField*/
	SFInt32 extensionBap187;	/*exposedField*/
	SFInt32 extensionBap188;	/*exposedField*/
	SFInt32 extensionBap189;	/*exposedField*/
	SFInt32 extensionBap190;	/*exposedField*/
	SFInt32 extensionBap191;	/*exposedField*/
	SFInt32 extensionBap192;	/*exposedField*/
	SFInt32 extensionBap193;	/*exposedField*/
	SFInt32 extensionBap194;	/*exposedField*/
	SFInt32 extensionBap195;	/*exposedField*/
	SFInt32 extensionBap196;	/*exposedField*/
	SFInt32 extensionBap197;	/*exposedField*/
	SFInt32 extensionBap198;	/*exposedField*/
	SFInt32 extensionBap199;	/*exposedField*/
	SFInt32 extensionBap200;	/*exposedField*/
	SFInt32 extensionBap201;	/*exposedField*/
	SFInt32 extensionBap202;	/*exposedField*/
	SFInt32 extensionBap203;	/*exposedField*/
	SFInt32 extensionBap204;	/*exposedField*/
	SFInt32 extensionBap205;	/*exposedField*/
	SFInt32 extensionBap206;	/*exposedField*/
	SFInt32 extensionBap207;	/*exposedField*/
	SFInt32 extensionBap208;	/*exposedField*/
	SFInt32 extensionBap209;	/*exposedField*/
	SFInt32 extensionBap210;	/*exposedField*/
	SFInt32 extensionBap211;	/*exposedField*/
	SFInt32 extensionBap212;	/*exposedField*/
	SFInt32 extensionBap213;	/*exposedField*/
	SFInt32 extensionBap214;	/*exposedField*/
	SFInt32 extensionBap215;	/*exposedField*/
	SFInt32 extensionBap216;	/*exposedField*/
	SFInt32 extensionBap217;	/*exposedField*/
	SFInt32 extensionBap218;	/*exposedField*/
	SFInt32 extensionBap219;	/*exposedField*/
	SFInt32 extensionBap220;	/*exposedField*/
	SFInt32 extensionBap221;	/*exposedField*/
	SFInt32 extensionBap222;	/*exposedField*/
	SFInt32 extensionBap223;	/*exposedField*/
	SFInt32 extensionBap224;	/*exposedField*/
	SFInt32 extensionBap225;	/*exposedField*/
	SFInt32 extensionBap226;	/*exposedField*/
	SFInt32 extensionBap227;	/*exposedField*/
	SFInt32 extensionBap228;	/*exposedField*/
	SFInt32 extensionBap229;	/*exposedField*/
	SFInt32 extensionBap230;	/*exposedField*/
	SFInt32 extensionBap231;	/*exposedField*/
	SFInt32 extensionBap232;	/*exposedField*/
	SFInt32 extensionBap233;	/*exposedField*/
	SFInt32 extensionBap234;	/*exposedField*/
	SFInt32 extensionBap235;	/*exposedField*/
	SFInt32 extensionBap236;	/*exposedField*/
	SFInt32 extensionBap237;	/*exposedField*/
	SFInt32 extensionBap238;	/*exposedField*/
	SFInt32 extensionBap239;	/*exposedField*/
	SFInt32 extensionBap240;	/*exposedField*/
	SFInt32 extensionBap241;	/*exposedField*/
	SFInt32 extensionBap242;	/*exposedField*/
	SFInt32 extensionBap243;	/*exposedField*/
	SFInt32 extensionBap244;	/*exposedField*/
	SFInt32 extensionBap245;	/*exposedField*/
	SFInt32 extensionBap246;	/*exposedField*/
	SFInt32 extensionBap247;	/*exposedField*/
	SFInt32 extensionBap248;	/*exposedField*/
	SFInt32 extensionBap249;	/*exposedField*/
	SFInt32 extensionBap250;	/*exposedField*/
	SFInt32 extensionBap251;	/*exposedField*/
	SFInt32 extensionBap252;	/*exposedField*/
	SFInt32 extensionBap253;	/*exposedField*/
	SFInt32 extensionBap254;	/*exposedField*/
	SFInt32 extensionBap255;	/*exposedField*/
	SFInt32 extensionBap256;	/*exposedField*/
	SFInt32 extensionBap257;	/*exposedField*/
	SFInt32 extensionBap258;	/*exposedField*/
	SFInt32 extensionBap259;	/*exposedField*/
	SFInt32 extensionBap260;	/*exposedField*/
	SFInt32 extensionBap261;	/*exposedField*/
	SFInt32 extensionBap262;	/*exposedField*/
	SFInt32 extensionBap263;	/*exposedField*/
	SFInt32 extensionBap264;	/*exposedField*/
	SFInt32 extensionBap265;	/*exposedField*/
	SFInt32 extensionBap266;	/*exposedField*/
	SFInt32 extensionBap267;	/*exposedField*/
	SFInt32 extensionBap268;	/*exposedField*/
	SFInt32 extensionBap269;	/*exposedField*/
	SFInt32 extensionBap270;	/*exposedField*/
	SFInt32 extensionBap271;	/*exposedField*/
	SFInt32 extensionBap272;	/*exposedField*/
	SFInt32 extensionBap273;	/*exposedField*/
	SFInt32 extensionBap274;	/*exposedField*/
	SFInt32 extensionBap275;	/*exposedField*/
	SFInt32 extensionBap276;	/*exposedField*/
	SFInt32 extensionBap277;	/*exposedField*/
	SFInt32 extensionBap278;	/*exposedField*/
	SFInt32 extensionBap279;	/*exposedField*/
	SFInt32 extensionBap280;	/*exposedField*/
	SFInt32 extensionBap281;	/*exposedField*/
	SFInt32 extensionBap282;	/*exposedField*/
	SFInt32 extensionBap283;	/*exposedField*/
	SFInt32 extensionBap284;	/*exposedField*/
	SFInt32 extensionBap285;	/*exposedField*/
	SFInt32 extensionBap286;	/*exposedField*/
	SFInt32 extensionBap287;	/*exposedField*/
	SFInt32 extensionBap288;	/*exposedField*/
	SFInt32 extensionBap289;	/*exposedField*/
	SFInt32 extensionBap290;	/*exposedField*/
	SFInt32 extensionBap291;	/*exposedField*/
	SFInt32 extensionBap292;	/*exposedField*/
	SFInt32 extensionBap293;	/*exposedField*/
	SFInt32 extensionBap294;	/*exposedField*/
	SFInt32 extensionBap295;	/*exposedField*/
	SFInt32 extensionBap296;	/*exposedField*/
} B_BAP;


typedef struct _tagBDP
{
	BASE_NODE
	Chain *bodyDefTables;	/*exposedField*/
	Chain *bodySceneGraph;	/*exposedField*/
} B_BDP;


typedef struct _tagBody
{
	BASE_NODE
	SFNode *bdp;	/*exposedField*/
	SFNode *bap;	/*exposedField*/
	Chain *renderedBody;	/*exposedField*/
} B_Body;


typedef struct _tagBodyDefTable
{
	BASE_NODE
	SFString bodySceneGraphNodeName;	/*exposedField*/
	MFInt32 bapIDs;	/*exposedField*/
	MFInt32 vertexIds;	/*exposedField*/
	MFInt32 bapCombinations;	/*exposedField*/
	MFVec3f displacements;	/*exposedField*/
	SFInt32 numInterpolateKeys;	/*exposedField*/
} B_BodyDefTable;


typedef struct _tagBodySegmentConnectionHint
{
	BASE_NODE
	SFString firstSegmentNodeName;	/*exposedField*/
	SFString secondSegmentNodeName;	/*exposedField*/
	MFInt32 firstVertexIdList;	/*exposedField*/
	MFInt32 secondVertexIdList;	/*exposedField*/
} B_BodySegmentConnectionHint;


typedef struct _tagDirectiveSound
{
	BASE_NODE
	SFVec3f direction;	/*exposedField*/
	SFFloat intensity;	/*exposedField*/
	SFVec3f location;	/*exposedField*/
	SFNode *source;	/*exposedField*/
	SFNode *perceptualParameters;	/*exposedField*/
	SFBool roomEffect;	/*exposedField*/
	SFBool spatialize;	/*exposedField*/
	MFFloat directivity;	/*field*/
	MFFloat angles;	/*field*/
	MFFloat frequency;	/*field*/
	SFFloat speedOfSound;	/*field*/
	SFFloat distance;	/*field*/
	SFBool useAirabs;	/*field*/
} B_DirectiveSound;


typedef struct _tagHierarchical3DMesh
{
	BASE_NODE
	SFInt32 triangleBudget;	/*eventIn*/
	void (*on_triangleBudget)(SFNode *pThis);	/*eventInHandler*/
	SFFloat level;	/*exposedField*/
	MFURL url;	/*field*/
	SFBool doneLoading;	/*eventOut*/
} B_Hierarchical3DMesh;


typedef struct _tagMaterialKey
{
	BASE_NODE
	SFBool isKeyed;	/*exposedField*/
	SFBool isRGB;	/*exposedField*/
	SFColor keyColor;	/*exposedField*/
	SFFloat lowThreshold;	/*exposedField*/
	SFFloat highThreshold;	/*exposedField*/
	SFFloat transparency;	/*exposedField*/
} B_MaterialKey;


typedef struct _tagPerceptualParameters
{
	BASE_NODE
	SFFloat sourcePresence;	/*exposedField*/
	SFFloat sourceWarmth;	/*exposedField*/
	SFFloat sourceBrilliance;	/*exposedField*/
	SFFloat roomPresence;	/*exposedField*/
	SFFloat runningReverberance;	/*exposedField*/
	SFFloat envelopment;	/*exposedField*/
	SFFloat lateReverberance;	/*exposedField*/
	SFFloat heavyness;	/*exposedField*/
	SFFloat liveness;	/*exposedField*/
	MFFloat omniDirectivity;	/*exposedField*/
	MFFloat directFilterGains;	/*exposedField*/
	MFFloat inputFilterGains;	/*exposedField*/
	SFFloat refDistance;	/*exposedField*/
	SFFloat freqLow;	/*exposedField*/
	SFFloat freqHigh;	/*exposedField*/
	SFTime timeLimit1;	/*exposedField*/
	SFTime timeLimit2;	/*exposedField*/
	SFTime timeLimit3;	/*exposedField*/
	SFTime modalDensity;	/*exposedField*/
} B_PerceptualParameters;


typedef struct _tagTemporalTransform
{
	BASE_NODE
	CHILDREN
	MFURL url;	/*exposedField*/
	SFTime startTime;	/*exposedField*/
	SFTime optimalDuration;	/*exposedField*/
	SFBool active;	/*exposedField*/
	SFFloat speed;	/*exposedField*/
	SFVec2f scalability;	/*exposedField*/
	MFInt32 stretchMode;	/*exposedField*/
	MFInt32 shrinkMode;	/*exposedField*/
	SFTime maxDelay;	/*exposedField*/
	SFTime actualDuration;	/*eventOut*/
} B_TemporalTransform;


typedef struct _tagTemporalGroup
{
	BASE_NODE
	CHILDREN
	SFBool costart;	/*field*/
	SFBool coend;	/*field*/
	SFBool meet;	/*field*/
	MFFloat priority;	/*exposedField*/
	SFBool isActive;	/*eventOut*/
	SFInt32 activeChild;	/*eventOut*/
} B_TemporalGroup;


typedef struct _tagServerCommand
{
	BASE_NODE
	SFBool trigger;	/*eventIn*/
	void (*on_trigger)(SFNode *pThis);	/*eventInHandler*/
	SFBool enable;	/*exposedField*/
	MFURL url;	/*exposedField*/
	SFString command;	/*exposedField*/
} B_ServerCommand;


typedef struct _tagInputSensor
{
	BASE_NODE
	SFBool enabled;	/*exposedField*/
	SFCommandBuffer buffer;	/*exposedField*/
	MFURL url;	/*exposedField*/
	SFTime eventTime;	/*eventOut*/
} B_InputSensor;


typedef struct _tagMatteTexture
{
	BASE_NODE
	SFNode *surfaceA;	/*field*/
	SFNode *surfaceB;	/*field*/
	SFNode *alphaSurface;	/*field*/
	SFString operation;	/*exposedField*/
	SFBool overwrite;	/*field*/
	SFFloat fraction;	/*exposedField*/
	MFFloat parameter;	/*exposedField*/
} B_MatteTexture;


typedef struct _tagMediaBuffer
{
	BASE_NODE
	SFFloat bufferSize;	/*exposedField*/
	MFURL url;	/*exposedField*/
	SFTime mediaStartTime;	/*exposedField*/
	SFTime mediaStopTime;	/*exposedField*/
	SFBool isBuffered;	/*eventOut*/
	SFBool enabled;	/*exposedField*/
} B_MediaBuffer;


typedef struct _tagMediaControl
{
	BASE_NODE
	MFURL url;	/*exposedField*/
	SFTime mediaStartTime;	/*exposedField*/
	SFTime mediaStopTime;	/*exposedField*/
	SFFloat mediaSpeed;	/*exposedField*/
	SFBool loop;	/*exposedField*/
	SFBool preRoll;	/*exposedField*/
	SFBool mute;	/*exposedField*/
	SFBool enabled;	/*exposedField*/
	SFBool isPreRolled;	/*eventOut*/
} B_MediaControl;


typedef struct _tagMediaSensor
{
	BASE_NODE
	MFURL url;	/*exposedField*/
	SFTime mediaCurrentTime;	/*eventOut*/
	SFTime streamObjectStartTime;	/*eventOut*/
	SFTime mediaDuration;	/*eventOut*/
	SFBool isActive;	/*eventOut*/
	MFString info;	/*eventOut*/
} B_MediaSensor;


typedef struct _tagClipper2D
{
	BASE_NODE
	CHILDREN
	SFNode *geometry;	/*exposedField*/
	SFBool inside;	/*exposedField*/
	SFNode *transform;	/*exposedField*/
	SFBool XOR;	/*exposedField*/
} B_Clipper2D;


typedef struct _tagColorTransform
{
	BASE_NODE
	CHILDREN
	SFFloat mrr;	/*exposedField*/
	SFFloat mrg;	/*exposedField*/
	SFFloat mrb;	/*exposedField*/
	SFFloat mra;	/*exposedField*/
	SFFloat tr;	/*exposedField*/
	SFFloat mgr;	/*exposedField*/
	SFFloat mgg;	/*exposedField*/
	SFFloat mgb;	/*exposedField*/
	SFFloat mga;	/*exposedField*/
	SFFloat tg;	/*exposedField*/
	SFFloat mbr;	/*exposedField*/
	SFFloat mbg;	/*exposedField*/
	SFFloat mbb;	/*exposedField*/
	SFFloat mba;	/*exposedField*/
	SFFloat tb;	/*exposedField*/
	SFFloat mar;	/*exposedField*/
	SFFloat mag;	/*exposedField*/
	SFFloat mab;	/*exposedField*/
	SFFloat maa;	/*exposedField*/
	SFFloat ta;	/*exposedField*/
} B_ColorTransform;


typedef struct _tagEllipse
{
	BASE_NODE
	SFVec2f radius;	/*exposedField*/
} B_Ellipse;


typedef struct _tagLinearGradient
{
	BASE_NODE
	SFVec2f endPoint;	/*exposedField*/
	MFFloat key;	/*exposedField*/
	MFColor keyValue;	/*exposedField*/
	MFFloat opacity;	/*exposedField*/
	SFInt32 spreadMethod;	/*exposedField*/
	SFVec2f startPoint;	/*exposedField*/
	SFNode *transform;	/*exposedField*/
} B_LinearGradient;


typedef struct _tagPathLayout
{
	BASE_NODE
	CHILDREN
	SFNode *geometry;	/*exposedField*/
	MFInt32 alignment;	/*exposedField*/
	SFFloat pathOffset;	/*exposedField*/
	SFFloat spacing;	/*exposedField*/
	SFBool reverseLayout;	/*exposedField*/
	SFInt32 wrapMode;	/*exposedField*/
	SFBool splitText;	/*exposedField*/
} B_PathLayout;


typedef struct _tagRadialGradient
{
	BASE_NODE
	SFVec2f center;	/*exposedField*/
	SFVec2f focalPoint;	/*exposedField*/
	MFFloat key;	/*exposedField*/
	MFColor keyValue;	/*exposedField*/
	MFFloat opacity;	/*exposedField*/
	SFFloat radius;	/*exposedField*/
	SFInt32 spreadMethod;	/*exposedField*/
	SFNode *transform;	/*exposedField*/
} B_RadialGradient;


typedef struct _tagSynthesizedTexture
{
	BASE_NODE
	MFVec3f translation;	/*exposedField*/
	MFRotation rotation;	/*exposedField*/
	SFInt32 pixelWidth;	/*exposedField*/
	SFInt32 pixelHeight;	/*exposedField*/
	SFBool loop;	/*exposedField*/
	SFFloat speed;	/*exposedField*/
	SFTime startTime;	/*exposedField*/
	SFTime stopTime;	/*exposedField*/
	MFURL url;	/*exposedField*/
	SFTime duration_changed;	/*eventOut*/
	SFBool isActive;	/*eventOut*/
} B_SynthesizedTexture;


typedef struct _tagTransformMatrix2D
{
	BASE_NODE
	CHILDREN
	SFFloat mxx;	/*exposedField*/
	SFFloat mxy;	/*exposedField*/
	SFFloat tx;	/*exposedField*/
	SFFloat myx;	/*exposedField*/
	SFFloat myy;	/*exposedField*/
	SFFloat ty;	/*exposedField*/
} B_TransformMatrix2D;


typedef struct _tagViewport
{
	BASE_NODE
	SFBool set_bind;	/*eventIn*/
	void (*on_set_bind)(SFNode *pThis);	/*eventInHandler*/
	SFVec2f position;	/*exposedField*/
	SFVec2f size;	/*exposedField*/
	SFFloat orientation;	/*exposedField*/
	MFInt32 alignment;	/*exposedField*/
	SFInt32 fit;	/*exposedField*/
	SFString description;	/*field*/
	SFTime bindTime;	/*eventOut*/
	SFBool isBound;	/*eventOut*/
} B_Viewport;


typedef struct _tagXCurve2D
{
	BASE_NODE
	SFNode *point;	/*exposedField*/
	SFFloat fineness;	/*exposedField*/
	MFInt32 type;	/*exposedField*/
} B_XCurve2D;


typedef struct _tagXFontStyle
{
	BASE_NODE
	MFString fontName;	/*exposedField*/
	SFBool horizontal;	/*exposedField*/
	MFString justify;	/*exposedField*/
	SFString language;	/*exposedField*/
	SFBool leftToRight;	/*exposedField*/
	SFFloat size;	/*exposedField*/
	SFString stretch;	/*exposedField*/
	SFFloat letterSpacing;	/*exposedField*/
	SFFloat wordSpacing;	/*exposedField*/
	SFInt32 weight;	/*exposedField*/
	SFBool fontKerning;	/*exposedField*/
	SFString style;	/*exposedField*/
	SFBool topToBottom;	/*exposedField*/
	MFString featureName;	/*exposedField*/
	MFInt32 featureStartOffset;	/*exposedField*/
	MFInt32 featureLength;	/*exposedField*/
	MFInt32 featureValue;	/*exposedField*/
} B_XFontStyle;


typedef struct _tagXLineProperties
{
	BASE_NODE
	SFColor lineColor;	/*exposedField*/
	SFInt32 lineStyle;	/*exposedField*/
	SFBool isCenterAligned;	/*exposedField*/
	SFBool isScalable;	/*exposedField*/
	SFInt32 lineCap;	/*exposedField*/
	SFInt32 lineJoin;	/*exposedField*/
	SFFloat miterLimit;	/*exposedField*/
	SFFloat transparency;	/*exposedField*/
	SFFloat width;	/*exposedField*/
	SFFloat dashOffset;	/*exposedField*/
	MFFloat dashes;	/*exposedField*/
	SFNode *texture;	/*exposedField*/
	SFNode *textureTransform;	/*exposedField*/
} B_XLineProperties;


/*NodeDataType tags*/
enum {
	NDT_SFWorldNode = 1,
	NDT_SF3DNode,
	NDT_SF2DNode,
	NDT_SFStreamingNode,
	NDT_SFAppearanceNode,
	NDT_SFAudioNode,
	NDT_SFBackground3DNode,
	NDT_SFBackground2DNode,
	NDT_SFGeometryNode,
	NDT_SFColorNode,
	NDT_SFTextureNode,
	NDT_SFCoordinateNode,
	NDT_SFCoordinate2DNode,
	NDT_SFExpressionNode,
	NDT_SFFaceDefMeshNode,
	NDT_SFFaceDefTablesNode,
	NDT_SFFaceDefTransformNode,
	NDT_SFFAPNode,
	NDT_SFFDPNode,
	NDT_SFFITNode,
	NDT_SFFogNode,
	NDT_SFFontStyleNode,
	NDT_SFTopNode,
	NDT_SFLinePropertiesNode,
	NDT_SFMaterialNode,
	NDT_SFNavigationInfoNode,
	NDT_SFNormalNode,
	NDT_SFTextureCoordinateNode,
	NDT_SFTextureTransformNode,
	NDT_SFViewpointNode,
	NDT_SFVisemeNode,
	NDT_SFViewportNode,
	NDT_SFBAPNode,
	NDT_SFBDPNode,
	NDT_SFBodyDefTableNode,
	NDT_SFBodySegmentConnectionHintNode,
	NDT_SFPerceptualParameterNode,
	NDT_SFTemporalNode,
	NDT_SFDepthImageNode,
	NDT_SFBlendListNode,
	NDT_SFFrameListNode,
	NDT_SFLightMapNode,
	NDT_SFSurfaceMapNode,
	NDT_SFViewMapNode,
	NDT_SFParticleInitializerNode,
	NDT_SFInfluenceNode,
	NDT_SFDepthTextureNode,
	NDT_SFSBBoneNode,
	NDT_SFSBMuscleNode,
	NDT_SFSBSegmentNode,
	NDT_SFSBSiteNode,
	NDT_SFBaseMeshNode,
	NDT_SFSubdivSurfaceSectorNode
};

/*All BIFS versions handled*/
#define NUM_BIFS_VERSION		6

enum {
	BIFS_V1 = 1,
	BIFS_V2,
	BIFS_V3,
	BIFS_V4,
	BIFS_V5,
	BIFS_V6,
	LAST_BIFS_VERSION = BIFS_V6
};

/*All nodes generated*/
#define M4_DEF_Anchor
#define M4_DEF_AnimationStream
#define M4_DEF_Appearance
#define M4_DEF_AudioBuffer
#define M4_DEF_AudioClip
#define M4_DEF_AudioDelay
#define M4_DEF_AudioFX
#define M4_DEF_AudioMix
#define M4_DEF_AudioSource
#define M4_DEF_AudioSwitch
#define M4_DEF_Background
#define M4_DEF_Background2D
#define M4_DEF_Billboard
#define M4_DEF_Bitmap
#define M4_DEF_Box
#define M4_DEF_Circle
#define M4_DEF_Collision
#define M4_DEF_Color
#define M4_DEF_ColorInterpolator
#define M4_DEF_CompositeTexture2D
#define M4_DEF_CompositeTexture3D
#define M4_DEF_Conditional
#define M4_DEF_Cone
#define M4_DEF_Coordinate
#define M4_DEF_Coordinate2D
#define M4_DEF_CoordinateInterpolator
#define M4_DEF_CoordinateInterpolator2D
#define M4_DEF_Curve2D
#define M4_DEF_Cylinder
#define M4_DEF_CylinderSensor
#define M4_DEF_DirectionalLight
#define M4_DEF_DiscSensor
#define M4_DEF_ElevationGrid
#define M4_DEF_Expression
#define M4_DEF_Extrusion
#define M4_DEF_Face
#define M4_DEF_FaceDefMesh
#define M4_DEF_FaceDefTables
#define M4_DEF_FaceDefTransform
#define M4_DEF_FAP
#define M4_DEF_FDP
#define M4_DEF_FIT
#define M4_DEF_Fog
#define M4_DEF_FontStyle
#define M4_DEF_Form
#define M4_DEF_Group
#define M4_DEF_ImageTexture
#define M4_DEF_IndexedFaceSet
#define M4_DEF_IndexedFaceSet2D
#define M4_DEF_IndexedLineSet
#define M4_DEF_IndexedLineSet2D
#define M4_DEF_Inline
#define M4_DEF_LOD
#define M4_DEF_Layer2D
#define M4_DEF_Layer3D
#define M4_DEF_Layout
#define M4_DEF_LineProperties
#define M4_DEF_ListeningPoint
#define M4_DEF_Material
#define M4_DEF_Material2D
#define M4_DEF_MovieTexture
#define M4_DEF_NavigationInfo
#define M4_DEF_Normal
#define M4_DEF_NormalInterpolator
#define M4_DEF_OrderedGroup
#define M4_DEF_OrientationInterpolator
#define M4_DEF_PixelTexture
#define M4_DEF_PlaneSensor
#define M4_DEF_PlaneSensor2D
#define M4_DEF_PointLight
#define M4_DEF_PointSet
#define M4_DEF_PointSet2D
#define M4_DEF_PositionInterpolator
#define M4_DEF_PositionInterpolator2D
#define M4_DEF_ProximitySensor2D
#define M4_DEF_ProximitySensor
#define M4_DEF_QuantizationParameter
#define M4_DEF_Rectangle
#define M4_DEF_ScalarInterpolator
#define M4_DEF_Script
#define M4_DEF_Shape
#define M4_DEF_Sound
#define M4_DEF_Sound2D
#define M4_DEF_Sphere
#define M4_DEF_SphereSensor
#define M4_DEF_SpotLight
#define M4_DEF_Switch
#define M4_DEF_TermCap
#define M4_DEF_Text
#define M4_DEF_TextureCoordinate
#define M4_DEF_TextureTransform
#define M4_DEF_TimeSensor
#define M4_DEF_TouchSensor
#define M4_DEF_Transform
#define M4_DEF_Transform2D
#define M4_DEF_Valuator
#define M4_DEF_Viewpoint
#define M4_DEF_VisibilitySensor
#define M4_DEF_Viseme
#define M4_DEF_WorldInfo
#define M4_DEF_AcousticMaterial
#define M4_DEF_AcousticScene
#define M4_DEF_ApplicationWindow
#define M4_DEF_BAP
#define M4_DEF_BDP
#define M4_DEF_Body
#define M4_DEF_BodyDefTable
#define M4_DEF_BodySegmentConnectionHint
#define M4_DEF_DirectiveSound
#define M4_DEF_Hierarchical3DMesh
#define M4_DEF_MaterialKey
#define M4_DEF_PerceptualParameters
#define M4_DEF_TemporalTransform
#define M4_DEF_TemporalGroup
#define M4_DEF_ServerCommand
#define M4_DEF_InputSensor
#define M4_DEF_MatteTexture
#define M4_DEF_MediaBuffer
#define M4_DEF_MediaControl
#define M4_DEF_MediaSensor
#define M4_DEF_Clipper2D
#define M4_DEF_ColorTransform
#define M4_DEF_Ellipse
#define M4_DEF_LinearGradient
#define M4_DEF_PathLayout
#define M4_DEF_RadialGradient
#define M4_DEF_SynthesizedTexture
#define M4_DEF_TransformMatrix2D
#define M4_DEF_Viewport
#define M4_DEF_XCurve2D
#define M4_DEF_XFontStyle
#define M4_DEF_XLineProperties


#ifdef __cplusplus
}
#endif



#endif		/*_m4_nodes_H*/

