/* $Id: gvconfig.c,v 1.3 2004/05/09 01:56:47 ellson Exp $ $Revision: 1.3 $ */
/* vim:set shiftwidth=4 ts=8: */
/*
    This software may only be used by you under license from AT&T Corp.
    ("AT&T").  A copy of AT&T's Source Code Agreement is available at
    AT&T's Internet website having the URL:
    <http://www.research.att.com/sw/tools/graphviz/license/source.html>
    If you received this software without first entering into a license
    with AT&T, you have an infringing copy of this software and cannot use
    it without violating AT&T's intellectual property rights.
*/

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>

#include        "config.h"
#include        "types.h"
#include        "macros.h"
#include        "gvrender.h"

/*
    A config for gvrender is a text file (or string data) containing a
    tcl-like-syntax list of plugins and their capabilities.

    Lines beginning with '#' are ignored as comments

    Blank lines are allowed and ignored.

    plugin_path_name {
	plugin_type {
	    plugin_name
	    ...
	}
	...
    ...

    e.g.

	/usr/lib/graphviz/cairo.so {renderer {xlib png ps}}
	/usr/lib/graphviz/gdgen.so {renderer {png gif jpg}}


    Internally the config is maintained as lists of plugin_names and 
    source dll foreach plugin_type.  If multiple plugins of the same
    name are found then the last-one-wins (thus giving preference to
    external plugins over internal builtins).

 */

static void separator (int *nest, char **tokens)
{
	char c, *s;

	s = *tokens;
	while ((c = *s)) {
		/* #->eol = comment */
		if (c == '#') {
			s++;
			while ((c = *s)) {
				s++;
				if (c == '\n')
					break;
			}
			continue;
		}
		if (c == '{') {
			(*nest)++;
			s++;
			continue;
		}
		if (c == '}') {
			(*nest)--;
			s++;
			continue;
		}
		if (c == ' ' || c == '\n' || c == '\t') {
                        s++;
                        continue;
                }
		break;
	}
	*tokens = s;
}

static char *token (int *nest, char **tokens)
{
	char c, *s, *t;

	s = t = *tokens;
	while ((c = *s)) {
		if ( c == '#'
		  || c == ' '
		  || c == '\t'
		  || c == '\n'
		  || c == '{'
		  || c == '}' )
			break;
		s++;
	}
	*tokens = s;
	separator(nest, tokens);
	*s = '\0';
	return t;
}

boolean gvconfig_install_plugin (GVC_t *gvc, char *api, char *type, char *path, void *fn)
{
	gv_plugin_t *plugin, **pnext;
	int phandle;

	if (strcmp(api,"renderer") == 0) {
		pnext = &(gvc->renderers);
		phandle = (gvc->next_renderer_handle)++;
	}
/*
        else if (strcmp(api,"other_plugin") == 0)
                pnext = &(gvc->other_plugin);
 */
	else
		return FALSE;

	/* keep alpha-sorted and insert new duplicates ahead of old */
	while (*pnext && strcmp(type,(*pnext)->type) >= 0) 
		pnext = &((*pnext)->next);

	plugin = malloc(sizeof(gv_plugin_t));
	plugin->next = *pnext;
	*pnext = plugin;
	plugin->handle = phandle;
	plugin->type = type;
	plugin->path = path;
        plugin->fn = fn;
	
	return TRUE;
}

gv_plugin_t *gvconfig_load_plugin(GVC_t *gvc, char *api, char *type)
{
	gv_plugin_t **pnext;

	if (strcmp(api,"renderer") == 0)
		pnext = &(gvc->renderers);
/*
        else if (strcmp(api,"other_plugin") == 0)
                pnext = &(gvc->other_plugin);
 */
	else
		return NULL;

	while (*pnext) {
		if (strcmp(type,(*pnext)->type) == 0) {
			/* FIXME - load plugin here */
			if ((*pnext)->fn)
				return *pnext;
		}
		pnext = &((*pnext)->next);
	}
	return NULL;
}

char *gvconfig_list_plugins(GVC_t *gvc, char *api)
{
	static char *buf;
	static int bufsz;
	gv_plugin_t **pnext;
	char *type, *lasttype, *next;
	unsigned int len, pos;

	if (strcmp(api,"renderer") == 0)
		pnext = &(gvc->renderers);
/*
        else if (strcmp(api,"other_plugin") == 0)
                pnext = &(gvc->other_plugin);
 */
	else
		return NULL;

	lasttype = "";
	pos = 0;
	while (*pnext) {
		type = (*pnext)->type;
		if (strcmp(type,lasttype) != 0) {
			len = strlen(type);
			if (bufsz < (pos+len+2)) {
				bufsz += 10*len;
				buf = realloc(buf, bufsz);
			}
			next = buf+pos;
			*next++ = ' ';
			pos++;
			strcpy(next,type);
			pos += len;
		}
		lasttype = type;
		pnext = &((*pnext)->next);
	}
	return buf;
}

void gvconfig (GVC_t *gvc, char *config)
{
	char *empty = "";
	char *s, *path = empty, *api = empty, *type = empty;
	int nest = 0;

	s = strdup(config);
	/* this copy is never free'd because the config uses pointers
		into it for string values */

	separator(&nest, &s);
	while (*s) {
		path = token(&nest, &s);
		do {
			api = token(&nest, &s);
			do {
				type = token(&nest, &s);
				if (!(gvconfig_install_plugin(gvc, api, type, path, NULL))) {
					fprintf(stderr,"config error: %s %s %s\n",
						api, type, path);
					return;
				}
			} while (nest == 2);
		} while (nest == 1);
	}
}
