#ifdef __cplusplus
extern "C" {
#endif

/* $Id: gvre.h,v 1.10 2004/08/30 17:25:02 ellson Exp $ $Revision: 1.10 $ */
/* vim:set shiftwidth=4 ts=8: */
/*
    This software may only be used by you under license from AT&T Corp.
    ("AT&T").  A copy of AT&T's Source Code Agreement is available at
    AT&T's Internet website having the URL:
    <http://www.research.att.com/sw/tools/graphviz/license/source.html>
    If you received this software without first entering into a license
    with AT&T, you have an infringing copy of this software and cannot use
    it without violating AT&T's intellectual property rights.
*/

/* This is the public header for the libgvre_* plugins */

#ifndef GVRE_H
#define GVRE_H

#include "gvrenderint.h"

struct gvrender_engine_s {
    int features;
    int id;
    void (*reset) (GVC_t *gvc);
    void (*begin_job) (GVC_t *gvc);
    void (*end_job) (GVC_t *gvc);
    void (*begin_graph) (GVC_t *gvc, graph_t *g);
    void (*end_graph) (GVC_t *gvc);
    void (*begin_page) (GVC_t *gvc);
    void (*end_page) (GVC_t *gvc);
    void (*begin_layer) (GVC_t *gvc);
    void (*end_layer) (GVC_t *gvc);
    void (*begin_cluster) (GVC_t *gvc, graph_t *sg);
    void (*end_cluster) (GVC_t *gvc);
    void (*begin_nodes) (GVC_t *gvc);
    void (*end_nodes) (GVC_t *gvc);
    void (*begin_edges) (GVC_t *gvc);
    void (*end_edges) (GVC_t *gvc);
    void (*begin_node) (GVC_t *gvc, node_t *n);
    void (*end_node) (GVC_t *gvc);
    void (*begin_edge) (GVC_t *gvc, edge_t *e);
    void (*end_edge) (GVC_t *gvc);
    void (*begin_context) (GVC_t *gvc);
    void (*end_context) (GVC_t *gvc);
    void (*begin_anchor) (GVC_t *gvc, char *href, char *tooltip, char *target);
    void (*end_anchor) (GVC_t *gvc);
    void (*set_font) (GVC_t *gvc, char *fontname, double fontsize);
    void (*textline) (GVC_t *gvc, pointf p, textline_t * str);
    void (*set_pencolor) (GVC_t *gvc, char *color);
    void (*set_fillcolor) (GVC_t *gvc, char *color);
    void (*set_style) (GVC_t *gvc, char **s);
    void (*ellipse) (GVC_t *gvc, pointf p, double rx, double ry, int filled);
    void (*polygon) (GVC_t *gvc, pointf * A, int n, int filled);
    void (*beziercurve) (GVC_t *gvc, pointf * A, int n, int arrow_at_start, int arrow_at_end);
    void (*polyline) (GVC_t *gvc, pointf * A, int n);
    void (*comment) (GVC_t *gvc, void *obj, attrsym_t * sym);
    void (*user_shape) (GVC_t *gvc, char *name, pointf * A, int sides, int filled);
};

#endif

#ifdef __cplusplus
}
#endif
