/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.AccountAliasListRequest;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.awsidentitymanagementv20100508.model.ListAccountAliasesRequest;
import com.amazonaws.services.awsidentitymanagementv20100508.model.ListAccountAliasesResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IAMAccountAliasListDriver
extends IAMDriver {
    private static final String ALIAS = "Alias: ";
    private static final String SIGNIN_LINK = "Direct Signin Link: ";
    private static final String SIGNIN_LINK_SUFFIX = ".signin.aws.amazon.com";
    private static final Log LOG = LogFactory.getLog(IAMAccountAliasListDriver.class);

    protected void invokeRequestImpl(CLIRequest request) {
        if (request instanceof AccountAliasListRequest) {
            ListAccountAliasesRequest aliasRequest = new ListAccountAliasesRequest();
            ListAccountAliasesResult listResult = this.getClient().listAccountAliases(aliasRequest);
            for (String alias : listResult.getAccountAliases()) {
                LOG.info((Object)(ALIAS + alias));
                LOG.info((Object)(SIGNIN_LINK + alias + SIGNIN_LINK_SUFFIX));
            }
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }
}

