/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.model.UserGetAttributesRequest;
import com.amazonaws.services.awsidentitymanagementv20100508.model.GetUserRequest;
import com.amazonaws.services.awsidentitymanagementv20100508.model.GetUserResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class IAMUserGetAttributesDriver
extends IAMDriver {
    private static final Log LOG = LogFactory.getLog(IAMUserGetAttributesDriver.class);

    protected void invokeRequestImpl(CLIRequest request) {
        if (request instanceof UserGetAttributesRequest) {
            UserGetAttributesRequest req = (UserGetAttributesRequest)request;
            LOG.debug((Object)("Getting user " + req));
            GetUserRequest getUserRequest = new GetUserRequest();
            getUserRequest.setUserName(req.getUserName());
            GetUserResult result = this.getClient().getUser(getUserRequest);
            LOG.info((Object)result.getUser().getArn());
            LOG.info((Object)result.getUser().getUserId());
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }
}

