/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.model.VirtualMFADeviceCreateRequest;
import com.amazonaws.services.identitymanagement.model.CreateVirtualMFADeviceRequest;
import com.amazonaws.services.identitymanagement.model.CreateVirtualMFADeviceResult;
import com.amazonaws.services.identitymanagement.model.VirtualMFADevice;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IAMVirtualMFADeviceCreateDriver
extends IAMDriver {
    private static final Log LOG = LogFactory.getLog(IAMVirtualMFADeviceCreateDriver.class);

    public void invokeRequestImpl(CLIRequest request) {
        if (request instanceof VirtualMFADeviceCreateRequest) {
            VirtualMFADeviceCreateRequest req = (VirtualMFADeviceCreateRequest)request;
            CreateVirtualMFADeviceRequest createVirtualMFADeviceRequest = new CreateVirtualMFADeviceRequest();
            createVirtualMFADeviceRequest.setPath(this.verifyPathAndAddSlashSuffix(req.getPath()));
            createVirtualMFADeviceRequest.setVirtualMFADeviceName(req.getVirtualMFADeviceName());
            LOG.debug((Object)("Calling enablemfadevice with request " + request));
            CreateVirtualMFADeviceResult result = this.getClient().createVirtualMFADevice(createVirtualMFADeviceRequest);
            VirtualMFADevice tk = result.getVirtualMFADevice();
            String outputPath = req.getOutputPath();
            if (outputPath == null) {
                LOG.info((Object)tk.getSerialNumber());
                if (req.getBootstrapMethod().equals("Base32String")) {
                    String secret = new String(tk.getBase32StringSeed().array());
                    LOG.info((Object)secret);
                } else {
                    this.displayQRCodeImage(tk);
                }
            } else {
                this.saveOutputFile(outputPath, req.getBootstrapMethod(), tk);
                LOG.info((Object)tk.getSerialNumber());
            }
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }

    private void displayQRCodeImage(final VirtualMFADevice device) {
        try {
            JFrame frame = new JFrame();
            frame.setDefaultCloseOperation(3);
            JPanel panel = new JPanel(){
                private static final long serialVersionUID = 1L;
                final BufferedImage bi;
                {
                    this.bi = ImageIO.read(new ByteArrayInputStream(device.getQRCodePNG().array()));
                }

                public void paintComponent(Graphics g) {
                    g.drawImage(this.bi, 0, 0, null);
                }
            };
            frame.getContentPane().add(panel);
            frame.setSize(250, 280);
            frame.setVisible(true);
        }
        catch (IOException e) {
            LOG.error((Object)"IO error displaying QRCode", (Throwable)e);
            LOG.error((Object)("Manual clean up via 'iam-userdelmfadevice -s " + device.getSerialNumber() + "'"));
        }
    }

    private void saveOutputFile(String outputPath, String bootstrapMethod, VirtualMFADevice device) {
        try {
            File outputFile = new File(outputPath);
            FileChannel writeChannel = new FileOutputStream(outputFile).getChannel();
            if ("Base32String".equals(bootstrapMethod)) {
                writeChannel.write(device.getBase32StringSeed());
            } else {
                writeChannel.write(device.getQRCodePNG());
            }
            writeChannel.close();
        }
        catch (IOException e) {
            LOG.error((Object)"IO error writing to file", (Throwable)e);
            LOG.error((Object)("Manual clean up via 'iam-userdelmfadevice -s " + device.getSerialNumber() + "'"));
        }
    }
}

