/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils;

import java.util.Arrays;
import net.sf.samtools.util.StringUtil;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;

public class BaseUtils {
    public static final byte[] BASES = new byte[]{65, 67, 71, 84};
    public static final byte[] EXTENDED_BASES = new byte[]{65, 67, 71, 84, 78, 68};
    private static final int[] baseIndexMap = new int[256];
    private static final int[] baseIndexWithIupacMap;

    public static BaseSubstitutionType SNPSubstitutionType(byte base1, byte base2) {
        BaseSubstitutionType t = BaseUtils.isTransition(base1, base2) ? BaseSubstitutionType.TRANSITION : BaseSubstitutionType.TRANSVERSION;
        return t;
    }

    public static boolean isTransition(byte base1, byte base2) {
        int b1 = BaseUtils.simpleBaseToBaseIndex(base1);
        int b2 = BaseUtils.simpleBaseToBaseIndex(base2);
        return b1 == Base.A.ordinal() && b2 == Base.G.ordinal() || b1 == Base.G.ordinal() && b2 == Base.A.ordinal() || b1 == Base.C.ordinal() && b2 == Base.T.ordinal() || b1 == Base.T.ordinal() && b2 == Base.C.ordinal();
    }

    public static boolean isTransversion(byte base1, byte base2) {
        return !BaseUtils.isTransition(base1, base2);
    }

    private BaseUtils() {
    }

    public static boolean basesAreEqual(byte base1, byte base2) {
        return BaseUtils.simpleBaseToBaseIndex(base1) == BaseUtils.simpleBaseToBaseIndex(base2);
    }

    public static boolean extendedBasesAreEqual(byte base1, byte base2) {
        return BaseUtils.extendedBaseToBaseIndex(base1) == BaseUtils.extendedBaseToBaseIndex(base2);
    }

    public static boolean containsBase(byte[] bases, byte base) {
        for (byte b : bases) {
            if (b != base) continue;
            return true;
        }
        return false;
    }

    public static boolean isUpperCase(byte[] bases) {
        for (byte base : bases) {
            if (BaseUtils.isUpperCase(base)) continue;
            return false;
        }
        return true;
    }

    public static boolean isUpperCase(byte base) {
        return base >= 65 && base <= 90;
    }

    public static byte[] convertIUPACtoN(byte[] bases, boolean errorOnBadReferenceBase, boolean ignoreConversionOfFirstByte) {
        int start;
        int length = bases.length;
        for (int i = start = ignoreConversionOfFirstByte ? 1 : 0; i < length; ++i) {
            int baseIndex = baseIndexWithIupacMap[bases[i]];
            if (baseIndex == Base.N.ordinal()) {
                bases[i] = 78;
                continue;
            }
            if (!errorOnBadReferenceBase || baseIndex != -1) continue;
            throw new UserException.BadInput("We encountered a non-standard non-IUPAC base in the provided reference: '" + bases[i] + "'");
        }
        return bases;
    }

    @Deprecated
    public static char[] iupacToBases(char code) {
        char[] bases = new char[2];
        switch (code) {
            case '*': 
            case 'A': 
            case 'a': {
                bases[1] = 65;
                bases[0] = 65;
                break;
            }
            case 'C': 
            case 'c': {
                bases[1] = 67;
                bases[0] = 67;
                break;
            }
            case 'G': 
            case 'g': {
                bases[1] = 71;
                bases[0] = 71;
                break;
            }
            case 'T': 
            case 't': {
                bases[1] = 84;
                bases[0] = 84;
                break;
            }
            case 'R': 
            case 'r': {
                bases[0] = 65;
                bases[1] = 71;
                break;
            }
            case 'Y': 
            case 'y': {
                bases[0] = 67;
                bases[1] = 84;
                break;
            }
            case 'S': 
            case 's': {
                bases[0] = 71;
                bases[1] = 67;
                break;
            }
            case 'W': 
            case 'w': {
                bases[0] = 65;
                bases[1] = 84;
                break;
            }
            case 'K': 
            case 'k': {
                bases[0] = 71;
                bases[1] = 84;
                break;
            }
            case 'M': 
            case 'm': {
                bases[0] = 65;
                bases[1] = 67;
                break;
            }
            default: {
                bases[1] = 78;
                bases[0] = 78;
            }
        }
        return bases;
    }

    public static int simpleBaseToBaseIndex(byte base) {
        if (base < 0 || base >= 256) {
            throw new UserException.BadInput("Non-standard bases were encountered in either the input reference or BAM file(s)");
        }
        return baseIndexMap[base];
    }

    @Deprecated
    public static int simpleBaseToBaseIndex(char base) {
        return baseIndexMap[base];
    }

    public static int extendedBaseToBaseIndex(byte base) {
        switch (base) {
            case 68: 
            case 100: {
                return Base.D.ordinal();
            }
            case 78: 
            case 110: {
                return Base.N.ordinal();
            }
        }
        return BaseUtils.simpleBaseToBaseIndex(base);
    }

    @Deprecated
    public static boolean isRegularBase(char base) {
        return BaseUtils.simpleBaseToBaseIndex(base) != -1;
    }

    public static boolean isRegularBase(byte base) {
        return BaseUtils.simpleBaseToBaseIndex(base) != -1;
    }

    public static boolean isAllRegularBases(byte[] bases) {
        for (byte base : bases) {
            if (BaseUtils.isRegularBase(base)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNBase(byte base) {
        return base == 78 || base == 110;
    }

    public static byte baseIndexToSimpleBase(int baseIndex) {
        switch (baseIndex) {
            case 0: {
                return 65;
            }
            case 1: {
                return 67;
            }
            case 2: {
                return 71;
            }
            case 3: {
                return 84;
            }
        }
        return 46;
    }

    public static byte simpleComplement(byte base) {
        switch (base) {
            case 65: 
            case 97: {
                return 84;
            }
            case 67: 
            case 99: {
                return 71;
            }
            case 71: 
            case 103: {
                return 67;
            }
            case 84: 
            case 116: {
                return 65;
            }
        }
        return base;
    }

    @Deprecated
    private static char simpleComplement(char base) {
        return (char)BaseUtils.simpleComplement((byte)base);
    }

    public static byte[] simpleReverseComplement(byte[] bases) {
        byte[] rcbases = new byte[bases.length];
        for (int i = 0; i < bases.length; ++i) {
            rcbases[i] = BaseUtils.simpleComplement(bases[bases.length - 1 - i]);
        }
        return rcbases;
    }

    @Deprecated
    public static char[] simpleReverseComplement(char[] bases) {
        char[] rcbases = new char[bases.length];
        for (int i = 0; i < bases.length; ++i) {
            rcbases[i] = BaseUtils.simpleComplement(bases[bases.length - 1 - i]);
        }
        return rcbases;
    }

    @Deprecated
    public static String simpleReverseComplement(String bases) {
        return new String(BaseUtils.simpleReverseComplement(bases.getBytes()));
    }

    public static void convertToUpperCase(byte[] bases) {
        StringUtil.toUpperCase((byte[])bases);
    }

    public static int mostFrequentBaseIndex(int[] baseCounts) {
        int mostFrequentBaseIndex = 0;
        for (int baseIndex = 1; baseIndex < 4; ++baseIndex) {
            if (baseCounts[baseIndex] <= baseCounts[mostFrequentBaseIndex]) continue;
            mostFrequentBaseIndex = baseIndex;
        }
        return mostFrequentBaseIndex;
    }

    public static int mostFrequentBaseIndexNotRef(int[] baseCounts, int refBaseIndex) {
        int tmp = baseCounts[refBaseIndex];
        baseCounts[refBaseIndex] = -1;
        int result = BaseUtils.mostFrequentBaseIndex(baseCounts);
        baseCounts[refBaseIndex] = tmp;
        return result;
    }

    public static int mostFrequentBaseIndexNotRef(int[] baseCounts, byte refSimpleBase) {
        return BaseUtils.mostFrequentBaseIndexNotRef(baseCounts, BaseUtils.simpleBaseToBaseIndex(refSimpleBase));
    }

    public static byte mostFrequentSimpleBase(int[] baseCounts) {
        return BaseUtils.baseIndexToSimpleBase(BaseUtils.mostFrequentBaseIndex(baseCounts));
    }

    public static double mostFrequentBaseFraction(byte[] sequence) {
        int[] baseCounts = new int[4];
        for (byte base : sequence) {
            int baseIndex = BaseUtils.simpleBaseToBaseIndex(base);
            if (baseIndex < 0) continue;
            int n = baseIndex;
            baseCounts[n] = baseCounts[n] + 1;
        }
        int mostFrequentBaseIndex = BaseUtils.mostFrequentBaseIndex(baseCounts);
        return (double)baseCounts[mostFrequentBaseIndex] / (double)sequence.length;
    }

    public static int getRandomBaseIndex() {
        return BaseUtils.getRandomBaseIndex(-1);
    }

    public static int getRandomBaseIndex(int excludeBaseIndex) {
        int randomBaseIndex = excludeBaseIndex;
        while (randomBaseIndex == excludeBaseIndex) {
            randomBaseIndex = GenomeAnalysisEngine.getRandomGenerator().nextInt(4);
        }
        return randomBaseIndex;
    }

    public static byte getComplement(byte base) {
        switch (base) {
            case 65: 
            case 97: {
                return 84;
            }
            case 67: 
            case 99: {
                return 71;
            }
            case 71: 
            case 103: {
                return 67;
            }
            case 84: 
            case 116: {
                return 65;
            }
            case 78: 
            case 110: {
                return 78;
            }
        }
        throw new ReviewedStingException("base must be A, C, G or T. " + (char)base + " is not a valid base.");
    }

    static {
        Arrays.fill(baseIndexMap, -1);
        BaseUtils.baseIndexMap[65] = Base.A.ordinal();
        BaseUtils.baseIndexMap[97] = Base.A.ordinal();
        BaseUtils.baseIndexMap[42] = Base.A.ordinal();
        BaseUtils.baseIndexMap[67] = Base.C.ordinal();
        BaseUtils.baseIndexMap[99] = Base.C.ordinal();
        BaseUtils.baseIndexMap[71] = Base.G.ordinal();
        BaseUtils.baseIndexMap[103] = Base.G.ordinal();
        BaseUtils.baseIndexMap[84] = Base.T.ordinal();
        BaseUtils.baseIndexMap[116] = Base.T.ordinal();
        baseIndexWithIupacMap = (int[])baseIndexMap.clone();
        BaseUtils.baseIndexWithIupacMap[42] = -1;
        BaseUtils.baseIndexWithIupacMap[78] = Base.N.ordinal();
        BaseUtils.baseIndexWithIupacMap[110] = Base.N.ordinal();
        BaseUtils.baseIndexWithIupacMap[82] = Base.N.ordinal();
        BaseUtils.baseIndexWithIupacMap[114] = Base.N.ordinal();
        BaseUtils.baseIndexWithIupacMap[89] = Base.N.ordinal();
        BaseUtils.baseIndexWithIupacMap[121] = Base.N.ordinal();
        BaseUtils.baseIndexWithIupacMap[77] = Base.N.ordinal();
        BaseUtils.baseIndexWithIupacMap[109] = Base.N.ordinal();
        BaseUtils.baseIndexWithIupacMap[75] = Base.N.ordinal();
        BaseUtils.baseIndexWithIupacMap[107] = Base.N.ordinal();
        BaseUtils.baseIndexWithIupacMap[87] = Base.N.ordinal();
        BaseUtils.baseIndexWithIupacMap[119] = Base.N.ordinal();
        BaseUtils.baseIndexWithIupacMap[83] = Base.N.ordinal();
        BaseUtils.baseIndexWithIupacMap[115] = Base.N.ordinal();
        BaseUtils.baseIndexWithIupacMap[66] = Base.N.ordinal();
        BaseUtils.baseIndexWithIupacMap[98] = Base.N.ordinal();
        BaseUtils.baseIndexWithIupacMap[68] = Base.N.ordinal();
        BaseUtils.baseIndexWithIupacMap[100] = Base.N.ordinal();
        BaseUtils.baseIndexWithIupacMap[72] = Base.N.ordinal();
        BaseUtils.baseIndexWithIupacMap[104] = Base.N.ordinal();
        BaseUtils.baseIndexWithIupacMap[86] = Base.N.ordinal();
        BaseUtils.baseIndexWithIupacMap[118] = Base.N.ordinal();
    }

    public static enum BaseSubstitutionType {
        TRANSITION,
        TRANSVERSION;

    }

    public static enum Base {
        A('A'),
        C('C'),
        G('G'),
        T('T'),
        N('N'),
        D('D');

        public byte base;

        private Base(char base) {
            this.base = (byte)base;
        }
    }
}

