/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.bcf2;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class BCFVersion {
    public static final byte[] MAGIC_HEADER_START = "BCF".getBytes();
    final int majorVersion;
    final int minorVersion;

    public BCFVersion(int majorVersion, int minorVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public static BCFVersion readBCFVersion(InputStream stream) throws IOException {
        byte[] magicBytes = new byte[MAGIC_HEADER_START.length];
        stream.read(magicBytes);
        if (Arrays.equals(magicBytes, MAGIC_HEADER_START)) {
            int majorByte = stream.read();
            int minorByte = stream.read();
            return new BCFVersion(majorByte, minorByte);
        }
        return null;
    }

    public void write(OutputStream out) throws IOException {
        out.write(MAGIC_HEADER_START);
        out.write(this.getMajorVersion() & 0xFF);
        out.write(this.getMinorVersion() & 0xFF);
    }

    public String toString() {
        return String.format("BCF%d.%d", this.getMajorVersion(), this.getMinorVersion());
    }
}

