/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.T4CTTIkpdnrgnc;
import oracle.jdbc.driver.T4CTTIkpdnrri;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.TIMESTAMPTZ;

final class T4CTTIokpn
extends T4CTTIfun {
    static final int REGISTER_KPNDEF = 1;
    static final int UNREGISTER_KPNDEF = 2;
    static final int POST_KPNDEF = 3;
    static final int EXISTINGCLIENT_KPNDEF = 0;
    static final int NEWCLIENT_KPNDEF = 1;
    static final int CLIENTCON_KPNDEF = 4;
    static final int KPUN_PRS_RAW = 1;
    static final int KPUN_VER_10200 = 2;
    static final int KPUN_VER_11100 = 3;
    static final int KPUN_VER_11200 = 4;
    static final int OCI_SUBSCR_NAMESPACE_ANONYMOUS = 0;
    static final int OCI_SUBSCR_NAMESPACE_AQ = 1;
    static final int OCI_SUBSCR_NAMESPACE_DBCHANGE = 2;
    static final int OCI_SUBSCR_NAMESPACE_MAX = 3;
    static final int KPD_CHNF_OPFILTER = 1;
    static final int KPD_CHNF_INSERT = 2;
    static final int KPD_CHNF_UPDATE = 4;
    static final int KPD_CHNF_DELETE = 8;
    static final int KPD_CHNF_ROWID = 16;
    static final int KPD_CQ_QUERYNF = 32;
    static final int KPD_CQ_BEST_EFFORT = 64;
    static final int KPD_CQ_CLQRYCACHE = 128;
    static final int KPD_CHNF_INVALID_REGID = 0;
    static final int KPD_NTFN_CONNID_LEN = 29;
    static final int KKCN_CTX_RAW = 0;
    static final int SUBSCR_QOS_RELIABLE = 1;
    static final int SUBSCR_QOS_PAYLOAD = 2;
    static final int SUBSCR_QOS_REPLICATE = 4;
    static final int SUBSCR_QOS_SECURE = 8;
    static final int SUBSCR_QOS_PURGE_ON_NTFN = 16;
    static final int SUBSCR_QOS_MULTICBK = 32;
    static final int SUBSCR_QOS_ASYNC_DEQ = 512;
    static final int SUBSCR_QOS_TX_ACK = 2048;
    static final int SUBSCR_QOS_AUTO_ACK = 1024;
    static final byte SUBSCR_NTFN_GROUPING_CLASS_NONE = 0;
    static final byte SUBSCR_NTFN_GROUPING_CLASS_TIME = 1;
    static final byte SUBSCR_NTFN_GROUPING_TYPE_SUMMARY = 1;
    static final byte SUBSCR_NTFN_GROUPING_TYPE_LAST = 2;
    private int opcode;
    private int mode;
    private int nbOfRegistrationInfo;
    private String user;
    private String location;
    private String jmsClientId = null;
    private String[] databaseInstances = null;
    private int[] namespace;
    private int[] kpdnrgrpval;
    private int[] kpdnrgrprepcnt;
    private int[] payloadType;
    private int[] qosFlags;
    private int[] timeout;
    private int[] dbchangeOpFilter;
    private int[] dbchangeTxnLag = null;
    private byte[] kpncid = null;
    private byte[][] registeredAgentName = null;
    private byte[][] kpdnrcx = null;
    private byte[] kpdnrgrpcla;
    private byte[] kpdnrgrptyp = null;
    private TIMESTAMPTZ[] kpdnrgrpstatim = null;
    private long[] dbchangeRegistrationId = null;
    private byte[] userArr = null;
    private byte[] locationArr = null;
    private byte[] subscriberName = null;
    private long regid = 0L;
    private long[] registrationId = null;
    ArrayList<String> listenerAddresses = new ArrayList();
    T4CTTIkpdnrri kpninst = null;
    T4CTTIkpdnrgnc kpngcret = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
    public static final boolean TRACE = false;

    T4CTTIokpn(T4CConnection t4CConnection) {
        super(t4CConnection, (byte)3);
        this.setFunCode((short)125);
    }

    void doOKPN(int n2, int n3, String string, String string2, int n4, int[] nArray, String[] stringArray, byte[][] byArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int[] nArray6, long[] lArray, byte[] byArray2, int[] nArray7, byte[] byArray3, TIMESTAMPTZ[] tIMESTAMPTZArray, int[] nArray8, long[] lArray2) throws IOException, SQLException {
        this.opcode = n2;
        this.mode = n3;
        this.user = string;
        this.location = string2;
        this.nbOfRegistrationInfo = n4;
        this.namespace = nArray;
        this.kpdnrcx = byArray;
        this.payloadType = nArray2;
        this.qosFlags = nArray3;
        this.timeout = nArray4;
        this.dbchangeOpFilter = nArray5;
        if (this.dbchangeOpFilter == null) {
            this.dbchangeOpFilter = new int[this.nbOfRegistrationInfo];
        }
        this.dbchangeTxnLag = nArray6;
        if (this.dbchangeTxnLag == null) {
            this.dbchangeTxnLag = new int[this.nbOfRegistrationInfo];
        }
        this.dbchangeRegistrationId = lArray;
        if (this.dbchangeRegistrationId == null) {
            this.dbchangeRegistrationId = new long[this.nbOfRegistrationInfo];
        }
        this.kpdnrgrpcla = byArray2;
        if (this.kpdnrgrpcla == null) {
            this.kpdnrgrpcla = new byte[this.nbOfRegistrationInfo];
        }
        this.kpdnrgrpval = nArray7;
        if (this.kpdnrgrpval == null) {
            this.kpdnrgrpval = new int[this.nbOfRegistrationInfo];
        }
        this.kpdnrgrptyp = byArray3;
        if (this.kpdnrgrptyp == null) {
            this.kpdnrgrptyp = new byte[this.nbOfRegistrationInfo];
        }
        this.kpdnrgrpstatim = tIMESTAMPTZArray;
        if (this.kpdnrgrpstatim == null) {
            this.kpdnrgrpstatim = new TIMESTAMPTZ[this.nbOfRegistrationInfo];
        }
        this.kpdnrgrprepcnt = nArray8;
        if (this.kpdnrgrprepcnt == null) {
            this.kpdnrgrprepcnt = new int[this.nbOfRegistrationInfo];
        }
        this.registrationId = lArray2;
        if (this.registrationId == null) {
            this.registrationId = new long[this.nbOfRegistrationInfo];
        }
        this.registeredAgentName = new byte[this.nbOfRegistrationInfo][];
        for (int i2 = 0; i2 < this.nbOfRegistrationInfo; ++i2) {
            if (stringArray[i2] == null) continue;
            this.registeredAgentName[i2] = this.meg.conv.StringToCharBytes(stringArray[i2]);
        }
        this.userArr = (byte[])(this.user != null ? this.meg.conv.StringToCharBytes(this.user) : null);
        this.locationArr = (byte[])(this.location != null ? this.meg.conv.StringToCharBytes(this.location) : null);
        this.regid = 0L;
        this.doRPC();
    }

    @Override
    void marshal() throws IOException {
        int n2 = 1;
        int n3 = 2;
        this.meg.marshalUB1((byte)this.opcode);
        this.meg.marshalUB4(this.mode);
        if (this.userArr != null) {
            this.meg.marshalPTR();
            this.meg.marshalUB4(this.userArr.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
        }
        if (this.locationArr != null) {
            this.meg.marshalPTR();
            this.meg.marshalUB4(this.locationArr.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
        }
        this.meg.marshalPTR();
        this.meg.marshalUB4(this.nbOfRegistrationInfo);
        this.meg.marshalUB2(n2);
        this.meg.marshalUB2(n3);
        if (this.connection.getTTCVersion() >= 4) {
            this.meg.marshalNULLPTR();
            this.meg.marshalPTR();
            if (this.connection.getTTCVersion() >= 5) {
                this.meg.marshalNULLPTR();
                this.meg.marshalPTR();
                if (this.connection.getTTCVersion() >= 7) {
                    this.meg.marshalPTR();
                    this.meg.marshalPTR();
                    this.meg.marshalPTR();
                    this.meg.marshalPTR();
                    this.meg.marshalPTR();
                    this.meg.marshalSWORD(29);
                    this.meg.marshalPTR();
                }
            }
        }
        if (this.userArr != null) {
            this.meg.marshalCHR(this.userArr);
        }
        if (this.locationArr != null) {
            this.meg.marshalCHR(this.locationArr);
        }
        assert (this.namespace != null && this.registeredAgentName != null && this.payloadType != null && this.qosFlags != null && this.timeout != null) : " namespace : " + this.namespace + ", registeredAgentName : " + this.registeredAgentName + ", payloadType : " + this.payloadType + ", qosFlags : " + this.qosFlags + ", timeout : " + this.timeout;
        assert (this.namespace.length == this.nbOfRegistrationInfo && this.registeredAgentName.length == this.nbOfRegistrationInfo && this.payloadType.length == this.nbOfRegistrationInfo && this.qosFlags.length == this.nbOfRegistrationInfo && this.timeout.length == this.nbOfRegistrationInfo && this.kpdnrcx.length == this.nbOfRegistrationInfo && this.dbchangeOpFilter.length == this.nbOfRegistrationInfo && this.dbchangeTxnLag.length == this.nbOfRegistrationInfo && this.kpdnrgrpcla.length == this.nbOfRegistrationInfo && this.kpdnrgrpval.length == this.nbOfRegistrationInfo && this.kpdnrgrptyp.length == this.nbOfRegistrationInfo && this.kpdnrgrpstatim.length == this.nbOfRegistrationInfo && this.kpdnrgrprepcnt.length == this.nbOfRegistrationInfo && this.registrationId.length == this.nbOfRegistrationInfo) : " namespace.length = " + this.namespace.length + ", registeredAgentName.length = " + this.registeredAgentName.length + ", qosFlags.length = " + this.qosFlags.length + ", timeout.length = " + this.timeout.length + ", kpdnrcx.length = " + this.kpdnrcx.length + ", dbchangeOpFilter.length = " + this.dbchangeOpFilter.length + ", dbchangeTxnLag.length = " + this.dbchangeTxnLag.length + ", kpdnrgrpcla.length = " + this.kpdnrgrpcla.length + ", kpdnrgrpval.length = " + this.kpdnrgrpval.length + ", kpdnrgrptyp.length = " + this.kpdnrgrptyp.length + ", kpdnrgrpstatim.length = " + this.kpdnrgrpstatim.length + ", kpdnrgrprepcnt.length = " + this.kpdnrgrprepcnt.length + ", registrationId.length = " + this.registrationId.length;
        for (int i2 = 0; i2 < this.nbOfRegistrationInfo; ++i2) {
            this.meg.marshalUB4(this.namespace[i2]);
            byte[] byArray = this.registeredAgentName[i2];
            if (byArray != null && byArray.length > 0) {
                this.meg.marshalUB4(byArray.length);
                this.meg.marshalCLR(byArray, 0, byArray.length);
            } else {
                this.meg.marshalUB4(0L);
            }
            if (this.kpdnrcx == null) {
                this.meg.marshalUB4(0L);
            } else if (this.kpdnrcx[i2] != null && this.kpdnrcx[i2].length > 0) {
                this.meg.marshalUB4(this.kpdnrcx[i2].length);
                this.meg.marshalCLR(this.kpdnrcx[i2], 0, this.kpdnrcx[i2].length);
            } else {
                this.meg.marshalUB4(0L);
            }
            this.meg.marshalUB4(this.payloadType[i2]);
            if (this.connection.getTTCVersion() < 4) continue;
            this.meg.marshalUB4(this.qosFlags[i2]);
            byte[] byArray2 = new byte[]{};
            this.meg.marshalUB4(byArray2.length);
            if (byArray2.length > 0) {
                this.meg.marshalCLR(byArray2, byArray2.length);
            }
            this.meg.marshalUB4(this.timeout[i2]);
            int n4 = 0;
            this.meg.marshalUB4(n4);
            this.meg.marshalUB4(this.dbchangeOpFilter[i2]);
            this.meg.marshalUB4(this.dbchangeTxnLag[i2]);
            this.meg.marshalUB4((int)this.dbchangeRegistrationId[i2]);
            if (this.connection.getTTCVersion() < 5) continue;
            this.meg.marshalUB1(this.kpdnrgrpcla[i2]);
            this.meg.marshalUB4(this.kpdnrgrpval[i2]);
            this.meg.marshalUB1(this.kpdnrgrptyp[i2]);
            if (this.kpdnrgrpstatim[i2] == null) {
                this.meg.marshalDALC(null);
            } else {
                this.meg.marshalDALC(this.kpdnrgrpstatim[i2].shareBytes());
            }
            this.meg.marshalSB4(this.kpdnrgrprepcnt[i2]);
            this.meg.marshalSB8(this.registrationId[i2]);
        }
    }

    long getRegistrationId() {
        return this.regid;
    }

    @Override
    void readRPA() throws IOException, SQLException {
        int n2;
        int n3 = (int)this.meg.unmarshalUB4();
        for (int i2 = 0; i2 < n3; ++i2) {
            this.meg.unmarshalUB4();
        }
        int[] nArray = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = (int)this.meg.unmarshalUB4();
        }
        this.regid = nArray[0];
        if (this.connection.getTTCVersion() >= 5) {
            int n4;
            int n5;
            n2 = (int)this.meg.unmarshalUB4();
            this.registrationId = new long[n2];
            for (n5 = 0; n5 < n2; ++n5) {
                this.registrationId[n5] = this.meg.unmarshalSB8();
                if (this.connection.getTTCVersion() < 7 || (n4 = (int)this.meg.unmarshalUB4()) <= 0) continue;
                this.subscriberName = new byte[n4];
                this.meg.unmarshalBuffer(this.subscriberName, 0, n4);
            }
            this.regid = this.registrationId[0];
            if (this.connection.getTTCVersion() >= 7) {
                int n6;
                n5 = (int)this.meg.unmarshalUB4();
                this.databaseInstances = new String[n5];
                for (n4 = 0; n4 < n5; ++n4) {
                    this.kpninst = new T4CTTIkpdnrri(this.connection);
                    this.kpninst.receive();
                    byte[] byArray = this.kpninst.getKpdnrrinm();
                    if (byArray == null) continue;
                    this.databaseInstances[n4] = this.meg.conv.CharBytesToString(byArray, byArray.length);
                }
                n4 = (int)this.meg.unmarshalUB4();
                this.listenerAddresses = new ArrayList();
                for (n6 = 0; n6 < n4; ++n6) {
                    this.kpngcret = new T4CTTIkpdnrgnc(this.connection);
                    this.kpngcret.receive();
                    byte[] byArray = this.kpngcret.getKpdnrgnclsc();
                    if (byArray == null) continue;
                    String string = this.meg.conv.CharBytesToString(byArray, byArray.length);
                    this.listenerAddresses.add(string);
                }
                n6 = this.meg.unmarshalUB2();
                if (n6 > 0) {
                    this.kpncid = new byte[n6];
                    this.kpncid = this.meg.unmarshalCHR(n6);
                    if (this.kpncid != null) {
                        this.jmsClientId = this.meg.conv.CharBytesToString(this.kpncid, this.kpncid.length);
                    }
                }
            }
        }
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }

    ArrayList<String> getListenerAddresses() {
        return this.listenerAddresses;
    }

    String getListenerAddress() throws SQLException {
        SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    long[] getRegistrationIdArray() {
        return this.registrationId;
    }

    String getJMSClientId() {
        return this.jmsClientId;
    }

    String[] getDatabaseInstances() {
        return this.databaseInstances;
    }
}

