/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import java.io.IOException;

public class GammaIntegerCodec
extends AbstractBitCodec<Integer> {
    private int offset = 0;
    private boolean lenCodingBit = false;

    private GammaIntegerCodec(int offset, boolean lenCodingBit) {
        this.offset = offset;
        this.lenCodingBit = lenCodingBit;
    }

    public GammaIntegerCodec(int offset) {
        this(offset, false);
    }

    public GammaIntegerCodec() {
        this(0, false);
    }

    @Override
    public final Integer read(BitInputStream bis) throws IOException {
        int len = 1;
        while (bis.readBit() == this.lenCodingBit) {
            ++len;
        }
        int readBits = bis.readBits(len - 1);
        int value = readBits | 1 << len - 1;
        return value - this.offset;
    }

    @Override
    public final long write(BitOutputStream bos, Integer value) throws IOException {
        if (value + this.offset < 1) {
            throw new IllegalArgumentException("Gamma codec handles only positive values: " + value);
        }
        long newValue = value + this.offset;
        int betaCodeLength = 1 + (int)(Math.log(newValue) / Math.log(2.0));
        if (betaCodeLength > 1) {
            bos.write(0L, betaCodeLength - 1);
        }
        bos.write(newValue, betaCodeLength);
        return betaCodeLength * 2 - 1;
    }

    @Override
    public final long numberOfBits(Integer value) {
        long newValue = value + this.offset;
        if (newValue < 1L) {
            throw new RuntimeException("Invalid valid: " + newValue);
        }
        int betaCodeLength = 1 + (int)(Math.log(newValue) / Math.log(2.0));
        return betaCodeLength * 2 - 1;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean isLenCodingBit() {
        return this.lenCodingBit;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setLenCodingBit(boolean lenCodingBit) {
        this.lenCodingBit = lenCodingBit;
    }

    @Override
    public Integer read(BitInputStream bis, int len) throws IOException {
        throw new RuntimeException("Not implemented.");
    }
}

