/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import java.io.IOException;

public class GolombLongCodec
extends AbstractBitCodec<Long> {
    private int m;
    private boolean quotientBit = true;
    private long offset = 0L;

    public GolombLongCodec(int m) {
        this(0L, m, true);
    }

    public GolombLongCodec(long offset, int m) {
        this(offset, m, true);
    }

    public GolombLongCodec(long offset, int m, boolean quotientBit) {
        if (m < 2) {
            throw new IllegalArgumentException("M parameter must be at least 2.");
        }
        this.m = m;
        this.quotientBit = quotientBit;
        this.offset = offset;
    }

    @Override
    public final Long read(BitInputStream bis) throws IOException {
        long quotient = 0L;
        while (bis.readBit() == this.quotientBit) {
            ++quotient;
        }
        long ceiling = (long)(Math.log(this.m) / Math.log(2.0) + 1.0);
        long reminder = bis.readBits((int)(ceiling - 1L));
        if ((double)reminder >= Math.pow(2.0, ceiling) - (double)this.m) {
            reminder <<= 1;
            reminder |= (long)bis.readBits(1);
            reminder = (long)((double)reminder - (Math.pow(2.0, ceiling) - (double)this.m));
        }
        return quotient * (long)this.m + reminder - this.offset;
    }

    @Override
    public final long write(BitOutputStream bos, Long value) throws IOException {
        long newValue = value + this.offset;
        long quotient = newValue / (long)this.m;
        long reminder = newValue % (long)this.m;
        long ceiling = (long)(Math.log(this.m) / Math.log(2.0) + 1.0);
        long len = quotient + 1L;
        bos.write(this.quotientBit, quotient);
        bos.write(!this.quotientBit);
        if ((double)reminder < Math.pow(2.0, ceiling) - (double)this.m) {
            bos.write(reminder, (int)ceiling - 1);
            len += ceiling - 1L;
        } else {
            bos.write((int)((double)reminder + Math.pow(2.0, ceiling) - (double)this.m), (int)ceiling);
            len += ceiling;
        }
        return len;
    }

    @Override
    public final long numberOfBits(Long value) {
        long newValue = value + this.offset;
        long quotient = newValue / (long)this.m;
        long reminder = newValue % (long)this.m;
        long ceiling = (long)(Math.log(this.m) / Math.log(2.0) + 1.0);
        long l = quotient + 1L;
        l = (double)reminder < Math.pow(2.0, ceiling) - (double)this.m ? (l += ceiling - 1L) : (l += ceiling);
        return l;
    }

    public int getM() {
        return this.m;
    }

    public boolean isQuotientBit() {
        return this.quotientBit;
    }

    public Long getOffset() {
        return this.offset;
    }

    public void setM(int m) {
        this.m = m;
    }

    public void setQuotientBit(boolean quotientBit) {
        this.quotientBit = quotientBit;
    }

    public void setOffset(Long offset) {
        this.offset = offset;
    }

    @Override
    public Long read(BitInputStream bis, int len) throws IOException {
        throw new RuntimeException("Multi-value read method not defined.");
    }
}

