/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.encoding.SubexpIntegerCodec;
import htsjdk.samtools.cram.io.ByteBufferUtils;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.EncodingParams;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public class SubexpIntegerEncoding
implements Encoding<Integer> {
    public static final EncodingID ENCODING_ID = EncodingID.SUBEXP;
    private int offset;
    private int k;

    public SubexpIntegerEncoding() {
    }

    public SubexpIntegerEncoding(int k) {
        this(0, k);
    }

    public SubexpIntegerEncoding(int offset, int k) {
        this.offset = offset;
        this.k = k;
    }

    @Override
    public EncodingID id() {
        return ENCODING_ID;
    }

    public static EncodingParams toParam(int offset, int k) {
        SubexpIntegerEncoding e = new SubexpIntegerEncoding();
        e.offset = offset;
        e.k = k;
        return new EncodingParams(ENCODING_ID, e.toByteArray());
    }

    @Override
    public byte[] toByteArray() {
        ByteBuffer buf = ByteBuffer.allocate(10);
        ByteBufferUtils.writeUnsignedITF8(this.offset, buf);
        ByteBufferUtils.writeUnsignedITF8(this.k, buf);
        buf.flip();
        byte[] bytes = new byte[buf.limit()];
        buf.get(bytes);
        return bytes;
    }

    @Override
    public void fromByteArray(byte[] data) {
        ByteBuffer buf = ByteBuffer.wrap(data);
        this.offset = ByteBufferUtils.readUnsignedITF8(buf);
        this.k = ByteBufferUtils.readUnsignedITF8(buf);
    }

    @Override
    public BitCodec<Integer> buildCodec(Map<Integer, InputStream> inputMap, Map<Integer, ExposedByteArrayOutputStream> outputMap) {
        return new SubexpIntegerCodec(this.offset, this.k);
    }
}

