/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.io;

import java.io.IOException;
import java.io.InputStream;

public class CountingInputStream
extends InputStream {
    private InputStream delegate;
    private long count = 0L;
    private boolean debug = false;

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public CountingInputStream(InputStream inputStream) {
        this.delegate = inputStream;
    }

    @Override
    public int read() throws IOException {
        ++this.count;
        int read = this.delegate.read();
        if (this.debug) {
            System.out.printf("pos=%d\tread=%d\n", this.count, read);
        }
        return read;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int read = this.delegate.read(b);
        this.count += (long)read;
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.delegate.read(b, off, len);
        this.count += (long)read;
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = this.delegate.skip(n);
        this.count += skipped;
        return skipped;
    }

    @Override
    public int available() throws IOException {
        return this.delegate.available();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public void mark(int readlimit) {
        this.delegate.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.delegate.reset();
        this.count = 0L;
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }

    public long getCount() {
        return this.count;
    }
}

