/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.bed;

import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.annotation.Strand;
import htsjdk.tribble.bed.BEDFeature;
import htsjdk.tribble.bed.FullBEDFeature;
import htsjdk.tribble.readers.LineIterator;
import htsjdk.tribble.util.ParsingUtils;
import java.util.regex.Pattern;

public class BEDCodec
extends AsciiFeatureCodec<BEDFeature> {
    private static final Pattern SPLIT_PATTERN = Pattern.compile("\\t|( +)");
    private final int startOffsetValue;

    public BEDCodec() {
        this(StartOffset.ONE);
    }

    public BEDCodec(StartOffset startOffset) {
        super(BEDFeature.class);
        this.startOffsetValue = startOffset.value();
    }

    public BEDFeature decodeLoc(String line) {
        return this.decode(line);
    }

    @Override
    public BEDFeature decode(String line) {
        if (line.trim().length() == 0) {
            return null;
        }
        if (line.startsWith("#") || line.startsWith("track") || line.startsWith("browser")) {
            this.readHeaderLine(line);
            return null;
        }
        String[] tokens = SPLIT_PATTERN.split(line, -1);
        return this.decode(tokens);
    }

    @Override
    public Object readActualHeader(LineIterator reader) {
        return null;
    }

    @Override
    public BEDFeature decode(String[] tokens) {
        int start;
        int tokenCount = tokens.length;
        if (tokenCount < 2) {
            return null;
        }
        String chr = tokens[0];
        int end = start = Integer.parseInt(tokens[1]) + this.startOffsetValue;
        if (tokenCount > 2) {
            end = Integer.parseInt(tokens[2]);
        }
        FullBEDFeature feature = new FullBEDFeature(chr, start, end);
        if (tokenCount > 3) {
            String name = tokens[3].replaceAll("\"", "");
            feature.setName(name);
        }
        if (tokenCount > 4) {
            try {
                float score = Float.parseFloat(tokens[4]);
                feature.setScore(score);
            }
            catch (NumberFormatException numberFormatException) {
                return feature;
            }
        }
        if (tokenCount > 5) {
            int strand;
            String strandString = tokens[5].trim();
            int n = strand = strandString.length() == 0 ? 32 : (int)strandString.charAt(0);
            if (strand == 45) {
                feature.setStrand(Strand.NEGATIVE);
            } else if (strand == 43) {
                feature.setStrand(Strand.POSITIVE);
            } else {
                feature.setStrand(Strand.NONE);
            }
        }
        if (tokenCount > 8) {
            String colorString = tokens[8];
            feature.setColor(ParsingUtils.parseColor(colorString));
        }
        if (tokenCount > 11) {
            this.createExons(start, tokens, feature, feature.getStrand());
        }
        return feature;
    }

    protected boolean readHeaderLine(String line) {
        return false;
    }

    private void createExons(int start, String[] tokens, FullBEDFeature gene, Strand strand) throws NumberFormatException {
        int exonNumber;
        int cdStart = Integer.parseInt(tokens[6]) + this.startOffsetValue;
        int cdEnd = Integer.parseInt(tokens[7]);
        int exonCount = Integer.parseInt(tokens[9]);
        String[] exonSizes = new String[exonCount];
        String[] startsBuffer = new String[exonCount];
        ParsingUtils.split(tokens[10], exonSizes, ',');
        ParsingUtils.split(tokens[11], startsBuffer, ',');
        int n = exonNumber = strand == Strand.NEGATIVE ? exonCount : 1;
        if (startsBuffer.length == exonSizes.length) {
            for (int i = 0; i < startsBuffer.length; ++i) {
                int exonStart = start + Integer.parseInt(startsBuffer[i]);
                int exonEnd = exonStart + Integer.parseInt(exonSizes[i]) - 1;
                gene.addExon(exonStart, exonEnd, cdStart, cdEnd, exonNumber);
                if (strand == Strand.NEGATIVE) {
                    --exonNumber;
                    continue;
                }
                ++exonNumber;
            }
        }
    }

    @Override
    public boolean canDecode(String path) {
        return path.toLowerCase().endsWith(".bed");
    }

    public int getStartOffset() {
        return this.startOffsetValue;
    }

    public static enum StartOffset {
        ZERO(0),
        ONE(1);

        private int start;

        private StartOffset(int start) {
            this.start = start;
        }

        public int value() {
            return this.start;
        }
    }
}

