/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.sam;

import com.google.java.contract.Ensures;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.TextCigarCodec;
import java.util.Arrays;
import java.util.Stack;
import org.broadinstitute.gatk.utils.exceptions.ReviewedGATKException;
import org.broadinstitute.gatk.utils.sam.AlignmentUtils;
import org.broadinstitute.gatk.utils.sam.GATKSAMRecord;
import org.broadinstitute.gatk.utils.smithwaterman.Parameters;
import org.broadinstitute.gatk.utils.smithwaterman.SWPairwiseAlignment;
import org.broadinstitute.gatk.utils.smithwaterman.SmithWaterman;

public class CigarUtils {
    public static final Parameters NEW_SW_PARAMETERS = new Parameters(200, -150, -260, -11);
    private static final String SW_PAD = "NNNNNNNNNN";

    public static Cigar combineAdjacentCigarElements(Cigar rawCigar) {
        Cigar combinedCigar = new Cigar();
        CigarElement lastElement = null;
        int lastElementLength = 0;
        for (CigarElement cigarElement : rawCigar.getCigarElements()) {
            if (lastElement != null && (lastElement.getOperator() == cigarElement.getOperator() || lastElement.getOperator() == CigarOperator.I && cigarElement.getOperator() == CigarOperator.D || lastElement.getOperator() == CigarOperator.D && cigarElement.getOperator() == CigarOperator.I)) {
                lastElementLength += cigarElement.getLength();
                continue;
            }
            if (lastElement != null) {
                combinedCigar.add(new CigarElement(lastElementLength, lastElement.getOperator()));
            }
            lastElement = cigarElement;
            lastElementLength = cigarElement.getLength();
        }
        if (lastElement != null) {
            combinedCigar.add(new CigarElement(lastElementLength, lastElement.getOperator()));
        }
        return combinedCigar;
    }

    public static Cigar invertCigar(Cigar cigar) {
        Stack<CigarElement> cigarStack = new Stack<CigarElement>();
        for (CigarElement cigarElement : cigar.getCigarElements()) {
            cigarStack.push(cigarElement);
        }
        Cigar invertedCigar = new Cigar();
        while (!cigarStack.isEmpty()) {
            invertedCigar.add((CigarElement)cigarStack.pop());
        }
        return invertedCigar;
    }

    public static boolean readHasNonClippedBases(GATKSAMRecord read) {
        for (CigarElement cigarElement : read.getCigar().getCigarElements()) {
            if (cigarElement.getOperator() == CigarOperator.SOFT_CLIP || cigarElement.getOperator() == CigarOperator.HARD_CLIP) continue;
            return true;
        }
        return false;
    }

    public static Cigar cigarFromString(String cigarString) {
        return TextCigarCodec.getSingleton().decode(cigarString);
    }

    public static boolean isCigarValid(Cigar cigar) {
        if (cigar.isValid(null, -1L) == null) {
            Stack<CigarElement> cigarElementStack = new Stack<CigarElement>();
            CigarOperator startingOp = null;
            CigarOperator endingOp = null;
            boolean readHasStarted = false;
            for (CigarElement cigarElement : cigar.getCigarElements()) {
                if (!readHasStarted && cigarElement.getOperator() != CigarOperator.SOFT_CLIP && cigarElement.getOperator() != CigarOperator.HARD_CLIP) {
                    readHasStarted = true;
                    startingOp = cigarElement.getOperator();
                }
                cigarElementStack.push(cigarElement);
            }
            while (!cigarElementStack.empty()) {
                CigarElement cigarElement = (CigarElement)cigarElementStack.pop();
                if (cigarElement.getOperator() == CigarOperator.SOFT_CLIP || cigarElement.getOperator() == CigarOperator.HARD_CLIP) continue;
                endingOp = cigarElement.getOperator();
                break;
            }
            if (startingOp != CigarOperator.DELETION && endingOp != CigarOperator.DELETION && startingOp != CigarOperator.SKIPPED_REGION && endingOp != CigarOperator.SKIPPED_REGION) {
                return true;
            }
        }
        return false;
    }

    public static final int countRefBasesBasedOnCigar(GATKSAMRecord read, int cigarStartIndex, int cigarEndIndex) {
        int result = 0;
        block4: for (int i = cigarStartIndex; i < cigarEndIndex; ++i) {
            CigarElement cigarElement = read.getCigar().getCigarElement(i);
            switch (cigarElement.getOperator()) {
                case M: 
                case S: 
                case D: 
                case N: 
                case H: {
                    result += cigarElement.getLength();
                    continue block4;
                }
                case I: {
                    continue block4;
                }
                default: {
                    throw new ReviewedGATKException("Unsupported cigar operator: " + cigarElement.getOperator());
                }
            }
        }
        return result;
    }

    public static Cigar calculateCigar(byte[] refSeq, byte[] altSeq) {
        if (altSeq.length == 0) {
            return new Cigar(Arrays.asList(new CigarElement(refSeq.length, CigarOperator.D)));
        }
        String paddedRef = SW_PAD + new String(refSeq) + SW_PAD;
        String paddedPath = SW_PAD + new String(altSeq) + SW_PAD;
        SWPairwiseAlignment alignment = new SWPairwiseAlignment(paddedRef.getBytes(), paddedPath.getBytes(), NEW_SW_PARAMETERS);
        if (CigarUtils.isSWFailure(alignment)) {
            return null;
        }
        int baseStart = SW_PAD.length();
        int baseEnd = paddedPath.length() - SW_PAD.length() - 1;
        Cigar nonStandard = AlignmentUtils.trimCigarByBases(alignment.getCigar(), baseStart, baseEnd);
        if (nonStandard.getReferenceLength() != refSeq.length) {
            nonStandard.add(new CigarElement(refSeq.length - nonStandard.getReferenceLength(), CigarOperator.D));
        }
        return CigarUtils.leftAlignCigarSequentially(nonStandard, refSeq, altSeq, 0, 0);
    }

    private static boolean isSWFailure(SmithWaterman alignment) {
        if (alignment.getAlignmentStart2wrt1() > 0) {
            return true;
        }
        for (CigarElement ce : alignment.getCigar().getCigarElements()) {
            if (ce.getOperator() != CigarOperator.S) continue;
            return true;
        }
        return false;
    }

    @Ensures(value={"cigar != null", "refSeq != null", "readSeq != null", "refIndex >= 0", "readIndex >= 0"})
    public static Cigar leftAlignCigarSequentially(Cigar cigar, byte[] refSeq, byte[] readSeq, int refIndex, int readIndex) {
        Cigar result;
        Cigar cigarToReturn = new Cigar();
        Cigar cigarToAlign = new Cigar();
        for (int i = 0; i < cigar.numCigarElements(); ++i) {
            CigarElement ce = cigar.getCigarElement(i);
            if (ce.getOperator() == CigarOperator.D || ce.getOperator() == CigarOperator.I) {
                cigarToAlign.add(ce);
                Cigar leftAligned = AlignmentUtils.leftAlignSingleIndel(cigarToAlign, refSeq, readSeq, refIndex, readIndex, false);
                for (CigarElement toAdd : leftAligned.getCigarElements()) {
                    cigarToReturn.add(toAdd);
                }
                refIndex += cigarToAlign.getReferenceLength();
                readIndex += cigarToAlign.getReadLength();
                cigarToAlign = new Cigar();
                continue;
            }
            cigarToAlign.add(ce);
        }
        if (!cigarToAlign.isEmpty()) {
            for (CigarElement toAdd : cigarToAlign.getCigarElements()) {
                cigarToReturn.add(toAdd);
            }
        }
        if ((result = AlignmentUtils.consolidateCigar(cigarToReturn)).getReferenceLength() != cigar.getReferenceLength()) {
            throw new IllegalStateException("leftAlignCigarSequentially failed to produce a valid CIGAR.  Reference lengths differ.  Initial cigar " + cigar + " left aligned into " + result);
        }
        return result;
    }
}

