/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.BAMRecordCodec;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordQueryNameComparator;
import htsjdk.samtools.SAMRecordUtil;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.filter.FilteringIterator;
import htsjdk.samtools.filter.SamRecordFilter;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.FastqQualityFormat;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.PeekableIterator;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.QualityEncodingDetector;
import htsjdk.samtools.util.SortingCollection;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.SamOrBam;

@CommandLineProgramProperties(usage="Reverts SAM or BAM files to a previous state by removing certain types of information and/or substituting in the original quality scores when available.", usageShort="Reverts SAM or BAM files to a previous state", programGroup=SamOrBam.class)
public class RevertSam
extends CommandLineProgram {
    @Option(shortName="I", doc="The input SAM/BAM file to revert the state of.")
    public File INPUT;
    @Option(shortName="O", doc="The output SAM/BAM file to create.")
    public File OUTPUT;
    @Option(shortName="SO", doc="The sort order to create the reverted output file with.")
    public SAMFileHeader.SortOrder SORT_ORDER = SAMFileHeader.SortOrder.queryname;
    @Option(shortName="OQ", doc="True to restore original qualities from the OQ field to the QUAL field if available.")
    public boolean RESTORE_ORIGINAL_QUALITIES = true;
    @Option(doc="Remove duplicate read flags from all reads.  Note that if this is true and REMOVE_ALIGNMENT_INFORMATION==false,  the output may have the unusual but sometimes desirable trait of having unmapped reads that are marked as duplicates.")
    public boolean REMOVE_DUPLICATE_INFORMATION = true;
    @Option(doc="Remove all alignment information from the file.")
    public boolean REMOVE_ALIGNMENT_INFORMATION = true;
    @Option(doc="When removing alignment information, the set of optional tags to remove.")
    public List<String> ATTRIBUTE_TO_CLEAR = new ArrayList<String>(){
        {
            this.add(SAMTag.NM.name());
            this.add(SAMTag.UQ.name());
            this.add(SAMTag.PG.name());
            this.add(SAMTag.MD.name());
            this.add(SAMTag.MQ.name());
            this.add(SAMTag.SA.name());
            this.add(SAMTag.MC.name());
        }
    };
    @Option(doc="WARNING: This option is potentially destructive. If enabled will discard reads in order to produce a consistent output BAM. Reads discarded include (but are not limited to) paired reads with missing mates, duplicated records, records with mismatches in length of bases and qualities. This option can only be enabled if the output sort order is queryname and will always cause sorting to occur.")
    public boolean SANITIZE = false;
    @Option(doc="If SANITIZE=true and higher than MAX_DISCARD_FRACTION reads are discarded due to sanitization thenthe program will exit with an Exception instead of exiting cleanly. Output BAM will still be valid.")
    public double MAX_DISCARD_FRACTION = 0.01;
    @Option(doc="The sample alias to use in the reverted output file.  This will override the existing sample alias in the file and is used only if all the read groups in the input file have the same sample alias ", shortName="ALIAS", optional=true)
    public String SAMPLE_ALIAS;
    @Option(doc="The library name to use in the reverted output file.  This will override the existing sample alias in the file and is used only if all the read groups in the input file have the same sample alias ", shortName="LIB", optional=true)
    public String LIBRARY_NAME;
    private static final Log log = Log.getInstance(RevertSam.class);

    public static void main(String[] args) {
        new RevertSam().instanceMainWithExit(args);
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.SANITIZE && this.SORT_ORDER != SAMFileHeader.SortOrder.queryname) {
            return new String[]{"SORT_ORDER must be queryname when sanitization is enabled with SANITIZE=true."};
        }
        return null;
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        boolean sanitizing = this.SANITIZE;
        SamReader in = SamReaderFactory.makeDefault().validationStringency(this.VALIDATION_STRINGENCY).open(this.INPUT);
        SAMFileHeader inHeader = in.getFileHeader();
        List rgs = inHeader.getReadGroups();
        if (this.SAMPLE_ALIAS != null || this.LIBRARY_NAME != null) {
            boolean allSampleAliasesIdentical = true;
            boolean allLibraryNamesIdentical = true;
            for (int i = 1; i < rgs.size(); ++i) {
                if (!((SAMReadGroupRecord)rgs.get(0)).getSample().equals(((SAMReadGroupRecord)rgs.get(i)).getSample())) {
                    allSampleAliasesIdentical = false;
                }
                if (((SAMReadGroupRecord)rgs.get(0)).getLibrary().equals(((SAMReadGroupRecord)rgs.get(i)).getLibrary())) continue;
                allLibraryNamesIdentical = false;
            }
            if (this.SAMPLE_ALIAS != null && !allSampleAliasesIdentical) {
                throw new PicardException("Read groups have multiple values for sample.  A value for SAMPLE_ALIAS cannot be supplied.");
            }
            if (this.LIBRARY_NAME != null && !allLibraryNamesIdentical) {
                throw new PicardException("Read groups have multiple values for library name.  A value for library name cannot be supplied.");
            }
        }
        boolean presorted = inHeader.getSortOrder() == this.SORT_ORDER || this.SORT_ORDER == SAMFileHeader.SortOrder.queryname && this.SANITIZE;
        SAMFileHeader outHeader = new SAMFileHeader();
        for (SAMReadGroupRecord rg : inHeader.getReadGroups()) {
            if (this.SAMPLE_ALIAS != null) {
                rg.setSample(this.SAMPLE_ALIAS);
            }
            if (this.LIBRARY_NAME != null) {
                rg.setLibrary(this.LIBRARY_NAME);
            }
            outHeader.addReadGroup(rg);
        }
        outHeader.setSortOrder(this.SORT_ORDER);
        if (!this.REMOVE_ALIGNMENT_INFORMATION) {
            outHeader.setSequenceDictionary(inHeader.getSequenceDictionary());
            outHeader.setProgramRecords(inHeader.getProgramRecords());
        }
        SAMFileWriter out = new SAMFileWriterFactory().makeSAMOrBAMWriter(outHeader, presorted, this.OUTPUT);
        SortingCollection sorter = sanitizing ? SortingCollection.newInstance(SAMRecord.class, (SortingCollection.Codec)new BAMRecordCodec(outHeader), (Comparator)new SAMRecordQueryNameComparator(), (int)this.MAX_RECORDS_IN_RAM) : null;
        ProgressLogger progress = new ProgressLogger(log, 1000000, "Reverted");
        for (SAMRecord rec : in) {
            if (rec.isSecondaryOrSupplementary()) continue;
            this.revertSamRecord(rec);
            if (sanitizing) {
                sorter.add((Object)rec);
            } else {
                out.addAlignment(rec);
            }
            progress.record(rec);
        }
        if (!sanitizing) {
            out.close();
        } else {
            long total = 0L;
            long discarded = 0L;
            PeekableIterator iterator = new PeekableIterator((Iterator)sorter.iterator());
            HashMap<SAMReadGroupRecord, FastqQualityFormat> readGroupToFormat = new HashMap<SAMReadGroupRecord, FastqQualityFormat>();
            for (final SAMReadGroupRecord rg : inHeader.getReadGroups()) {
                SamReader reader = SamReaderFactory.makeDefault().validationStringency(this.VALIDATION_STRINGENCY).open(this.INPUT);
                SamRecordFilter filter = new SamRecordFilter(){

                    public boolean filterOut(SAMRecord rec) {
                        return !rec.getReadGroup().getId().equals(rg.getId());
                    }

                    public boolean filterOut(SAMRecord first, SAMRecord second) {
                        throw new UnsupportedOperationException();
                    }
                };
                readGroupToFormat.put(rg, QualityEncodingDetector.detect((long)10000L, (CloseableIterator)new FilteringIterator((Iterator)reader.iterator(), filter), (boolean)this.RESTORE_ORIGINAL_QUALITIES));
                CloserUtil.close((Object)reader);
            }
            for (SAMReadGroupRecord r : readGroupToFormat.keySet()) {
                log.info(new Object[]{"Detected quality format for " + r.getReadGroupId() + ": " + readGroupToFormat.get(r)});
            }
            if (readGroupToFormat.values().contains(FastqQualityFormat.Solexa)) {
                log.error(new Object[]{"No quality score encoding conversion implemented for " + FastqQualityFormat.Solexa});
                return -1;
            }
            ProgressLogger sanitizerProgress = new ProgressLogger(log, 1000000, "Sanitized");
            block5: while (iterator.hasNext()) {
                List<SAMRecord> recs = this.fetchByReadName((PeekableIterator<SAMRecord>)iterator);
                total += (long)recs.size();
                for (SAMRecord rec : recs) {
                    if (rec.getReadBases().length == rec.getBaseQualities().length) continue;
                    log.debug(new Object[]{"Discarding " + recs.size() + " reads with name " + rec.getReadName() + " for mismatching bases and quals length."});
                    discarded += (long)recs.size();
                    continue block5;
                }
                if (!recs.get(0).getReadPairedFlag() && recs.size() > 1) {
                    log.debug(new Object[]{"Discarding " + recs.size() + " reads with name " + recs.get(0).getReadName() + " because they claim to be unpaired."});
                    discarded += (long)recs.size();
                    continue;
                }
                if (recs.get(0).getReadPairedFlag()) {
                    int firsts = 0;
                    int seconds = 0;
                    int unpaired = 0;
                    for (SAMRecord rec : recs) {
                        if (!rec.getReadPairedFlag()) {
                            ++unpaired;
                        }
                        if (rec.getFirstOfPairFlag()) {
                            ++firsts;
                        }
                        if (!rec.getSecondOfPairFlag()) continue;
                        ++seconds;
                    }
                    if (unpaired > 0 || firsts != 1 || seconds != 1) {
                        log.debug(new Object[]{"Discarding " + recs.size() + " reads with name " + recs.get(0).getReadName() + " because pairing information in corrupt."});
                        discarded += (long)recs.size();
                        continue;
                    }
                }
                for (SAMRecord rec : recs) {
                    FastqQualityFormat recordFormat = (FastqQualityFormat)readGroupToFormat.get(rec.getReadGroup());
                    if (!recordFormat.equals((Object)FastqQualityFormat.Standard)) {
                        byte[] quals = rec.getBaseQualities();
                        int i = 0;
                        while (i < quals.length) {
                            int n = i++;
                            quals[n] = (byte)(quals[n] - 31);
                        }
                        rec.setBaseQualities(quals);
                    }
                    out.addAlignment(rec);
                    sanitizerProgress.record(rec);
                }
            }
            out.close();
            double discardRate = (double)discarded / (double)total;
            DecimalFormat fmt = new DecimalFormat("0.000%");
            log.info(new Object[]{"Discarded " + discarded + " out of " + total + " (" + fmt.format(discardRate) + ") reads in order to sanitize output."});
            if ((double)discarded / (double)total > this.MAX_DISCARD_FRACTION) {
                throw new PicardException("Discarded " + fmt.format(discardRate) + " which is above MAX_DISCARD_FRACTION of " + fmt.format(this.MAX_DISCARD_FRACTION));
            }
        }
        return 0;
    }

    private List<SAMRecord> fetchByReadName(PeekableIterator<SAMRecord> iterator) {
        LinkedList<SAMRecord> out = new LinkedList<SAMRecord>();
        if (iterator.hasNext()) {
            SAMRecord first = (SAMRecord)iterator.next();
            out.add(first);
            while (iterator.hasNext() && ((SAMRecord)iterator.peek()).getReadName().equals(first.getReadName())) {
                out.add((SAMRecord)iterator.next());
            }
        }
        return out;
    }

    public void revertSamRecord(SAMRecord rec) {
        byte[] oq;
        if (this.RESTORE_ORIGINAL_QUALITIES && (oq = rec.getOriginalBaseQualities()) != null) {
            rec.setBaseQualities(oq);
            rec.setOriginalBaseQualities(null);
        }
        if (this.REMOVE_DUPLICATE_INFORMATION) {
            rec.setDuplicateReadFlag(false);
        }
        if (this.REMOVE_ALIGNMENT_INFORMATION) {
            if (rec.getReadNegativeStrandFlag()) {
                SAMRecordUtil.reverseComplement((SAMRecord)rec);
                rec.setReadNegativeStrandFlag(false);
            }
            rec.setReferenceIndex(-1);
            rec.setAlignmentStart(0);
            rec.setCigarString("*");
            rec.setMappingQuality(0);
            if (!rec.getReadUnmappedFlag()) {
                rec.setInferredInsertSize(0);
                rec.setNotPrimaryAlignmentFlag(false);
                rec.setProperPairFlag(false);
                rec.setReadUnmappedFlag(true);
            }
            if (rec.getReadPairedFlag()) {
                rec.setMateAlignmentStart(0);
                rec.setMateNegativeStrandFlag(false);
                rec.setMateReferenceIndex(-1);
                rec.setMateUnmappedFlag(true);
            }
            for (String tag : this.ATTRIBUTE_TO_CLEAR) {
                rec.setAttribute(tag, null);
            }
        }
    }
}

