/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;

public class VerifyTransactionHandler
extends PacketHandler {
    private Logger logger = Globals.getLogger();
    public static boolean DEBUG;
    TransactionList translist = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public VerifyTransactionHandler(TransactionList transactionList) {
        this.translist = transactionList;
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet) throws BrokerException {
        Hashtable<String, Object> hashtable;
        Packet packet2;
        block20: {
            block19: {
                int n = 200;
                String string = null;
                if (!$assertionsDisabled && packet.getPacketType() != 78) {
                    throw new AssertionError();
                }
                packet2 = new Packet(iMQConnection.useDirectBuffers());
                packet2.setConsumerID(packet.getConsumerID());
                packet2.setPacketType(79);
                hashtable = new Hashtable<String, Object>();
                Hashtable hashtable2 = null;
                TransactionUID transactionUID = null;
                try {
                    long l;
                    hashtable2 = packet.getProperties();
                    Long l2 = (Long)hashtable2.get("JMQTransactionID");
                    long l3 = l = l2 == null ? 0L : l2;
                    if (l == 0L) {
                        throw new BrokerException("Bad/Missing transaction id");
                    }
                    transactionUID = new TransactionUID(l);
                    TransactionState transactionState = this.translist.retrieveState(transactionUID);
                    if (transactionState == null) {
                        n = 410;
                    } else {
                        int n2 = transactionState.getState();
                        if (n2 != 5) {
                            throw new BrokerException("Transaction " + transactionUID + " is not PREPARED " + transactionState, 410);
                        }
                        Hashtable hashtable3 = this.translist.getTransactionMap(transactionUID, true);
                        if (hashtable3 != null) {
                            try {
                                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                                objectOutputStream.writeObject(hashtable3);
                                objectOutputStream.flush();
                                byteArrayOutputStream.flush();
                                packet2.setMessageBody(byteArrayOutputStream.toByteArray());
                                byteArrayOutputStream.close();
                            }
                            catch (Exception exception) {
                                this.logger.log(16, "B3100", (Object)" sending back broker data", (Throwable)exception);
                            }
                        }
                    }
                }
                catch (BrokerException brokerException) {
                    string = brokerException.getMessage();
                    n = brokerException.getStatusCode();
                    if (n != 410 && n != 404) {
                        this.logger.logStack(8, "B3100", "unknown status", (Throwable)brokerException);
                    } else {
                        this.logger.log(4, "Transaction " + transactionUID + " not found", brokerException);
                    }
                }
                catch (Throwable throwable) {
                    this.logger.logStack(8, "B3100", "exception processing verify transaction ", throwable);
                    string = throwable.toString();
                    n = 500;
                }
                if (n == 410) {
                    n = 404;
                }
                hashtable.put("JMQStatus", new Integer(n));
                if (string != null) {
                    hashtable.put("JMQReason", string);
                }
                if (IMQConnection.DUMP_PACKET) break block19;
                if (!IMQConnection.OUT_DUMP_PACKET) break block20;
            }
            hashtable.put("JMQReqID", packet.getSysMessageID().toString());
        }
        packet2.setProperties(hashtable);
        iMQConnection.sendControlMessage(packet2);
        return true;
    }

    static {
        $assertionsDisabled = !VerifyTransactionHandler.class.desiredAssertionStatus();
        DEBUG = false;
    }
}

