/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.util;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.GetDestinationsHandler;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.ConflictException;
import com.sun.messaging.jmq.jmsserver.util.memory.MemoryGlobals;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.admin.DestinationInfo;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jms.management.server.MQObjectName;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class DestinationUtil {
    private static String[] queueCreateAttrs = new String[]{"ConsumerFlowLimit", "LocalOnly", "LimitBehavior", "LocalDeliveryPreferred", "MaxBytesPerMsg", "MaxNumActiveConsumers", "MaxNumBackupConsumers", "MaxNumMsgs", "MaxNumProducers", "MaxTotalMsgBytes", "UseDMQ"};
    private static String[] topicCreateAttrs = new String[]{"ConsumerFlowLimit", "LocalOnly", "LimitBehavior", "MaxBytesPerMsg", "MaxNumMsgs", "MaxNumProducers", "MaxTotalMsgBytes", "UseDMQ"};

    public static int toExternalDestState(int n) {
        switch (n) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 0: {
                return 0;
            }
        }
        return -1;
    }

    public static int toInternalDestState(int n) {
        switch (n) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 0: {
                return 0;
            }
        }
        return -1;
    }

    public static List getVisibleDestinations() {
        boolean bl = false;
        Iterator iterator = Destination.getAllDestinations();
        ArrayList<Destination> arrayList = new ArrayList<Destination>();
        while (iterator.hasNext()) {
            Destination destination = (Destination)iterator.next();
            if (!DestinationUtil.isVisibleDestination(destination)) continue;
            arrayList.add(destination);
        }
        return arrayList;
    }

    public static List getVisibleTemporaryDestinations(long l) {
        boolean bl = false;
        Iterator iterator = Destination.getAllDestinations();
        ArrayList<Destination> arrayList = new ArrayList<Destination>();
        while (iterator.hasNext()) {
            ConnectionUID connectionUID;
            Destination destination = (Destination)iterator.next();
            if (!DestinationUtil.isVisibleDestination(destination) || !destination.isTemporary() || (connectionUID = destination.getConnectionUID()) == null || connectionUID.longValue() != l) continue;
            arrayList.add(destination);
        }
        return arrayList;
    }

    public static boolean isVisibleDestination(Destination destination) {
        return !destination.isInternal() && !destination.isAdmin() && !destination.getDestinationName().equals("__JMQAdmin");
    }

    public static DestinationInfo getDestinationInfo(Destination destination) {
        DestinationInfo destinationInfo = GetDestinationsHandler.getDestinationInfo(destination);
        return destinationInfo;
    }

    public static String toExternalDestLimitBehavior(int n) {
        switch (n) {
            case 0: {
                return "FLOW_CONTROL";
            }
            case 1: {
                return "REMOVE_OLDEST";
            }
            case 2: {
                return "REJECT_NEWEST";
            }
            case 3: {
                return "REMOVE_LOW_PRIORITY";
            }
        }
        return "UNKNOWN";
    }

    public static int toInternalDestLimitBehavior(String string) {
        if (string.equals("FLOW_CONTROL")) {
            return 0;
        }
        if (string.equals("REMOVE_OLDEST")) {
            return 1;
        }
        if (string.equals("REJECT_NEWEST")) {
            return 2;
        }
        if (string.equals("REMOVE_LOW_PRIORITY")) {
            return 3;
        }
        return -1;
    }

    public static int toInternalPauseType(String string) {
        if (string.equals("PRODUCERS")) {
            return 2;
        }
        if (string.equals("CONSUMERS")) {
            return 1;
        }
        if (string.equals("ALL")) {
            return 3;
        }
        return -1;
    }

    public static String toExternalPauseType(int n) {
        switch (n) {
            case 2: {
                return "PRODUCERS";
            }
            case 1: {
                return "CONSUMERS";
            }
            case 3: {
                return "ALL";
            }
        }
        return "UNKNOWN";
    }

    public static boolean isValidPauseType(String string) {
        if (string.equals("PRODUCERS")) {
            return true;
        }
        if (string.equals("CONSUMERS")) {
            return true;
        }
        return string.equals("ALL");
    }

    public static void pauseAllDestinations(int n) {
        Iterator iterator = Destination.getAllDestinations();
        while (iterator.hasNext()) {
            Destination destination = (Destination)iterator.next();
            if (destination.isInternal() || destination.isAdmin() || destination.isTemporary()) continue;
            destination.pauseDestination(n);
        }
    }

    public static void resumeAllDestinations() {
        Iterator iterator = Destination.getAllDestinations();
        while (iterator.hasNext()) {
            Destination destination = (Destination)iterator.next();
            if (!destination.isPaused()) continue;
            destination.resumeDestination();
        }
    }

    public static void compactAllDestinations() throws BrokerException {
        Destination destination;
        Iterator iterator = Destination.getAllDestinations();
        boolean bl = true;
        String string = null;
        BrokerResources brokerResources = Globals.getBrokerResources();
        Logger logger = Globals.getLogger();
        while (iterator.hasNext()) {
            destination = (Destination)iterator.next();
            if (destination.isInternal() || destination.isAdmin() || destination.isTemporary() || destination.isPaused()) continue;
            bl = false;
            String string2 = brokerResources.getString("B3135");
            string = brokerResources.getString("B4160", string2);
            throw new BrokerException(string);
        }
        if (bl) {
            iterator = Destination.getAllDestinations();
            while (iterator.hasNext()) {
                destination = (Destination)iterator.next();
                if (destination.isInternal() || destination.isAdmin() || destination.isTemporary()) continue;
                destination.compact();
            }
        }
    }

    public static void checkDestType(String string) throws BrokerException {
        if (string == null) {
            throw new BrokerException("Null destination type specified");
        }
        if (string.equals("q") || string.equals("t")) {
            return;
        }
        BrokerResources brokerResources = Globals.getBrokerResources();
        throw new BrokerException(brokerResources.getString("B4262", string));
    }

    public static void checkCreateDestinationAttrs(String string, AttributeList attributeList) throws BrokerException {
        String[] stringArray = null;
        DestinationUtil.checkDestType(string);
        if (attributeList == null) {
            return;
        }
        if (string.equals("q")) {
            stringArray = queueCreateAttrs;
        } else if (string.equals("t")) {
            stringArray = topicCreateAttrs;
        }
        Iterator iterator = attributeList.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            String string2 = attribute.getName();
            if (DestinationUtil.checkOneDestAttr(string2, stringArray)) continue;
            BrokerResources brokerResources = Globals.getBrokerResources();
            String string3 = string.equals("q") ? brokerResources.getString("B4263", string2) : brokerResources.getString("B4264", string2);
            throw new BrokerException(string3);
        }
    }

    private static boolean checkOneDestAttr(String string, String[] stringArray) {
        if (string == null) {
            return false;
        }
        if (stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public static void createDestination(DestinationInfo destinationInfo) throws BrokerException {
        SizeString sizeString;
        SizeString sizeString2;
        int n;
        int n2;
        Logger logger;
        BrokerResources brokerResources;
        int n3;
        String string;
        block32: {
            string = null;
            n3 = 200;
            brokerResources = Globals.getBrokerResources();
            logger = Globals.getLogger();
            n2 = 257;
            n = -1;
            sizeString2 = null;
            sizeString = null;
            if (MemoryGlobals.MEM_DISALLOW_CREATE_DEST) {
                n3 = 500;
                string = "B2077";
            } else if (destinationInfo.isModified(1)) {
                if (destinationInfo.isModified(2)) {
                    n2 = destinationInfo.type;
                }
                if (destinationInfo.isModified(4)) {
                    n = destinationInfo.maxMessages;
                }
                if (destinationInfo.isModified(8)) {
                    sizeString2 = new SizeString();
                    sizeString2.setBytes(destinationInfo.maxMessageBytes);
                }
                if (destinationInfo.isModified(16)) {
                    sizeString = new SizeString();
                    sizeString.setBytes(destinationInfo.maxMessageSize);
                }
            } else {
                n3 = 500;
                string = "B4089";
            }
            if (n3 == 200) {
                if (DestType.destNameIsInternal(destinationInfo.name)) {
                    n3 = 500;
                    string = brokerResources.getKString("B4175", destinationInfo.name, DestType.INTERNAL_DEST_PREFIX);
                } else if (DestinationUtil.isValidDestinationName(destinationInfo.name)) {
                    try {
                        Destination.createDestination(destinationInfo.name, n2);
                    }
                    catch (Exception exception) {
                        n3 = 500;
                        string = brokerResources.getString("B4090", destinationInfo.name, DestinationUtil.getMessageFromException(exception));
                        if (exception instanceof ConflictException) {
                            logger.log(8, string, exception);
                            break block32;
                        }
                        logger.logStack(8, string, exception);
                    }
                } else {
                    n3 = 500;
                    string = brokerResources.getKString("B4091", destinationInfo.name);
                }
            }
        }
        if (n3 == 200) {
            try {
                Destination destination = Destination.getDestination(destinationInfo.name, DestType.isQueue(n2));
                destination.setCapacity(n);
                destination.setByteCapacity(sizeString2);
                destination.setMaxByteSize(sizeString);
                if (destinationInfo.isModified(32)) {
                    int bl = destinationInfo.destScope;
                    destination.setScope(bl);
                }
                if (destinationInfo.isModified(64)) {
                    int destinationUID = destinationInfo.destLimitBehavior;
                    destination.setLimitBehavior(destinationUID);
                }
                if (destinationInfo.isModified(128)) {
                    int exception2 = destinationInfo.maxPrefetch;
                    destination.setMaxPrefetch(exception2);
                }
                if (destinationInfo.isModified(256)) {
                    int n4 = destinationInfo.destCDP;
                    destination.setClusterDeliveryPolicy(n4);
                }
                if (destinationInfo.isModified(512)) {
                    int n5 = destinationInfo.maxActiveConsumers;
                    destination.setMaxActiveConsumers(n5);
                }
                if (destinationInfo.isModified(2048)) {
                    int n6 = destinationInfo.maxProducers;
                    destination.setMaxProducers(n6);
                }
                if (destinationInfo.isModified(1024)) {
                    int n7 = destinationInfo.maxFailoverConsumers;
                    destination.setMaxFailoverConsumers(n7);
                }
                if (destinationInfo.isModified(4096)) {
                    int n8 = destinationInfo.maxNumSharedConsumers;
                    destination.setMaxSharedConsumers(n8);
                }
                if (destinationInfo.isModified(8192)) {
                    int n9 = destinationInfo.sharedConsumerFlowLimit;
                    destination.setSharedFlowLimit(n9);
                }
                if (destinationInfo.isModified(16384)) {
                    boolean bl = destinationInfo.useDMQ;
                    destination.setUseDMQ(bl);
                }
                destination.update();
            }
            catch (Exception exception) {
                try {
                    DestinationUID destinationUID = DestinationUID.getUID(destinationInfo.name, DestType.isQueue(n2));
                    Destination.removeDestination(destinationUID, false, exception.toString());
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                n3 = 500;
                string = brokerResources.getString("B4092", destinationInfo.name, DestinationUtil.getMessageFromException(exception));
                logger.log(16, string, exception);
            }
        }
        if (n3 != 200) {
            throw new BrokerException(string);
        }
    }

    public static boolean isValidDestinationName(String string) {
        if (string == null) {
            return false;
        }
        char[] cArray = string.toCharArray();
        if (cArray == null || cArray.length < 1) {
            return false;
        }
        if (Character.isJavaIdentifierStart(cArray[0])) {
            for (int i = 1; i < cArray.length; ++i) {
                if (Character.isJavaIdentifierPart(cArray[i])) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public static String getMessageFromException(Exception exception) {
        String string = exception.getMessage();
        if (exception instanceof BrokerException) {
            Throwable throwable = ((BrokerException)exception).getCause();
            if (throwable == null) {
                return string;
            }
            String string2 = throwable.getMessage();
            if (string2 != null) {
                string = string + "\n" + string2;
            }
        }
        return string;
    }

    public static DestinationInfo getDestinationInfoFromAttrs(String string, String string2, AttributeList attributeList) {
        DestinationInfo destinationInfo = new DestinationInfo();
        destinationInfo.setName(string2);
        if (string.equals("q")) {
            destinationInfo.setType(1);
        } else if (string.equals("t")) {
            destinationInfo.setType(2);
        }
        if (attributeList == null) {
            return destinationInfo;
        }
        Iterator iterator = attributeList.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            String string3 = attribute.getName();
            Object object = attribute.getValue();
            if (string3.equals("ConsumerFlowLimit")) {
                destinationInfo.setPrefetch(((Long)object).intValue());
            }
            if (string3.equals("LocalOnly")) {
                destinationInfo.setScope((Boolean)object);
            }
            if (string3.equals("LimitBehavior")) {
                destinationInfo.setLimitBehavior(DestinationUtil.toInternalDestLimitBehavior((String)object));
            }
            if (string3.equals("LocalDeliveryPreferred")) {
                int n = (Boolean)object != false ? 1 : 2;
                destinationInfo.setClusterDeliveryPolicy(n);
            }
            if (string3.equals("MaxBytesPerMsg")) {
                destinationInfo.setMaxMessageSize((Long)object);
            }
            if (string3.equals("MaxNumActiveConsumers")) {
                destinationInfo.setMaxActiveConsumers((Integer)object);
            }
            if (string3.equals("MaxNumBackupConsumers")) {
                destinationInfo.setMaxFailoverConsumers((Integer)object);
            }
            if (string3.equals("MaxNumMsgs")) {
                destinationInfo.setMaxMessages(((Long)object).intValue());
            }
            if (string3.equals("MaxNumProducers")) {
                destinationInfo.setMaxProducers((Integer)object);
            }
            if (string3.equals("MaxTotalMsgBytes")) {
                destinationInfo.setMaxMessageBytes((Long)object);
            }
            if (!string3.equals("UseDMQ")) continue;
            destinationInfo.setUseDMQ((Boolean)object);
        }
        return destinationInfo;
    }

    public static ObjectName getConfigObjectName(Destination destination) throws MalformedObjectNameException {
        ObjectName objectName = MQObjectName.createDestinationConfig(destination.isQueue() ? "q" : "t", destination.getDestinationName());
        return objectName;
    }

    public static ObjectName getMonitorObjectName(Destination destination) throws MalformedObjectNameException {
        ObjectName objectName = MQObjectName.createDestinationMonitor(destination.isQueue() ? "q" : "t", destination.getDestinationName());
        return objectName;
    }

    public static Object convertAttrValueInternaltoExternal(int n, Object object) {
        switch (n) {
            case 64: {
                if (object != null && object instanceof Integer) {
                    Integer n2 = (Integer)object;
                    return DestinationUtil.toExternalDestLimitBehavior(n2);
                }
                return "UNKNOWN";
            }
        }
        return object;
    }

    public static String getAttrNameFromDestinationInfoAttr(int n) {
        Object var1_1 = null;
        switch (n) {
            case 4: {
                return "MaxNumMsgs";
            }
            case 16: {
                return "MaxBytesPerMsg";
            }
            case 8: {
                return "MaxTotalMsgBytes";
            }
            case 64: {
                return "LimitBehavior";
            }
            case 256: {
                return "LocalDeliveryPreferred";
            }
            case 512: {
                return "MaxNumActiveConsumers";
            }
            case 1024: {
                return "MaxNumBackupConsumers";
            }
            case 2048: {
                return "MaxNumProducers";
            }
            case 128: {
                return "ConsumerFlowLimit";
            }
            case 16384: {
                return "UseDMQ";
            }
        }
        return null;
    }

    public static void checkPauseType(String string) throws IllegalArgumentException {
        if (string.equals("ALL") || string.equals("PRODUCERS") || string.equals("CONSUMERS")) {
            return;
        }
        BrokerResources brokerResources = Globals.getBrokerResources();
        throw new IllegalArgumentException(brokerResources.getString("B4265", string));
    }
}

