/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.io.PacketProperties;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.util.DestType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Hashtable;

public class ClusterDestInfo {
    private Destination d = null;
    private GPacket pkt = null;
    private String destName = null;
    private int destType = -1;
    static final /* synthetic */ boolean $assertionsDisabled;

    private ClusterDestInfo(Destination destination) {
        this.d = destination;
    }

    private ClusterDestInfo(GPacket gPacket) {
        if (!$assertionsDisabled && gPacket.getType() != 15 && gPacket.getType() != 13) {
            throw new AssertionError();
        }
        this.pkt = gPacket;
        this.destName = (String)gPacket.getProp("N");
        this.destType = (Integer)gPacket.getProp("DT");
    }

    public static ClusterDestInfo newInstance(Destination destination) {
        return new ClusterDestInfo(destination);
    }

    public static ClusterDestInfo newInstance(GPacket gPacket) {
        return new ClusterDestInfo(gPacket);
    }

    public GPacket getGPacket(short s, boolean bl) {
        if (!$assertionsDisabled && this.d == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && s != 15 && s != 13) {
            throw new AssertionError();
        }
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType(s);
        gPacket.putProp("N", this.d.getDestinationName());
        gPacket.putProp("DT", new Integer(this.d.getType()));
        switch (s) {
            case 15: {
                break;
            }
            case 13: {
                HashMap hashMap;
                if (DestType.isTemporary(this.d.getType())) {
                    gPacket.putProp("connectionUID", new Long(this.d.getConnectionUID().longValue()));
                }
                if ((hashMap = this.d.getDestinationProperties()) == null) {
                    hashMap = new HashMap();
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    PacketProperties.write(hashMap, byteArrayOutputStream);
                    byteArrayOutputStream.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                byte[] byArray = byteArrayOutputStream.toByteArray();
                gPacket.setPayload(ByteBuffer.wrap(byArray));
            }
        }
        if (bl) {
            gPacket.putProp("M", new Boolean(true));
        }
        return gPacket;
    }

    public DestinationUID getDestUID() {
        if (!$assertionsDisabled && this.destName == null) {
            throw new AssertionError();
        }
        return DestinationUID.getUID(this.destName, DestType.isQueue(this.destType));
    }

    public int getDestType() {
        if (!$assertionsDisabled && this.pkt == null) {
            throw new AssertionError();
        }
        return this.destType;
    }

    public String getDestName() {
        if (!$assertionsDisabled && this.pkt == null) {
            throw new AssertionError();
        }
        return this.destName;
    }

    public Hashtable getDestProps() throws IOException, ClassNotFoundException {
        if (!$assertionsDisabled && this.pkt == null) {
            throw new AssertionError();
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.pkt.getPayload().array());
        return PacketProperties.parseProperties(byteArrayInputStream);
    }

    static {
        $assertionsDisabled = !ClusterDestInfo.class.desiredAssertionStatus();
    }
}

