/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerState;
import com.sun.messaging.jmq.jmsserver.persist.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.TakeoverLockException;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

class BrokerDAOImpl
extends BaseDAOImpl
implements BrokerDAO {
    protected String tableName;
    protected String insertSQL;
    protected String updateSQL;
    protected String updateHeartbeatSQL;
    protected String updateHeartbeat2SQL;
    protected String updateStateSQL;
    protected String takeoverSQL;
    protected String deleteSQL;
    protected String selectSQL;
    protected String selectAllSQL;
    protected String selectAllByStateSQL;
    protected String selectHeartbeatSQL;
    protected String selectAllHeartbeatsSQL;
    protected String selectStateSQL;
    protected String selectAllStatesSQL;

    BrokerDAOImpl() throws BrokerException {
        DBManager dBManager = DBManager.getDBManager();
        this.tableName = dBManager.getTableName("MQBKR40");
        this.insertSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("ID").append(", ").append("URL").append(", ").append("VERSION").append(", ").append("STATE").append(", ").append("SESSION_ID").append(", ").append("HEARTBEAT_TS").append(") VALUES ( ?, ?, ?, ?, ?, ? )").toString();
        this.updateSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("URL").append(" = ?, ").append("VERSION").append(" = ?, ").append("STATE").append(" = ?, ").append("SESSION_ID").append(" = ?, ").append("TAKEOVER_BROKER").append(" = ?").append(" WHERE ").append("ID").append(" = ?").toString();
        this.updateHeartbeatSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("HEARTBEAT_TS").append(" = ?").append(" WHERE ").append("ID").append(" = ?").toString();
        this.updateHeartbeat2SQL = this.updateHeartbeatSQL + " AND " + "HEARTBEAT_TS" + " = ?" + " AND " + "STATE" + " = ?";
        this.updateStateSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("STATE").append(" = ?").append(" WHERE ").append("ID").append(" = ?").append(" AND ").append("STATE").append(" = ?").toString();
        this.takeoverSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("TAKEOVER_BROKER").append(" = ?, ").append("STATE").append(" = ?, ").append("HEARTBEAT_TS").append(" = ?").append(" WHERE ").append("ID").append(" = ?").append(" AND ").append("STATE").append(" = ?").append(" AND ").append("HEARTBEAT_TS").append(" = ?").append(" AND ").append("TAKEOVER_BROKER").append(" is NULL").toString();
        this.deleteSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectSQL = new StringBuffer(128).append("SELECT ").append("ID").append(", ").append("URL").append(", ").append("VERSION").append(", ").append("STATE").append(", ").append("SESSION_ID").append(", ").append("TAKEOVER_BROKER").append(", ").append("HEARTBEAT_TS").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectAllSQL = new StringBuffer(128).append("SELECT ").append("ID").append(", ").append("URL").append(", ").append("VERSION").append(", ").append("STATE").append(", ").append("SESSION_ID").append(", ").append("TAKEOVER_BROKER").append(", ").append("HEARTBEAT_TS").append(" FROM ").append(this.tableName).toString();
        this.selectAllByStateSQL = new StringBuffer(128).append(this.selectAllSQL).append(" WHERE ").append("STATE").append(" = ?").toString();
        this.selectHeartbeatSQL = new StringBuffer(128).append("SELECT ").append("HEARTBEAT_TS").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectAllHeartbeatsSQL = new StringBuffer(128).append("SELECT ").append("ID").append(", ").append("HEARTBEAT_TS").append(" FROM ").append(this.tableName).toString();
        this.selectStateSQL = new StringBuffer(128).append("SELECT ").append("STATE").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectAllStatesSQL = new StringBuffer(128).append("SELECT ").append("ID").append(", ").append("STATE").append(" FROM ").append(this.tableName).toString();
    }

    public final String getTableNamePrefix() {
        return "MQBKR40";
    }

    public final String getTableName() {
        return this.tableName;
    }

    public void insert(Connection connection, String string, String string2, int n, BrokerState brokerState, long l, long l2) throws BrokerException {
        boolean bl = false;
        PreparedStatement preparedStatement = null;
        try {
            if (connection == null) {
                connection = DBManager.getDBManager().getConnection(true);
                bl = true;
            }
            preparedStatement = connection.prepareStatement(this.insertSQL);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            preparedStatement.setInt(3, n);
            preparedStatement.setInt(4, brokerState.intValue());
            Util.setLong(preparedStatement, 5, l);
            Util.setLong(preparedStatement, 6, l2);
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            try {
                if (connection != null && !connection.getAutoCommit()) {
                    connection.rollback();
                }
            }
            catch (SQLException sQLException) {
                this.logger.log(32, "B4080", sQLException);
            }
            if (exception instanceof BrokerException) {
                throw (BrokerException)exception;
            }
            Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.insertSQL + "]", (SQLException)exception) : exception;
            throw new BrokerException(this.br.getKString("B4217", string), exception2);
        }
        finally {
            if (bl) {
                Util.close(null, preparedStatement, connection);
            } else {
                Util.close(null, preparedStatement, null);
            }
        }
    }

    public void update(Connection connection, String string, String string2, String string3, int n, BrokerState brokerState, long l) throws BrokerException {
        boolean bl = false;
        PreparedStatement preparedStatement = null;
        try {
            if (connection == null) {
                connection = DBManager.getDBManager().getConnection(true);
                bl = true;
            }
            preparedStatement = connection.prepareStatement(this.updateSQL);
            preparedStatement.setString(1, string3);
            preparedStatement.setInt(2, n);
            preparedStatement.setInt(3, brokerState.intValue());
            preparedStatement.setLong(4, l);
            Util.setString(preparedStatement, 5, string2);
            preparedStatement.setString(6, string);
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            try {
                if (connection != null && !connection.getAutoCommit()) {
                    connection.rollback();
                }
            }
            catch (SQLException sQLException) {
                this.logger.log(32, "B4080", sQLException);
            }
            if (exception instanceof BrokerException) {
                throw (BrokerException)exception;
            }
            Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateSQL + "]", (SQLException)exception) : exception;
            throw new BrokerException(this.br.getKString("B4217", string), exception2);
        }
        finally {
            if (bl) {
                Util.close(null, preparedStatement, connection);
            } else {
                Util.close(null, preparedStatement, null);
            }
        }
    }

    public boolean updateHeartbeat(Connection connection, String string, long l) throws BrokerException {
        boolean bl = false;
        boolean bl2 = false;
        PreparedStatement preparedStatement = null;
        try {
            if (connection == null) {
                connection = DBManager.getDBManager().getConnection(true);
                bl2 = true;
            }
            preparedStatement = connection.prepareStatement(this.updateHeartbeatSQL);
            preparedStatement.setLong(1, l);
            preparedStatement.setString(2, string);
            if (preparedStatement.executeUpdate() == 1) {
                bl = true;
            }
        }
        catch (Exception exception) {
            try {
                if (connection != null && !connection.getAutoCommit()) {
                    connection.rollback();
                }
            }
            catch (SQLException sQLException) {
                this.logger.log(32, "B4080", sQLException);
            }
            if (exception instanceof BrokerException) {
                throw (BrokerException)exception;
            }
            Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateHeartbeatSQL + "]", (SQLException)exception) : exception;
            throw new BrokerException(this.br.getKString("B4222", string), exception2);
        }
        finally {
            if (bl2) {
                Util.close(null, preparedStatement, connection);
            } else {
                Util.close(null, preparedStatement, null);
            }
        }
        return bl;
    }

    public boolean updateHeartbeat(Connection connection, String string, long l, long l2, BrokerState brokerState) throws BrokerException {
        boolean bl = false;
        boolean bl2 = false;
        PreparedStatement preparedStatement = null;
        try {
            if (connection == null) {
                connection = DBManager.getDBManager().getConnection(true);
                bl2 = true;
            }
            preparedStatement = connection.prepareStatement(this.updateHeartbeat2SQL);
            preparedStatement.setLong(1, l);
            preparedStatement.setString(2, string);
            preparedStatement.setLong(3, l2);
            preparedStatement.setInt(4, brokerState.intValue());
            if (preparedStatement.executeUpdate() == 1) {
                bl = true;
            }
        }
        catch (Exception exception) {
            try {
                if (connection != null && !connection.getAutoCommit()) {
                    connection.rollback();
                }
            }
            catch (SQLException sQLException) {
                this.logger.log(32, "B4080", sQLException);
            }
            if (exception instanceof BrokerException) {
                throw (BrokerException)exception;
            }
            Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateHeartbeat2SQL + "]", (SQLException)exception) : exception;
            String string2 = "Expected " + brokerState + " and last heartbeat " + l2;
            throw new BrokerException(this.br.getKString("B4223", string2), exception2);
        }
        finally {
            if (bl2) {
                Util.close(null, preparedStatement, connection);
            } else {
                Util.close(null, preparedStatement, null);
            }
        }
        return bl;
    }

    public boolean updateState(Connection connection, String string, BrokerState brokerState, BrokerState brokerState2) throws BrokerException {
        boolean bl = false;
        boolean bl2 = false;
        PreparedStatement preparedStatement = null;
        try {
            if (connection == null) {
                connection = DBManager.getDBManager().getConnection(true);
                bl2 = true;
            }
            preparedStatement = connection.prepareStatement(this.updateStateSQL);
            preparedStatement.setInt(1, brokerState.intValue());
            preparedStatement.setString(2, string);
            preparedStatement.setInt(3, brokerState2.intValue());
            if (preparedStatement.executeUpdate() == 1) {
                bl = true;
            }
        }
        catch (Exception exception) {
            try {
                if (connection != null && !connection.getAutoCommit()) {
                    connection.rollback();
                }
            }
            catch (SQLException sQLException) {
                this.logger.log(32, "B4080", sQLException);
            }
            if (exception instanceof BrokerException) {
                throw (BrokerException)exception;
            }
            Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateStateSQL + "]", (SQLException)exception) : exception;
            throw new BrokerException(this.br.getKString("B4217", string), exception2);
        }
        finally {
            if (bl2) {
                Util.close(null, preparedStatement, connection);
            } else {
                Util.close(null, preparedStatement, null);
            }
        }
        return bl;
    }

    public HABrokerInfo takeover(Connection connection, String string, String string2, long l, BrokerState brokerState, long l2, BrokerState brokerState2) throws BrokerException {
        HABrokerInfo hABrokerInfo = null;
        PreparedStatement preparedStatement = null;
        try {
            hABrokerInfo = this.getBrokerInfo(connection, string2);
            if (hABrokerInfo == null) {
                String string3 = this.br.getKString("B3169", string2);
                throw new BrokerException(this.br.getKString("B3100", string3));
            }
            preparedStatement = connection.prepareStatement(this.takeoverSQL);
            preparedStatement.setString(1, string);
            preparedStatement.setInt(2, brokerState2.intValue());
            preparedStatement.setLong(3, l2);
            preparedStatement.setString(4, string2);
            preparedStatement.setInt(5, brokerState.intValue());
            preparedStatement.setLong(6, l);
            if (preparedStatement.executeUpdate() != 1) {
                String string4 = this.br.getKString("B3170", string2);
                TakeoverLockException takeoverLockException = new TakeoverLockException(string4);
                takeoverLockException.setBrokerInfo(hABrokerInfo);
                throw takeoverLockException;
            }
        }
        catch (Exception exception) {
            try {
                try {
                    if (connection != null && !connection.getAutoCommit()) {
                        connection.rollback();
                    }
                }
                catch (SQLException sQLException) {
                    this.logger.log(32, "B4080", sQLException);
                }
                if (exception instanceof BrokerException) {
                    throw (BrokerException)exception;
                }
                Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.takeoverSQL + "]", (SQLException)exception) : exception;
                throw new BrokerException(this.br.getKString("B3172", string2), exception2);
            }
            catch (Throwable throwable) {
                Util.close(null, preparedStatement, null);
                throw throwable;
            }
        }
        Util.close(null, preparedStatement, null);
        return hABrokerInfo;
    }

    public void delete(Connection connection, String string) throws BrokerException {
        boolean bl = false;
        PreparedStatement preparedStatement = null;
        try {
            if (connection == null) {
                connection = DBManager.getDBManager().getConnection(true);
                bl = true;
            }
            preparedStatement = connection.prepareStatement(this.deleteSQL);
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            try {
                if (connection != null && !connection.getAutoCommit()) {
                    connection.rollback();
                }
            }
            catch (SQLException sQLException) {
                this.logger.log(32, "B4080", sQLException);
            }
            if (exception instanceof BrokerException) {
                throw (BrokerException)exception;
            }
            Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.deleteSQL + "]", (SQLException)exception) : exception;
            throw new BrokerException(this.br.getKString("B4220", string), exception2);
        }
        finally {
            if (bl) {
                Util.close(null, preparedStatement, connection);
            } else {
                Util.close(null, preparedStatement, null);
            }
        }
    }

    public void deleteAll(Connection connection) throws BrokerException {
        if (Globals.getHAEnabled()) {
            return;
        }
        super.deleteAll(connection);
    }

    public long getHeartbeat(Connection connection, String string) throws BrokerException {
        long l;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                l = -1L;
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectHeartbeatSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        l = resultSet.getLong(1);
                    }
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectHeartbeatSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4218", string), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return l;
    }

    public HashMap getAllHeartbeats(Connection connection) throws BrokerException {
        HashMap<String, Long> hashMap;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                hashMap = new HashMap<String, Long>();
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectAllHeartbeatsSQL);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        long l = resultSet.getLong(2);
                        hashMap.put(string, new Long(l));
                    }
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectAllHeartbeatsSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4221"), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return hashMap;
    }

    public BrokerState getState(Connection connection, String string) throws BrokerException {
        BrokerState brokerState;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                brokerState = null;
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectStateSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        brokerState = BrokerState.getState(resultSet.getInt(1));
                    }
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectStateSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4218", string), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return brokerState;
    }

    public Object[] getAllStates(Connection connection) throws BrokerException {
        Object[] objectArray;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<BrokerState> arrayList2 = new ArrayList<BrokerState>();
                objectArray = new Object[]{arrayList, arrayList2};
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectAllStatesSQL);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        int n = resultSet.getInt(2);
                        arrayList.add(string);
                        arrayList2.add(BrokerState.getState(n));
                    }
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectAllStatesSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4221"), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return objectArray;
    }

    public HABrokerInfo getBrokerInfo(Connection connection, String string) throws BrokerException {
        HABrokerInfo hABrokerInfo;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                hABrokerInfo = null;
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        hABrokerInfo = this.loadData(resultSet);
                    }
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4218", string), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return hABrokerInfo;
    }

    public HashMap getAllBrokerInfos(Connection connection) throws BrokerException {
        HashMap<String, HABrokerInfo> hashMap;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                hashMap = new HashMap<String, HABrokerInfo>();
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectAllSQL);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        HABrokerInfo hABrokerInfo = this.loadData(resultSet);
                        hashMap.put(hABrokerInfo.getId(), hABrokerInfo);
                    }
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectAllSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4221"), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return hashMap;
    }

    public HashMap getAllBrokerInfosByState(Connection connection, BrokerState brokerState) throws BrokerException {
        HashMap<String, HABrokerInfo> hashMap;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                hashMap = new HashMap<String, HABrokerInfo>();
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectAllByStateSQL);
                    preparedStatement.setInt(1, brokerState.intValue());
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        HABrokerInfo hABrokerInfo = this.loadData(resultSet);
                        hashMap.put(hABrokerInfo.getId(), hABrokerInfo);
                    }
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectAllByStateSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4221"), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return hashMap;
    }

    public HashMap getDebugInfo(Connection connection) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        StringBuffer stringBuffer = new StringBuffer(512);
        try {
            Collection collection = this.getAllBrokerInfos(connection).values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object v = iterator.next();
                stringBuffer.append(v.toString()).append(BrokerResources.NL);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        hashMap.put("Broker(" + this.tableName + ")", stringBuffer.toString());
        return hashMap;
    }

    protected HABrokerInfo loadData(ResultSet resultSet) throws SQLException {
        HABrokerInfo hABrokerInfo = new HABrokerInfo(resultSet.getString("ID"), resultSet.getString("TAKEOVER_BROKER"), resultSet.getString("URL"), resultSet.getInt("VERSION"), resultSet.getInt("STATE"), resultSet.getLong("SESSION_ID"), resultSet.getLong("HEARTBEAT_TS"));
        return hABrokerInfo;
    }
}

