#!/bin/sh
#
# Generates an RI src area.
#
# Note:  This script generates an RI src area from a CLEAN raptor workspace.
# 	 Do NOT run this script on a raptor workspace with files that have
#	 been edited or checked-in.  This script will NOT restore your
#	 original $WSTOP/src area.  
#       
#	 This script will take the original $WSTOP/src directory and
#	 create an RI src area.  The original $WSTOP/src will be renamed
#	 to $WSTOP/src.orig.  The RI src will then be located in $WSTOP/src.
#
#	 Use this script only ONCE - unless you restore it by removing
#	 the generated RI src in $WSTOP/src and moving back
#	 $WSTOP/src.orig back to $WSTOP/src.
#
script_home=`/usr/bin/dirname $0`
WSTOP=$script_home/../../../../..
cd $WSTOP; 
WSTOP=`pwd`

fastjavac_cmd="/usr/dist/pkgs/forte_for_java/bin/fastjavac/fastjavac.sun"
javahome="/usr/j2se"
_copyright="/*\n* Copyright 2003 Sun Microsystems, Inc. All Rights Reserved\n* SUN PROPRIETARY/CONFIDENTIAL\n* Use is subject to license terms.\n*\n*/\n"

if [ ! -x "$javahome/bin/javac" ]
then
    echo "Could not find a JDK scrubbing comments."
    echo "Default location : $javahome"
    echo "Exiting."
    exit 1
fi

if [ ! -x "$fastjavac_cmd" ]
then
    echo "Could not find the fastjavac program for scrubbing comments."
    echo "Default location : $fastjavac_cmd"
    echo "Exiting."
    exit 1
fi

#####################################################
# Do some checking before running this script.
# If src.orig exists, then that means this script was already run
# once and the workspace needs to be restored back to its original form.
#
if [ -d $WSTOP/src.orig -o -d $WSTOP/src-ri ]; then
    echo " "
    echo "The directory $WSTOP/src.orig or src.ri already exists which indicates "
    echo "that you generated the RI src tree once before.  "
    echo "This script will only work on a new source tree"
    echo " "
    echo "To force the building of the RI source again, "
    echo "make sure $WSTOP/src.orig is moved back to $WSTOP/src."
    echo " "
    echo "Exiting. "
    exit 1
fi

#####################################################
# If there are no SCCS directories under src, then the src area
# is probably an RI generated area and the workspace needs to be
# restored
#
if [ ! -d $WSTOP/src/SCCS ]; then
    echo " "
    echo "The directory $WSTOP/src/SCCS does not exist which hints "
    echo "that the $WSTOP/src directory is not an original $WSTOP/src"
    echo "area that has just been brought over from it's parent."
    echo "Please run this script on a clean workspace that has just"
    echo "been brought over."
    echo " "
    echo "Exiting. "
    exit 1
fi

#####################################################
# Tar over src to src-ri excluding SCCS dirs (F option on tar).
#
mkdir -p $WSTOP/src-ri
echo "### Making an RI src area from the original src into src-ri excluding SCCS ..."
cd $WSTOP/src; /bin/tar cfF - . | (cd ../src-ri; tar xfBp -)
#
# Move src to src.orig.
# Move src-ri to src.
#
echo "### Moving original $WSTOP/src to $WSTOP/src.orig ..."
mv $WSTOP/src $WSTOP/src.orig
echo "### Moving RI src area $WSTOP/src-ri back to $WSTOP/src ..."
mv $WSTOP/src-ri $WSTOP/src

#####################################################
# - Change build type to BUILD_TYPE=RI in Defs.gmk
# - Change SUBDIRS of some GNUmakefiles and 
#

echo "### Change BUILD_TYPE to RI in src/buildcfg/Defs.gmk ..."
cd $WSTOP/src/buildcfg
sed s/BUILD_TYPE=MQ/BUILD_TYPE=RI/g Defs.gmk > Defs.gmk.tmp
mv -f Defs.gmk.tmp Defs.gmk

echo "### Editing GNUmakefiles by changing SUBDIRS that do not apply to RI ..."

cd $WSTOP/src/share/java/javax;
sed -e s/jms\ xml/jms/g GNUmakefile > GNUmakefile.tmp
mv -f GNUmakefile.tmp GNUmakefile

cd $WSTOP/src/share/java/com/sun
sed -e s/messaging\ jms\ xml/messaging\ jms/g GNUmakefile > GNUmakefile.tmp
mv -f GNUmakefile.tmp GNUmakefile

cd $WSTOP/src/share/java/com/sun/messaging;
sed -e s/jms\ jmq\ naming\ xml/jms\ jmq\ naming/g GNUmakefile > GNUmakefile.tmp
mv -f GNUmakefile.tmp GNUmakefile

cd $WSTOP/src/share/java/com/sun/messaging/jmq/jmsclient/protocol
sed -e s/ssl\ tcp\ http/tcp/g GNUmakefile > GNUmakefile.tmp
mv -f GNUmakefile.tmp GNUmakefile

cd $WSTOP/src/share/java/com/sun/messaging/jmq/jmsserver/net
sed -e s/tcp\ tls\ http\ https/tcp/g GNUmakefile > GNUmakefile.tmp
mv -f GNUmakefile.tmp GNUmakefile
 
cd $WSTOP/src/share/java/com/sun/messaging/jmq/jmsserver
sed -e s/multibroker\ audit\ cluster/multibroker\ cluster/g GNUmakefile > GNUmakefile.tmp
mv -f GNUmakefile.tmp GNUmakefile

cd $WSTOP/src/share/java/com/sun/messaging/jmq/jmsserver/management
sed -e s/mbeans\ agent\ jesmf\ util/mbeans\ agent\ util/g GNUmakefile > GNUmakefile.tmp
mv -f GNUmakefile.tmp GNUmakefile

cd $WSTOP/src/share/java/com/sun/messaging/jmq
sed -e s/auth\ transport\ jmsselector/auth\ jmsselector/g GNUmakefile > GNUmakefile.tmp
mv -f GNUmakefile.tmp GNUmakefile

cd $WSTOP/src/solaris
rm -f GNUmakefile
mv -f GNUmakefile.RI GNUmakefile

cd $WSTOP/src/share
sed -e s/java\ props\ lic\ security/java\ props\ security/g GNUmakefile > GNUmakefile.tmp
mv -f GNUmakefile.tmp GNUmakefile

# Take out the svc directory that contains *.c for win32 
# This code that starts the VM.  We will pre-compile and these exe's.
cd $WSTOP/src/win32
sed -e s/bin\ svc/bin/g GNUmakefile > GNUmakefile.tmp
mv -f GNUmakefile.tmp GNUmakefile

# This changes the top GNUmakefile to do a install-ri so that it 
# automatically builds the dist install image after a compile.
cd $WSTOP/src
sed -e s/\$\(SUBDIRS\)/\$\(SUBDIRS\)\ install-ri/g GNUmakefile > GNUmakefile.tmp
mv -f GNUmakefile.tmp GNUmakefile

#####################################################
# Unzip the src/share/help helpfiles.zip file into src/sharehelp
# in order to remove the zip dependency to build the RI source.

echo "### Unzipping helpfiles.zip in src/share/help ..."
cd $WSTOP/src/share/help; mkdir helpfiles_en; unzip -o -d helpfiles_en helpfiles.zip

#####################################################
# Now remove directories that do not apply to RI.
#
cd $WSTOP;
echo "### Removing src subdirs that do not apply to RI ..."
rm -rf src/share/java/javax/activation
rm -rf src/share/java/javax/xml
rm -rf src/share/java/com/sun/xml
rm -rf src/share/java/com/sun/messaging/xml
rm -rf src/share/java/com/sun/messaging/jmq/jmsclient/protocol/ssl
rm -rf src/share/java/com/sun/messaging/jmq/jmsclient/protocol/http
rm -rf src/share/java/com/sun/messaging/jmq/jmsserver/audit
rm -rf src/share/java/com/sun/messaging/jmq/jmsserver/net/http
rm -rf src/share/java/com/sun/messaging/jmq/jmsserver/net/https
rm -rf src/share/java/com/sun/messaging/jmq/jmsserver/management/jesmf
rm -rf src/share/java/com/sun/messaging/jmq/transport

#
# Misc stuff
#
rm -rf src/buildant
rm -rf src/share/cclient
rm -rf src/share/java/examples
rm -rf src/share/java/webapps
rm -rf src/doc/en/*pdf
rm -rf src/share/lic
# Keep this source directory even though RI doesn't build it
# so that licensees can build if they want.
# rm -rf src/win32/svc
rm -rf src/doc/en/*.html src/doc/en/man src/doc/en/man src/doc/en/LICENSE* src/doc/en/README \
       src/doc/en/README-sp1 src/doc/en/AUTORUN* src/doc/en/develop src/doc/en/index* \
       src/doc/en/install* src/doc/ja src/doc/zh_CN src/doc/en/README_EE \
       src/doc/en/THIRDPARTYLICENSE* 
rm -rf src/buildcfg/install
rm -rf src/buildcfg/tools/gnumake
rm -rf src/buildcfg/tools/eabundles
rm -rf src/buildcfg/tools/jstyle
rm -rf src/buildcfg/tools/l10n
rm -rf src/buildcfg/tools/linux
rm -rf src/buildcfg/tools/sfx2sh
rm -rf src/buildcfg/tools/shell
rm -rf src/buildcfg/tools/zip
rm -rf src/buildcfg/tools/pointbase

#####################################################
# Copy the README-ri to the src directory.
cp -f src/doc/en/README-ri $WSTOP/src/README

#####################################################
# Done
echo "### The RI src area is now in $WSTOP/src"
echo "### The original $WSTOP/src directory has been moved to $WSTOP/src.orig"
echo "### Done."
