/*
 * @(#)JMSManager.java	1.2 01/11/30
 * Original @(#)JMSManager.java	1.4 00/11/21
 * 
 * Copyright 2000-2001 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 */
package com.sun.jms.spi;
import javax.jms.JMSException;

/**
 * Interface definition to allow external control of the JMS Server. 
 * Typically this would be the J2EE Server. The intention is to support 
 * pluggable JMS Services.
 *
 * @see 
 * @author   Frank Richichi
 */

 
public interface JMSManager {

    /**
     * Set an instance of the external manager.
     * @param externalManager JMS manager.
     */
    void setExternalManager(ExternalManager externalManager);
    

    /**
    * Get an instance of the external manager.
    * @return manager set by a previous set call.
    */
    ExternalManager getExternalManager();


    /**
     * Start an instance of the JMS Service within the
     * current java virtual machine.
     * @exception JMSException thrown if start not successful.
     */
    void startJMSService() throws JMSException;


    /**
     * Stop the instance of the JMS Service running
     * within the current java virtual machine.
     * @exception JMSException thrown if stop not successful.
     */
    void stopJMSService() throws JMSException;
}


