/*
 * @(#)JMSXAQueueConnectionFactory.java	1.2 01/11/30
 * Original @(#)JMSXAQueueConnectionFactory.java	1.2 00/11/21
 *
 * Copyright 1997-2001 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
 */

package com.sun.jms.spi.xa;

import javax.jms.*;

/** An JMSXAQueueConnectionFactory creates JMSXAQueueConnection and provides the 
  * associated QueueConnectionFactory.
  *
  * @version     1.0 - 14 May 1998
  * @author      Mark Hapner
  * @author      Rich Burridge
  *
  * @see         javax.jms.QueueConnectionFactory
  * @see         com.sun.jms.spi.xa.JMSXAConnectionFactory
  */

public interface JMSXAQueueConnectionFactory 
       extends JMSXAConnectionFactory {

    /** Create an XA queue connection with default user identity.
      * The connection is created in stopped mode. No messages 
      * will be delivered until <code>Connection.start</code> method
      * is explicitly called.
      *
      * @return a newly created XA queue connection.
      *
      * @exception JMSException if JMS Provider fails to create XA queue Connection
      *                         due to some internal error.
      * @exception JMSSecurityException  if client authentication fails due to 
      *                         invalid user name or password.
       */ 

    JMSXAQueueConnection
    createXAQueueConnection() throws JMSException;


    /** Create an XA queue connection with specific user identity.
      * The connection is created in stopped mode. No messages 
      * will be delivered until <code>Connection.start</code> method
      * is explicitly called.
      *  
      * @param userName the caller's user name
      * @param password the caller's password
      *  
      * @return a newly created XA queue connection.
      *
      * @exception JMSException if JMS Provider fails to create XA queue Connection
      *                         due to some internal error.
      * @exception JMSSecurityException  if client authentication fails due to 
      *                         invalid user name or password.
      */ 

    JMSXAQueueConnection
    createXAQueueConnection(String userName, String password) 
					     throws JMSException;
				
}
