/*
 * @(#)JMSXATopicConnection.java	1.2 01/11/30
 * Original @(#)JMSXATopicConnection.java	1.3 00/11/21
 *
 * Copyright 1997-2001 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
 */

package com.sun.jms.spi.xa;

import javax.jms.*;

/** An JMSXATopicConnection creates JMSXATopicSession and provides the associated TopicConnection.
  *
  * @version     1.0 - 13 March 1998
  * @author      Mark Hapner
  * @author      Rich Burridge
  *
  * @see         com.sun.jms.xa.XAConnection
  */

public interface JMSXATopicConnection 
	extends JMSXAConnection {

    /** Create an XATopicSession.
      *  
      * @exception JMSException if JMS Connection fails to create a
      *                         XA topic session due to some internal error.
      */ 

    JMSXATopicSession
    createXATopicSession(boolean transacted, int acknowledgeMode) throws JMSException;

    /** get a TopicConnection associated with this XATopicConnection object.
      *  
      * @return a TopicConnection.
      */ 

    TopicConnection getTopicConnection();
}
