/*
 * @(#)JMSXATopicConnectionFactory.java	1.2 01/11/30
 * Original @(#)JMSXATopicConnectionFactory.java	1.2 00/11/21
 *
 * Copyright 1997-2001 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
 */

package com.sun.jms.spi.xa;

import javax.jms.*;

/** An JMSXATopicConnectionFactory creates JMSXATopicConnection and provides the 
  * associated TopicConnectionFactory.
  *
  * @version     1.0 - 14 May 1998
  * @author      Mark Hapner
  * @author      Rich Burridge
  *
  * @see         javax.jms.TopicConnectionFactory
  * @see         com.sun.jms.spi.xa.JMSXAConnectionFactory
  */

public interface JMSXATopicConnectionFactory 
	extends JMSXAConnectionFactory {

    /** Create an XA topic connection with default user identity.
      * The connection is created in stopped mode. No messages 
      * will be delivered until <code>Connection.start</code> method
      * is explicitly called.
      *
      * @return a newly created XA topic connection.
      *
      * @exception JMSException if JMS Provider fails to create XA topic Connection
      *                         due to some internal error.
      * @exception JMSSecurityException  if client authentication fails due to 
      *                         invalid user name or password.
      */ 

    JMSXATopicConnection
    createXATopicConnection() throws JMSException;


    /** Create an XA topic connection with specified user identity.
      * The connection is created in stopped mode. No messages 
      * will be delivered until <code>Connection.start</code> method
      * is explicitly called.
      *  
      * @param userName the caller's user name
      * @param password the caller's password
      *  
      * @return a newly created XA topic connection.
      *
      * @exception JMSException if JMS Provider fails to create XA topi connection
      *                         due to some internal error.
      * @exception JMSSecurityException  if client authentication fails due to 
      *                         invalid user name or password.
      */ 

    JMSXATopicConnection
    createXATopicConnection(String userName, String password) 
					     throws JMSException;
					     
}
