/*
 * @(#)BrokerServiceListInspector.java	1.7 01/12/12
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.util.ServiceState;
import com.sun.messaging.jmq.util.admin.ServiceInfo;

import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.admin.resources.AdminResources;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;

/** 
 * Inspector panel for the broker service list.
 *
 * @see InspectorPanel
 * @see AInspector
 * @see ConsoleObj
 */
public class BrokerServiceListInspector extends TabledInspector  {

    private static AdminResources ar = Globals.getAdminResources();
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();

    /**
     * Return the array of Strings containing the collumn labels/headers.
     * @return the array of Strings containing the collumn labels/headers.
     */
    public String[] getColumnHeaders()  {
        String[] columnNames = {acr.getString(acr.I_SVC_NAME),
                                acr.getString(acr.I_PORT_NUMBER),
                                acr.getString(acr.I_SVC_STATE)};
        return (columnNames);
    }

    /**
     * Returns the Object at a particular cell collumn for a given
     * ConsoleObj object. Each row in the JTable represents one ConsoleObj.
     * This method returns the object/value for the ConsoleObj, for a particular 
     * collumn.
     *
     * @return the Object at a particular cell collumn for a given
     * ConsoleObj object.
     */
    public Object getValueAtCollumn(ConsoleObj conObj, int col)  {

        BrokerServiceCObj      bSvcCObj;

        if (!(conObj instanceof BrokerServiceCObj))  {
            return null;
        }

        bSvcCObj = (BrokerServiceCObj)conObj;
	ServiceInfo svcInfo = bSvcCObj.getServiceInfo();

        if (col == 0) {
            return (bSvcCObj);
        } else if (col == 1) {
	    String portStr;

	    // The port number is not applicable to this service
	    if (svcInfo.port == -1) {
		portStr = "-";

	    } else if (svcInfo.dynamicPort) {
                // Add more information about the port number:
                // dynamically generated or statically declared
                switch (svcInfo.state) {
                    case ServiceState.UNKNOWN:
                        portStr = ar.getString(ar.I_DYNAMIC);
                        break;
                    default:
                        portStr = new Integer(svcInfo.port).toString()
					+ " (" 
					+ ar.getString(ar.I_DYNAMIC) 
					+ ")";
                 }
            } else {
                portStr = new Integer(svcInfo.port).toString()
				+ " (" 
				+ ar.getString(ar.I_STATIC) 
				+ ")";
	    }

            return (portStr);
        } else if (col == 2) {
            return (ServiceState.getString(svcInfo.state));
        }

        return (null);
    }
}
