/*
 * @(#)ObjStoreDestListInspector.java	1.11 02/02/13
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.DestinationConfiguration;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;

/** 
 * Inspector panel for the object store destination list.
 *
 * @see InspectorPanel
 * @see AInspector
 * @see ConsoleObj
 */
public class ObjStoreDestListInspector extends TabledInspector {
    
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();

    /**
     * Return the array of Strings containing the collumn labels/headers.
     * @return the array of Strings containing the collumn labels/headers.
     */
    public String[] getColumnHeaders()  {
        String[] columnNames = {acr.getString(acr.I_OBJSTORE_LOOKUP_NAME),
				acr.getString(acr.I_OBJSTORE_DEST_TYPE),
				acr.getString(acr.I_OBJSTORE_DEST_NAME)};
	return (columnNames);
    }

    /**
     * Returns the Object at a particular cell collumn for a given
     * ConsoleObj object. Each row in the JTable represents one ConsoleObj.
     * This method returns the object/value for the ConsoleObj, for a particular 
     * collumn.
     *
     * @return the Object at a particular cell collumn for a given
     * ConsoleObj object.
     */
    public Object getValueAtCollumn(ConsoleObj conObj, int col)  {
	if (col == 0) {
	    return (conObj);
	} else if (col == 1) {
	    Object object = ((ObjStoreDestCObj)conObj).getObject();
	    if (object instanceof com.sun.messaging.Topic) {
		return acr.getString(acr.I_TOPIC);
	    } else if (object instanceof com.sun.messaging.Queue) {
		return acr.getString(acr.I_QUEUE);
	    }
	} else if (col == 2) {
	    Object object = ((ObjStoreDestCObj)conObj).getObject();
	    if (object != null  && object instanceof AdministeredObject) {
		try {
		    String destName = ((AdministeredObject)object).getProperty
				(DestinationConfiguration.imqDestinationName);
		    return destName;
		} catch (Exception ex) {
		    return "";
		}
	    }
	}

	return (null);
    }
}
