/*
 * @(#)BrokerAdminManager.java	1.2 00/12/11
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.admin.bkrutil;

import java.util.Hashtable;

public class BrokerAdminManager {

    /**
     * The reference to this class itself.
     */
    private static BrokerAdminManager mgr = null;

    /**
     * This contains all the available (bookmarked) instances of BrokerAdmin.
     */
    private static Hashtable admins;

    /**
     * If the BrokerAdminManager was requested more than once, this
     * will simply return the same instance.
     *
     * @return  BrokerAdminManager  the only one instance of this class
     */
    public static synchronized
        BrokerAdminManager getBrokerAdminManager() {

        if (mgr == null) {
            mgr = new BrokerAdminManager();
	    admins = new Hashtable();
	}
        return mgr;
    }

    /**
     * Adds an instance of BrokerAdmin to the list.
     * This will simply overwrite the existing one if there is any.
     */
    public void addBrokerAdmin(BrokerAdmin ba) {
	    admins.put(ba.getKey(), ba);	
    }

    /**
     *
     */
    public void deleteBrokerAdmin(BrokerAdmin ba) {
            admins.remove(ba.getKey());
    }

    /**
     * Returns the list of admin instances.
     */
    public Hashtable getBrokerAdmins() {
	return admins;
    }

    /**
     * Returns true if the key of BrokerAdmin exists in the list.
     * Returns false otherwise.
     */
    public boolean exist(String key) {
	return admins.containsKey(key);
    }
}
