/*
 * @(#)AuthenticationProtocolHandler.java	1.10 05/11/09
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */
package com.sun.messaging.jmq.auth.api.client;

import java.util.Hashtable;
import javax.security.auth.login.LoginException;

/**
 * AuthenticationProtocolHandler provides the client-side API for
 * application implementor to plug-in own authentication request handler
 * 
 * @version     JMQ 2.0
 * @author      Amy Kang
 * 
 */
public interface AuthenticationProtocolHandler {

    /**
     * This method must return the authentication type it implements.  
     */
    public String getType();

    /**
	 * This method is called right before start a authentication process
     *
     * @param username the user name passed from createConnection()
     * @param password the password passed from createConnection()
     * @param authProperties not defined yet 
     *
     * Currently for JMQ2.0, username/password always have values (if not
     * passed in createConnection() call, they are assigned default values).
     *
     */
    public void init(String username, String password,
                     Hashtable authProperties) throws LoginException; 

    /**
     * This method is called to handle a authentication request.
     *
     * @param authRequest the authentication request data.  This is the
     *                    packet body of AUTHENTICATE_REQUEST packet.
     * @param sequence this is the sequence number field in the 
     *                 AUTHENTICATE_REQUEST packet 
     *                 (canbe used for correlation in multiple requests case)
     * @return the response data.  This will be sent as packet body in 
     *                 the AUTHENTICATE packet. 
     *                 
     * @exception LoginException any error while handle the request
     *
     */
    public byte[] handleRequest(byte[] authRequest, int sequence) 
                                            throws LoginException; 
}
